/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="BadInstanceof", summary="instanceof used in a way that is equivalent to a null check.", severity=BugPattern.SeverityLevel.WARNING, tags={"Simplification"})
public final class BadInstanceof
extends BugChecker
implements BugChecker.InstanceOfTreeMatcher {
    private static final String NON_NULL = "`%s` is a non-null instance of %s which is a subtype of %s, so this check is always true.";
    private static final String NULLABLE = "`%s` is an instance of %s which is a subtype of %s, so this is equivalent to a null check.";

    public Description matchInstanceOf(InstanceOfTree tree, VisitorState state) {
        if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)tree.getExpression()), (Type)ASTHelpers.getType((Tree)tree.getType()), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        String subType = SuggestedFixes.prettyType((Type)ASTHelpers.getType((Tree)tree.getExpression()), (VisitorState)state);
        String expression = state.getSourceForNode((Tree)tree.getExpression());
        String superType = state.getSourceForNode(tree.getType());
        if (Matchers.isNonNullUsingDataflow().matches((Tree)tree.getExpression(), state)) {
            return this.buildDescription(tree).setMessage(String.format(NON_NULL, expression, subType, superType)).build();
        }
        return this.buildDescription(tree).setMessage(String.format(NULLABLE, expression, subType, superType)).addFix((Fix)BadInstanceof.getFix(tree, state)).build();
    }

    private static SuggestedFix getFix(InstanceOfTree tree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        Tree grandParent = state.getPath().getParentPath().getParentPath().getLeaf();
        if (parent.getKind() == Tree.Kind.PARENTHESIZED && grandParent.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
            return SuggestedFix.replace((Tree)grandParent, (String)(state.getSourceForNode((Tree)tree.getExpression()) + " == null"));
        }
        return SuggestedFix.replace((Tree)tree, (String)(state.getSourceForNode((Tree)tree.getExpression()) + " != null"));
    }
}

