﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/privatenetworks/PrivateNetworks_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace PrivateNetworks
{
namespace Model
{
  class AWS_PRIVATENETWORKS_API PingResult
  {
  public:
    PingResult();
    PingResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    PingResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>Information about the health of the service.</p>
     */
    inline const Aws::String& GetStatus() const{ return m_status; }

    /**
     * <p>Information about the health of the service.</p>
     */
    inline void SetStatus(const Aws::String& value) { m_status = value; }

    /**
     * <p>Information about the health of the service.</p>
     */
    inline void SetStatus(Aws::String&& value) { m_status = std::move(value); }

    /**
     * <p>Information about the health of the service.</p>
     */
    inline void SetStatus(const char* value) { m_status.assign(value); }

    /**
     * <p>Information about the health of the service.</p>
     */
    inline PingResult& WithStatus(const Aws::String& value) { SetStatus(value); return *this;}

    /**
     * <p>Information about the health of the service.</p>
     */
    inline PingResult& WithStatus(Aws::String&& value) { SetStatus(std::move(value)); return *this;}

    /**
     * <p>Information about the health of the service.</p>
     */
    inline PingResult& WithStatus(const char* value) { SetStatus(value); return *this;}

  private:

    Aws::String m_status;
  };

} // namespace Model
} // namespace PrivateNetworks
} // namespace Aws
