﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/opensearch/OpenSearchService_EXPORTS.h>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace OpenSearchService
{
namespace Model
{

  /**
   * <p>The zone awareness configuration for the domain cluster, such as the number
   * of availability zones.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ZoneAwarenessConfig">AWS
   * API Reference</a></p>
   */
  class AWS_OPENSEARCHSERVICE_API ZoneAwarenessConfig
  {
  public:
    ZoneAwarenessConfig();
    ZoneAwarenessConfig(Aws::Utils::Json::JsonView jsonValue);
    ZoneAwarenessConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>An integer value to indicate the number of availability zones for a domain
     * when zone awareness is enabled. This should be equal to number of subnets if VPC
     * endpoints is enabled. </p>
     */
    inline int GetAvailabilityZoneCount() const{ return m_availabilityZoneCount; }

    /**
     * <p>An integer value to indicate the number of availability zones for a domain
     * when zone awareness is enabled. This should be equal to number of subnets if VPC
     * endpoints is enabled. </p>
     */
    inline bool AvailabilityZoneCountHasBeenSet() const { return m_availabilityZoneCountHasBeenSet; }

    /**
     * <p>An integer value to indicate the number of availability zones for a domain
     * when zone awareness is enabled. This should be equal to number of subnets if VPC
     * endpoints is enabled. </p>
     */
    inline void SetAvailabilityZoneCount(int value) { m_availabilityZoneCountHasBeenSet = true; m_availabilityZoneCount = value; }

    /**
     * <p>An integer value to indicate the number of availability zones for a domain
     * when zone awareness is enabled. This should be equal to number of subnets if VPC
     * endpoints is enabled. </p>
     */
    inline ZoneAwarenessConfig& WithAvailabilityZoneCount(int value) { SetAvailabilityZoneCount(value); return *this;}

  private:

    int m_availabilityZoneCount;
    bool m_availabilityZoneCountHasBeenSet = false;
  };

} // namespace Model
} // namespace OpenSearchService
} // namespace Aws
