﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/OrganizationScanEc2InstanceWithFindingsResult.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>An object that contains information on the status of all Malware Protection
   * data source for an organization.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/OrganizationMalwareProtectionConfigurationResult">AWS
   * API Reference</a></p>
   */
  class AWS_GUARDDUTY_API OrganizationMalwareProtectionConfigurationResult
  {
  public:
    OrganizationMalwareProtectionConfigurationResult();
    OrganizationMalwareProtectionConfigurationResult(Aws::Utils::Json::JsonView jsonValue);
    OrganizationMalwareProtectionConfigurationResult& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Describes the configuration for scanning EC2 instances with findings for an
     * organization.</p>
     */
    inline const OrganizationScanEc2InstanceWithFindingsResult& GetScanEc2InstanceWithFindings() const{ return m_scanEc2InstanceWithFindings; }

    /**
     * <p>Describes the configuration for scanning EC2 instances with findings for an
     * organization.</p>
     */
    inline bool ScanEc2InstanceWithFindingsHasBeenSet() const { return m_scanEc2InstanceWithFindingsHasBeenSet; }

    /**
     * <p>Describes the configuration for scanning EC2 instances with findings for an
     * organization.</p>
     */
    inline void SetScanEc2InstanceWithFindings(const OrganizationScanEc2InstanceWithFindingsResult& value) { m_scanEc2InstanceWithFindingsHasBeenSet = true; m_scanEc2InstanceWithFindings = value; }

    /**
     * <p>Describes the configuration for scanning EC2 instances with findings for an
     * organization.</p>
     */
    inline void SetScanEc2InstanceWithFindings(OrganizationScanEc2InstanceWithFindingsResult&& value) { m_scanEc2InstanceWithFindingsHasBeenSet = true; m_scanEc2InstanceWithFindings = std::move(value); }

    /**
     * <p>Describes the configuration for scanning EC2 instances with findings for an
     * organization.</p>
     */
    inline OrganizationMalwareProtectionConfigurationResult& WithScanEc2InstanceWithFindings(const OrganizationScanEc2InstanceWithFindingsResult& value) { SetScanEc2InstanceWithFindings(value); return *this;}

    /**
     * <p>Describes the configuration for scanning EC2 instances with findings for an
     * organization.</p>
     */
    inline OrganizationMalwareProtectionConfigurationResult& WithScanEc2InstanceWithFindings(OrganizationScanEc2InstanceWithFindingsResult&& value) { SetScanEc2InstanceWithFindings(std::move(value)); return *this;}

  private:

    OrganizationScanEc2InstanceWithFindingsResult m_scanEc2InstanceWithFindings;
    bool m_scanEc2InstanceWithFindingsHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
