//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.8
//
// <auto-generated>
//
// Generated from file `PropertiesAdmin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The PropertiesAdmin interface provides remote access to the properties
 * of a communicator.
 **/
public interface PropertiesAdmin extends Object
{
    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param current The Current object for the invocation.
     * @return The property value.
     **/
    String getProperty(String key, Current current);

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param current The Current object for the invocation.
     * @return The matching property set.
     **/
    java.util.Map<java.lang.String, java.lang.String> getPropertiesForPrefix(String prefix, Current current);

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param current The Current object for the invocation.
     **/
    void setProperties(java.util.Map<java.lang.String, java.lang.String> newProperties, Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::Ice::PropertiesAdmin"
    };

    @Override
    default String[] ice_ids(Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Ice::PropertiesAdmin";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<OutputStream> _iceD_getProperty(PropertiesAdmin obj, final com.zeroc.IceInternal.Incoming inS, Current current)
    {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_key;
        iceP_key = istr.readString();
        inS.endReadParams();
        String ret = obj.getProperty(iceP_key, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<OutputStream> _iceD_getPropertiesForPrefix(PropertiesAdmin obj, final com.zeroc.IceInternal.Incoming inS, Current current)
    {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_prefix;
        iceP_prefix = istr.readString();
        inS.endReadParams();
        java.util.Map<java.lang.String, java.lang.String> ret = obj.getPropertiesForPrefix(iceP_prefix, current);
        OutputStream ostr = inS.startWriteParams();
        PropertyDictHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<OutputStream> _iceD_setProperties(PropertiesAdmin obj, final com.zeroc.IceInternal.Incoming inS, Current current)
    {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        java.util.Map<java.lang.String, java.lang.String> iceP_newProperties;
        iceP_newProperties = PropertyDictHelper.read(istr);
        inS.endReadParams();
        obj.setProperties(iceP_newProperties, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "getPropertiesForPrefix",
        "getProperty",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "setProperties"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, Current current)
        throws UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_getPropertiesForPrefix(this, in, current);
            }
            case 1:
            {
                return _iceD_getProperty(this, in, current);
            }
            case 2:
            {
                return Object._iceD_ice_id(this, in, current);
            }
            case 3:
            {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 4:
            {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 5:
            {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 6:
            {
                return _iceD_setProperties(this, in, current);
            }
        }

        assert(false);
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }
}
