/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// BufferReusePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class BufferReusePassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = BufferReusePassBase;

  BufferReusePassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferReusePassBase(const BufferReusePassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-reuse");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-reuse"; }

  ::llvm::StringRef getDescription() const override { return "Pass to find and annotate candidates for buffer reuse."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferReusePass");
  }
  ::llvm::StringRef getName() const override { return "BufferReusePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferReusePassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// CopyCleanupPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CopyCleanupPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = CopyCleanupPassBase;

  CopyCleanupPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  CopyCleanupPassBase(const CopyCleanupPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("copy-cleanup");
  }
  ::llvm::StringRef getArgument() const override { return "copy-cleanup"; }

  ::llvm::StringRef getDescription() const override { return "Pass to remove copies which are consumed by a GenericOp."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("CopyCleanupPass");
  }
  ::llvm::StringRef getName() const override { return "CopyCleanupPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(CopyCleanupPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// EmbedMemRefPrintsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class EmbedMemRefPrintsPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = EmbedMemRefPrintsPassBase;

  EmbedMemRefPrintsPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  EmbedMemRefPrintsPassBase(const EmbedMemRefPrintsPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("embed-memref-prints");
  }
  ::llvm::StringRef getArgument() const override { return "embed-memref-prints"; }

  ::llvm::StringRef getDescription() const override { return "Pass to print content of memrefs"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EmbedMemRefPrintsPass");
  }
  ::llvm::StringRef getName() const override { return "EmbedMemRefPrintsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<LLVM::LLVMDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(EmbedMemRefPrintsPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// EmbedTFFrameworkPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class EmbedTFFrameworkPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = EmbedTFFrameworkPassBase;

  EmbedTFFrameworkPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  EmbedTFFrameworkPassBase(const EmbedTFFrameworkPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("embed-tf-framework");
  }
  ::llvm::StringRef getArgument() const override { return "embed-tf-framework"; }

  ::llvm::StringRef getDescription() const override { return "Pass to embed TF Framework for allocation and assertions,"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EmbedTFFrameworkPass");
  }
  ::llvm::StringRef getName() const override { return "EmbedTFFrameworkPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(EmbedTFFrameworkPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// FuseInnerParallelLoopsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class FuseInnerParallelLoopsPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = FuseInnerParallelLoopsPassBase;

  FuseInnerParallelLoopsPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  FuseInnerParallelLoopsPassBase(const FuseInnerParallelLoopsPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("fuse-inner-parallel-loops");
  }
  ::llvm::StringRef getArgument() const override { return "fuse-inner-parallel-loops"; }

  ::llvm::StringRef getDescription() const override { return "Limited pass to forward stores to loads."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FuseInnerParallelLoopsPass");
  }
  ::llvm::StringRef getName() const override { return "FuseInnerParallelLoopsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FuseInnerParallelLoopsPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// GpuKernelToBlobPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class GpuKernelToBlobPassBase : public ::mlir::OperationPass<gpu::GPUModuleOp> {
public:
  using Base = GpuKernelToBlobPassBase;

  GpuKernelToBlobPassBase() : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  GpuKernelToBlobPassBase(const GpuKernelToBlobPassBase &other) : ::mlir::OperationPass<gpu::GPUModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gpu-kernel-to-blob");
  }
  ::llvm::StringRef getArgument() const override { return "gpu-kernel-to-blob"; }

  ::llvm::StringRef getDescription() const override { return "Pass to annotate GPU Module with its PTX"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GpuKernelToBlobPass");
  }
  ::llvm::StringRef getName() const override { return "GpuKernelToBlobPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(GpuKernelToBlobPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<std::string> blob_annotation_{*this, "blob-annotation", ::llvm::cl::desc("Blob attribute name"), ::llvm::cl::init("gpu.binary_blob")};
  ::mlir::Pass::ListOption<std::string> architectures_{*this, "arch", ::llvm::cl::desc("GPU architectures")};
  ::mlir::Pass::Option<bool> generate_fatbin_{*this, "generate-fatbin", ::llvm::cl::desc("Bundle machine code for the different architectures in one fatbin."), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<bool> print_ptx_{*this, "print-ptx", ::llvm::cl::desc("Print generated PTX code per target architecture."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> print_llvmir_{*this, "print-llvmir", ::llvm::cl::desc("Print llvm ir when lowering code per target architecture."), ::llvm::cl::init(false)};
};

//===----------------------------------------------------------------------===//
// KernelgenFinalBufferizePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class KernelgenFinalBufferizePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = KernelgenFinalBufferizePassBase;

  KernelgenFinalBufferizePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  KernelgenFinalBufferizePassBase(const KernelgenFinalBufferizePassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("kernelgen-final-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "kernelgen-final-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform late operations on values to buffer based ones."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("KernelgenFinalBufferizePass");
  }
  ::llvm::StringRef getName() const override { return "KernelgenFinalBufferizePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(KernelgenFinalBufferizePassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// ParallelLoopsToSequential
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ParallelLoopsToSequentialBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = ParallelLoopsToSequentialBase;

  ParallelLoopsToSequentialBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ParallelLoopsToSequentialBase(const ParallelLoopsToSequentialBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("parallel-loops-to-sequential");
  }
  ::llvm::StringRef getArgument() const override { return "parallel-loops-to-sequential"; }

  ::llvm::StringRef getDescription() const override { return "Pass to convert scf::ParallelOp to scf::ForOp"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ParallelLoopsToSequential");
  }
  ::llvm::StringRef getName() const override { return "ParallelLoopsToSequential"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ParallelLoopsToSequentialBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// PropagateShapeKnowledgeToKernels
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class PropagateShapeKnowledgeToKernelsBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = PropagateShapeKnowledgeToKernelsBase;

  PropagateShapeKnowledgeToKernelsBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  PropagateShapeKnowledgeToKernelsBase(const PropagateShapeKnowledgeToKernelsBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("propagate-shape-knowledge-to-kernels");
  }
  ::llvm::StringRef getArgument() const override { return "propagate-shape-knowledge-to-kernels"; }

  ::llvm::StringRef getDescription() const override { return "Pass to propagate shape information into kernels"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PropagateShapeKnowledgeToKernels");
  }
  ::llvm::StringRef getName() const override { return "PropagateShapeKnowledgeToKernels"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(PropagateShapeKnowledgeToKernelsBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// PropagateTfAbiKnowledgeToKernels
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class PropagateTfAbiKnowledgeToKernelsBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = PropagateTfAbiKnowledgeToKernelsBase;

  PropagateTfAbiKnowledgeToKernelsBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  PropagateTfAbiKnowledgeToKernelsBase(const PropagateTfAbiKnowledgeToKernelsBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("propagate-tf-abi-knowledge-to-kernels");
  }
  ::llvm::StringRef getArgument() const override { return "propagate-tf-abi-knowledge-to-kernels"; }

  ::llvm::StringRef getDescription() const override { return "Pass to propagate tensorflow ABI knowledge to kernels"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PropagateTfAbiKnowledgeToKernels");
  }
  ::llvm::StringRef getName() const override { return "PropagateTfAbiKnowledgeToKernels"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(PropagateTfAbiKnowledgeToKernelsBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// RewriteTFFrameworkAssert
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class RewriteTFFrameworkAssertBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = RewriteTFFrameworkAssertBase;

  RewriteTFFrameworkAssertBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  RewriteTFFrameworkAssertBase(const RewriteTFFrameworkAssertBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("rewrite-tf-framework-assert");
  }
  ::llvm::StringRef getArgument() const override { return "rewrite-tf-framework-assert"; }

  ::llvm::StringRef getDescription() const override { return "Pass to rewrite TFAssertOps to CondBranchOp"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("RewriteTFFrameworkAssert");
  }
  ::llvm::StringRef getName() const override { return "RewriteTFFrameworkAssert"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(RewriteTFFrameworkAssertBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// ShapeToDescriptorsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ShapeToDescriptorsPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = ShapeToDescriptorsPassBase;

  ShapeToDescriptorsPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ShapeToDescriptorsPassBase(const ShapeToDescriptorsPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("shape-to-descriptors");
  }
  ::llvm::StringRef getArgument() const override { return "shape-to-descriptors"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform shape computations to descriptors"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ShapeToDescriptorsPass");
  }
  ::llvm::StringRef getName() const override { return "ShapeToDescriptorsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ShapeToDescriptorsPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// TFKernelToLLVMPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TFKernelToLLVMPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = TFKernelToLLVMPassBase;

  TFKernelToLLVMPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TFKernelToLLVMPassBase(const TFKernelToLLVMPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-kernel-to-llvm");
  }
  ::llvm::StringRef getArgument() const override { return "tf-kernel-to-llvm"; }

  ::llvm::StringRef getDescription() const override { return "Pass for applying LLVM legalization patterns."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TFKernelToLLVMPass");
  }
  ::llvm::StringRef getName() const override { return "TFKernelToLLVMPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TFKernelToLLVMPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<std::string> blob_annotation_{*this, "blob-annotation", ::llvm::cl::desc("Blob attribute name"), ::llvm::cl::init("gpu.binary_blob")};
};

//===----------------------------------------------------------------------===//
// TFToJITInvocationPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TFToJITInvocationPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TFToJITInvocationPassBase;

  TFToJITInvocationPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TFToJITInvocationPassBase(const TFToJITInvocationPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-to-jit-invocation");
  }
  ::llvm::StringRef getArgument() const override { return "tf-to-jit-invocation"; }

  ::llvm::StringRef getDescription() const override { return "Pass to rewrite all TF operations to JIT invocations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TFToJITInvocationPass");
  }
  ::llvm::StringRef getName() const override { return "TFToJITInvocationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TFToJITInvocationPassBase<DerivedT>)

protected:
  ::mlir::Pass::ListOption<int64_t> tile_sizes_{*this, "tile-sizes", ::llvm::cl::desc("Tiling sizes"), llvm::cl::ZeroOrMore};
  ::mlir::Pass::ListOption<int64_t> unroll_factors_{*this, "unroll-factors", ::llvm::cl::desc("Unrolling in each tile dimension"), llvm::cl::ZeroOrMore};
  ::mlir::Pass::Option<int64_t> max_supported_rank_{*this, "max-supported-rank", ::llvm::cl::desc("Max rank that this kernel supports")};
  ::mlir::Pass::Option<bool> enable_ftz_{*this, "enable-ftz", ::llvm::cl::desc("Enable the denormal flush to zero mode when generating code")};
  ::mlir::Pass::Option<bool> index_64bit_{*this, "index_64bit", ::llvm::cl::desc("Enable the 64 bit indexing for GPU kernels")};
  ::mlir::Pass::Option<bool> cpu_codegen_{*this, "cpu-codegen", ::llvm::cl::desc("CPU codegen (false implies GPU)")};
  ::mlir::Pass::Option<bool> jit_i64_indexed_for_large_tensors_{*this, "jit_i64_indexed_for_large_tensors", ::llvm::cl::desc("Enable JIT compilation of i64-indexed kernels for large input tensors."), ::llvm::cl::init(false)};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// BufferReusePass Registration
//===----------------------------------------------------------------------===//

inline void registerBufferReusePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateBufferReusePass();
  });
}

//===----------------------------------------------------------------------===//
// CopyCleanupPass Registration
//===----------------------------------------------------------------------===//

inline void registerCopyCleanupPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateCopyCleanupPass();
  });
}

//===----------------------------------------------------------------------===//
// EmbedMemRefPrintsPass Registration
//===----------------------------------------------------------------------===//

inline void registerEmbedMemRefPrintsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateEmbedMemRefPrintsPass();
  });
}

//===----------------------------------------------------------------------===//
// EmbedTFFrameworkPass Registration
//===----------------------------------------------------------------------===//

inline void registerEmbedTFFrameworkPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return tf_framework::CreateEmbedTFFrameworkPass();
  });
}

//===----------------------------------------------------------------------===//
// FuseInnerParallelLoopsPass Registration
//===----------------------------------------------------------------------===//

inline void registerFuseInnerParallelLoopsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateFuseInnerParallelLoopsPass();
  });
}

//===----------------------------------------------------------------------===//
// GpuKernelToBlobPass Registration
//===----------------------------------------------------------------------===//

inline void registerGpuKernelToBlobPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateGpuKernelToBlobPass();
  });
}

//===----------------------------------------------------------------------===//
// KernelgenFinalBufferizePass Registration
//===----------------------------------------------------------------------===//

inline void registerKernelgenFinalBufferizePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateKernelgenFinalBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// ParallelLoopsToSequential Registration
//===----------------------------------------------------------------------===//

inline void registerParallelLoopsToSequentialPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateParallelLoopsToSequential();
  });
}

//===----------------------------------------------------------------------===//
// PropagateShapeKnowledgeToKernels Registration
//===----------------------------------------------------------------------===//

inline void registerPropagateShapeKnowledgeToKernelsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreatePropagateShapeKnowledgeToKernels();
  });
}

//===----------------------------------------------------------------------===//
// PropagateTfAbiKnowledgeToKernels Registration
//===----------------------------------------------------------------------===//

inline void registerPropagateTfAbiKnowledgeToKernelsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreatePropagateTfAbiKnowledgeToKernels();
  });
}

//===----------------------------------------------------------------------===//
// RewriteTFFrameworkAssert Registration
//===----------------------------------------------------------------------===//

inline void registerRewriteTFFrameworkAssertPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return tf_framework::CreateRewriteTFFrameworkAssert();
  });
}

//===----------------------------------------------------------------------===//
// ShapeToDescriptorsPass Registration
//===----------------------------------------------------------------------===//

inline void registerShapeToDescriptorsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateShapeToDescriptorsPass();
  });
}

//===----------------------------------------------------------------------===//
// TFKernelToLLVMPass Registration
//===----------------------------------------------------------------------===//

inline void registerTFKernelToLLVMPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateTFKernelToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// TFToJITInvocationPass Registration
//===----------------------------------------------------------------------===//

inline void registerTFToJITInvocationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return transforms::CreateTFToJITInvocationPass();
  });
}

//===----------------------------------------------------------------------===//
// KernelGen Registration
//===----------------------------------------------------------------------===//

inline void registerKernelGenPasses() {
  registerBufferReusePassPass();
  registerCopyCleanupPassPass();
  registerEmbedMemRefPrintsPassPass();
  registerEmbedTFFrameworkPassPass();
  registerFuseInnerParallelLoopsPassPass();
  registerGpuKernelToBlobPassPass();
  registerKernelgenFinalBufferizePassPass();
  registerParallelLoopsToSequentialPass();
  registerPropagateShapeKnowledgeToKernelsPass();
  registerPropagateTfAbiKnowledgeToKernelsPass();
  registerRewriteTFFrameworkAssertPass();
  registerShapeToDescriptorsPassPass();
  registerTFKernelToLLVMPassPass();
  registerTFToJITInvocationPassPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
