/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ValueListType","./lib/_Helper","sap/base/assert","sap/base/Log","sap/base/util/isEmptyObject","sap/base/util/JSTokenizer","sap/base/util/ObjectPath","sap/ui/base/SyncPromise","sap/ui/model/BindingMode","sap/ui/model/ChangeReason","sap/ui/model/ClientListBinding","sap/ui/model/Context","sap/ui/model/ContextBinding","sap/ui/model/MetaModel","sap/ui/model/PropertyBinding","sap/ui/model/odata/OperationMode","sap/ui/model/odata/type/Boolean","sap/ui/model/odata/type/Byte","sap/ui/model/odata/type/Date","sap/ui/model/odata/type/DateTimeOffset","sap/ui/model/odata/type/Decimal","sap/ui/model/odata/type/Double","sap/ui/model/odata/type/Guid","sap/ui/model/odata/type/Int16","sap/ui/model/odata/type/Int32","sap/ui/model/odata/type/Int64","sap/ui/model/odata/type/Raw","sap/ui/model/odata/type/SByte","sap/ui/model/odata/type/Single","sap/ui/model/odata/type/Stream","sap/ui/model/odata/type/String","sap/ui/model/odata/type/TimeOfDay","sap/ui/thirdparty/URI"],function(V,_,a,L,b,J,O,S,B,C,c,d,f,M,P,g,h,k,E,D,l,m,G,I,o,p,R,q,r,s,t,T,U){"use strict";var u,v=new Map(),w=L.Level.DEBUG,x=/\$\(/g,y=/^-?\d+$/,z,A,F="sap.ui.model.odata.v4.ODataMetaModel",H,K=/\(.*\)$/,N=new R(),Q=/\$\)/g,W=new Map(),X={messageChange:true},Y={"Edm.Boolean":{Type:h},"Edm.Byte":{Type:k},"Edm.Date":{Type:E},"Edm.DateTimeOffset":{constraints:{"$Precision":"precision"},Type:D},"Edm.Decimal":{constraints:{"@Org.OData.Validation.V1.Minimum/$Decimal":"minimum","@Org.OData.Validation.V1.Minimum@Org.OData.Validation.V1.Exclusive":"minimumExclusive","@Org.OData.Validation.V1.Maximum/$Decimal":"maximum","@Org.OData.Validation.V1.Maximum@Org.OData.Validation.V1.Exclusive":"maximumExclusive","$Precision":"precision","$Scale":"scale"},Type:l},"Edm.Double":{Type:m},"Edm.Guid":{Type:G},"Edm.Int16":{Type:I},"Edm.Int32":{Type:o},"Edm.Int64":{Type:p},"Edm.SByte":{Type:q},"Edm.Single":{Type:r},"Edm.Stream":{Type:s},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence","$MaxLength":"maxLength"},Type:t},"Edm.TimeOfDay":{constraints:{"$Precision":"precision"},Type:T}},Z={},$="@com.sap.vocabularies.Common.v1.ValueList",a1="@com.sap.vocabularies.Common.v1.ValueListMapping",b1="@com.sap.vocabularies.Common.v1.ValueListReferences",c1="@com.sap.vocabularies.Common.v1.ValueListWithFixedValues",d1=L.Level.WARNING;function e1(e,i,j,n){var n1,o1=e.mSchema2MetadataUrl[i];if(!o1){o1=e.mSchema2MetadataUrl[i]={};o1[j]=false;}else if(!(j in o1)){n1=Object.keys(o1)[0];if(o1[n1]){k1(e,"A schema cannot span more than one document: "+i+" - expected reference URI "+n1+" but instead saw "+j,n);}o1[j]=false;}}function f1(e,i,j,n){var n1,o1,p1,q1;function r1(s1){var t1,u1;if(!(j in s1)){n(d1,o1," does not contain ",j);return;}n(w,"Including ",j," from ",o1);for(u1 in s1){if(u1[0]!=="$"&&l1(u1)===j){t1=s1[u1];i[u1]=t1;j1(t1,i.$Annotations);}}}if(j in i){return i[j];}q1=e.mSchema2MetadataUrl[j];if(q1){p1=Object.keys(q1);if(p1.length>1){k1(e,"A schema cannot span more than one document: "+"schema is referenced by following URLs: "+p1.join(", "),j);}o1=p1[0];q1[o1]=true;n(w,"Namespace ",j," found in $Include of ",o1);n1=e.mMetadataUrl2Promise[o1];if(!n1){n(w,"Reading ",o1);n1=e.mMetadataUrl2Promise[o1]=S.resolve(e.oRequestor.read(o1)).then(e.validate.bind(e,o1));}n1=n1.then(r1);if(j in i){return i[j];}i[j]=n1;return n1;}}function g1(e,i){if(e===i){return"";}if(e.startsWith(i)&&e[i.length]==="#"&&e.indexOf("@",i.length)<0){return e.slice(i.length+1);}}function h1(e){var i=g1(e,a1);return i!==undefined?i:g1(e,$);}function i1(n,e){return e.some(function(i){return n==="$ReturnType"?i.$ReturnType:i.$Parameter&&i.$Parameter.some(function(j){return j.$Name===n;});});}function j1(e,i,j){var n;function n1(o1,p1){var q1;for(q1 in p1){if(j||!(q1 in o1)){o1[q1]=p1[q1];}}}for(n in e.$Annotations){if(!(n in i)){i[n]={};}n1(i[n],e.$Annotations[n]);}delete e.$Annotations;}function k1(e,i,j){var n=new Error(j+": "+i);e.oModel.reportError(i,F,n);throw n;}function l1(e){return e.slice(0,e.lastIndexOf(".")+1);}z=f.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(e,i,j){a(!j||j.getModel()===e,"oContext must belong to this model");f.call(this,e,i,j);},initialize:function(){var e=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(e!==this.oElementContext){this.oElementContext=e;this._fireChange();}},setContext:function(e){a(!e||e.getModel()===this.oModel,"oContext must belong to this model");if(e!==this.oContext){this.oContext=e;if(!this.bInitial){this.initialize();}}}});A=c.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{constructor:function(){c.apply(this,arguments);},_fireFilter:function(){},_fireSort:function(){},checkUpdate:function(e){var i=this.oList.length;this.update();if(e||this.oList.length!==i){this._fireChange({reason:C.Change});}},fetchContexts:function(){var i,e=this.oModel.resolve(this.sPath,this.oContext),j=this;if(!e){return S.resolve([]);}i=e.endsWith("@");if(!i&&!e.endsWith("/")){e+="/";}return this.oModel.fetchObject(e).then(function(n){if(!n){return[];}if(i){e=e.slice(0,-1);}return Object.keys(n).filter(function(n1){return n1[0]!=="$"&&i!==(n1[0]!=="@");}).map(function(n1){return new d(j.oModel,e+n1);});});},getContexts:function(i,e){this.iCurrentStart=i||0;this.iCurrentLength=Math.min(e||Infinity,this.iLength-this.iCurrentStart);return this.getCurrentContexts();},getCurrentContexts:function(){var e=[],i,n=this.iCurrentStart+this.iCurrentLength;for(i=this.iCurrentStart;i<n;i+=1){e.push(this.oList[this.aIndices[i]]);}if(this.oList.dataRequested){e.dataRequested=true;}return e;},setContexts:function(e){this.oList=e;this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();},update:function(){var e=[],i=this.fetchContexts(),j=this;if(i.isFulfilled()){e=i.getResult();}else{i.then(function(e){j.setContexts(e);j._fireChange({reason:C.Change});});e.dataRequested=true;}this.setContexts(e);}});H=P.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){P.apply(this,arguments);this.vValue=undefined;},checkUpdate:function(e,i){var j,n=this;function n1(o1){if(e||o1!==n.vValue){n.vValue=o1;n._fireChange({reason:i||C.Change});}return o1;}j=this.oModel.fetchObject(this.sPath,this.oContext,this.mParameters).then(n1);if(this.mParameters&&this.mParameters.$$valueAsPromise&&j.isPending()){n1(j.unwrap());}else if(j.isRejected()){j.unwrap();}},getValue:function(){return this.vValue;},setContext:function(e){if(this.oContext!==e){this.oContext=e;if(this.bRelative){this.checkUpdate(false,C.Context);}}},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue");}});var m1=M.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:function(e,i,j,n,n1){M.call(this);this.aAnnotationUris=j&&!Array.isArray(j)?[j]:j;this.sDefaultBindingMode=B.OneTime;this.mETags={};this.dLastModified=new Date(0);this.oMetadataPromise=null;this.oModel=n;this.mMetadataUrl2Promise={};this.oRequestor=e;this.mSchema2MetadataUrl={};this.mSupportedBindingModes={"OneTime":true,"OneWay":true};this.bSupportReferences=n1!==false;this.mUnsupportedFilterOperators={"All":true,"Any":true};this.sUrl=i;}});m1.prototype.$$valueAsPromise=true;m1.prototype._mergeAnnotations=function(e,j){var n=this;this.validate(this.sUrl,e);e.$Annotations={};Object.keys(e).forEach(function(i){if(e[i].$kind==="Schema"){e1(n,i,n.sUrl);j1(e[i],e.$Annotations);}});j.forEach(function(n1,i){var o1,p1;n.validate(n.aAnnotationUris[i],n1);for(p1 in n1){if(p1[0]!=="$"){if(p1 in e){k1(n,"A schema cannot span more than one document: "+p1,n.aAnnotationUris[i]);}o1=n1[p1];e[p1]=o1;if(o1.$kind==="Schema"){e1(n,p1,n.aAnnotationUris[i]);j1(o1,e.$Annotations,true);}}}});};m1.prototype.attachEvent=function(e){if(!(e in X)){throw new Error("Unsupported event '"+e+"': v4.ODataMetaModel#attachEvent");}return M.prototype.attachEvent.apply(this,arguments);};m1.prototype.bindContext=function(e,i){return new z(this,e,i);};m1.prototype.bindList=function(e,i,j,n){return new A(this,e,i,j,n);};m1.prototype.bindProperty=function(e,i,j){return new H(this,e,i,j);};m1.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree");};m1.prototype.fetchCanonicalPath=function(e){return this.fetchUpdateData("",e).then(function(i){if(!i.editUrl){throw new Error(e.getPath()+": No canonical path for transient entity");}if(i.propertyPath){throw new Error("Context "+e.getPath()+" does not point to an entity. It should be "+i.entityPath);}return"/"+i.editUrl;});};m1.prototype.fetchData=function(){return this.fetchEntityContainer().then(function(e){return JSON.parse(JSON.stringify(e));});};m1.prototype.fetchEntityContainer=function(e){var i,j=this;if(!this.oMetadataPromise){i=[S.resolve(this.oRequestor.read(this.sUrl,false,e))];if(this.aAnnotationUris){this.aAnnotationUris.forEach(function(n){i.push(S.resolve(j.oRequestor.read(n,true,e)));});}if(!e){this.oMetadataPromise=S.all(i).then(function(n){var n1=n[0];j._mergeAnnotations(n1,n.slice(1));return n1;});}}return this.oMetadataPromise;};m1.prototype.fetchObject=function(j,n,n1){var o1=this.resolve(j,n),p1=this;if(!o1){L.error("Invalid relative path w/o context",j,F);return S.resolve(null);}return this.fetchEntityContainer().then(function(q1){var r1,s1,t1,u1,v1,w1,x1,y1,z1;function A1(e,i,I1){var J1,K1,L1,M1,N1="";if(i){K1=i.indexOf("@@");if(K1>0){i=i.slice(0,K1);}}else{i=e;}I1=I1||"";if(r1){w1=M1=z1.filter(D1);if(M1.length!==1){return E1(d1,"Expected a single overload, but found "+M1.length);}if(r1!==Z){N1=M1[0].$Parameter[0].$isCollection?"Collection("+r1+")":r1;}L1=y1+"("+N1+")"+I1;if(q1.$Annotations[L1]){if(i==="@"){z1=q1.$Annotations[L1];J1=q1.$Annotations[y1+I1];if(J1){z1=Object.assign({},J1,z1);}return false;}if(i in q1.$Annotations[L1]){y1=L1;z1=q1;return true;}}}y1+=I1;z1=q1;return true;}function B1(i,j){var I1,J1,K1,L1=i.indexOf("@",2);if(L1>-1){return E1(d1,"Unsupported path after ",i.slice(0,L1));}i=i.slice(2);K1=i.indexOf("(");if(K1>0){if(!i.endsWith(")")){return E1(d1,"Expected ')' instead of '",i.slice(-1),"'");}try{J1=J.parseJS("["+i.slice(K1+1,-1).replace(x,"{").replace(Q,"}")+"]");}catch(e){return E1(d1,e.message,": ",e.text.slice(1,e.at),"<--",e.text.slice(e.at,-1));}i=i.slice(0,K1);}I1=i[0]==="."?O.get(i.slice(1),n1.scope):n1&&O.get(i,n1.scope)||(i==="requestCurrencyCodes"||i==="requestUnitsOfMeasure"?p1[i].bind(p1):O.get(i));if(typeof I1!=="function"){return E1(d1,i," is not a function but: "+I1);}try{z1=I1(z1,{$$valueAsPromise:n1&&n1.$$valueAsPromise,arguments:J1,context:new d(p1,j),schemaChildName:x1,overload:w1.length===1?w1[0]:undefined});}catch(e){E1(d1,"Error calling ",i,": ",e);}return true;}function C1(e,i){var I1;if(e==="$ReturnType"){if(i.$ReturnType){z1=i.$ReturnType;return true;}}else if(e&&i.$Parameter){I1=i.$Parameter.filter(function(J1){return J1.$Name===e;});if(I1.length){z1=I1[0];return true;}}return false;}function D1(e){return!e.$IsBound&&r1===Z||e.$IsBound&&r1===e.$Parameter[0].$Type;}function E1(i){var e;if(L.isLoggable(i,F)){e=Array.isArray(t1)?t1.join("/"):t1;L[i===w?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(e?" at /"+e:""),o1,F);}if(i===d1){z1=undefined;}return false;}function F1(e,i){var I1;function J1(){t1=t1||y1&&i&&y1+"/"+i;return E1.apply(this,arguments);}r1=z1&&z1.$Type||r1;if(p1.bSupportReferences&&!(e in q1)){I1=l1(e);z1=f1(p1,q1,I1,J1);}if(e in q1){y1=u1=x1=e;z1=w1=q1[x1];if(!S.isThenable(z1)){return true;}}if(S.isThenable(z1)&&z1.isPending()){return J1(w,"Waiting for ",I1);}return J1(d1,"Unknown qualified name ",e);}function G1(e,i,I1){var J1,K1;if(e==="$Annotations"){return E1(d1,"Invalid segment: $Annotations");}if(i&&typeof z1==="object"&&e in z1){if(e[0]==="$"||y.test(e)){v1=false;}}else{J1=e.indexOf("@@");if(J1<0){if(e.endsWith("@sapui.name")){J1=e.length-11;}else{J1=e.indexOf("@");}}if(J1>0){if(!G1(e.slice(0,J1),i,I1)){return false;}e=e.slice(J1);K1=true;}if(typeof z1==="string"&&!(K1&&(e==="@sapui.name"||e[1]==="@"))&&!H1(z1,I1.slice(0,i))){return false;}if(v1){if(e[0]==="$"&&e!=="$Parameter"&&e!=="$ReturnType"||y.test(e)){v1=false;}else{if(K1){}else if(e[0]!=="@"&&e.indexOf(".")>0){return F1(e);}else if(z1&&"$Type"in z1){if(!F1(z1.$Type,"$Type")){return false;}}else if(z1&&"$Action"in z1){if(!F1(z1.$Action,"$Action")){return false;}r1=Z;}else if(z1&&"$Function"in z1){if(!F1(z1.$Function,"$Function")){return false;}r1=Z;}else if(!i){y1=u1=x1=x1||q1.$EntityContainer;z1=w1=w1||q1[x1];if(Array.isArray(z1)&&C1(e,z1[0])){return true;}if(e&&e[0]!=="@"&&!(e in w1)){return E1(d1,"Unknown child ",e," of ",x1);}}if(Array.isArray(z1)){if(e==="$Parameter"){return true;}if(e.startsWith("@$ui5.overload@")){e=e.slice(14);K1=true;}if(K1){if(e[1]!=="@"&&!A1(e)){return false;}}else{if(e!==I1[i]&&I1[i][e.length+1]!=="@"&&i1(e,z1)){u1=e;return A1(e,I1[i].slice(e.length),"/"+u1);}if(r1){z1=z1.filter(D1);}if(e==="@$ui5.overload"){return true;}if(z1.length!==1){return E1(d1,"Expected a single overload, but found "+z1.length);}if(C1(e,z1[0])){return true;}z1=z1[0].$ReturnType;y1+="/0/$ReturnType";if(z1){if(e==="value"&&!(q1[z1.$Type]&&q1[z1.$Type].value)){u1=undefined;return true;}if(!F1(z1.$Type,"$Type")){return false;}}if(!e){return true;}}}}}if(!e){return i+1>=I1.length||E1(d1,"Invalid empty segment");}if(e[0]==="@"){if(e==="@sapui.name"){z1=u1;if(z1===undefined){E1(d1,"Unsupported path before @sapui.name");}else if(i+1<I1.length){E1(d1,"Unsupported path after @sapui.name");}return false;}if(e[1]==="@"){if(i+1<I1.length){return E1(d1,"Unsupported path after ",e);}return B1(e,[""].concat(I1.slice(0,i),I1[i].slice(0,J1)).join("/"));}}if(!z1||typeof z1!=="object"){z1=undefined;return!s1&&E1(w,"Invalid segment: ",e);}if(v1&&e[0]==="@"){r1=z1.$Type||r1;z1=q1.$Annotations[y1]||{};v1=false;}else if(e==="$"&&i+1<I1.length){return E1(d1,"Unsupported path after $");}}if(e!=="@"&&e!=="$"){if(e[0]==="@"){s1=true;}u1=v1||e[0]==="@"?e:undefined;y1=v1?y1+"/"+e:undefined;z1=z1[e];}return true;}function H1(e,i){var I1;if(t1){return E1(d1,"Invalid recursion");}t1=i;s1=false;v1=true;z1=q1;I1=e.split("/").every(G1);t1=undefined;return I1;}if(!H1(o1.slice(1))&&S.isThenable(z1)){z1=z1.then(function(){return p1.fetchObject(j,n,n1);});}return z1;});};m1.prototype.fetchUI5Type=function(e,i){var j=this.getMetaContext(e),n=this;if(e.endsWith("/$count")){u=u||new p();return S.resolve(u);}return this.fetchObject(undefined,j).catch(function(){}).then(function(n1){var o1=N,p1;if(!n1){L.warning("No metadata for path '"+e+"', using "+o1.getName(),undefined,F);return o1;}if(i){if(b(i)){i=undefined;}else if("parseKeepsEmptyString"in i&&n1.$Type!=="Edm.String"){if(Object.keys(i).length===1){i=undefined;}else{i=Object.assign({},i);delete i.parseKeepsEmptyString;}}}if(!i&&n1["$ui5.type"]){return n1["$ui5.type"];}if(n1.$isCollection){L.warning("Unsupported collection type, using "+o1.getName(),e,F);}else{p1=Y[n1.$Type];if(p1){o1=new p1.Type(i,n.getConstraints(n1,j.getPath()));}else{L.warning("Unsupported type '"+n1.$Type+"', using "+o1.getName(),e,F);}}if(!i){n1["$ui5.type"]=o1;}return o1;});};m1.prototype.fetchUpdateData=function(e,j,n){var n1=j.getModel(),o1=n1.resolve(e,j),p1=this;function q1(i){var r1=new Error(o1+": "+i);n1.reportError(i,F,r1);throw r1;}return this.fetchObject(this.getMetaPath(o1)).then(function(){return p1.fetchEntityContainer();}).then(function(r1){var s1,t1=r1[r1.$EntityContainer],u1,v1,w1,x1,y1,z1,A1,B1;function C1(G1){var i=G1.indexOf("(");return i>=0?G1.slice(i):"";}function D1(i){s1.push({path:y1,prefix:i,type:B1});}function E1(G1){var i=G1.indexOf("(");return i>=0?G1.slice(0,i):G1;}function F1(i){if(i.includes("($uid=")){D1(E1(i));}else{s1.push(i);}}A1=o1.slice(1).split("/");x1=A1.shift();y1="/"+x1;u1=y1;w1=decodeURIComponent(E1(x1));v1=t1[w1];if(!v1){q1("Not an entity set: "+w1);}B1=r1[v1.$Type];e="";z1="";s1=[];F1(x1);A1.forEach(function(i){var G1,H1;y1+="/"+i;if(y.test(i)){D1(s1.pop());u1+="/"+i;}else{H1=decodeURIComponent(E1(i));z1=_.buildPath(z1,H1);G1=B1[H1];if(!G1){q1("Not a (navigation) property: "+H1);}B1=r1[G1.$Type];if(G1.$kind==="NavigationProperty"){if(v1.$NavigationPropertyBinding&&z1 in v1.$NavigationPropertyBinding){w1=v1.$NavigationPropertyBinding[z1];v1=t1[w1];z1="";s1=[encodeURIComponent(w1)+C1(i)];if(!G1.$isCollection){D1(s1.pop());}}else{F1(i);}u1=y1;e="";}else{e=_.buildPath(e,i);}}});if(n){return S.resolve({editUrl:undefined,entityPath:u1,propertyPath:e});}return S.all(s1.map(function(i){if(typeof i==="string"){return i;}return j.fetchValue(i.path).then(function(G1){var H1;if(!G1){q1("No instance to calculate key predicate at "+i.path);}if(_.hasPrivateAnnotation(G1,"transient")){n=true;return undefined;}H1=_.getPrivateAnnotation(G1,"predicate");if(!H1){q1("No key predicate known at "+i.path);}return i.prefix+H1;},function(G1){q1(G1.message+" at "+i.path);});})).then(function(i){return{editUrl:n?undefined:i.join("/"),entityPath:u1,propertyPath:e};});});};m1.prototype.fetchValueListMappings=function(e,i,j,n){var n1=this,o1=e.getMetaModel();function p1(){var q1=n[0],r1="";if(n.length!==1){throw new Error("Expected a single overload, but found "+n.length);}if(q1.$IsBound){r1=q1.$Parameter[0].$isCollection?"Collection("+q1.$Parameter[0].$Type+")":q1.$Parameter[0].$Type;}return i+"("+r1+")";}return o1.fetchEntityContainer().then(function(q1){var r1,s1=q1.$Annotations,t1,u1=_.namespace(i),v1={},w1=n1===o1,x1,y1;if(j.$Name){t1=p1()+"/"+j.$Name;y1=i+"/"+j.$Name;}x1=Object.keys(s1).filter(function(z1){if(_.namespace(z1)===u1){if(t1?z1===t1||z1===y1:n1.getObject("/"+z1)===j){return true;}if(w1||y1&&_.getMetaPath(z1)===y1){return false;}throw new Error("Unexpected annotation target '"+z1+"' with namespace of data service in "+e.sServiceUrl);}return false;});if(!x1.length){throw new Error("No annotation '"+$.slice(1)+"' in "+e.sServiceUrl);}if(x1.length===1){r1=s1[x1[0]];}else{r1=Object.assign({},s1[y1],s1[t1]);}Object.keys(r1).forEach(function(z1){var A1=h1(z1);if(A1!==undefined){v1[A1]=r1[z1];["CollectionRoot","SearchSupported"].forEach(function(B1){if(B1 in r1[z1]){throw new Error("Property '"+B1+"' is not allowed in annotation '"+z1.slice(1)+"' for target '"+x1[0]+"' in "+e.sServiceUrl);}});}else if(!w1){throw new Error("Unexpected annotation '"+z1.slice(1)+"' for target '"+x1[0]+"' with namespace of data service in "+e.sServiceUrl);}});return v1;});};m1.prototype.fetchValueListType=function(e){var i=this.getMetaContext(e),j=this;return this.fetchObject(undefined,i).then(function(n){var n1,o1;if(!n){throw new Error("No metadata for "+e);}n1=j.getObject("@",i);if(n1[c1]){return V.Fixed;}for(o1 in n1){if(g1(o1,b1)!==undefined||g1(o1,a1)!==undefined){return V.Standard;}if(g1(o1,$)!==undefined){return n1[o1].SearchSupported===false?V.Fixed:V.Standard;}}return V.None;});};m1.prototype.getAbsoluteServiceUrl=function(e){var i=new U(this.sUrl).absoluteTo(document.baseURI).pathname().toString();return new U(e).absoluteTo(i).filename("").toString();};m1.prototype.getAllPathReductions=function(e,n,n1,o1){var p1=n.split("/").length,q1,r1={},s1=e.split("/"),t1=this;function u1(j,v1,w1,x1){var i,y1,z1;function A1(B1){if(!n1){u1(j,v1,i-1,true);}if(x1){v1=v1.slice();j=j.slice();}v1.splice(i,B1);j.splice(i,B1);if(!n1){r1[j.join("/")]=true;}}for(i=w1;i>=p1;i-=1){y1=y.test(j[i+1])?i+2:i+1;if(y1<j.length&&v1[i].$Partner===j[y1]&&!v1[y1].$isCollection&&v1[y1].$Partner===j[i].replace(K,"")){A1(y1-i+1);}else if(Array.isArray(v1[i])&&j[i+1]==="$Parameter"){z1=t1.getObject(t1.getMetaPath(j.slice(0,i+1).join("/")+"/@$ui5.overload"));if(z1.length===1&&z1[0].$Parameter[0].$Name===j[i+2]){A1(3);}}else if(o1&&v1[i].$isCollection){break;}}}q1=s1.map(function(i,j){return j<p1||i[0]==="#"||i[0]==="@"||y.test(i)||i==="$Parameter"?{}:t1.getObject(t1.getMetaPath(s1.slice(0,j+1).join("/")))||{};});r1[e]=true;if(!(o1&&q1[s1.length-1].$isCollection)){u1(s1,q1,s1.length-2);}return n1?s1.join("/"):Object.keys(r1);};m1.prototype.getConstraints=function(e,i){var j,n,n1,o1=Y[e.$Type];function p1(q1,r1){if(r1!==undefined){n=n||{};n[q1]=r1;}}if(o1){n1=o1.constraints;for(j in n1){p1(n1[j],j[0]==="@"?this.getObject(i+j):e[j]);}if(e.$Nullable===false){p1("nullable",false);}}return n;};m1.prototype.getData=_.createGetMethod("fetchData");m1.prototype.getETags=function(){return this.mETags;};m1.prototype.getLastModified=function(){return this.dLastModified;};m1.prototype.getMetaContext=function(e){return new d(this,this.getMetaPath(e));};m1.prototype.getMetaPath=function(e){return _.getMetaPath(e);};m1.prototype.getObject=_.createGetMethod("fetchObject");m1.prototype.getOrCreateSharedModel=function(e,i,j){var n,n1;e=this.getAbsoluteServiceUrl(e);n=!!j+e;n1=W.get(n);if(!n1){n1=new this.oModel.constructor({autoExpandSelect:j,groupId:i,httpHeaders:this.oModel.getHttpHeaders(),operationMode:g.Server,serviceUrl:e,sharedRequests:true,synchronizationMode:"None"});W.set(n,n1);}return n1;};m1.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty");};m1.prototype.getProperty=m1.prototype.getObject;m1.prototype.getReducedPath=function(e,i){return this.getAllPathReductions(e,i,true,true);};m1.prototype.getUI5Type=_.createGetMethod("fetchUI5Type",true);m1.prototype.getUnitOrCurrencyPath=function(e){var i=this.getObject("@",this.getMetaContext(e)),j=i&&(i["@Org.OData.Measures.V1.Unit"]||i["@Org.OData.Measures.V1.ISOCurrency"]);return j&&j.$Path;};m1.prototype.getValueListType=_.createGetMethod("fetchValueListType",true);m1.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList");};m1.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh");};m1.prototype.requestCodeList=function(e,i,j){var n=this.fetchEntityContainer().getResult(),n1=n[n.$EntityContainer],o1=this;if(j&&j.context){if(j.context.getModel()!==this||j.context.getPath()!=="/"){throw new Error("Unsupported context: "+j.context);}}if(i!==undefined&&i!==n1){throw new Error("Unsupported raw value: "+i);}return this.requestObject("/@com.sap.vocabularies.CodeList.v1."+e).then(function(p1){var q1,r1,s1,t1,u1;if(!p1){return null;}q1=o1.getAbsoluteServiceUrl(p1.Url)+"#"+p1.CollectionPath;t1=v.get(q1);if(t1){return t1;}s1=o1.getOrCreateSharedModel(p1.Url,"$direct");r1=s1.getMetaModel();u1="/"+p1.CollectionPath+"/";t1=r1.requestObject(u1).then(function(v1){var w1=u1+"@Org.OData.Core.V1.AlternateKeys",x1=r1.getObject(w1),y1,z1=H1(v1.$Key),A1=u1+z1+"@com.sap.vocabularies.Common.v1.",B1,C1,D1=u1+z1+"@com.sap.vocabularies.CodeList.v1.StandardCode/$Path",E1,F1;function G1(I1,J1){var K1=J1.getProperty(z1),L1={Text:J1.getProperty(F1),UnitSpecificScale:J1.getProperty(C1)};if(E1){L1.StandardCode=J1.getProperty(E1);}if(L1.UnitSpecificScale===null){L.error("Ignoring customizing w/o unit-specific scale for code "+K1+" from "+p1.CollectionPath,p1.Url,F);}else{I1[K1]=L1;}return I1;}function H1(I1){var J1;if(I1&&I1.length===1){J1=I1[0];}else{throw new Error("Single key expected: "+u1);}return typeof J1==="string"?J1:J1[Object.keys(J1)[0]];}if(x1){if(x1.length!==1){throw new Error("Single alternative expected: "+w1);}else if(x1[0].Key.length!==1){throw new Error("Single key expected: "+w1+"/0/Key");}z1=x1[0].Key[0].Name.$PropertyPath;}C1=r1.getObject(A1+"UnitSpecificScale/$Path");F1=r1.getObject(A1+"Text/$Path");B1=[z1,C1,F1];E1=r1.getObject(D1);if(E1){B1.push(E1);}y1=s1.bindList("/"+p1.CollectionPath,null,null,null,{$select:B1});return y1.requestContexts(0,Infinity).then(function(I1){if(!I1.length){L.error("Customizing empty for ",s1.sServiceUrl+p1.CollectionPath,F);}return I1.reduce(G1,{});}).finally(function(){y1.destroy();});});v.set(q1,t1);return t1;});};m1.prototype.requestCurrencyCodes=function(e,i){return this.requestCodeList("CurrencyCodes",e,i);};m1.prototype.requestData=_.createRequestMethod("fetchData");m1.prototype.requestObject=_.createRequestMethod("fetchObject");m1.prototype.requestUI5Type=_.createRequestMethod("fetchUI5Type");m1.prototype.requestUnitsOfMeasure=function(e,i){return this.requestCodeList("UnitsOfMeasure",e,i);};m1.prototype.requestValueListInfo=function(e,i){var j=this.getMetaPath(e),n=j.slice(0,j.lastIndexOf("/")).replace("/$Parameter",""),n1=n.slice(n.lastIndexOf("/")+1),o1=this;if(!n1.includes(".")){n1=undefined;}return Promise.all([n1||this.requestObject(n+"/@sapui.name"),this.requestObject(j),this.requestObject(j+"@"),this.requestObject(j+c1),this.requestObject(n+"/@$ui5.overload")]).then(function(p1){var q1=p1[2],r1=p1[3],s1={},t1=p1[1],u1={};function v1(w1,x1,y1,z1){if(r1!==undefined&&"SearchSupported"in w1){throw new Error("Must not set 'SearchSupported' in annotation "+"'com.sap.vocabularies.Common.v1.ValueList' and annotation "+"'com.sap.vocabularies.Common.v1.ValueListWithFixedValues'");}if("CollectionRoot"in w1){z1=o1.getOrCreateSharedModel(w1.CollectionRoot,undefined,i);if(u1[x1]&&u1[x1].$model===z1){s1[x1]=undefined;}}if(s1[x1]){throw new Error("Annotations '"+$.slice(1)+"' with identical qualifier '"+x1+"' for property "+e+" in "+s1[x1]+" and "+y1);}s1[x1]=y1;w1=_.clone(w1);w1.$model=z1;delete w1.CollectionRoot;delete w1.SearchSupported;u1[x1]=w1;}if(!t1){throw new Error("No metadata for "+e);}return Promise.all(Object.keys(q1).filter(function(w1){return g1(w1,b1)!==undefined;}).map(function(w1){var x1=q1[w1];return Promise.all(x1.map(function(y1){var z1=o1.getOrCreateSharedModel(y1,undefined,i);return o1.fetchValueListMappings(z1,p1[0],t1,p1[4]).then(function(A1){Object.keys(A1).forEach(function(B1){v1(A1[B1],B1,y1,z1);});});}));})).then(function(){var w1;Object.keys(q1).filter(function(x1){return h1(x1)!==undefined;}).forEach(function(x1){v1(q1[x1],h1(x1),o1.sUrl,o1.oModel);});w1=Object.keys(u1);if(!w1.length){throw new Error("No annotation '"+b1.slice(1)+"' for "+e);}if(r1){if(w1.length>1){throw new Error("Annotation '"+c1.slice(1)+"' but multiple '"+$.slice(1)+"' for property "+e);}return{"":u1[w1[0]]};}return u1;});});};m1.prototype.requestValueListType=_.createRequestMethod("fetchValueListType");m1.prototype.resolve=function(e,i){var j,n;if(!e){return i?i.getPath():undefined;}n=e[0];if(n==="/"){return e;}if(!i){return undefined;}if(n==="."){if(e[1]!=="/"){throw new Error("Unsupported relative path: "+e);}e=e.slice(2);}j=i.getPath();return n==="@"||j.endsWith("/")?j+e:j+"/"+e;};m1.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax");};m1.prototype.toString=function(){return F+": "+this.sUrl;};m1.prototype.validate=function(e,j){var i,n,n1,o1,p1,q1;if(!this.bSupportReferences){return j;}for(q1 in j.$Reference){p1=j.$Reference[q1];q1=new U(q1).absoluteTo(this.sUrl).toString();if("$IncludeAnnotations"in p1){k1(this,"Unsupported IncludeAnnotations",e);}for(i in p1.$Include){o1=p1.$Include[i];if(o1 in j){k1(this,"A schema cannot span more than one document: "+o1+" - is both included and defined",e);}e1(this,o1,q1,e);}}n1=j.$LastModified?new Date(j.$LastModified):null;this.mETags[e]=j.$ETag?j.$ETag:n1;n=j.$Date?new Date(j.$Date):new Date();n1=n1||n;if(this.dLastModified<n1){this.dLastModified=n1;}delete j.$Date;delete j.$ETag;delete j.$LastModified;return j;};return m1;});
