/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/mdc/field/FieldHelpBase','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/enum/OutParameterMode','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/condition/FilterConverter','sap/ui/base/ManagedObjectObserver','sap/ui/base/SyncPromise','sap/base/util/ObjectPath','sap/base/util/deepEqual','sap/base/util/merge','sap/ui/model/resource/ResourceModel','sap/ui/model/Context'],function(F,C,a,O,b,c,M,S,d,e,m,R,f){"use strict";var D;var B;var V;var g;var h;var k;var l=F.extend("sap.ui.mdc.field.FieldValueHelp",{metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/field/FieldValueHelpDelegate"}},filterFields:{type:"string",defaultValue:""},keyPath:{type:"string",defaultValue:""},descriptionPath:{type:"string",defaultValue:""},showConditionPanel:{type:"boolean",defaultValue:false},title:{type:"string",group:"Appearance",defaultValue:""},noDialog:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.mdc.field.FieldValueHelpContentWrapperBase",multiple:false},filterBar:{type:"sap.ui.mdc.FilterBar",multiple:false},inParameters:{type:"sap.ui.mdc.field.InParameter",group:"Data",multiple:true},outParameters:{type:"sap.ui.mdc.field.OutParameter",group:"Data",multiple:true},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"}},defaultAggregation:"content",events:{dataRequested:{}}}});l._init=function(){F._init.apply(this,arguments);D=undefined;B=undefined;V=undefined;g=undefined;h=undefined;k=undefined;};l.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(n.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions","showConditionPanel","title","filterFields"],aggregations:["content","filterBar","inParameters"]});this.setBindingContext(null);};l.prototype.exit=function(){F.prototype.exit.apply(this,arguments);if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;}if(this._oFilterConditionModel){this._oFilterConditionModel.destroy();delete this._oFilterConditionModel;}this._oObserver.disconnect();this._oObserver=undefined;};l.prototype.invalidate=function(i){if(i){var j=this.getContent();var o1=this.getAggregation("_dialog");if(j&&i===j){var p1=this.getAggregation("_popover");if(o1&&o1.isOpen()){var q1=o1.getContent()[0];q1.invalidate(i);}else if(p1&&p1.isOpen()){p1.invalidate(i);}return;}var r1=this.getFilterBar();if((o1&&i===o1)||(r1&&i===r1)){if(i.bOutput&&!this._bIsBeingDestroyed){var s1=this.getParent();if(s1){s1.invalidate(this);}}return;}}F.prototype.invalidate.apply(this,arguments);};l.prototype.connect=function(i){F.prototype.connect.apply(this,arguments);m1.call(this);h1.call(this,this.getShowConditionPanel());return this;};l.prototype.getIcon=function(){if(this.getNoDialog()){return"sap-icon://slim-arrow-down";}else{return"sap-icon://value-help";}};l.prototype._createPopover=function(){var i=F.prototype._createPopover.apply(this,arguments);if(i){var j=this.getContent();if(j){j.initialize(true);}i._getAllContent=function(){var o1=this.getParent();var p1=[];if(o1){var q1=l1.call(o1);if(q1){p1.push(q1);}}return p1;};if(this._bNavigate){this.navigate(this._iStep);}}return i;};l.prototype._handleAfterOpen=function(i){F.prototype._handleAfterOpen.apply(this,arguments);var j=this.getContent();if(j){j.fieldHelpOpen(true);}};l.prototype.open=function(i){if(this.getNoDialog()&&!i){i=true;}this._bUseFilterBar=!i;m1.call(this);var j=this.getContent();var o1=function(){if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;this.open(i);}}.bind(this);var p1=this._bOpen?this._callContentRequest(!!i,o1):this._fireOpen(!!i,o1);delete this._bOpen;if(!p1){if(i){this._getPopover();}else{c1.call(this);}if(j&&j.getFilterEnabled()&&!this._oFilterConditionModel){W.call(this);}this._bOpenAfterPromise=true;return;}this._bOpenHandled=true;j=this.getContent();if(j&&j.getFilterEnabled()&&!this._bNavigateRunning){if(!j.isSuspended()||i){this._bApplyFilter=true;}if(!this._oFilterConditionModel){W.call(this);}else{k1.call(this);}}if(this._bUpdateFilterAfterClose){this._bUpdateFilterAfterClose=false;y.call(this,this.getFilterValue());}if(i){if(!j){this._bOpenIfContent=true;}else{j.fieldHelpOpen(i);if(this._oFilterConditionModel&&!this.getFilterValue()&&!this._bNavigateRunning){this._oFilterConditionModel.checkUpdate(true,true);}F.prototype.open.apply(this,[i]);}}else{j1.call(this);var q1=this.getAggregation("_popover");if(q1){if(q1.isOpen()){this.close();}q1.$().remove();}var r1=c1.call(this);if(r1){var s1=r1.getContent()[0];s1.setShowTokenizer(this.getMaxConditions()!==1&&!!j);s1.setFormatOptions(this._getFormatOptions());s1.bindProperty("conditions",{path:"$help>/conditions"});var t1=this.getFilterFields();if(t1){s1.bindProperty("filterConditions",{path:"filter>/conditions/"+t1});}if(j){j.fieldHelpOpen(false);x.call(this);}this._aOldConditions=this.getConditions();r1.open();this._bDialogOpen=true;}else{this._bOpen=true;}}this._bOpenHandled=false;return;};l.prototype.toggleOpen=function(i){if(this.getNoDialog()&&!i){i=true;}if(i){F.prototype.toggleOpen.apply(this,[i]);}else if(this._bOpen||this._bOpenIfContent||this._bOpenAfterPromise){delete this._bOpen;delete this._bSuggestion;delete this._bOpenIfContent;delete this._bOpenAfterPromise;}else{var j=c1.call(this);if(j){if(j.isOpen()){var o1=j.oPopup.getOpenState();if(o1!=="CLOSED"&&o1!=="CLOSING"){this.close();}else{this._bReopen=true;}}else{this.open(i);}}else{this.open(i);}}};l.prototype.close=function(){if(!this._bDialogOpen){F.prototype.close.apply(this,arguments);}else{this._bUseFilterBar=false;var i=this.getAggregation("_dialog");if(i){this._bClosing=true;i.close();var j=i.getContent()[0];j.unbindProperty("conditions",true);j.unbindProperty("filterConditions",true);}this._bReopen=false;delete this._bOpen;delete this._bOpenAfterPromise;}};l.prototype.isOpen=function(i){var j=F.prototype.isOpen.apply(this,arguments);if(!j&&(!i||!this._bClosing)){var o1=this.getAggregation("_dialog");if(o1){j=o1.isOpen();}}return j;};function _(){if(!this._oFilterConditionModel){return;}var i=this._oFilterConditionModel.getAllConditions();var j=false;for(var o1 in i){if(i[o1].length>0){j=true;break;}}if(j){this._oFilterConditionModel.removeAllConditions();}}l.prototype._handleAfterClose=function(i){var j=this.getContent();if(j){if(!j.getAsyncKeyText()){_.call(this);}j.fieldHelpClose();}this._bApplyFilter=false;F.prototype._handleAfterClose.apply(this,arguments);};function n(i){if(i.object==this){var j;if(i.name==="content"){b1.call(this,i.mutation,i.child);}if(i.name==="filterBar"){i1.call(this,i.mutation,i.child);}if(i.name==="conditions"){w.call(this,i.current);}if(i.name==="filterValue"){if(this._bClosing){this._bUpdateFilterAfterClose=true;}else{y.call(this,i.current);}}if(i.name==="showConditionPanel"){h1.call(this,i.current);}if(i.name==="title"){j=this.getAggregation("_dialog");if(j){j.setTitle(i.current);}}if(i.name==="filterFields"){j=this.getAggregation("_dialog");if(j){var o1=j.getContent()[0];o1.setSearchEnabled(!!i.current);if(j.isOpen()){if(i.current){o1.bindProperty("filterConditions",{path:"filter>/conditions/"+i.current});}else{o1.unbindProperty("filterConditions",true);}}}}if(i.name==="inParameters"){z.call(this,i.child,i.mutation);}}else if(i.object.isA("sap.ui.mdc.field.InParameter")){if(i.name==="value"){G.call(this,i.object.getHelpPath(),i.current,i.old,i.object.getUseConditions());}if(i.name==="helpPath"){H.call(this,i.current,i.old,i.object.getValue(),i.object.getUseConditions());}}}l.prototype.openByTyping=function(){if(!this._bDetermineSearchSupportedCalled&&!this.isOpen()&&!this._bOpen&&!this._bOpenIfContent&&!this._bOpenAfterPromise){this.initControlDelegate();if(this.bDelegateInitialized){return o.call(this);}else{this._bDetermineSearchSupportedCalled=true;return this.awaitControlDelegate().then(function(){return o.call(this);}.bind(this));}}return!!this.getFilterFields();};function o(){this.fireOpen({suggestion:true});this._bDetermineSearchSupportedCalled=true;var i=this.getControlDelegate().determineSearchSupported(this.getPayload(),this);if(i instanceof Promise){return i.then(function(){return!!this.getFilterFields();}.bind(this));}else{return!!this.getFilterFields();}}l.prototype.isFocusInHelp=function(){if(!this.getNoDialog()){var i=this.getAggregation("_dialog");if((i&&i.isOpen())||(this._bDialogRequested&&this._bOpen)){return true;}}if(this._bFocusPopover){return true;}return false;};l.prototype.navigate=function(i){var j=this.getContent();var o1=this.getAggregation("_popover");m1.call(this);if(!o1||!o1.isOpen()){var p1=function(){this.navigate(i);}.bind(this);var q1=this._bNavigate?this._callContentRequest(true,p1):this._fireOpen(true,p1);if(!q1){j=this.getContent();this._bNavigate=false;this._iStep=null;if(j){this._getPopover();if(!this._oFilterConditionModel){W.call(this);}}return;}}this._bNavigate=false;this._iStep=null;j=this.getContent();if(j){o1=this._getPopover();this._bApplyFilter=true;this._bNavigateRunning=true;if(!this._oFilterConditionModel){W.call(this);}else{I.call(this);}this._oFilterConditionModel.checkUpdate(true,true);}if(!o1){this._bNavigate=true;this._iStep=i;return;}if(j){j.navigate(i);}};function p(i){var j=this._getPopover();var o1=i.getParameter("key");var p1=i.getParameter("description");var q1=i.getParameter("inParameters");var r1=i.getParameter("outParameters");var s1=i.getParameter("leave");var t1=i.getParameter("itemId");var u1;if(s1){this._oField.focus();return;}if(o1===undefined){this._bFocusPopover=true;}if(!j.isOpen()){this._bOpenHandled=true;this.open(true);this._bOpenHandled=false;}this._bNavigateRunning=false;if(o1===undefined){this._bFocusPopover=false;return;}u1=C.createItemCondition(o1,p1);u1.validated=b.Validated;if(q1){u1.inParameters=J.call(this,q1);}if(r1){u1.outParameters=K.call(this,r1);}this.setProperty("conditions",[u1],true);this.fireNavigate({value:p1,key:o1,condition:u1,itemId:t1});}l.prototype._getTextOrKey=function(i,j,o1,p1,q1,r1){var s1="";var t1=this.getContent();if(t1){var u1=t1.getListBinding();if(!u1){this.fireDataRequested();}var v1=this.oBindingContexts[undefined];var w1=this.getInParameters();var x1=false;if(o1&&f.hasChanged(v1,o1)){x1=true;}var y1=q.call(this,w1,x1,o1,v1);s1=S.resolve().then(function(){return s.call(this,y1);}.bind(this)).then(function(){return S.resolve().then(function(){if(j){return t1.getTextForKey(i,Q.call(this,p1,w1,false,y1,o1),P.call(this,q1,true),r1);}else{return t1.getKeyForText(i,Q.call(this,undefined,w1,false,y1,o1),r1);}}.bind(this)).then(function(s1){r.call(this,y1,x1);return t.call(this,s1);}.bind(this)).unwrap();}.bind(this)).unwrap();}return s1;};function q(j,o1,p1,q1){var r1=[];for(var i=0;i<j.length;i++){var s1=j[i];var t1=s1.getBinding("value");if(t1){var u1=t1.getPath();var v1=t1.getContext();if(o1&&(v1===q1||(!v1&&q1))){if(p1.getProperty(u1)===undefined){var w1=t1.getModel();r1.push(w1.bindProperty(u1,p1));}}else{if(!v1||v1.getProperty(u1)===undefined||!e(s1.validateProperty("value",v1.getProperty(u1)),s1.getValue())){r1.push(t1);}}}}return r1;}function r(j,o1){if(!o1){return;}for(var i=0;i<j.length;i++){j[i].destroy();}}function s(i){if(i.length===0){return null;}this.initControlDelegate();if(this.bDelegateInitialized){return this.getControlDelegate().checkBindingsPending(this.getPayload(),i);}else{return this.awaitControlDelegate().then(function(){return this.getControlDelegate().checkBindingsPending(this.getPayload(),i);}.bind(this));}}function t(i){if(i&&typeof i==="object"){i=m({},i);if(i.inParameters){i.inParameters=J.call(this,i.inParameters);}if(i.outParameters){i.outParameters=K.call(this,i.outParameters);}}return i;}l.prototype._isTextOrKeyRequestSupported=function(){var i=this.getContent();return!!i;};l.prototype.isUsableForValidation=function(){var i=this.getContent();return!!i;};function u(o1){var p1=o1.getParameter("selectedItems");var q1=o1.getParameter("itemPress");var r1;var s1=this.getConditions();var t1;var i=0;var j=0;var u1=false;var v1=this.getMaxConditions();for(i=s1.length-1;i>=0;i--){t1=s1[i];t1.inParameters=N.call(this,t1.inParameters);t1.outParameters=P.call(this,t1.outParameters);if(t1.validated===b.Validated){u1=false;for(j=0;j<p1.length;j++){r1=p1[j];if(t1.values[0]===r1.key&&(!t1.inParameters||!r1.inParameters||e(t1.inParameters,r1.inParameters))&&(!t1.outParameters||!r1.outParameters||e(t1.outParameters,r1.outParameters))){u1=true;if(t1.values[1]!==r1.description&&r1.description){if(t1.values.length===1){t1.values.push(r1.description);}else{t1.values[1]=r1.description;}}break;}}if(!u1){s1.splice(i,1);}}}for(i=0;i<p1.length;i++){r1=p1[i];u1=false;for(j=0;j<s1.length;j++){t1=s1[j];if(t1.validated===b.Validated&&t1.values[0]===r1.key&&(!t1.inParameters||e(t1.inParameters,r1.inParameters))&&(!t1.outParameters||e(t1.outParameters,r1.outParameters))){u1=true;t1.inParameters=r1.inParameters;t1.outParameters=r1.outParameters;break;}}if(!u1){t1=C.createItemCondition(r1.key,r1.description,r1.inParameters,r1.outParameters);t1.validated=b.Validated;s1.push(t1);}}if(v1>0&&s1.length>v1){s1.splice(0,s1.length-v1);}for(i=0;i<s1.length;i++){t1=s1[i];if(t1.inParameters){t1.inParameters=J.call(this,t1.inParameters);}else{delete t1.inParameters;}if(t1.outParameters){t1.outParameters=K.call(this,t1.outParameters);}else{delete t1.outParameters;}}if(this._bDialogOpen){this.setProperty("conditions",s1,true);}else{var w1=false;var x1=false;if(this.getMaxConditions()===1||q1){this.close();x1=true;}if(this.getMaxConditions()===1){w1=true;}this.setProperty("conditions",s1,true);this.fireSelect({conditions:s1,add:w1,close:x1});}}function v(i){var j=i.getParameter("contentChange");var o1=this.getContent();var p1=o1.getAsyncKeyText();if(j){var q1=this.getAggregation("_popover");var r1=this.getAggregation("_dialog");if(o1){if(o1.getFilterEnabled()&&!this._oFilterConditionModel&&((q1&&this._bOpenIfContent)||r1)){W.call(this);}if(q1&&this._bOpenIfContent){var s1=this._getField();if(s1){o1.fieldHelpOpen(true);q1.openBy(this._getControlForSuggestion());T.call(this);}this._bOpenIfContent=false;}else if(r1){var t1=r1.getContent()[0];a1.call(this,t1,o1.getDialogContent());}}}if(!p1){this.fireDataUpdate();}}function w(j){var o1=false;for(var i=0;i<j.length;i++){var p1=j[i];if(!p1.validated){a.checkConditionValidated(p1);o1=true;}}if(o1){this.setConditions(j);}else{x.call(this);}}function x(){if(!this._oField){return;}var j=this.getContent();if(j){var o1=this.getConditions();var p1=[];for(var i=0;i<o1.length;i++){var q1=o1[i];if(q1.validated===b.Validated){p1.push({key:q1.values[0],description:q1.values[1],inParameters:N.call(this,q1.inParameters),outParameters:P.call(this,q1.outParameters)});}}if(!e(p1,j.getSelectedItems())){j.setSelectedItems(p1);}}}function y(i){if(!this._oFilterConditionModel){return;}var j=this.getFilterFields();if(!j){return;}var o1=this._oFilterConditionModel.getConditions(j);var p1=o1.length>0?o1[0].values[0]:"";if(i===p1){return;}if(i){this._bOwnFilterChange=true;}this._oFilterConditionModel.removeAllConditions(j);i=i.trim();if(i){this._bOwnFilterChange=false;var q1=C.createCondition("StartsWith",[i],undefined,undefined,b.NotValidated);this._oFilterConditionModel.addCondition(j,q1);}}function z(i,j){var o1=i.getHelpPath();var p1=false;if(j==="remove"){this._oObserver.unobserve(i);if(this._getField()&&this.isOpen()){p1=E.call(this,o1);}}else{this._oObserver.observe(i,{properties:true});if(this._getField()&&this.isOpen()){var q1=i.getValue();var r1=i.getUseConditions();p1=E.call(this,o1);p1=A.call(this,o1,q1,r1)||p1;x.call(this);}}}function A(j,o1,p1){var q1;var r1;var s1;var t1=false;if(this._oFilterConditionModel&&j&&o1){q1=this.getFilterBar();if(this._bUseFilterBar&&q1){r1=q1.getInternalConditions();if(!r1[j]){r1[j]=[];}}if(p1){if(Array.isArray(o1)){for(var i=0;i<o1.length;i++){s1=m({},o1[i]);if(s1.inParameters){s1.inParameters=N.call(this,s1.inParameters);}if(s1.outParameters){s1.outParameters=P.call(this,s1.outParameters);}this._oFilterConditionModel.addCondition(j,s1);if(this._bUseFilterBar&&q1){r1[j].push(s1);}t1=true;}}}else{s1=C.createItemCondition(o1);s1.validated=b.Validated;this._oFilterConditionModel.addCondition(j,s1);if(this._bUseFilterBar&&q1){r1[j].push(s1);}t1=true;}}if(t1&&this._bUseFilterBar&&q1){q1.setInternalConditions(r1);}return t1;}function E(i){var j=false;if(this._oFilterConditionModel&&i&&this._oFilterConditionModel.getConditions(i).length>0){this._oFilterConditionModel.removeAllConditions(i);j=true;}var o1=this.getFilterBar();if(this._bUseFilterBar&&o1){var p1=o1.getInternalConditions();if(p1[i]&&p1[i].length>0){p1[i]=[];o1.setInternalConditions(p1);j=true;}}return j;}function G(i,j,o1,p1){if(this._bNoInOutFilterUpdate){return;}if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.sUpdateTimer=undefined;this.fireDataUpdate();}.bind(this),0);}if(!this._getField()||!this.isOpen()){return;}var q1=false;q1=E.call(this,i);q1=A.call(this,i,j,p1)||q1;x.call(this);}function H(i,j,o1,p1){if(!this._getField()||!this.isOpen()){return;}var q1=false;q1=E.call(this,j);q1=A.call(this,i,o1,p1)||q1;}function I(){var j=this.getInParameters();var o1=false;for(var i=0;i<j.length;i++){var p1=j[i];var q1=p1.getHelpPath();var r1=p1.getValue();var s1=p1.getUseConditions();o1=E.call(this,q1)||o1;o1=A.call(this,q1,r1,s1)||o1;}if(this._oFilterConditionModel&&!o1&&this._bApplyFilter&&this._bPendingFilterUpdate){this._bPendingFilterUpdate=false;this._oFilterConditionModel.checkUpdate(true,true);}}l.prototype.onFieldChange=function(){var o1=this.getOutParameters();m1.call(this);var p1=q.call(this,o1,false);S.resolve().then(function(){return s.call(this,p1);}.bind(this)).then(function(){if(this.bIsDestroyed){return;}var q1=this.getConditions();for(var i=0;i<q1.length;i++){var r1=q1[i];if(r1.outParameters){for(var s1 in r1.outParameters){for(var j=0;j<o1.length;j++){var t1=o1[j];var u1=t1.getValue();var v1=t1.getUseConditions();var w1=true;if(t1.getMode()===O.WhenEmpty){if(v1){w1=!u1||(Array.isArray(u1)&&u1.length===0);}else{w1=!u1;}}if(w1){if(v1){var x1;if(!t1.getHelpPath()){x1=C.createCondition("EQ",[t1.getFixedValue()],undefined,undefined,b.NotValidated);}else if(t1.getFieldPath()===s1){x1=C.createCondition("EQ",[r1.outParameters[s1]],undefined,undefined,b.Validated);}else{continue;}if(!u1){u1=[];}if(!Array.isArray(u1)){throw new Error("Value on OutParameter must be an array "+t1);}if(a.indexOfCondition(x1,u1)<0){x1.validated=b.Validated;u1.push(x1);t1.setValue(u1);}}else{if(!t1.getHelpPath()){t1.setValue(t1.getFixedValue());}else if(t1.getFieldPath()===s1){t1.setValue(r1.outParameters[s1]);}}}}}}}}.bind(this)).unwrap();};function J(i){return L.call(this,i,this.getInParameters());}function K(i){return L.call(this,i,this.getOutParameters());}function L(j,o1){if(!j||o1.length===0){return null;}var p1={};for(var i=0;i<o1.length;i++){var q1=o1[i];var r1=q1.getHelpPath();var s1=q1.getFieldPath();if(r1&&s1){for(var t1 in j){if(r1===t1){p1[s1]=j[t1];break;}}}else if(!r1&&s1&&q1.getFixedValue){p1[s1]=q1.getFixedValue();}}return p1;}function N(i){return Q.call(this,i,this.getInParameters());}function P(i,j){return Q.call(this,i,this.getOutParameters(),j);}function Q(o1,p1,q1,r1,s1){var t1;var u1;var v1;var w1;var i=0;if(p1.length>0){if(!o1){if(!q1){var x1=this.getBindingContext();for(i=0;i<p1.length;i++){u1=p1[i];v1=u1.getHelpPath();var y1=u1.getValue();if(r1||s1){var z1=u1.getBinding("value");var A1=false;if(z1){for(var j=0;j<r1.length;j++){if(z1.getPath()===r1[j].getPath()){y1=r1[j].getValue();A1=true;break;}}if(!A1&&s1&&z1.getContext()!==s1&&z1.getContext()===x1){y1=s1.getProperty(z1.getPath());}}}if(v1&&y1){if(!t1){t1={};}if(u1.getUseConditions()){if(y1.length>0){t1[v1]=y1[0].values[0];}}else{t1[v1]=y1;}}}}}else{for(var B1 in o1){for(i=0;i<p1.length;i++){u1=p1[i];v1=u1.getHelpPath();w1=u1.getFieldPath();if(w1&&w1===B1&&v1){if(!t1){t1={};}t1[v1]=o1[B1];}}}}}return t1;}function T(){if(!this._oFilterConditionModel||(!this.isOpen()&&!this._bNavigateRunning&&!this._bOpen)||this._bClosing||!this._bApplyFilter){this._bPendingFilterUpdate=true;return;}if(this._bFilterWaitingForBinding){return;}var i=this.getInParameters();var j=q.call(this,i,false);var o1=s.call(this,j);if(o1 instanceof Promise){o1.then(function(){this._bFilterWaitingForBinding=false;this._oFilterConditionModel.checkUpdate(true,true);}.bind(this));this._bFilterWaitingForBinding=true;return;}var p1=this.getContent();if(p1){var q1=this._oFilterConditionModel.getAllConditions();var r1=c.createConditionTypesMapFromFilterBar(q1,this.getFilterBar());var s1=c.createFilters(q1,r1);var t1=[];var u1=this._oFilterConditionModel.getConditions("$search");var v1;if(s1){t1.push(s1);}if(u1.length>0){v1=u1[0].values[0];}p1.applyFilters(t1,v1);}}function U(i){if(this._bOwnFilterChange){return;}var j=this.getFilterFields();if(j&&!this._bUpdateFilterAfterClose){var o1=this._oFilterConditionModel.getConditions(j);var p1=o1.length>0?o1[0].values[0]:"";if(p1!==this.getFilterValue()){this.setProperty("filterValue",p1,true);}}T.call(this);}function W(){if(!h&&!this._bFilterConditionModelRequested){h=sap.ui.require("sap/ui/mdc/condition/ConditionModel");if(!h){sap.ui.require(["sap/ui/mdc/condition/ConditionModel"],X.bind(this));this._bFilterConditionModelRequested=true;}}if(h){var i=this.getFilterValue();this._oFilterConditionModel=new h();if(i){y.call(this,i);}I.call(this);var j=this._oFilterConditionModel.bindProperty("/conditions",this._oFilterConditionModel.getContext("/conditions"));j.attachChange(U.bind(this));this.setModel(this._oFilterConditionModel,"filter");}}function X(i){h=i;this._bFilterConditionModelRequested=false;if(!this._bIsBeingDestroyed){W.call(this);}}l.prototype.getMaxConditions=function(){if(this._oField&&this._oField.getMaxConditionsForHelp){return this._oField.getMaxConditionsForHelp();}else if(this._oField&&this._oField.getMaxConditions){return this._oField.getMaxConditions();}else{return 1;}};l.prototype.getDisplay=function(){if(this._oField&&this._oField.getDisplay){return this._oField.getDisplay();}};l.prototype.getRequired=function(){if(this._oField&&this._oField.getRequired){return this._oField.getRequired();}else{return false;}};l.prototype.getDataType=function(){if(this._oField.getDataType){return this._oField.getDataType();}else{return"sap.ui.model.type.String";}};l.prototype._getFormatOptions=function(){if(this._oField&&this._oField._getFormatOptions){return this._oField._getFormatOptions();}else{return{};}};l.prototype._getKeyPath=function(){var i=this.getKeyPath();if(!i&&this._oField&&this._oField.getFieldPath&&this._oField.getFieldPath()){i=this._oField.getFieldPath();}return i;};l.prototype.clone=function(i,j){var o1=this.getContent();var p1=this.getFilterBar();if(o1){o1.detachEvent("navigate",p,this);o1.detachEvent("selectionChange",u,this);o1.detachEvent("dataUpdate",v,this);}if(p1){p1.detachEvent("search",j1,this);}var q1=F.prototype.clone.apply(this,arguments);if(o1){o1.attachEvent("navigate",p,this);o1.attachEvent("selectionChange",u,this);o1.attachEvent("dataUpdate",v,this);}if(p1){p1.attachEvent("search",j1,this);}return q1;};function Y(){var i;if((!D||!B||!V||!g)&&!this._bDialogRequested){D=sap.ui.require("sap/m/Dialog");B=sap.ui.require("sap/m/Button");V=sap.ui.require("sap/ui/mdc/field/ValueHelpPanel");g=sap.ui.require("sap/ui/mdc/field/DefineConditionPanel");k=sap.ui.require("sap/ui/model/base/ManagedObjectModel");if(!D||!B||!V||!g||!k){sap.ui.require(["sap/m/Dialog","sap/m/Button","sap/ui/mdc/field/ValueHelpPanel","sap/ui/mdc/field/DefineConditionPanel","sap/ui/model/base/ManagedObjectModel"],Z.bind(this));this._bDialogRequested=true;}}if(D&&B&&V&&g&&k&&!this._bDialogRequested){if(!this._oResourceBundle){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");}var j=new B(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),type:sap.m.ButtonType.Emphasized,press:d1.bind(this)});var o1=new B(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:e1.bind(this)});this._oManagedObjectModel=new k(this);var p1=$.call(this);i=new D(this.getId()+"-dialog",{contentHeight:"600px",contentWidth:"1000px",horizontalScrolling:false,verticalScrolling:false,title:this.getTitle(),resizable:true,draggable:true,content:[p1],afterOpen:f1.bind(this),afterClose:g1.bind(this),buttons:[j,o1]});i.isPopupAdaptationAllowed=function(){return false;};this.setAggregation("_dialog",i,true);i.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");h1.call(this,this.getShowConditionPanel());}return i;}function Z(i,j,o1,p1,q1){D=i;B=j;V=o1;g=p1;k=q1;this._bDialogRequested=false;if(!this._bIsBeingDestroyed){Y.call(this);if(this._bOpen){this.open();}}}function $(){var i=this.getContent();var j=this.getFilterBar();var o1=new V(this.getId()+"-VHP",{height:"100%",showFilterbar:!!j,searchEnabled:!!this.getFilterFields(),formatOptions:this._getFormatOptions(),search:n1.bind(this)});o1.setModel(this._oManagedObjectModel,"$help");if(i){i.initialize(false);a1.call(this,o1,i.getDialogContent());}if(j){o1.setFilterbar(j);}return o1;}function a1(i,j){i.setTable(j);}function b1(i,j){var o1=this.getAggregation("_popover");var p1=this.getAggregation("_dialog");if(i==="remove"){j.detachEvent("navigate",p,this);j.detachEvent("selectionChange",u,this);j.detachEvent("dataUpdate",v,this);j=undefined;}else{j.attachEvent("navigate",p,this);j.attachEvent("selectionChange",u,this);j.attachEvent("dataUpdate",v,this);x.call(this);}this.fireDataUpdate();if(this._bNavigate){this.navigate(this._iStep);}else if(o1){o1.invalidate();var q1=this.getFilterValue();if(q1){y.call(this,q1);}I.call(this);if(j&&j.getFilterEnabled()&&!this._oFilterConditionModel){W.call(this);}if(j&&this._bOpenIfContent){j.initialize(true);var r1=this._getField();if(r1){j.fieldHelpOpen(true);o1.openBy(this._getControlForSuggestion());}this._bOpenIfContent=false;}}else if(j&&this._bOpenIfContent){this._bOpenIfContent=false;this.open(true);}if(p1){if(j){j.initialize(false);if(j.getFilterEnabled()&&!this._oFilterConditionModel){W.call(this);}var s1=p1.getContent()[0];s1.setShowTokenizer(this.getMaxConditions()!==1);a1.call(this,s1,j.getDialogContent());if(p1.isOpen()||this._bOpen){j.fieldHelpOpen(false);}}}}function c1(){var i=this.getAggregation("_dialog");if(!i){i=Y.call(this);}return i;}function d1(i){this.close();var j=this.getConditions();j=C._removeEmptyConditions(j);a.updateConditionsValues(j,this._getFormatOptions().operators);this._bNoConditionModelUpdate=true;this.setProperty("conditions",j,true);this._bOK=true;}function e1(i){this.close();this.setProperty("conditions",this._aOldConditions,true);}function f1(i){}function g1(i){this._bDialogOpen=false;this._aOldConditions=undefined;this._bUseFilterBar=false;this._bApplyFilter=false;this._handleAfterClose(i);if(this._bOK){var j=this.getConditions();this.fireSelect({conditions:j,add:false,close:true});}this._bOK=undefined;}function h1(i){var j=this.getAggregation("_dialog");if(j&&this._oField){var o1=j.getContent()[0];if(i){if(!o1._oDefineConditionPanel){var p1=new g(this.getId()+"-DCP");o1.setDefineConditions(p1);}}else{o1.setDefineConditions();}}}function i1(i,j){if(i==="remove"){j.detachEvent("search",j1,this);j=undefined;}else{j.attachEvent("search",j1,this);}var o1=this.getAggregation("_dialog");if(o1){var p1=o1.getContent()[0];p1.setFilterbar(j);p1.setShowFilterbar(!!j);I.call(this);j1.call(this);}}function j1(j){if(!this._oFilterConditionModel||!this._bUseFilterBar){return;}var o1=this.getFilterBar();if(o1){var p1=this._oFilterConditionModel.getAllConditions();var q1=o1.getInternalConditions();var r1=this.getFilterFields();var i=0;var s1;var t1;for(s1 in p1){if(s1!==r1){for(i=0;i<p1[s1].length;i++){t1=m({},p1[s1][i]);if(!q1[s1]||a.indexOfCondition(t1,q1[s1])<0){this._oFilterConditionModel.removeCondition(s1,t1);}}}}for(s1 in q1){for(i=0;i<q1[s1].length;i++){t1=m({},q1[s1][i]);if(!p1[s1]||a.indexOfCondition(t1,p1[s1])<0){this._oFilterConditionModel.addCondition(s1,t1);}}}if(!this._bApplyFilter&&(j||o1.getLiveMode())){this._bApplyFilter=true;this._oFilterConditionModel.checkUpdate(true,true);}}}function k1(){if(!this._oFilterConditionModel){return;}var i=this.getFilterBar();if(i){var j=this._oFilterConditionModel.getAllConditions();var o1=i.getInternalConditions();var p1=this.getFilterFields();var q1=false;var r1;for(r1 in o1){if(r1!==p1){if(j[r1]&&j[r1].length>0){this._oFilterConditionModel.removeAllConditions(r1);}if(o1[r1].length>0){o1[r1]=[];q1=true;}}}j=this._oFilterConditionModel.getAllConditions();for(r1 in j){if(r1!==p1){if(j[r1].length>0){this._oFilterConditionModel.removeAllConditions(r1);}}}if(q1){i.setInternalConditions(o1);}}I.call(this);}function l1(){var i=this.getContent();if(i){return i.getSuggestionContent();}}function m1(){var i=this._oField?this._oField.getBindingContext():null;this.setBindingContext(i);}function n1(i){this._bApplyFilter=true;this._oFilterConditionModel.checkUpdate(true,true);}l.prototype.getScrollDelegate=function(){var i=this.getAggregation("_dialog");if(i&&(i.isOpen()||i.oPopup.getOpenState()==="Opening")){var j=this.getContent();var o1=j&&j.getDialogContent();if(o1&&o1.getScrollDelegate){return o1.getScrollDelegate();}else{return undefined;}}else{return F.prototype.getScrollDelegate.apply(this,arguments);}};l.prototype._fireOpen=function(i){if(!this._bOpenHandled){return F.prototype._fireOpen.apply(this,arguments);}return true;};l.prototype.getRoleDescription=function(){if(this.getMaxConditions()===1){return null;}else{if(!this._oResourceBundleM){this._oResourceBundleM=sap.ui.getCore().getLibraryResourceBundle("sap.m");}return this._oResourceBundleM.getText("MULTICOMBOBOX_ARIA_ROLE_DESCRIPTION");}};return l;});
