/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/layout/cssgrid/GridLayoutBase","sap/ui/layout/cssgrid/GridBasicLayout","sap/ui/layout/cssgrid/GridLayoutDelegate","sap/ui/base/ManagedObjectObserver","sap/ui/layout/library","./CSSGridRenderer"],function(C,G,a,b,M){"use strict";var c=C.extend("sap.ui.layout.cssgrid.CSSGrid",{metadata:{library:"sap.ui.layout",defaultAggregation:"items",interfaces:["sap.ui.layout.cssgrid.IGridConfigurable"],properties:{width:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},gridTemplateColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridTemplateRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridRowGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridColumnGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridGap:{type:"sap.ui.layout.cssgrid.CSSGridGapShortHand",defaultValue:""},gridAutoRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoFlow:{type:"sap.ui.layout.cssgrid.CSSGridAutoFlow",defaultValue:"Row"}},aggregations:{customLayout:{type:"sap.ui.layout.cssgrid.GridLayoutBase",multiple:false},items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true}},dnd:{draggable:false,droppable:true}}});c.prototype.getGridDomRefs=function(){return[this.getDomRef()];};c.prototype.getGridLayoutConfiguration=function(){if(this.getCustomLayout()){return this.getCustomLayout();}else{return this._getDefaultGridLayout();}};c.prototype._getDefaultGridLayout=function(){var d=new a({gridTemplateColumns:this.getGridTemplateColumns(),gridTemplateRows:this.getGridTemplateRows(),gridRowGap:this.getGridRowGap(),gridColumnGap:this.getGridColumnGap(),gridGap:this.getGridGap(),gridAutoRows:this.getGridAutoRows(),gridAutoColumns:this.getGridAutoColumns(),gridAutoFlow:this.getGridAutoFlow()});return d;};c.prototype.init=function(){this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._oGridObserver=new M(this._onGridChange.bind(this));this._oGridObserver.observe(this,{aggregations:["items"]});this._addGridLayoutDelegate();};c.prototype.exit=function(){this._removeGridLayoutDelegate();if(this._oGridObserver){this._oGridObserver.disconnect();this._oGridObserver=null;}};c.prototype._addGridLayoutDelegate=function(){if(!this.oGridLayoutDelegate){this.oGridLayoutDelegate=new b();this.addDelegate(this.oGridLayoutDelegate,false,this,false);}};c.prototype._removeGridLayoutDelegate=function(){if(this.oGridLayoutDelegate){this.removeDelegate(this.oGridLayoutDelegate);this.oGridLayoutDelegate.destroy();this.oGridLayoutDelegate=null;}};c.prototype._onGridChange=function(o){if(o.name!=="items"||!o.child){return;}if(o.mutation==="insert"){o.child.addEventDelegate(this._oItemDelegate,o.child);}else if(o.mutation==="remove"){o.child.removeEventDelegate(this._oItemDelegate,o.child);}};c.prototype._onAfterItemRendering=function(){G.setItemStyles(this);};c.prototype.onLayoutDataChange=function(e){G.setItemStyles(e.srcControl);};return c;});
