//@ui5-bundle sap/uxap/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/uxap/AnchorBar',["sap/ui/thirdparty/jquery","sap/m/Button","sap/m/MenuButton","sap/m/library","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","sap/ui/core/Control","./HierarchicalSelect","./library","sap/uxap/AnchorBarRenderer","sap/base/Log","sap/ui/events/KeyCodes"],function(q,B,M,m,T,I,a,R,S,H,D,C,b,c,l,A,L,K){"use strict";var d=m.SelectType;
var e=T.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
e.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._bRtlScenario=this._bRtl&&!D.browser.msie;this._bHasButtonsBar=D.system.tablet||D.system.desktop;this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=0;this._iTolerance=0;this._iOffset=0;this._sResizeListenerId=undefined;}this.setDesign("Transparent");};
e.SCROLL_STEP=250;e.SCROLL_DURATION=500;e.DOM_CALC_DELAY=200;
e.prototype.setSelectedButton=function(o){var p=this.getSelectedButton(),P,s=this._oSelect.getItems(),h=s.length>0;if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o){if(o.getId()===p){return this;}var f=o.data("sectionId");this._sSelectedKey=f;if(f&&h){this._oSelect.setSelectedKey(f);}if(this._bHasButtonsBar&&o.data("secondLevel")!==true){P=sap.ui.getCore().byId(p);this._toggleSelectionStyleClass(P,false);this._toggleSelectionStyleClass(o,true);if(f){this.scrollToSection(f,e.SCROLL_DURATION);}this._setAnchorButtonsTabFocusValues(o);}this.setAssociation("selectedButton",o,true);}return this;};
e.prototype.setShowPopover=function(v,s){if(this.getShowPopover()===v){return this;}return this.setProperty("showPopover",v,true);};
e.prototype.getSelectedSection=function(){var s=this.getSelectedButton();if(s&&(typeof(s)==="string")){s=sap.ui.getCore().byId(s);}if(s&&(s instanceof B)&&s.data("sectionId")){return sap.ui.getCore().byId(s.data("sectionId"));}return null;};
e.prototype.onBeforeRendering=function(){if(this._bHasButtonsBar){this._iREMSize=parseInt(q("body").css("font-size"));this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3;}if(T.prototype.onBeforeRendering){T.prototype.onBeforeRendering.call(this);}var f=this.getContent()||[],u=this.getUpperCase();this._oSelect.setUpperCase(u);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",u);if(f.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey);}};
e.prototype.addContent=function(o,i){var f=o.data("secondLevel")===true||o.data("secondLevel")==="true";o.addStyleClass("sapUxAPAnchorBarButton");o.removeAllAriaDescribedBy();this._createSelectItem(o,f);if(f){o.destroy();}else{this.addAggregation("content",o,i);}return this;};
e.prototype._createSelectItem=function(o,i){var f=o.getBindingInfo("text"),g=o.getText().trim()!=""||f;if(g&&(!i||o.data("bTitleVisible")===true)){var p=new a({key:o.data("sectionId"),text:o.getText(),customData:[new C({key:"secondLevel",value:o.data("secondLevel")})]});if(f){p.bindProperty("text",Object.assign({},f));}this._oSelect.addItem(p);}};
e.prototype._decorateSubMenuButtons=function(E){var f=E.getSource().getContent();f.forEach(function(o){o.$().attr("aria-controls",o.data("sectionId"));});};
e.prototype._toggleSelectionStyleClass=function(o,f){if(o&&o.toggleStyleClass){o.toggleStyleClass("sapUxAPAnchorBarButtonSelected",f);if(o instanceof M){o._getButtonControl().$().attr("aria-selected",f);}else{o.$().attr("aria-selected",f);}}};
e.prototype._handleDirectScroll=function(E){this._requestScrollToSection(E.getSource().data("sectionId"));};
e.prototype._requestScrollToSection=function(r){var o=sap.ui.getCore().byId(r),f=o.getParent();if(this.getParent()instanceof l.ObjectPageLayout){var n=r;if(o instanceof l.ObjectPageSubSection&&f instanceof l.ObjectPageSection){n=f.getId();}this.getParent().setDirectScrollingToSection(n);this.getParent().scrollToSection(o.getId(),null,0,true);}if(o instanceof l.ObjectPageSubSection&&f instanceof l.ObjectPageSection){f.setAssociation("selectedSubSection",o,true);}};
e.prototype._onSelectChange=function(E){var s=E.getParameter("selectedItem"),o;if(!s){L.warning("AnchorBar :: no selected hierarchicalSelect item");return;}o=sap.ui.getCore().byId(s.getKey());if(o){this._requestScrollToSection(o.getId());}else{L.error("AnchorBar :: cannot find corresponding section",s.getKey());}};
e.prototype._getHierarchicalSelect=function(){if(!this.getAggregation('_select')){this.setAggregation('_select',new c({width:"100%",icon:"sap-icon://slim-arrow-down",tooltip:this.oLibraryResourceBundleOP.getText("ANCHOR_BAR_OVERFLOW"),change:q.proxy(this._onSelectChange,this)}));}return this.getAggregation('_select');};
e.prototype._createScrollArrow=function(f){var s,i,g,h,o,t=this,j=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),k=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(f){s=this.getId()+"-arrowScrollLeft";i="slim-arrow-left";g="anchorBarArrowLeft";h=this._bRtl?k:j;}else{s=this.getId()+"-arrowScrollRight";i="slim-arrow-right";g="anchorBarArrowRight";h=this._bRtl?j:k;}o=new B(s,{icon:I.getIconURI(i),type:"Transparent",press:function(E){E.preventDefault();t._handleScrollButtonTap(f);},tooltip:h});o.addEventDelegate({onAfterRendering:function(){if(sap.ui.getCore().getConfiguration().getTheme()!="sap_hcb"){this.$().attr("tabindex",-1);}},onThemeChanged:function(){if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",-1);}}},o);return new H({content:[o]}).addStyleClass("anchorBarArrow").addStyleClass(g);};
e.prototype._getScrollArrowLeft=function(){var s=this.getAggregation("_scrollArrowLeft");if(s){return s;}else{s=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",s);return s;}};
e.prototype._getScrollArrowRight=function(){var s=this.getAggregation("_scrollArrowRight");if(s){return s;}else{s=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",s);return s;}};
e.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this._bHideScrollContainer=false;this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(d.IconOnly);this._computeBarSectionsInfo();}else{this._bHideScrollContainer=true;this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(d.Default);}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon);this.invalidate();};
e.prototype._adjustSize=function(E){var o=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),w=E&&E.size&&(E.size.width!==E.oldSize.width),n=l.Utilities.isPhoneScenario(o)?A._AnchorBarHierarchicalSelectMode.Text:A._AnchorBarHierarchicalSelectMode.Icon;if(n!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=n;this._applyHierarchicalSelectMode();}if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0){return;}var $=this.$(),f=$.find(".sapUxAPAnchorBarScrollContainer"),N,g,i;if(w){this.scrollToSection(this._sSelectedKey);}i=f.width();if(this._bRtlScenario){if(D.browser.firefox){g=Math.abs(f.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);N=Math.abs(f.scrollLeft())>=this._iTolerance;}else{g=Math.abs(f.scrollLeft())>=this._iTolerance;N=Math.abs(f.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);}}else{g=f.scrollLeft()+i<(this._iMaxPosition-this._iTolerance);N=f.scrollLeft()>=this._iTolerance;}L.debug("AnchorBar :: scrolled at "+f.scrollLeft(),"scrollBegin ["+(N?"true":"false")+"] scrollEnd ["+(g?"true":"false")+"]");$.toggleClass("sapUxAPAnchorBarScrollLeft",N);$.toggleClass("sapUxAPAnchorBarScrollRight",g);}};
e.prototype._handleScrollButtonTap=function(s){var i=((!this._bRtlScenario&&s)||(this._bRtlScenario&&!s))?-1:1;this._oScroller.scrollTo(this._iMaxPosition*i,0,e.SCROLL_DURATION*3);};
e.prototype.scrollToSection=function(i,f){if(this._bHasButtonsBar){var o=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),f=f||e.SCROLL_DURATION,s;if(!l.Utilities.isPhoneScenario(o)&&this._oSectionInfo[i]){if(this._bRtlScenario&&D.browser.firefox){s=this._oSectionInfo[i].scrollLeft+this._iOffset;}else{s=this._oSectionInfo[i].scrollLeft-this._iOffset;if(s<0){s=0;}}L.debug("AnchorBar :: scrolling to section "+i+" of "+s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);q(document.getElementById(this.getId()+"-scroll")).parent().stop(true,false);}this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),f);this._oScroller.scrollTo(s,0,f);}}else{L.debug("AnchorBar :: no need to scroll to "+i);}}};
e.prototype.getScrollDelegate=function(){return this._oScroller;};
e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
e.prototype.onsapright=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};
e.prototype.onsapleft=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i-1;return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};
e.prototype.onsapdown=function(E){E.preventDefault();};
e.prototype.onsapup=function(E){E.preventDefault();};
e.prototype.onsaphome=function(E){E.preventDefault();var f=this.getContent();f[0].focus();};
e.prototype.onsapend=function(E){E.preventDefault();var f=this.getContent();f[f.length-1].focus();};
e.prototype.onsappageup=function(E){this._handlePageUp(E);};
e.prototype.onsappagedown=function(E){this._handlePageDown(E);};
e.prototype._handlePageUp=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i-(e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};
e.prototype._handlePageDown=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i+e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};
e.prototype._setAnchorButtonsTabFocusValues=function(s){var f=this.getContent()||[],$,F='0',n='-1',t="tabIndex";f.forEach(function(o){$=o.getAggregation("_button")?o.getAggregation("_button").$():o.$();if(o.sId===(s&&s.sId)){$.attr(t,F);}else{$.attr(t,n);}});};
e.prototype.onAfterRendering=function(){var s;if(T.prototype.onAfterRendering){T.prototype.onAfterRendering.call(this);}s=sap.ui.getCore().byId(this.getSelectedButton());this._setAnchorButtonsTabFocusValues(s);this._iMaxPosition=-1;this._sResizeListenerId=R.register(this,q.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").on("scroll",q.proxy(this._onScroll,this));if(s){this.setSelectedButton(s);}if(this._bHasButtonsBar){setTimeout(function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo();}this._adjustSize();}.bind(this),e.DOM_CALC_DELAY);}};
e.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=setTimeout(function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize();}.bind(this),e.SCROLL_DURATION);}};
e.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var f=this.getContent()||[];f.forEach(this._computeNextSectionInfo,this);if(this._bRtlScenario&&(D.browser.webkit||D.browser.firefox)){f.forEach(this._adjustNextSectionInfo,this);this._oScroller.scrollTo(this._iMaxPosition,0,0);}};
e.prototype._computeNextSectionInfo=function(o){var f=o.isA("sap.m.MenuButton")?o._getButtonControl():o,s=o.hasStyleClass("sapUxAPAnchorBarButtonSelected");if(o.data("bHasSubMenu")){f.$().attr("aria-haspopup","menu");f.$().find(".sapMBtn").attr("role","group").removeAttr('aria-haspopup');}f.$().attr("aria-controls",o.data("sectionId")).attr("aria-selected",s);var w=o.$().outerWidth(true);this._oSectionInfo[o.data("sectionId")]={scrollLeft:this._iMaxPosition,width:w};this._iMaxPosition+=w;};
e.prototype._adjustNextSectionInfo=function(o){var s=this._oSectionInfo[o.data("sectionId")];if(D.browser.firefox){s.scrollLeft=-s.scrollLeft;}else{s.scrollLeft=this._iMaxPosition-s.scrollLeft-s.width;}};
e.prototype._resetControl=function(){this.destroyAggregation('content');this._oSelect.destroyAggregation("items",true);return this;};
e.prototype._getAccessibilityRole=function(){return'none';};
e.prototype.enhanceAccessibilityState=function(E,f){var o=this.getContent(),i=o.indexOf(E);if(i!==-1){f.role="option";f.setsize=o.length;f.posinset=i+1;}};
e.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null;}};
e.prototype._getWidth=function(o){var f=o.getDomRef();return!(o instanceof b)?0:(f&&f.offsetWidth)||0;};
e.prototype.setVisible=function(v){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoAnchorBar",!v);return this.setProperty("visible",v);};
return e;});
sap.ui.predefine('sap/uxap/AnchorBarRenderer',["sap/m/ToolbarRenderer","sap/ui/core/Renderer","sap/m/BarInPageEnabler","./library"],function(T,R,B,l){"use strict";var A=R.extend(T);A.apiVersion=2;var _=A._AnchorBarHierarchicalSelectMode={Icon:"icon",Text:"text"};
A.renderBarContent=function(r,t){if(t._bHasButtonsBar){r.renderControl(t._getScrollArrowLeft());r.openStart("div",t.getId()+"-scrollContainer");if(t._bHideScrollContainer){r.style("display","none");}r.class("sapUxAPAnchorBarScrollContainer").openEnd();r.openStart("div",t.getId()+"-scroll").attr("role","listbox").attr("aria-describedby",t.getId()+"-desc").attr("aria-roledescription",sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("ANCHOR_BAR_ROLE_DESCRIPTION")).openEnd();if(!t._bHideScrollContainer){A.renderBarItems(r,t);}r.close("div");r.openStart("span",t.getId()+"-desc").class("sapUiPseudoInvisibleText").openEnd();r.text(sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("ANCHOR_BAR_ARIA_LABEL_DESC"));r.close("span");r.close("div");r.renderControl(t._getScrollArrowRight());}B.addChildClassTo(t._oSelect,t);r.renderControl(t._oSelect);};
A.renderBarItems=function(r,t){var s=t.getSelectedButton();t.getContent().forEach(function(c){B.addChildClassTo(c,t);if(c.getId()===s){c.addStyleClass("sapUxAPAnchorBarButtonSelected");}r.renderControl(c);});};
A.decorateRootElement=function(r,t){T.decorateRootElement.apply(this,arguments);if(t._sHierarchicalSelectMode===_.Icon){r.class("sapUxAPAnchorBarOverflow");}if(t.getBackgroundDesign()){r.class("sapUxAPAnchorBar"+t.getBackgroundDesign());}};
return A;},true);
sap.ui.predefine('sap/uxap/BlockBase',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/mvc/View","./BlockBaseMetadata","sap/ui/model/Context","sap/ui/Device","sap/ui/layout/form/ColumnLayout","./library","sap/ui/core/Component","sap/ui/layout/library","sap/base/Log"],function(q,C,a,b,B,c,D,d,l,e,f,L){"use strict";var S=f.form.SimpleFormLayout;var g=l.BlockBaseFormAdjustment;
var h=C.extend("sap.uxap.BlockBase",{
metadata:{designtime:"sap/uxap/designtime/BlockBase.designtime",library:"sap.uxap",properties:{"mode":{type:"string",group:"Appearance"},"visible":{type:"boolean",group:"Appearance",defaultValue:true},"columnLayout":{type:"sap.uxap.BlockBaseColumnLayout",group:"Behavior",defaultValue:"auto"},"formAdjustment":{type:"sap.uxap.BlockBaseFormAdjustment",group:"Behavior",defaultValue:g.BlockColumns},"showSubSectionMore":{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mappings",aggregations:{"mappings":{type:"sap.uxap.ModelMapping",multiple:true,singularName:"mapping"},"_views":{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},associations:{"selectedView":{type:"sap.ui.core.Control",multiple:false}},events:{"viewInit":{parameters:{view:{type:"sap.ui.core.mvc.View"}}}},views:{}},
renderer:"sap.uxap.BlockBaseRenderer"
},B);
h.prototype.init=function(){if(!this.getMetadata().hasViews()){this.getMetadata().setView("defaultXML",{viewName:this.getMetadata().getName(),type:"XML"});}this._oMappingApplied={};this._bLazyLoading=false;this._bConnected=false;this._oUpdatedModels={};this._oParentObjectPageSubSection=null;this._oPromisedViews={};};
h.prototype.onBeforeRendering=function(){var p;this._applyMapping();if(!this.getMode()||this.getMode()===""){if(this.getMetadata().getView("defaultXML")){this.setMode("defaultXML");}else{L.error("BlockBase ::: there is no mode defined for rendering "+this.getMetadata().getName()+". You can either set a default mode on the block metadata or set the mode property before rendering the block.");}}this._applyFormAdjustment();p=this._getObjectPageLayout();this._bLazyLoading=p&&(p.getEnableLazyLoading()||p.getUseIconTabBar());};
h.prototype.onAfterRendering=function(){var p=this._getObjectPageLayout();if(p){p._requestAdjustLayout();}};
h.prototype.setParent=function(p,A,s){if(p instanceof l.ObjectPageSubSection){this._bLazyLoading=true;this._oParentObjectPageSubSection=p;}else{C.prototype.setParent.call(this,p,A,s);}};
h.prototype.setModel=function(m,n){this._applyMapping(n);return C.prototype.setModel.call(this,m,n);};
h.prototype._applyMapping=function(){if(this._shouldLazyLoad()){L.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected");}else{this.getMappings().forEach(function(m,i){var M,o,I=m.getInternalModelName(),E=m.getExternalPath(),s=m.getExternalModelName(),p;if(E){if(I==""||E==""){throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty");}M=this.getModel(s);if(!M){return;}p=M.resolve(E,this.getBindingContext(s));o=this.getBindingContext(I);if(!this._isMappingApplied(I)||(this.getModel(I)!==this.getModel(s))||(o&&(o.getPath()!==p))){L.info("BlockBase :: mapping external model "+s+" to "+I);this._oMappingApplied[I]=true;C.prototype.setModel.call(this,M,I);this.setBindingContext(new c(M,p),I);}}},this);}};
h.prototype._isMappingApplied=function(i){return this.getModel(i)&&this._oMappingApplied[i];};
h.prototype.propagateProperties=function(n){if(this._shouldLazyLoad()&&!this._oUpdatedModels.hasOwnProperty(n)){this._oUpdatedModels[n]=true;}else{this._applyMapping(n);}return C.prototype.propagateProperties.call(this,n);};
h.prototype.getSupportedModes=function(){var s=q.extend({},this.getMetadata().getViews());for(var k in s){s[k]=k;}return s;};
h.prototype.setMode=function(m){m=this._validateMode(m);if(this.getMode()!==m){this.setProperty("mode",m,false);if(!this._shouldLazyLoad()){this._selectView(m);}}return this;};
h.prototype.setColumnLayout=function(s){if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.invalidate();}this.setProperty("columnLayout",s);};
h.prototype.clone=function(){var A=-1,s=this.getAssociation("selectedView"),v=this.getAggregation("_views")||[];if(s){v.forEach(function(V,i){if(V.getId()===s){A=i;}return A<0;});}var n=C.prototype.clone.call(this);if(A>=0){n.setAssociation("selectedView",n.getAggregation("_views")[A]);}return n;};
h.prototype._validateMode=function(m){this.validateProperty("mode",m);if(!this.getMetadata().getView(m)){var s=this.getMetadata()._sClassName||this.getId();if(this.getMetadata().getView("defaultXML")){L.warning("BlockBase :: no view defined for block "+s+" for mode "+m+", loading defaultXML instead");m="defaultXML";}else{throw new Error("BlockBase :: no view defined for block "+s+" for mode "+m);}}return m;};
h.prototype._getSelectedViewContent=function(){var v=null,s,V;s=this.getAssociation("selectedView");V=this.getAggregation("_views");if(V){for(var i=0;!v&&i<V.length;i++){if(V[i].getId()===s){v=V[i];}}}return v;};
h.prototype.createView=function(p,m){if(!this._oPromisedViews[p.id]){this._oPromisedViews[p.id]=new Promise(function(r,i){var o=e.getOwnerComponentFor(this),j=function(){var k=function(){return b.create(p);};if(o){return o.runAsOwner(k);}else{return k();}};j().then(function(v){this._afterViewInstantiated(v,m);r(v);}.bind(this));}.bind(this));}return this._oPromisedViews[p.id];};
h.prototype._afterViewInstantiated=function(v,m){var o=v.getController();if(v){if(o){o.oParentBlock=this;}v.addCustomData(new a({"key":"layoutMode","value":m}));this.addAggregation("_views",v);this.fireEvent("viewInit",{view:v});}else{throw new Error("BlockBase :: no view defined in metadata.views for mode "+m);}};
h.prototype._notifyForLoadingInMode=function(o,v,m){if(o&&typeof o.onParentBlockModeChange==="function"){o.onParentBlockModeChange(m);}else{L.info("BlockBase ::: could not notify "+v.sViewName+" of loading in mode "+m+": missing controller onParentBlockModeChange method");}};
h.prototype._selectView=function(m){var v,V=this.getId()+"-"+m,s,i;i=function(v){if(v&&this.getAssociation("selectedView")!==V){this.setAssociation("selectedView",v);this._notifyForLoadingInMode(v.getController(),v,m);}}.bind(this);v=this._findView(m);if(v){i(v);return;}s=this.getMetadata().getView(m);s.id=V;this.createView(s,m).then(function(v){i(v);});};
h.prototype._findView=function(m){var v=this.getAggregation("_views")||[],V,F;F=v.filter(function(o){return o.data("layoutMode")===m;});if(F.length){return F[0];}V=this.getMetadata().getView(m);F=v.filter(function(o){return V.viewName===o.getViewName();});if(F.length){return F[0];}};
h.FORM_ADUSTMENT_OFFSET=16;h._FORM_ADJUSTMENT_CONST={labelSpan:{L:12},emptySpan:{L:0},columns:{XL:1,L:1,M:1}};h._PARENT_GRID_SIZE=12;
h.prototype._computeFormAdjustmentFields=function(F,p){if(F&&p){return F===g.BlockColumns?q.extend({},h._FORM_ADJUSTMENT_CONST,{columns:p}):h._FORM_ADJUSTMENT_CONST;}};
h.prototype._applyFormAdjustment=function(){var F=this.getFormAdjustment(),v=this._getSelectedViewContent(),p=this._oParentObjectPageSubSection,o;if((F!==g.None)&&v&&p){o=this._computeFormAdjustmentFields(F,p._oLayoutConfig);v.getContent().forEach(function(i){this._adjustForm(i,o);}.bind(this));}};
h.prototype._adjustForm=function(F,o){var i,j;if(F.getMetadata().getName()==="sap.ui.layout.form.SimpleForm"){F.setLayout(S.ColumnLayout);j=F.getAggregation("form").getLayout();j._iBreakPointTablet-=h.FORM_ADUSTMENT_OFFSET;j._iBreakPointDesktop-=h.FORM_ADUSTMENT_OFFSET;j._iBreakPointLargeDesktop-=h.FORM_ADUSTMENT_OFFSET;F.setLabelSpanL(o.labelSpan.L);F.setEmptySpanL(o.emptySpan.L);this._applyFormAdjustmentFields(o,F);F.setWidth("100%");}else if(F.getMetadata().getName()==="sap.ui.layout.form.Form"){j=F.getLayout();if(j&&j.getMetadata().getName()==="sap.ui.layout.form.ColumnLayout"){i=j;}else{i=new d();F.setLayout(i);}i._iBreakPointTablet-=h.FORM_ADUSTMENT_OFFSET;i._iBreakPointDesktop-=h.FORM_ADUSTMENT_OFFSET;i._iBreakPointLargeDesktop-=h.FORM_ADUSTMENT_OFFSET;i.setLabelCellsLarge(o.labelSpan.L);i.setEmptyCellsLarge(o.emptySpan.L);this._applyFormAdjustmentFields(o,i);F.setWidth("100%");}};
h.prototype._applyFormAdjustmentFields=function(F,o){o.setColumnsXL(F.columns.XL);o.setColumnsL(F.columns.L);o.setColumnsM(F.columns.M);};
h.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};
h.prototype.setVisible=function(v,s){var p=this._getObjectPageLayout();this.setProperty("visible",v,s);p&&p._requestAdjustLayoutAndUxRules();return this;};
h.prototype.setShowSubSectionMore=function(v,i){if(v!=this.getShowSubSectionMore()){this.setProperty("showSubSectionMore",v,true);if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.refreshSeeMoreVisibility();}}return this;};
h.prototype.connectToModels=function(){if(!this._bConnected){L.debug("BlockBase :: Connecting block to the UI5 model tree");this._bConnected=true;if(this._bLazyLoading){var m=this.getMode();m&&this._selectView(m);}this.invalidate();}};
h.prototype._allowPropagationToLoadedViews=function(A){if(!this._bConnected){return;}this.mSkipPropagation._views=!A;};
h.prototype.updateBindingContext=function(s,i,m,u){if(!this._shouldLazyLoad()){return C.prototype.updateBindingContext.call(this,s,i,m,u);}else{L.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};
h.prototype.updateBindings=function(u,m){if(!this._shouldLazyLoad()){return C.prototype.updateBindings.call(this,u,m);}else{L.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};
h.prototype._shouldLazyLoad=function(){return!!this._oParentObjectPageSubSection&&this._bLazyLoading&&!this._bConnected;};
return h;});
sap.ui.predefine('sap/uxap/BlockBaseMetadata',["sap/ui/thirdparty/jquery","sap/ui/core/ElementMetadata","sap/base/Log"],function(q,E,L){"use strict";var B=function(c,C){E.apply(this,arguments);this._mViews=C.metadata.views||{};};B.prototype=Object.create(E.prototype);B.prototype.constructor=B;
B.prototype.applySettings=function(c){var r=c.hasOwnProperty("renderer")?(c.renderer||""):undefined;E.prototype.applySettings.call(this,c);if(r==null){this._sRendererName=null;}};
B.prototype.getRendererName=function(){if(!this._sBlockRenderer){this._sBlockRenderer=this._resolveRendererName();L.debug("BlockBaseMetadata :: "+this.getName()+" is renderer with "+this._sBlockRenderer);}return this._sBlockRenderer;};
B.prototype._resolveRendererName=function(){var c=E.prototype.getRendererName.call(this);if(c==null){var p=this.getParent();if(p){c=B.prototype._resolveRendererName.apply(p);}else{throw new Error("BlockBaseMetadata :: no renderer found for "+this.getName());}}return c;};
B.prototype.getView=function(v){return this._mViews[v];};
B.prototype.getViews=function(){return this._mViews;};
B.prototype.setView=function(v,V){this._mViews[v]=V;return this;};
B.prototype.hasViews=function(){return!q.isEmptyObject(this._mViews);};
return B;},true);
sap.ui.predefine('sap/uxap/BlockBaseRenderer',function(){"use strict";var B={apiVersion:2};
B.render=function(r,c){if(!c.getVisible()){return;}r.openStart("div",c);if(c._getSelectedViewContent()){r.class('sapUxAPBlockBase').class("sapUxAPBlockBase"+c.getMode());}else{var C=c.getMetadata().getName().split(".").pop();r.class(C+c.getMode());}r.openEnd();if(c._getSelectedViewContent()){r.renderControl(c._getSelectedViewContent());}r.close("div");};
return B;},true);
sap.ui.predefine('sap/uxap/BreadCrumbs',["sap/m/Link","sap/m/Select","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/Device","./library","sap/ui/core/InvisibleText","./BreadCrumbsRenderer","sap/ui/thirdparty/jquery"],function(L,S,C,R,I,a,b,D,l,c,B,q){"use strict";
var d=C.extend("sap.uxap.BreadCrumbs",{metadata:{library:"sap.uxap",properties:{showCurrentLocation:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"links",aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},currentLocation:{type:"sap.m.Text",multiple:false},_tubeIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowSelect:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}}});
d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
d.prototype.init=function(){this._iREMSize=parseInt(q("body").css("font-size"));this._iContainerMaxHeight=this._iREMSize*2;};
d.prototype.onBeforeRendering=function(){this._bOnPhone=D.system.phone;this._resetControl();};
d.prototype.onAfterRendering=function(){this._handleInitialModeSelection();};
d.prototype._handleInitialModeSelection=function(){if(this._bOnPhone){this._setSelectVisible(true);return this;}this._configureKeyboardHandling();if(!this._iContainerHeight){this._iContainerHeight=this.$().outerHeight();}if(this._iContainerHeight>this._iContainerMaxHeight){this._toggleOverflowMode(true);return this;}this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};
d.prototype._toggleOverflowMode=function(u){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}this._setSelectVisible(u);this._setBreadcrumbsVisible(!u);this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};
d.prototype._getTubeIcon=function(){if(!this.getAggregation("_tubeIcon")){this.setAggregation("_tubeIcon",new b({"src":"sap-icon://slim-arrow-right","color":"#bfbfbf","size":"1rem","useIconTooltip":false}).addStyleClass("sapUxAPTubeIcon"));}return this.getAggregation("_tubeIcon");};
d.prototype._getOverflowSelect=function(){var o,s;if(!this.getAggregation("_overflowSelect")){s=this.getLinks().reverse()||[];s.unshift(this.getCurrentLocation());o=new S({items:s.map(this._createSelectItem),autoAdjustWidth:true});o.attachChange(this._overflowSelectChangeHandler);this.setAggregation("_overflowSelect",o);}return this.getAggregation("_overflowSelect");};
d.prototype._createSelectItem=function(i){return new a({key:i.getId(),text:i.getText()});};
d.prototype._overflowSelectChangeHandler=function(e){var s=e.getParameter("selectedItem").getKey(),o=sap.ui.getCore().byId(s),f,g;if(o instanceof L){f=o.getHref();o.firePress();if(f){g=o.getTarget();if(g){window.open(f,g);}else{window.location.href=f;}}}return this;};
d.prototype._handleScreenResize=function(e){var s=this._shouldOverflow(),u=this._getUsingOverflowSelect();if(s&&!u){this._toggleOverflowMode(true);}else if(!s&&u){this._toggleOverflowMode(false);}return this;};
d.prototype._shouldOverflow=function(){var $=this._getBreadcrumbsAsJQueryObject(),s,u=this._getUsingOverflowSelect();if(u){this._setBreadcrumbsVisible(true);}$.addClass("sapUxAPInvisible");s=$.outerHeight()>this._iContainerMaxHeight;$.removeClass("sapUxAPInvisible");if(u){this._setBreadcrumbsVisible(false);}return s;};
d.prototype._getBreadcrumbsAsJQueryObject=function(){if(!this._$breadcrumbs){this._$breadcurmbs=this.$("breadcrumbs");}return this._$breadcurmbs;};
d.prototype._getOverflowSelectAsJQueryObject=function(){if(!this._$select){this._$select=this.$("select");}return this._$select;};
d.prototype._setBreadcrumbsVisible=function(v){var $=this.$(),e=this._getBreadcrumbsAsJQueryObject(),f="sapUxAPFullWidth",s="sapUiHidden";if(v){e.removeClass(s);$.removeClass(f);}else{e.addClass(s);$.addClass(f);}return $;};
d.prototype._setSelectVisible=function(v){var $=this._getOverflowSelectAsJQueryObject(),s="sapUiHidden";if(v){$.removeClass(s);}else{$.addClass(s);}return this;};
d.prototype._resetControl=function(){this._iContainerHeight=null;this._$select=null;this._$breadcrumbs=null;this.setAggregation("_overflowSelect",null,true);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}return this;};
d.prototype._getAriaLabelledBy=function(){if(!this._oAriaLabelledBy){d.prototype._oAriaLabelledBy=new c({text:sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("BREADCRUMB_TRAIL_LABEL")}).toStatic();}return this._oAriaLabelledBy;};
d.prototype._getItemNavigation=function(){if(!this._ItemNavigation){this._ItemNavigation=new I();}return this._ItemNavigation;};
d.prototype._getItemsToNavigate=function(){var i=this.getLinks(),o=this.getCurrentLocation(),s=this.getShowCurrentLocation();if(s&&o){i.push(o);}return i;};
d.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),h=this._getBreadcrumbsAsJQueryObject()[0],s=-1,e=this._getItemsToNavigate(),n=[];e.forEach(function(o){o.$().attr("tabindex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setCycling(false);i.setRootDomRef(h);i.setItemDomRefs(n);i.setSelectedIndex(s);this._getBreadcrumbsAsJQueryObject().attr("tabindex","-1");e[0].$().attr("tabindex","0");return this;};
d.prototype.onsappageup=function(e){this._handlePageKeys(e,false);};
d.prototype.onsappagedown=function(e){this._handlePageKeys(e,true);};
d.prototype._handlePageKeys=function(e,m){var n,f=this._getItemsToNavigate(),E=0,i=m?f.length-1:0;e.preventDefault();f.some(function(o,g){if(o.getId()===e.target.id){E=g;return true;}});if(m){n=E+d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}else{n=E-d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}if(n&&f[n]){f[n].focus();}else if(f[i]){f[i].focus();}};
d.prototype._getUsingOverflowSelect=function(){return!this._getOverflowSelectAsJQueryObject().hasClass("sapUiHidden");};
d.prototype.exit=function(){if(this._ItemNavigation){this.removeDelegate(this._ItemNavigation);this._ItemNavigation.destroy();this._ItemNavigation=null;}this._resetControl();};
return d;});
sap.ui.predefine('sap/uxap/BreadCrumbsRenderer',function(){"use strict";var B={apiVersion:2};
B.render=function(r,c){r.openStart("div",c).class("sapUxAPBreadCrumbs").attr("role","navigation").attr("aria-labelledby",c._getAriaLabelledBy().getId()).openEnd();this._renderOverflowSelect(r,c);if(!c._bOnPhone){this._renderBreadcrumbTrail(r,c);}r.close("div");};
B._renderBreadcrumbTrail=function(r,c){var l=c.getLinks(),C=c.getCurrentLocation(),t=c._getTubeIcon(),s=c.getShowCurrentLocation();r.openStart("ul",c.getId()+"-breadcrumbs").openEnd();l.forEach(function(L){r.openStart("li").openEnd();r.renderControl(L);r.renderControl(t);r.close("li");});if(s){r.openStart("li").openEnd();r.renderControl(C);r.close("li");}r.close("ul");};
B._renderOverflowSelect=function(r,c){var t=c._getTubeIcon();r.openStart("div",c.getId()+"-select");r.class("sapUiHidden");r.openEnd();r.openStart("span").class("sapUxAPBreadCrumbsDots").openEnd().text("...").close("span");r.renderControl(t);r.renderControl(c._getOverflowSelect());r.close("div");};
return B;},true);
sap.ui.predefine('sap/uxap/HierarchicalSelect',["sap/m/Select","sap/ui/Device","sap/ui/thirdparty/jquery","./library","./HierarchicalSelectRenderer","sap/ui/thirdparty/jqueryui/jquery-ui-position"],function(S,D,q,l,H){"use strict";
var a=S.extend("sap.uxap.HierarchicalSelect",{metadata:{library:"sap.uxap",properties:{upperCase:{type:"boolean",group:"Appearance",defaultValue:false}}}});
a.POPOVER_MIN_WIDTH_REM=11;
a.prototype.onAfterRendering=function(){S.prototype.onAfterRendering.apply(this,arguments);};
a.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var i=this.getItems()||[];i.forEach(function(I){var c=(I.data("secondLevel")===true)?"sapUxAPHierarchicalSelectSecondLevel":"sapUxAPHierarchicalSelectFirstLevel";I.$().addClass(c);},this);};
a.prototype.setUpperCase=function(v,s){this.setProperty("upperCase",v,s);this.toggleStyleClass("sapUxAPHierarchicalSelectUpperCase",v);var p=this.getAggregation("picker");if(p){p.toggleStyleClass("sapMSltPickerFirstLevelUpperCase",v);if(!s){p.invalidate();}}return this;};
a.prototype.onsapenter=S.prototype.onsapspace;["onsapup","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(n){a.prototype[n]=function(e){S.prototype[n].call(this,e);e.stopPropagation();};});
a.prototype._createDialog=function(){var d=S.prototype._createDialog.call(this),c=d.getCustomHeader();if(c){c.addStyleClass("sapUxAPHierarchicalSelect");}return d;};
a.prototype._decoratePopover=function(p){S.prototype._decoratePopover.call(this,p);p._adaptPositionParams=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["end bottom","end center","end top","begin center"];this._atPositions=["end top","end center","end bottom","begin center"];};if(D.system.tablet||D.system.desktop){var r=q.position.scrollbarWidth();if(r>0){p.setOffsetX(r);}}};
a.prototype._onAfterRenderingPopover=function(){var p=this.getPicker(),P=p.getDomRef("cont"),m=P.style.minWidth;if(m.endsWith("rem")){m=m.substring(0,m.length-3);var M=parseFloat(m);if(M<a.POPOVER_MIN_WIDTH_REM&&P){P.style.minWidth=a.POPOVER_MIN_WIDTH_REM+"rem";}}};
return a;});
sap.ui.predefine('sap/uxap/HierarchicalSelectRenderer',["sap/m/SelectRenderer","sap/ui/core/Renderer"],function(S,R){"use strict";var H=R.extend(S);H.apiVersion=2;
H.addClass=function(r){r.class("sapUxAPHierarchicalSelect");};
return H;},true);
sap.ui.predefine('sap/uxap/LazyLoading',["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/Object","./ObjectPageSubSection","./library","sap/base/Log"],function(q,D,B,O,l,L){"use strict";
var a=B.extend("sap.uxap._helpers.LazyLoading",{
constructor:function(o){this._oObjectPageLayout=o;this._$html=q("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._bSuppressed=false;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters();},
getInterface:function(){return this;}
});
a.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;this.LAZY_LOADING_EXTRA_PAGE_SIZE=0.5;this.LAZY_LOADING_EXTRA_SUBSECTION=this.LAZY_LOADING_DELAY*5;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":1,"ScrollToSection":1};}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":1};}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":2};}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":3,"ScrollToSection":3};}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5;};
a.prototype.suppress=function(){this._bSuppressed=true;};
a.prototype.resume=function(){this._bSuppressed=false;};
a.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading();};
a.prototype.lazyLoadDuringScroll=function(i,s,t,p){var P,d,f=false;if(this._bSuppressed){return;}if(i){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer);}this._sLazyLoadingTimer=null;this.doLazyLoading();return;}this._iScrollProgress=s-this._iPreviousScrollTop;P=Math.round(Math.abs(this._iScrollProgress)/p*100);if(P>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){f=true;}this._iPreviousScrollTop=s;this._iPreviousScrollTimestamp=t||0;d=(s===0)?0:this.LAZY_LOADING_DELAY;if(f&&this._sLazyLoadingTimer){L.debug("ObjectPageLayout :: lazyLoading","delayed by "+d+" ms because of fast scroll");clearTimeout(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null;}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),d);}};
a.prototype.doLazyLoading=function(){var h=this._oObjectPageLayout._getHeightRelatedParameters(),i=this._oObjectPageLayout.getUseIconTabBar(),s=sap.ui.getCore().byId(this._oObjectPageLayout.getSelectedSection()),S=this._oObjectPageLayout._oSectionInfo,b,c,p,d=this._iPreviousScrollTop>=(h.iHeaderContentHeight),e,E=-1,o={},f={},t,g,j;if(this._bSuppressed){return;}p=(h.iScreenHeight-(d?h.iAnchorBarHeight:0)-(d?h.iHeaderTitleHeightStickied:0));b=h.iScrollTop;t=Date.now()-this._iPreviousScrollTimestamp;g=(t<(this.LAZY_LOADING_DELAY/2))&&(Math.abs(this._iScrollProgress)>5);if(g){if(this._iScrollProgress>=0){j=Math.round(Math.min(this._iScrollProgress*20,p/2));}else{j=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,p/2));}b+=j;L.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+j);}c=b+p;b+=16;q.each(S,q.proxy(function(I,k){if(!k.isSection&&k.sectionReference.getParent()&&k.sectionReference.getParent().getVisible()){if(i&&s&&s.indexOfSubSection(k.sectionReference)<0){return;}if(k.positionTop<=c&&b<k.positionBottom-1){f[I]=I;if(!k.loaded){o[I]=I;}}else if(!k.loaded&&k.positionTop>c&&k.positionTop<c+p*this.LAZY_LOADING_EXTRA_PAGE_SIZE&&(E==-1||k.positionTop<E)){E=k.positionTop;e=I;}}},this));if(E!=-1&&q.isEmptyObject(o)){L.debug("ObjectPageLayout :: lazyLoading","extra section added : "+e);o[e]=e;}q.each(o,q.proxy(function(k,m){L.debug("ObjectPageLayout :: lazyLoading","connecting "+m);sap.ui.getCore().byId(m).connectToModels();S[m].loaded=true;},this));q.each(f,q.proxy(function(k,m){if(!this._oPrevSubSectionsInView[k]){L.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+m);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:sap.ui.getCore().byId(m)});}},this));this._oPrevSubSectionsInView=f;if(g){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_DELAY);}else{if(E){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_EXTRA_SUBSECTION);}else{this._sLazyLoadingTimer=null;}}};
a.prototype.getSubsectionsToPreload=function(A,i){var s,t;if(i){s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;t=false;}else{s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;t=true;}var S=[];A.some(function(o){if(!t&&i){t=o.getId()==i;}if(t&&o instanceof O){if(o.getVisible()&&o._getInternalVisible()){S.push(o);s--;}}return s<=0;});return S;};
a.prototype.destroy=function(){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer);}};
a.prototype._isPhone=function(){return l.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};
a.prototype._isTablet=function(){return D.system.tablet;};
a.prototype._isTabletSize=function(){return l.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};
return a;});
sap.ui.predefine('sap/uxap/ModelMapping',["sap/ui/core/Element","./library"],function(E,l){"use strict";
var M=E.extend("sap.uxap.ModelMapping",{metadata:{library:"sap.uxap",properties:{externalModelName:{type:"string",group:"Misc",defaultValue:null},internalModelName:{type:"string",group:"Misc",defaultValue:"Model"},externalPath:{type:"string",group:"Misc",defaultValue:null}}}});
return M;});
sap.ui.predefine('sap/uxap/ObjectImageHelper',["sap/ui/base/ManagedObject","sap/ui/core/IconPool","sap/m/Avatar","sap/m/Image"],function(M,I,A,a){"use strict";var O=function(){};
O.createObjectImage=function(h){var o,s=h.getObjectImageURI();if(s.indexOf("sap-icon://")===0){o=O.instantiateAvatar(s);o.addStyleClass("sapUxAPObjectPageHeaderObjectImageIcon");}else{o=new a({densityAware:h.getObjectImageDensityAware(),alt:M.escapeSettingsValue(h.getObjectImageAlt()),decorative:false,mode:"Background",backgroundSize:"contain",backgroundPosition:"center"});o.addStyleClass("sapUxAPObjectPageHeaderObjectImage");o.setSrc(s);}if(h.getObjectImageAlt()){o.setTooltip(h.getObjectImageAlt());}return o;};
O.instantiateAvatar=function(u){return new A({displaySize:"L",fallbackIcon:u});};
O.createPlaceholder=function(){return O.instantiateAvatar(I.getIconURI("picture"));};
O.updateAvatarInstance=function(o,s,c){o.setDisplayShape(s);o.setBackgroundColor(c);};
O._renderImageAndPlaceholder=function(r,o){var h=o.oHeader,b=o.oObjectImage,p=o.oPlaceholder,i=o.bIsObjectIconAlwaysVisible,c=o.bAddSubContainer,B=o.sBaseClass,s=h.getObjectImageShape(),d=h.getObjectImageBackgroundColor(),S=h.getShowPlaceholder()&&!h.getObjectImageURI(),e=b.isA("sap.m.Avatar");if(h.getShowPlaceholder()){O.updateAvatarInstance(p,s,d);}if(h.getObjectImageURI()||h.getShowPlaceholder()){r.openStart("span").class(B).class('sapUxAPObjectPageHeaderObjectImage-'+s);if(i){r.class('sapUxAPObjectPageHeaderObjectImageForce');}r.openEnd();if(c){r.openStart("span").class("sapUxAPObjectPageHeaderObjectImageContainerSub").openEnd();}if(e){O.updateAvatarInstance(b,s,d);r.openStart("div").class("sapUxAPObjectPageHeaderObjectImage").class("sapUxAPObjectPageHeaderPlaceholder").openEnd();}if(h.getObjectImageURI()){r.renderControl(b);}O._renderPlaceholder(r,p,S);if(e){r.close("div");}if(c){r.close("span");}r.close("span");}};
O._renderPlaceholder=function(r,p,v){r.openStart("div").class('sapUxAPObjectPageHeaderPlaceholder').class('sapUxAPObjectPageHeaderObjectImage');if(!v){r.class('sapUxAPHidePlaceholder');}r.openEnd();r.renderControl(p);r.close("div");};
return O;});
sap.ui.predefine('sap/uxap/ObjectPageAccessibleLandmarkInfo',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var O=E.extend("sap.uxap.ObjectPageAccessibleLandmarkInfo",{metadata:{library:"sap.uxap",properties:{rootRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Main"},rootLabel:{type:"string",defaultValue:null},contentRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},contentLabel:{type:"string",defaultValue:null},navigationRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Navigation"},navigationLabel:{type:"string",defaultValue:null},headerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Banner"},headerLabel:{type:"string",defaultValue:null},footerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Region"},footerLabel:{type:"string",defaultValue:null}}}});
return O;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderContent',['./library',"./ObjectPageDynamicHeaderContentRenderer","sap/base/Log"],function(l,O,L){"use strict";try{sap.ui.getCore().loadLibrary("sap.f");}catch(e){L.error("The control 'sap.uxap.ObjectPageDynamicHeaderContent' needs library 'sap.f'.");throw(e);}var D=sap.ui.requireSync("sap/f/DynamicPageHeader");
var a=D.extend("sap.uxap.ObjectPageDynamicHeaderContent",{metadata:{interfaces:["sap.uxap.IHeaderContent"],library:"sap.uxap"}});
a.createInstance=function(c,v,C,p,s){return new a({content:c,visible:v,pinnable:p,id:s});};
a.prototype.supportsPinUnpin=function(){return true;};
a.prototype.supportsChildPageDesign=function(){return false;};
a.prototype.supportsAlwaysExpanded=function(){return false;};
a.prototype.setContentDesign=function(d){};
a.prototype.setVisible=function(v){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoHeaderContent",!v);return this.setProperty("visible",v);};
return a;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderContentRenderer',['sap/ui/core/Renderer','sap/f/DynamicPageHeaderRenderer'],function(R,D){"use strict";var O=R.extend(D);O.apiVersion=2;return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderTitle',['./library','sap/uxap/ObjectPageDynamicHeaderContent',"./ObjectPageDynamicHeaderTitleRenderer","sap/base/Log"],function(l,O,a,L){"use strict";try{sap.ui.getCore().loadLibrary("sap.f");}catch(e){L.error("The control 'sap.uxap.ObjectPageDynamicHeaderTitle' needs library 'sap.f'.");throw(e);}var D=sap.ui.requireSync("sap/f/DynamicPageTitle");
var b=D.extend("sap.uxap.ObjectPageDynamicHeaderTitle",{metadata:{interfaces:["sap.uxap.IHeaderTitle"],library:"sap.uxap"}});
b.prototype.isDynamic=function(){return true;};
b.prototype.getCompatibleHeaderContentClass=function(){return O;};
b.prototype.supportsToggleHeaderOnTitleClick=function(){return true;};
b.prototype.supportsTitleInHeaderContent=function(){return false;};
b.prototype.supportsAdaptLayoutForDomElement=function(){return false;};
b.prototype.supportsBackgroundDesign=function(){return true;};
b.KNOWN_HEADING_CONTROL_CLASS_NAMES=["sap.m.Title","sap.m.Text","sap.m.FormattedText","sap.m.Label"];
b.prototype.getTitleText=function(){var h=this.getHeading(),c=h&&h.getMetadata().getName();if(b.KNOWN_HEADING_CONTROL_CLASS_NAMES.indexOf(c)>-1){return h.getText();}};
b.prototype.getHeaderDesign=function(){return l.ObjectPageHeaderDesign.Light;};
b.prototype.snap=function(u){this._toggleState(false,u);this._updateARIAState(false);};
b.prototype.unSnap=function(u){this._toggleState(true,u);this._updateARIAState(true);};
b.prototype._adaptObjectPageHeaderIndentifierLine=function($,E){};
return b;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderTitleRenderer',['sap/ui/core/Renderer','sap/f/DynamicPageTitleRenderer'],function(R,D){"use strict";var O=R.extend(D);O.apiVersion=2;return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeader',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library","./ObjectPageHeaderRenderer"],function(q,C,I,a,D,B,O,R,b,A,c,d,l,m,e){"use strict";var f=l.Importance;var g=m.ButtonType;var P=m.PlacementType;var h=l.ObjectPageHeaderDesign;var j=m.AvatarShape;var k=m.AvatarColor;
function n(i){return typeof i==="function";}
var o=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:j.Square},objectImageBackgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:k.Accent6},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:h.Light},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink"},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false},titleSelectorTooltip:{type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designtime:"sap/uxap/designtime/ObjectPageHeader.designtime"}});
o.prototype._iAvailablePercentageForActions=0.3;
o.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this);};
o.getMetadata().forwardAggregation("breadCrumbsLinks",{getter:function(){return this._lazyLoadInternalAggregation("_breadCrumbs");},aggregation:"links"});
o.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};
o.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};
o.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};
o.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};
o._internalAggregationFactory={"_objectImage":c.createObjectImage,"_placeholder":c.createPlaceholder,"_overflowActionSheet":function(){return new A({placement:P.Bottom});},"_lockIconCont":function(i){return this._getButton(i,"sap-icon://private","lock-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_breadCrumbs":function(i){return new B({links:i.getAggregation("breadCrumbLinks")});},"_lockIcon":function(i){return this._getButton(i,"sap-icon://private","lock",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow-cont",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(i){return this._getIcon(i,"favorite",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(i){return this._getIcon(i,"flag",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(i){return this._getButton(i,"sap-icon://overflow","overflow",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"));},"_expandButton":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","expand",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(i){return this._getButton(i,"sap-icon://user-edit","changes-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(i){return this._getButton(i,"sap-icon://user-edit","changes",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(i,u,T){return I.createControlByURI({id:this._getParentAugmentedId(i,u),tooltip:T,src:I.getIconURI(u),visible:false});},_getButton:function(i,u,v,T){return new b({id:this._getParentAugmentedId(i,v),tooltip:T,icon:u,type:g.Transparent});},_getParentAugmentedId:function(i,u){return i.getId()+"-"+u;}};
o.prototype._lazyLoadInternalAggregation=function(i,S){if(!this.getAggregation(i)){this.setAggregation(i,o._internalAggregationFactory[i](this),S);}return this.getAggregation(i);};
o.prototype._applyActionProperty=function(i,u){var v=u[0];if(this.getProperty(i)!==v){u.unshift(i);this.setProperty.apply(this,u);if(!this._bFirstRendering){this._notifyParentOfChanges();}}return this;};
o.prototype._applyObjectImageProperty=function(i,u){var v=u[0];if(this.getProperty(i)!==v){u.unshift(i);this.setProperty.apply(this,u);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true);}}return this;};
o.prototype._setAggregationTooltip=function(i,T){var u=this.getAggregation(i);if(u){u.setTooltip(T);}return this;};
o.prototype._setTitleSelectorTooltip=function(T){if(T===null||T===undefined){T=this.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP");}this._setAggregationTooltip("_titleArrowIcon",T);this._setAggregationTooltip("_titleArrowIconCont",T);return this;};
o.prototype.setHeaderDesign=function(H){this.setProperty("headerDesign",H);if(this.getParent()){this.getParent().invalidate();}return this;};
o.prototype.setObjectTitle=function(N){var i=this.getParent(),u=this.getProperty("objectTitle"),v=u!==N;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));i&&n(i._updateAriaLabels)&&i._updateAriaLabels();if(v&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{"id":this.getId(),"name":"objectTitle","oldValue":u,"newValue":N});}return this;};
var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],r=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape","objectImageBackgroundColor"];var G=function(i){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);o.prototype[u]=function(){var v=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,i,v);return this;};};var s=function(i){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);o.prototype[u]=function(){var v=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,i,v);return this;};};var t=function(i,S,T){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);S[u]=function(){var v=Array.prototype.slice.call(arguments);v.unshift(i);T.setProperty.apply(T,v);return this.setProperty.apply(this,v);};};p.forEach(G);r.forEach(s);
o.prototype._destroyObjectImage=function(){var i="_objectImage",u=this.getAggregation(i);if(u){u.destroy();this.setAggregation(i,null);}};
o.prototype.onBeforeRendering=function(){var S=this.getSideContentButton(),i=this;if(S&&!S.getTooltip()){S.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"));}var u=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._resetActionSheetMap();if(u.length>1||this._hasOneButtonShowText(u)){u.forEach(function(v){if(v instanceof b&&!(v instanceof O)){v._bInternalVisible=v.getVisible();v._getInternalVisible=function(){return this._bInternalVisible;};v._setInternalVisible=function(V,x){this.$().toggle(V);if(V!=this._bInternalVisible){this._bInternalVisible=V;if(x){this.invalidate();}}};v.setVisible=function(V){v._setInternalVisible(V,true);b.prototype.setVisible.call(this,V);};v.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}i._resizeIdentifierLineContainer(i.$());};}if(v instanceof b&&v.getVisible()){var w=this._createActionSheetButton(v);this._oActionSheetButtonMap[v.getId()]=w;this._oOverflowActionSheet.addButton(w);t("text",v,w);t("icon",v,w);t("enabled",v,w);}},this);}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._bFirstRendering=false;};
o.prototype._resetActionSheetMap=function(){Object.keys(this._oActionSheetButtonMap).forEach(function(i){this._oActionSheetButtonMap[i].destroy();}.bind(this));this._oActionSheetButtonMap={};};
o.prototype._createActionSheetButton=function(i){return new b({press:q.proxy(this._onSeeMoreContentSelect,this),enabled:i.getEnabled(),text:i.getText(),icon:i.getIcon(),tooltip:i.getTooltip(),customData:new a({key:"originalId",value:i.getId()})});};
o.prototype._handleImageNotFoundError=function(){var i=this._lazyLoadInternalAggregation("_objectImage"),u=this.getParent(),$=u?u.$():this.$();if(this.getShowPlaceholder()){$.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();$.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");}else{i.addStyleClass("sapMNoImg");}};
o.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error");};
o.prototype.onAfterRendering=function(){var $=this._lazyLoadInternalAggregation("_objectImage").$();if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout);}this._adaptLayout();this._clearImageNotFoundHandler();$.error(this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError();}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._attachDetachActionButtonsHandler(true);};
o.prototype._onHeaderResize=function(E){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._onUpdateHeaderTitleSize==="function"){this.getParent()._onUpdateHeaderTitleSize(E);}};
o.prototype._attachDetachActionButtonsHandler=function(i){var u=this.getActions()||[];if(u.length<1){return;}u.forEach(function(v){if(v instanceof b){var w=this._oActionSheetButtonMap[v.getId()];if(i){v.attachEvent("_change",this._adaptLayoutDelayed,this);if(w){w.attachEvent("_change",this._adaptOverflow,this);}}else{v.detachEvent("_change",this._adaptLayoutDelayed,this);if(w){w.detachEvent("_change",this._adaptOverflow,this);}}}},this);};
o.prototype._onSeeMoreContentSelect=function(E){var i=E.getSource(),u=sap.ui.getCore().byId(i.data("originalId"));if(u.firePress){u.firePress({overflowButtonId:this._oOverflowButton.getId(),bInOverflow:true});}this._oOverflowActionSheet.close();};
o._actionImportanceMap={"Low":3,"Medium":2,"High":1};
o._sortActionsByImportance=function(i,u){var v=(i instanceof O)?i.getImportance():f.High,w=(u instanceof O)?u.getImportance():f.High,x=o._actionImportanceMap[v]-o._actionImportanceMap[w];if(x===0){return i.position-u.position;}return x;};
o.prototype._hasOneButtonShowText=function(i){var u=false;if(i.length!==1){return u;}if(i[0]instanceof O){u=(!i[0].getHideText()&&i[0].getText()!="");}else if(i[0]instanceof b){u=(i[0].getText()!="");}return u;};
o.prototype._adaptLayout=function(E){var $=this.$("identifierLine"),i=$.width(),u=this._getActionsWidth(),v=u/i,w=this._iAvailablePercentageForActions*i,x=this._oOverflowButton.$();if(i===0){return;}if(v>this._iAvailablePercentageForActions){this._adaptActions(w);}else if(E&&E.getSource()instanceof O){E.getSource()._setInternalVisible(true);}if(D.system.phone){this.getActions().forEach(function(F){if(F instanceof b){F.$().css("visibility","visible");}});}var y=this.$("actions");var z=y.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(z.filter(":visible").length===z.length){x.hide();}this._adaptObjectPageHeaderIndentifierLine(this.$());};
o.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout);}this._adaptLayoutTimeout=setTimeout(function(){this._adaptLayoutTimeout=null;this._adaptLayout();}.bind(this),0);};
o.prototype._adaptObjectPageHeaderIndentifierLine=function($){var i=this._findById($,"identifierLine"),u=i.find(".sapUxAPObjectPageHeaderIdentifierTitle");this._adaptObjectPageHeaderTitle(u);this._resizeIdentifierLineContainer($);};
o.prototype._resizeIdentifierLineContainer=function($){var i=this._findById($,"identifierLineContainer"),u=this._findById($,"actions"),v=this._findById($,"identifierLine"),w=v.width(),x=$?$.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),y=u.width()+x.width();i.width((0.95-(y/w))*100+"%");};
o.prototype._adaptObjectPageHeaderTitle=function($){var T=$.width(),u=$.find(".sapUxAPObjectPageHeaderTitleText"),v=u.length,w;for(var i=0;i<v;i++){w=q(u.get(i));w.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",false);if(w.width()>T){w.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",true);}}};
o.prototype._adaptActions=function(u){var M=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||D.system.phone,$=this._oOverflowButton.$(),v=$.show().width(),w=this.getActions(),x=w.length,y;for(var i=0;i<x;i++){w[i].position=i;}w.sort(o._sortActionsByImportance);w.forEach(function(z){y=this._oActionSheetButtonMap[z.getId()];if(y){v+=z.$().width();if(u>v&&!M){this._setActionButtonVisibility(z,true);$.hide();}else{this._setActionButtonVisibility(z,false);$.show();}}},this);};
o.prototype._adaptOverflow=function(){var i=this._oOverflowActionSheet.getButtons();var H=i.some(function(u){return u.getVisible();});this._oOverflowButton.$().toggle(H);};
o.prototype._setActionButtonVisibility=function(i,v){var u=this._oActionSheetButtonMap[i.getId()];if(u){if(i.getVisible()){i._setInternalVisible(v);u.setVisible(!v);}else{u.setVisible(false);}}};
o.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(i){if(i instanceof b){i.$().show();if(D.system.phone){i.$().css("visibility","hidden");}w+=i.$().outerWidth(true);}});return w;};
o.prototype._findById=function($,i){var E;if(!i||!$){return null;}i=this.getId()+'-'+i;E="#"+i.replace(/(:|\.)/g,'\\$1');return $.find(E);};
o.prototype._getBreadcrumbsAggregation=function(){var i=this.getBreadcrumbs(),u=this._lazyLoadInternalAggregation('_breadCrumbs',true);return i||((u&&u.getLinks().length)?u:null);};
o.prototype._notifyParentOfChanges=function(i){var u=this.getParent();if(u&&typeof u._headerTitleChangeHandler==="function"){u._headerTitleChangeHandler(i);}};
o.prototype.setTitleSelectorTooltip=function(T){this._setTitleSelectorTooltip(T);this.setAggregation("titleSelectorTooltip",T,true);return this;};
o.prototype.destroyTitleSelectorTooltip=function(){this._setTitleSelectorTooltip(null);this.destroyAggregation("titleSelectorTooltip",true);return this;};
o.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._resetActionSheetMap();};
o.prototype.setNavigationBar=function(i){this.setAggregation("navigationBar",i);if(i&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":i});}return this;};
o.prototype._getAdaptableContent=function(){return this.getNavigationBar();};
o.prototype.isDynamic=function(){return false;};
o.prototype.getCompatibleHeaderContentClass=function(){return d;};
o.prototype.supportsToggleHeaderOnTitleClick=function(){return false;};
o.prototype.supportsTitleInHeaderContent=function(){return true;};
o.prototype.supportsAdaptLayoutForDomElement=function(){return true;};
o.prototype.supportsBackgroundDesign=function(){return false;};
o.prototype.getTitleText=function(){return this.getObjectTitle();};
o.prototype.snap=function(){this._adaptLayout();};
o.prototype.unSnap=function(){this._adaptLayout();};
o.prototype._toggleExpandButton=function(T){};
o.prototype._setShowExpandButton=function(v){};
o.prototype._focusExpandButton=function(){};
o.prototype._toggleFocusableState=function(F){};
return o;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderActionButton',["sap/m/Button","./library","./ObjectPageHeaderActionButtonRenderer"],function(B,l,O){"use strict";
var a=B.extend("sap.uxap.ObjectPageHeaderActionButton",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.uxap",properties:{hideText:{type:"boolean",defaultValue:true},hideIcon:{type:"boolean",defaultValue:false},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}},designtime:"sap/uxap/designtime/ObjectPageHeaderActionButton.designtime"}});
a.prototype.init=function(){B.prototype.init.call(this);this._bInternalVisible=this.getVisible();};
a.prototype.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};
a.prototype.applySettings=function(s,S){if(B.prototype.applySettings){B.prototype.applySettings.call(this,s,S);}this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",this.getHideText());this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",this.getHideIcon());};
a.prototype.setHideText=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",v);return this.setProperty("hideText",v,i);};
a.prototype.setHideIcon=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",v);return this.setProperty("hideIcon",v,i);};
a.prototype._setInternalVisible=function(v,i){this.$().toggle(v);if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};
a.prototype.setVisible=function(v){var r=B.prototype.setVisible.apply(this,arguments);this.getParent()&&this.getParent().invalidate();return r;};
a.prototype._getInternalVisible=function(){return this._bInternalVisible;};
a.prototype.getOverflowToolbarConfig=function(){var c={canOverflow:true,propsUnrelatedToSize:["importance"],getCustomImportance:function(){return this.getImportance();}.bind(this)};c.onBeforeEnterOverflow=function(A){A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",false,true);A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",false,true);};c.onAfterExitOverflow=function(A){A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",A.getHideText(),true);A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",A.getHideIcon(),true);};return c;};
return a;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderActionButtonRenderer',["sap/m/ButtonRenderer","sap/ui/core/Renderer"],function(B,R){"use strict";var O=R.extend(B);O.apiVersion=2;return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeaderContent',["sap/ui/core/Control","./library","sap/m/Button","./ObjectImageHelper","./ObjectPageHeaderContentRenderer"],function(C,l,B,O,a){"use strict";var b=l.ObjectPageHeaderDesign;
var c=C.extend("sap.uxap.ObjectPageHeaderContent",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderContent"],properties:{contentDesign:{type:"sap.uxap.ObjectPageHeaderDesign",group:"Misc",defaultValue:b.Light}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_editHeaderButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}}}});
c.prototype.onBeforeRendering=function(){var p=this.getParent(),e=this.getAggregation("_editHeaderButton");if(e){return;}if(p&&(p instanceof l.ObjectPageLayout)&&p.getShowEditHeaderButton()){e=this._getInternalBtnAggregation("_editHeaderButton","EDIT_HEADER","-editHeaderBtn","Transparent");e.attachPress(this._handleEditHeaderButtonPress,this);}};
c.prototype.exit=function(){var e=this.getAggregation("_editHeaderButton");if(e){e.detachPress(this._handleEditHeaderButtonPress,this);}};
c.prototype._handleEditHeaderButtonPress=function(e){this.getParent().fireEditHeaderButtonPress();};
c.prototype._getInternalBtnAggregation=function(A,s,d,e){if(!this.getAggregation(A)){var o=new B({text:sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText(s),type:e,id:this.getId()+d});this.setAggregation(A,o);}return this.getAggregation(A);};
c.prototype._getObjectImage=function(){if(!this.getAggregation("_objectImage")){var p=this.getParent(),h=p&&p.getHeaderTitle&&p.getHeaderTitle(),o=h&&O.createObjectImage(h);if(o){this.setAggregation("_objectImage",o,true);}}return this.getAggregation("_objectImage");};
c.prototype._destroyObjectImage=function(s){var o=this.getAggregation("_objectImage");if(o){o.destroy();this.getAggregation("_objectImage",null,s);}};
c.prototype._getPlaceholder=function(){if(!this.getAggregation("_placeholder")){var p=this.getParent(),h=p&&p.getHeaderTitle&&p.getHeaderTitle(),s=h.getShowPlaceholder();var P=s&&O.createPlaceholder();if(P){this.setAggregation("_placeholder",P,true);}}return this.getAggregation("_placeholder");};
c.prototype._getLayoutDataForControl=function(o){var L=o.getLayoutData();if(!L){return;}else if(L instanceof l.ObjectPageHeaderLayoutData){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var d=L.getMultipleLayoutData();for(var i=0;i<d.length;i++){var e=d[i];if(e instanceof l.ObjectPageHeaderLayoutData){return e;}}}};
c.prototype.setVisible=function(v){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoHeaderContent",!v);return this.setProperty("visible",v);};
c.createInstance=function(d,v,s,p,S){return new c({content:d,visible:v,contentDesign:s,id:S});};
c.prototype.supportsPinUnpin=function(){return false;};
c.prototype.supportsChildPageDesign=function(){return true;};
c.prototype.supportsAlwaysExpanded=function(){return true;};
c.prototype._toggleCollapseButton=function(t){};
c.prototype._setShowCollapseButton=function(v){};
c.prototype._focusCollapseButton=function(){};
c.prototype._focusPinButton=function(){};
return c;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderContentRenderer',["./ObjectPageHeaderRenderer","./ObjectImageHelper"],function(O,a){"use strict";var b={apiVersion:2};
b.render=function(r,c){var p=c.getParent(),P=p&&p.isA("sap.uxap.ObjectPageLayout"),h=(p&&P)?p.getHeaderTitle():undefined,R=(p&&P)?(p.isA("sap.uxap.ObjectPageLayout")&&p.getShowTitleInHeaderContent()):false,d=P&&p.getShowEditHeaderButton()&&c.getContent()&&c.getContent().length>0;if(d){r.openStart("div",c).class("sapUxAPObjectPageHeaderContentFlexBox").class("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());if(h){r.class('sapUxAPObjectPageContentObjectImage-'+h.getObjectImageShape());}r.openEnd();}r.openStart("div",d?undefined:c);if(d){r.class("sapUxAPObjectPageHeaderContentCellLeft");}else{r.class("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());if(h){r.class('sapUxAPObjectPageContentObjectImage-'+h.getObjectImageShape());}}r.class("sapContrastPlus").class("ui-helper-clearfix").class("sapUxAPObjectPageHeaderContent");if(!c.getVisible()){r.class("sapUxAPObjectPageHeaderContentHidden");}r.openEnd();if(P&&p.getIsChildPage()){r.openStart("div").class("sapUxAPObjectChildPage").openEnd().close("div");}if(R){this._renderTitleImage(r,c,h);if(c.getContent().length==0){r.openStart("span").class("sapUxAPObjectPageHeaderContentItem").openEnd();this._renderTitle(r,h);r.close("span");}}c.getContent().forEach(function(i,I){this._renderHeaderContentItem(i,I,r,R,h,c);},this);r.close("div");if(d){this._renderEditButton(r,c);r.close("div");}};
b._renderHeaderContentItem=function(h,i,r,R,t,c){var H=false,d=false,l=c._getLayoutDataForControl(h),I=i===0;if(l){H=l.getShowSeparatorBefore();d=l.getShowSeparatorAfter();r.openStart("span").class("sapUxAPObjectPageHeaderWidthContainer").class("sapUxAPObjectPageHeaderContentItem").style("width",l.getWidth());if(d||H){r.class("sapUxAPObjectPageHeaderSeparatorContainer");}if(!l.getVisibleL()){r.class("sapUxAPObjectPageHeaderLayoutHiddenL");}if(!l.getVisibleM()){r.class("sapUxAPObjectPageHeaderLayoutHiddenM");}if(!l.getVisibleS()){r.class("sapUxAPObjectPageHeaderLayoutHiddenS");}r.openEnd();if(H){r.openStart("span").class("sapUxAPObjectPageHeaderSeparatorBefore").openEnd().close("span");}if(I&&R){this._renderTitle(r,t);}}else{if(I&&R){r.openStart("span").class("sapUxAPObjectPageHeaderContentItem").openEnd();this._renderTitle(r,t);}else{h.addStyleClass("sapUxAPObjectPageHeaderContentItem");}}r.renderControl(h);if(d){r.openStart("span").class("sapUxAPObjectPageHeaderSeparatorAfter").openEnd().close("span");}if(l||(I&&R)){r.close("span");}};
b._renderTitleImage=function(r,c,h){a._renderImageAndPlaceholder(r,{oHeader:h,oObjectImage:c._getObjectImage(),oPlaceholder:c._getPlaceholder(),bIsObjectIconAlwaysVisible:false,bAddSubContainer:false,sBaseClass:'sapUxAPObjectPageHeaderContentImageContainer'});};
b._renderTitle=function(r,h){O._renderObjectPageTitle(r,h,true);};
b._renderEditButton=function(r,h){r.openStart("div").class("sapUxAPObjectPageHeaderContentCellRight").openEnd();r.renderControl(h.getAggregation("_editHeaderButton"));r.close("div");};
return b;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeaderLayoutData',["sap/ui/core/LayoutData","./library"],function(L,l){"use strict";
var O=L.extend("sap.uxap.ObjectPageHeaderLayoutData",{metadata:{library:"sap.uxap",properties:{visibleS:{type:"boolean",group:"Misc",defaultValue:true},visibleM:{type:"boolean",group:"Misc",defaultValue:true},visibleL:{type:"boolean",group:"Misc",defaultValue:true},showSeparatorBefore:{type:"boolean",group:"Misc",defaultValue:false},showSeparatorAfter:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'}}}});
return O;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderRenderer',["./ObjectImageHelper","sap/ui/Device"],function(O,D){"use strict";var a={apiVersion:2};
a.render=function(r,c){var n=c.getNavigationBar(),t=(c.getIsObjectIconAlwaysVisible()||c.getIsObjectTitleAlwaysVisible()||c.getIsObjectSubtitleAlwaysVisible()||c.getIsActionAreaAlwaysVisible()),p=c.getParent(),e=c.getAggregation("_expandButton"),o=c._lazyLoadInternalAggregation("_objectImage",true),P,I=D.system.desktop,b=p&&p.isA("sap.uxap.ObjectPageLayout")&&((p.getHeaderContent()&&p.getHeaderContent().length>0&&p.getShowHeaderContent())||(p.getShowHeaderContent()&&p.getShowTitleInHeaderContent()));r.openStart("div",c).class('sapUxAPObjectPageHeader').class('sapUxAPObjectPageHeaderDesign-'+c.getHeaderDesign()).openEnd();if(n){r.openStart("div").class("sapUxAPObjectPageHeaderNavigation").openEnd();r.renderControl(n);r.close("div");}r.openStart("div",c.getId()+"-identifierLine").class('sapUxAPObjectPageHeaderIdentifier');if(t){r.class('sapUxAPObjectPageHeaderIdentifierForce');}r.openEnd();if(p&&p.isA("sap.uxap.ObjectPageLayout")&&p.getIsChildPage()){r.openStart("div").class("sapUxAPObjectChildPage").openEnd().close("div");}if(c.getShowPlaceholder()){P=c._lazyLoadInternalAggregation("_placeholder",true);}O._renderImageAndPlaceholder(r,{oHeader:c,oObjectImage:o,oPlaceholder:P,bIsObjectIconAlwaysVisible:c.getIsObjectIconAlwaysVisible(),bAddSubContainer:true,sBaseClass:'sapUxAPObjectPageHeaderObjectImageContainer'});r.openStart("span",c.getId()+"-identifierLineContainer").class('sapUxAPObjectPageHeaderIdentifierContainer').openEnd();this._renderObjectPageTitle(r,c);r.close("span");r.openStart("span",c.getId()+"-actions").class('sapUxAPObjectPageHeaderIdentifierActions');if(c.getIsActionAreaAlwaysVisible()){r.class('sapUxAPObjectPageHeaderIdentifierActionsForce');}r.openEnd();if(I&&b){e.addStyleClass("sapUxAPObjectPageHeaderExpandButton");r.renderControl(e);}var A=c.getActions();for(var i=0;i<A.length;i++){var d=A[i];r.renderControl(d);}var f=c.getAggregation("_overflowButton");r.renderControl(f);this._renderSideContentBtn(r,c);r.close("span");r.close("div");r.close("div");};
a._renderObjectPageTitle=function(r,c,t){var o=c.getObjectTitle(),m=(c.getShowMarkers()&&(c.getMarkFavorite()||c.getMarkFlagged())),b=c._getBreadcrumbsAggregation(),T=c.getTooltip_Text(),i=t?"-content":"";if(!t&&b){r.renderControl(b);}r.openStart("h2",c.getId()+"-title"+i).class('sapUxAPObjectPageHeaderIdentifierTitle');if(c.getIsObjectTitleAlwaysVisible()){r.class('sapUxAPObjectPageHeaderIdentifierTitleForce');}if(t){r.class('sapUxAPObjectPageHeaderIdentifierTitleInContent');}if(c.getShowTitleSelector()){r.class('sapUxAPObjectPageHeaderTitleFollowArrow');}r.openEnd();r.openStart("span",c.getId()+"-innerTitle"+i).class("sapUxAPObjectPageHeaderTitleText").class("sapUxAPObjectPageHeaderTitleTextWrappable");if(T){r.attr("title",T);}r.openEnd();if(m||c.getShowTitleSelector()||c.getMarkLocked()||c.getMarkChanges()){var s=o.substr(o.lastIndexOf(" ")+1);var d=o.substr(0,o.lastIndexOf(" ")+1);if(s.length===1){s=o;d='';}r.text(d);r.close("span");r.openStart("span").class('sapUxAPObjectPageHeaderNowrapMarkers');if(c.getMarkLocked()||c.getMarkChanges()){r.class('sapUxAPObjectPageHeaderMarks');}r.openEnd();r.openStart("span").class("sapUxAPObjectPageHeaderTitleText").openEnd().text(s).close("span");this._renderMarkers(r,c);if(c.getMarkLocked()){this._renderLock(r,c,t);}else if(c.getMarkChanges()){this._renderMarkChanges(r,c,t);}this._renderSelectTitleArrow(r,c,t);r.close("span");}else{r.text(o);r.close("span");}r.close("h2");if(c.getObjectSubtitle()){r.openStart("div",c.getId()+"-subtitle"+i).class('sapUxAPObjectPageHeaderIdentifierDescription');if(c.getIsObjectSubtitleAlwaysVisible()){r.class('sapUxAPObjectPageHeaderIdentifierDescriptionForce');}if(t){r.class('sapUxAPObjectPageHeaderIdentifierSubTitleInContent');}r.openEnd();r.text(c.getObjectSubtitle());r.close("div");}};
a._renderSelectTitleArrow=function(r,c,t){if(c.getShowTitleSelector()){r.openStart("span").class("sapUxAPObjectPageHeaderTitleArrow").openEnd();if(t){r.renderControl(c._oTitleArrowIconCont);}else{r.renderControl(c._oTitleArrowIcon);}r.close("span");}};
a._renderSideContentBtn=function(r,c){var s=c.getSideContentButton();if(s){r.openStart("span");r.class("sapUxAPObjectPageHeaderSideContentBtn");r.openEnd();r.openStart("span").class("sapUxAPObjectPageHeaderSeparator").openEnd().close("span");r.renderControl(s);r.close("span");}};
a._renderMarkChanges=function(r,c,t){r.openStart("span").class("sapUxAPObjectPageHeaderChangesBtn").class("sapUiSizeCompact").openEnd();if(t){r.renderControl(c._oChangesIconCont);}else{r.renderControl(c._oChangesIcon);}r.close("span");};
a._renderLock=function(r,c,t){r.openStart("span").class("sapUxAPObjectPageHeaderLockBtn").class("sapUiSizeCompact").openEnd();if(t){r.renderControl(c._oLockIconCont);}else{r.renderControl(c._oLockIcon);}r.close("span");};
a._renderMarkers=function(r,c){var I=[];if(c.getShowMarkers()){I.push(c._oFavIcon);I.push(c._oFlagIcon);this._renderMarkersAria(r,c);r.openStart("span",c.getId()+"-markers").class("sapMObjStatusMarker").attr("aria-describedby",c.getId()+"-markers-aria").openEnd();for(var i=0;i<I.length;i++){r.renderControl(I[i]);}r.close("span");}};
a._renderMarkersAria=function(r,c){var A="";if(c.getMarkFlagged()){A+=(c.oLibraryResourceBundle.getText("ARIA_FLAG_MARK_VALUE")+" ");}if(c.getMarkFavorite()){A+=(c.oLibraryResourceBundle.getText("ARIA_FAVORITE_MARK_VALUE")+" ");}if(A!==""){r.openStart("div",c.getId()+"-markers-aria").attr("aria-hidden","false").class("sapUiHidden").openEnd().text(A).close("div");}};
return a;},true);
sap.ui.predefine('sap/uxap/ObjectPageLayout',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/m/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/base/util/array/diff","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/base/util/merge","sap/ui/events/KeyCodes","sap/ui/events/F6Navigation","sap/ui/dom/getFirstEditableInput","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem'],function(q,M,R,C,a,D,S,O,b,c,d,L,A,T,e,f,l,g,h,i,j,k,m,K,F,n,P,o){"use strict";var p=f.TitleLevel;var r=f.AccessibleLandmarkRole;var s=l.ObjectPageSubSectionLayout;
var t=a.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:s.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:p.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},sectionChange:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},subSectionVisibilityChange:{parameters:{visibleSubSections:{type:"object"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});
t.HEADER_CALC_DELAY=350;t.DOM_CALC_DELAY=200;t.MAX_SNAP_POSITION_OFFSET=20;t.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;t.TITLE_LEVEL_AS_ARRAY=Object.keys(p);t.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};t.BREAK_POINTS={TABLET:1024,PHONE:600};t.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop"};t.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};t.DIV="div";t.HEADER="header";t.FOOTER="section";t.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";t.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";t.NO_NAVIGATION_CLASS_NAME="sapUxAPObjectPageNoNavigation";
t.prototype._getFirstEditableInput=function(v){var w=this.getDomRef(v);return n(w);};
t.prototype._focusFirstEditableInput=function(v){this._getFirstEditableInput(v).focus();};
t._getNextTitleLevelEntry=function(v){var w=t.TITLE_LEVEL_AS_ARRAY.indexOf(v),x=w!==-1,H=x&&(w!==t.TITLE_LEVEL_AS_ARRAY.length-1);if(!x){return p.Auto;}return t.TITLE_LEVEL_AS_ARRAY[H?w+1:w];};
t._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
t.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._oVisibleSubSections=0;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$titleArea=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iHeaderContentPaddingBottom=0;this._oScrollContainerLastState={};this._iREMSize=parseInt(q("body").css("font-size"));this._iOffset=parseInt(0.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._initializeScroller();};
t.prototype.onBeforeRendering=function(){var H,v;this._deregisterScreenSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy();}this._oLazyLoading=new L(this);this._deregisterCustomEvents();if(!this.getVisible()){return;}if(!this.getSelectedSection()){this._bHeaderExpanded=true;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){v=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(v);if(v){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);if(D.system.desktop){this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);}if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter());}this._$titleArea=[];};
t.prototype.setBackgroundDesignAnchorBar=function(B){var v=this.getBackgroundDesignAnchorBar();if(v===B){return this;}this.setProperty("backgroundDesignAnchorBar",B);this._oABHelper._getAnchorBar().setBackgroundDesign(B);return this;};
t.prototype.setToggleHeaderOnTitleClick=function(v){var w=this.getHeaderTitle(),x=this.setProperty("toggleHeaderOnTitleClick",v,true);if(!w||!w.supportsToggleHeaderOnTitleClick()){h.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return x;}v=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return x;};
t.prototype._attachTitlePressHandler=function(){var v=this.getHeaderTitle();if(u(v)&&!this._bAlreadyAttachedTitlePressHandler){v.attachEvent(t.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};
t.prototype._toggleHeaderVisibility=function(v){var H=this._getHeaderContent();if(u(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!v);}};
t.prototype._snapHeader=function(v){var I,H=this._getHeaderContent();if(H&&H.supportsPinUnpin()&&this._bPinned){this._unPin();H.getAggregation("_pinButton").setPressed(false);v=true;}this._toggleHeaderTitle(false,true);this._toggleHeaderVisibility(v);this._moveAnchorBarToTitleArea();if(v){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};
t.prototype._expandHeader=function(v){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(v){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();};
t.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return;}var E=!this._bHeaderExpanded,I,v,w;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));v=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!I);this._expandHeader(v);if(!v){this._scrollTo(0,0);}}else{w=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(w);}this.getHeaderTitle()._getFocusSpan().trigger("focus");};
t.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(u(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(t.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
t.prototype._handleExpandButtonPressEventLifeCycle=function(v){var H=this.getHeaderTitle(),w=this._hasDynamicTitle(),E;if(H&&!w){E=H.getAggregation("_expandButton");if(E){E[v?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};
t.prototype._adjustSelectedSectionByUXRules=function(){var v=this.oCore.byId(this.getSelectedSection()),V=v&&this._sectionCanBeRenderedByUXRules(v);if(!V){if(this._oFirstVisibleSection){v=this._oFirstVisibleSection;this.setAssociation("selectedSection",v.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}};
t.prototype._sectionCanBeRenderedByUXRules=function(v){if(!(v instanceof O)){return false;}var w=v.getBindingInfo("subSections");if(!w&&(!v.getVisible()||!v._getInternalVisible())){return false;}var x=this._aSectionBases.map(function(y){return y.getId();});return(x.indexOf(v.getId())>-1);};
t.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var v=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&v){return[v];}else{return this.getSections();}};
t.prototype._preloadSectionsOnBeforeFirstRendering=function(){var v=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(v);if(this.getEnableLazyLoading()){v.forEach(function(w){this.fireEvent("subSectionPreload",{subSection:w});},this);}};
t.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var v,w,I;if(!this.getEnableLazyLoading()){return this._getSectionsToRender();}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases());}this._adjustSelectedSectionByUXRules();w=this.oCore.byId(this.getSelectedSection());if(!w||(w===this._oFirstVisibleSection)){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases);}I=this.indexOfSection(w);var x=function(y){var z=y.isA("sap.uxap.ObjectPageSection")?y:y.getParent();return this.indexOfSection(z)>=I;}.bind(this);v=this._aSectionBases.filter(x);return this._oLazyLoading.getSubsectionsToPreload(v);};
t.prototype._grepCurrentTabSectionBases=function(){var v=[],w,x,y,z;this._adjustSelectedSectionByUXRules();w=this.oCore.byId(this.getSelectedSection());if(w){x=w.getId();this._aSectionBases.forEach(function(B){y=B.getParent();z=y&&y.getId();if(B.getId()===x||z===x){v.push(B);}});}return v;};
t.prototype.onAfterRendering=function(){var H=this._getHeaderContent(),v=this.getFooter(),w,W=this._getWidth(this);this._bInvalidatedAndNotRerendered=false;this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._ensureCorrectParentHeight();if(this._$sectionsContainer){this._$sectionsContainer.off("focusout");this._$sectionsContainer.off("focusin");}this._cacheDomElements();if(this._$sectionsContainer){this._$sectionsContainer.focusin(function(){this._skipToNextFastGroup=true;}.bind(this));this._$sectionsContainer.focusout(function(){this._skipToNextFastGroup=false;}.bind(this));}if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle");}if(W>0){this._updateMedia(W,t.MEDIA);}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());}if(H&&H.supportsPinUnpin()){this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",H.getPinnable());}if(v){w=t._getLibraryResourceBundle().getText("FOOTER_ARIA_LABEL");v.$().attr("aria-label",w);}this._handleExpandButtonPressEventLifeCycle(true);};
t.prototype._onAfterRenderingDomReady=function(){var v,w,x,W=this._getWidth(this);if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();v=this.getSelectedSection();w=this.oCore.byId(v);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(v){if(this.getUseIconTabBar()){this._setSelectedSectionId(v);this._setCurrentTabSection(w);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(w);this._checkSubSectionVisibilityChange();}else{this.scrollToSection(v,0);}}this._toggleScrolling(!this._bAllContentFitsContainer);if(D.system.desktop){this._$opWrapper.on("scroll.OPL",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){x=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(x);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(W,t.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(W,t.DYNAMIC_HEADERS_MEDIA);}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady");};
t.prototype._toggleScrolling=function(E){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflowY=E?"auto":"hidden";}};
t.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),v=this._calculateShiftOffset();$.css(v.sStyleAttribute,v.iMarginalsOffset+"px");};
t.prototype._calculateShiftOffset=function(){var H=0,v=this.oCore.getConfiguration().getRTL()?"left":"right",w=this._hasVerticalScrollBar(),x=this._iOffset,y;if(D.system.desktop){y=j().width;H=y;if(!w){H=0;x+=y;}}return{"sStyleAttribute":v,"iActionsOffset":x,"iMarginalsOffset":H};};
t.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?t.HEADER_CALC_DELAY:0;};
t.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._oLazyLoading){this._oLazyLoading.destroy();this._oLazyLoading=null;}this._deregisterScreenSizeListener();if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};
t.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var v=new e(this.getId()+"-vertSB",{scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this),visible:false});this.setAggregation("_customScrollBar",v,true);}return this.getAggregation("_customScrollBar");};
t.prototype.onWrapperScroll=function(E){var v=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(v);}};
t.prototype.onCustomScrollerScroll=function(E){var v=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(v);};
t.prototype.setShowOnlyHighImportance=function(v){var w=this.getShowOnlyHighImportance();if(w!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(x){x._updateImportance();});}return this;};
t.prototype.setIsHeaderContentAlwaysExpanded=function(v){var w=this.getAlwaysShowContentHeader();var x=(D.system.phone||D.system.tablet);if(w!==v){this.setProperty("alwaysShowContentHeader",v,x);}return this;};
t.prototype.setShowEditHeaderButton=function(v){var w=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(w!==v){this.setProperty("showEditHeaderButton",v,true);H&&H.invalidate();}return this;};
t.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};
t.prototype.setSelectedSection=function(I){var v,w;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){k(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._selectFirstVisibleSection();return this;}this.scrollToSection(I);v=b._getClosestSection(I);w=(v instanceof b)?v.getId():v;return this.setAssociation("selectedSection",w,true);};
t.prototype._selectFirstVisibleSection=function(){if(this.getUseIconTabBar()){this._adjustSelectedSectionByUXRules();this._setCurrentTabSection(this._oFirstVisibleSection);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(this._oFirstVisibleSection);this._preloadSectionsOnBeforeScroll(this._oFirstVisibleSection);this._updateSelectionOnScroll(0);this._checkSubSectionVisibilityChange();}else if(this.$().is(":visible")){this._scrollTo(0,0);if(!this._bInvalidatedAndNotRerendered){this._sScrolledSectionId=null;this._updateSelectionOnScroll(0);}}};
t.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};
t.prototype._cacheDomElements=function(){this._$footerWrapper=q(document.getElementById(this.getId()+"-footerWrapper"));this._$titleArea=q(document.getElementById(this.getId()+"-headerTitle"));this._$anchorBar=q(document.getElementById(this.getId()+"-anchorBar"));this._$stickyAnchorBar=q(document.getElementById(this.getId()+"-stickyAnchorBar"));this._$opWrapper=q(document.getElementById(this.getId()+"-opwrapper"));this._$spacer=q(document.getElementById(this.getId()+"-spacer"));this._$headerContent=q(document.getElementById(this.getId()+"-headerContent"));this._$stickyHeaderContent=q(document.getElementById(this.getId()+"-stickyHeaderContent"));this._$contentContainer=q(document.getElementById(this.getId()+"-scroll"));this._$sectionsContainer=q(document.getElementById(this.getId()+"-sectionsContainer"));this._$skipFastGroupAnchor=q(document.getElementById(this.getId()+"-skipFastGroupAnchor"));this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};
t.prototype._handleExpandButtonPress=function(E){this._expandHeader(true);};
t.prototype._toggleHeaderTitle=function(E,U){var H=this.getHeaderTitle();if(this._$titleArea.length){this._$titleArea.toggleClass("sapUxAPObjectPageHeaderStickied",!E);this._$titleArea.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!E);}if(E){H&&H.unSnap(U);}else{H&&H.snap(U);}};
t.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this._bSupressModifyOnScrollOnce=true;};
t.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;}};
t.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};
t.prototype._applyUxRules=function(I){var v,w,V,x,y,z,U,B,E,G,H,J,N={};v=this.getSections()||[];x=0;z=this.getShowAnchorBar();U=this.getUseIconTabBar();B=null;this._cleanMemory();v.forEach(function(Q){if(!Q.getVisible()){return true;}this._registerSectionBaseInfo(Q);w=Q.getSubSections()||[];V=0;E=null;w.forEach(function(W){if(!W.getVisible()){return true;}this._registerSectionBaseInfo(W);y=W.getVisibleBlocksCount();if(y===0){W._setInternalVisible(false,I);h.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+W.getTitle()+" forced to hidden");}else{W._setInternalVisible(true,I);N[W.getId()]=true;V++;if(!E){E=W;}if(this._shouldApplySectionTitleLevel(W)){W._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(W));}}},this);if(V==0){Q._setInternalVisible(false,I);h.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+Q.getTitle()+" forced to hidden");}else{Q._setInternalVisible(true,I);N[Q.getId()]=true;if(!B){B=Q;J=V;}if(this.getSubSectionLayout()===s.TitleOnTop&&V===1&&E.getTitle().trim()!==""){h.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+Q.getTitle()+" is taking its single subsection title "+E.getTitle());Q._setInternalTitle(E.getTitle(),I);N[E.getId()]=false;E._setBorrowedTitleDomId(Q.getId()+"-title");}else{Q._setInternalTitle("",I);}if(V===1&&!E.getTitle().trim()){E._setBorrowedTitleDomId(Q.getId()+"-title");}if(this._shouldApplySectionTitleLevel(Q)){Q._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(Q));}x++;}if(U){N[Q.getId()]=false;}},this);if(x<=1){z=false;h.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");if(U&&B){N[B.getId()]=true;}}else if(B&&z){G=true;N[B.getId()]=false;h.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+B.getTitle()+" title forced to hidden");}this.toggleStyleClass(t.NO_NAVIGATION_CLASS_NAME,x<=1);Object.keys(N).forEach(function(Q){this.oCore.byId(Q)._setInternalTitleVisible(N[Q],I);}.bind(this));if(z){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(z,I);this._oFirstVisibleSection=B;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(B);this._bAllContentFitsContainer=(x===1)&&(V===1)&&this._oFirstVisibleSubSection.hasStyleClass(c.FIT_CONTAINER_CLASS);if(G&&(J===1)){H=this.getAggregation("_anchorBar").getContent();if(H.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(H[0].getId()+"-content");}}this._checkSubSectionVisibilityChange();};
t.prototype._checkSubSectionVisibilityChange=function(){var U=this.getUseIconTabBar(),v=U&&sap.ui.getCore().byId(this.getSelectedSection()),w=v?[v]:this._getVisibleSections(),V={},I;w.forEach(function(x){x.getSubSections().forEach(function(y){I=y.getVisible()&&y._getInternalVisible();if(I){V[y.getId()]=y;}});});if(i(Object.keys((this._oVisibleSubSections)),Object.keys(V)).length){this._oVisibleSubSections=V;this.fireEvent("subSectionVisibilityChange",{visibleSubSections:V});}};
t.prototype.setUseIconTabBar=function(v){var w=this.getUseIconTabBar();if(v!=w){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};
t.prototype.onsapskipforward=function(E){if(this._skipToNextFastGroup){this._handleGroupNavigation(E,true);}};
t.prototype.onsapskipback=function(E){if(this._skipToNextFastGroup){this._handleGroupNavigation(E,false);}};
t.prototype._handleGroupNavigation=function(E,v){var w={target:v?this._$skipFastGroupAnchor[0]:this._$sectionsContainer[0]};E.type="keydown";F.handleF6GroupNavigation(E,w);};
t.prototype._setCurrentTabSection=function(v,I){if(!v){return;}var w;if(v instanceof sap.uxap.ObjectPageSubSection){w=v;v=v.getParent();}else{w=this._getFirstVisibleSubSection(v);}if(this._oCurrentTabSection!==v){this._renderSection(v);this._oCurrentTabSection=v;}this._oCurrentTabSubSection=w;};
t.prototype._renderSection=function(v){var $=this.$().find(".sapUxAPObjectPageContainer"),w;if(v&&$.length){w=this.oCore.createRenderManager();this.getSections().forEach(function(x){if((x.getId()===v.getId())){w.renderControl(v);}else{w.cleanupControlWithoutRendering(x);}});w.flush($[0]);w.destroy();}};
t.prototype.setShowAnchorBarPopover=function(v,w){var x=this.getProperty("showAnchorBarPopover"),v=this.validateProperty("showAnchorBarPopover",v),y=this.getSelectedSection();if(v===x){return this;}this._oABHelper._getAnchorBar().setShowPopover(v);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(y);return this.setProperty("showAnchorBarPopover",v,true);};
t.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};
t.prototype._setInternalAnchorBarVisible=function(v,I){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(I===true){this.invalidate();}}};
t.prototype.setUpperCaseAnchorBar=function(v){this._oABHelper._getAnchorBar().setProperty("upperCase",v);return this.setProperty("upperCaseAnchorBar",v,true);};
t.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,t.DOM_CALC_DELAY,this);}if(!I){h.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+t.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(v){});};
t.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,t.DOM_CALC_DELAY,this);}if(!I){h.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+t.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(v){});};
t.prototype._adjustLayoutAndUxRules=function(){var v,w;h.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();v=this.getSelectedSection();w=this.oCore.byId(v);if(w){this._setSelectedSectionId(v);if(this.getUseIconTabBar()){this._setCurrentTabSection(w);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(w);}this._requestAdjustLayout(true).then(function(x){if(x){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();v=this.getSelectedSection();if(!this._isClosestScrolledSection(v)||this._oScroller._$Container.is(":animated")){this.scrollToSection(v,null,0,false,true);}}.bind(this));}};
t.prototype._isClosestScrolledSection=function(v){var w=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,x=this.iScreenHeight,y=this._getClosestScrolledSectionId(w,x);return y&&(v===y);};
t.prototype._setSelectedSectionId=function(v){var w=this.getAggregation("_anchorBar"),x=v&&this._oSectionInfo[v];if(!x){return;}if(w&&x.buttonId){w.setSelectedButton(x.buttonId);this.setAssociation("selectedSection",v,true);}};
t.prototype.isFirstRendering=function(){return this._bFirstRendering;};
t.prototype._cleanMemory=function(){var v=this.getAggregation("_anchorBar");if(v){v._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};
t.prototype._registerSectionBaseInfo=function(v){this._oSectionInfo[v.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(v instanceof b),sectionReference:v};this._aSectionBases.push(v);};
t.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};
t.prototype.scrollToSection=function(I,v,w,x,y){var z=this.oCore.byId(I),B,E,G=(sap.ui.getCore().getConfiguration().getAnimationMode()!==C.AnimationMode.none),H;if(!this.getDomRef()){h.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!z){h.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]||!z._getInternalVisible()){h.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){h.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var J=b._getClosestSection(z);var W=this._bAllContentFitsContainer,N;this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(J);this._toggleScrolling(!this._bAllContentFitsContainer);N=this._bAllContentFitsContainer!==W;if(N&&!this._bHeaderExpanded){this._snapHeader(!this._bAllContentFitsContainer);this._bSupressModifyOnScrollOnce=true;}if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}J._allowPropagationToLoadedViews(true);this._setCurrentTabSection(z);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[J.getId()].buttonId);this.setAssociation("selectedSection",J.getId(),true);this._checkSubSectionVisibilityChange();}E=z instanceof c?z:this._getFirstVisibleSubSection(z);if(x){this.fireNavigate({section:b._getClosestSection(z),subSection:E});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}w=w||0;z._expandSection();this._requestAdjustLayout(true);v=this._computeScrollDuration(v,z);var Q=this._computeScrollPosition(z);if(this._sCurrentScrollId!=I||y){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),v);}this._preloadSectionsOnBeforeScroll(z);this.getHeaderTitle()&&this._shiftHeaderTitle();Q+=w;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(Q)){B=this._getSnapPosition();this._scrollTo(B,0);if(B===0){this._toggleHeader(true);}}H=G&&v&&this.getEnableLazyLoading();this._scrollTo(Q,v,H);}};
t.prototype._hasSingleVisibleFullscreenSubSection=function(v){var V=v.getSubSections().filter(function(w){return w.getVisible()&&w._getInternalVisible()&&(w.getBlocks().length>0);});return(V.length===1)&&V[0].hasStyleClass(c.FIT_CONTAINER_CLASS);};
t.prototype._computeScrollDuration=function(v,w){var x=parseInt(v);x=x>=0?x:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((w instanceof b)||this._isFirstVisibleSectionBase(w))&&this._bStickyAnchorBar){x=0;}return x;};
t.prototype._computeScrollPosition=function(v){var w=v&&(v instanceof b),I=v.getId(),x=this._bMobileScenario||w?this._oSectionInfo[I].positionTopMobile:this._oSectionInfo[I].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(v)){x=0;}return x;};
t.prototype._preloadSectionsOnBeforeScroll=function(v){var I=v.getId(),w;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){w=(v instanceof b)?v:v.getParent();this._connectModelsForSections([w]);}if(this.getEnableLazyLoading()){var x=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;w=this._oLazyLoading.getSubsectionsToPreload(x,I);if(D.system.desktop){setTimeout(function(){this._connectModelsForSections(w);}.bind(this),50);}else{this._connectModelsForSections(w);}w.forEach(function(y){this.fireEvent("subSectionEnteredViewPort",{subSection:y});},this);}};
t.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};
t.prototype.setDirectScrollingToSection=function(v){this.sDirectSectionId=v;};
t.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};
t.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};
t.prototype._scrollTo=function(y,v,w){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){h.debug("ObjectPageLayout :: scrolling to "+y);if((v===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}if(w&&this._oLazyLoading){this._oLazyLoading.suppress();this._oScroller.scrollTo(0,y,v,this._resumeLazyLoading.bind(this));}else{this._oScroller.scrollTo(0,y,v);}}return this;};
t.prototype._resumeLazyLoading=function(){if(this._oLazyLoading){this._oLazyLoading.resume();this._oLazyLoading.lazyLoadDuringScroll(true);}};
t.prototype._scrollBelowCollapseVisualIndicator=function(){var H=this._getHeaderContent(),$,v,V,w;if(!u(H)||!u(this._$opWrapper)){return;}$=H._getCollapseButton().getDomRef();v=$.getBoundingClientRect().height;V=this._$opWrapper[0].getBoundingClientRect().height;w=$.offsetTop+v-V;this._scrollTo(w);};
t.prototype._updateMedia=function(w,v){if(!w){return;}var U=function(x){Object.keys(v).forEach(function(y){var z=v[y],E=x===z;this.toggleStyleClass(z,E);},this);}.bind(this),B=t.BREAK_POINTS;if(w<=B.PHONE){U(v.PHONE);}else if(w<=B.TABLET){U(v.TABLET);}else{U(v.DESKTOP);}};
t.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var v,w,x,y,z,B,E=!this._bHeaderExpanded,I,G,H,J=this.getDomRef(),U=this.getUseIconTabBar();if(!J||!this._bDomReady){return false;}h.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(J);if(this.iScreenHeight===0){return;}this.iFooterHeight=this._getFooterHeight();var N=-1;this._aSectionBases.forEach(function(Q){var V=this._oSectionInfo[Q.getId()],$=Q.$(),W,X=false;if(!V||!$.length){return;}if(!V.isSection){N++;}V.$dom=$;var Y=$.position().top;V.positionTop=Math.ceil(Y);if(V.isSection){W=Q.$("header");}else{W=Q.$("headerTitle");}X=W.length===0;if(!X){V.positionTopMobile=Math.ceil(l.Utilities.getChildPosition(W,this._$contentContainer).top)+W.outerHeight();}else{V.positionTopMobile=V.positionTop;}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){V.positionTopMobile-=this.iAnchorBarHeight;V.positionTop-=this.iAnchorBarHeight;}V.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",X);if(this._bMobileScenario){var Z=this.oCore.byId(Q.getId()).getParent();if(Z instanceof b&&Z._getIsHidden()){return;}if(z){this._oSectionInfo[z].positionBottom=V.positionTop;}z=Q.getId();w=Q;}else{if(V.isSection){if(z){this._oSectionInfo[z].positionBottom=V.positionTop;if(y){this._oSectionInfo[y].positionBottom=V.positionTop;}}z=Q.getId();y=null;}else{if(y){this._oSectionInfo[y].positionBottom=V.positionTop;}y=Q.getId();w=Q;}}if(!V.isSection){G=U||(Q.getParent()===this._oFirstVisibleSection);I=G&&(N===0);H=Q.hasStyleClass(c.FIT_CONTAINER_CLASS);Q._setHeight(this._computeSubSectionHeight(I,H,V.positionTop));}},this);if(w){v=this._computeLastVisibleHeight(w);if(this._bMobileScenario&&z){this._oSectionInfo[z].positionBottom=this._oSectionInfo[z].positionTop+v;}else{if(y){this._oSectionInfo[y].positionBottom=this._oSectionInfo[y].positionTop+v;}if(z&&y){this._oSectionInfo[z].positionBottom=this._oSectionInfo[y].positionTop+v;}}B=this._bStickyAnchorBar||(N>0)||this._checkContentBottomRequiresSnap(w);if(this._bAllContentFitsContainer){B=false;}if(B&&!this._shouldPreserveHeaderInTitleArea()){E=true;}x=this._computeSpacerHeight(w,v,B,E);this._$spacer.height(x+"px");h.debug("ObjectPageLayout :: bottom spacer is now "+x+"px");m(this._oScrollContainerLastState,{iScrollableContentLength:Math.ceil(this._getScrollableContentLength()),iSpacerHeight:x});}this._updateCustomScrollerHeight(E);this._setSectionInfoIsDirty(false);return true;};
t.prototype._computeSubSectionHeight=function(v,w,x){var y,z;if(!w){return"";}var I=(this._bAllContentFitsContainer)?this._bHeaderExpanded:v;y=this._getSectionsContainerHeight(!I);if(this._bAllContentFitsContainer){z=(x-this.iHeaderContentHeight)+this.iFooterHeight;y-=z;}return y+"px";};
t.prototype._updateCustomScrollerHeight=function(v){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var w=this._computeScrollableContentSize(v);w+=this._getStickyAreaHeight(v);this._getCustomScrollBar().setContentSize(w+"px");var x=(w>Math.ceil(this.iScreenHeight)),V=(x!==this._getCustomScrollBar().getVisible());if(V){this._getCustomScrollBar().setVisible(x);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};
t.prototype._computeScrollableContentSize=function(v){var w=0;if(this._$contentContainer&&this._$contentContainer.length){w=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&v){w-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!v){w+=this.iAnchorBarHeight;}return w;};
t.prototype._computeLastVisibleHeight=function(v){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var w=this._getSectionPositionTop(v,I);return this._$spacer.position().top-w;};
t.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};
t.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};
t.prototype._getSectionsContainerHeight=function(I){var v=this._getScrollableViewportHeight(I);if(!I){v-=(this.iHeaderContentHeight+this.iAnchorBarHeight);}return v;};
t.prototype._getSectionPositionTop=function(v,w){var x=Math.ceil(l.Utilities.getChildPosition(v.$(),this._$contentContainer).top);if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea&&w){x-=this.iAnchorBarHeight;}return x;};
t.prototype._getSectionPositionBottom=function(v,w){var x=this._oSectionInfo[v.getId()].positionBottom;if(!w){x+=this.iAnchorBarHeight;}return x;};
t.prototype._determineSectionBaseInternalTitleLevel=function(v){var w=this.getSectionTitleLevel(),I=v instanceof b;if(w===p.Auto){return I?p.H3:p.H4;}return I?w:t._getNextTitleLevelEntry(w);};
t.prototype._shouldApplySectionTitleLevel=function(v){return v.getTitleLevel()===p.Auto;};
t.prototype._checkContentBottomRequiresSnap=function(v){var w=false;return this._getSectionPositionBottom(v,w)>(this._getScrollableViewportHeight(w)+this._getSnapPosition());};
t.prototype._computeSpacerHeight=function(v,w,x,y){var z,B;if(Object.keys(this._oVisibleSubSections).length===1&&this._bHeaderExpanded){z=0;}else{B=this._getScrollableViewportHeight(y);if(x){B=Math.ceil(B);w=Math.floor(w);}else{w=this._$spacer.position().top;}if(w<B){z=B-w;if(this._bMobileScenario){z+=(this._oSectionInfo[v.getId()].positionTopMobile-this._oSectionInfo[v.getId()].positionTop);}}else{z=0;}}if((this.iFooterHeight>z)){z+=this.iFooterHeight;}return z;};
t.prototype._isFirstVisibleSectionBase=function(v){var w,x,y,z=this.getSelectedSection(),U=this.getUseIconTabBar();if(!v||!v.getParent()){return;}w=v.getId();if(U&&(w===z)){return true;}if(U&&(v.getParent().getId()===z)){x=sap.ui.getCore().byId(z);y=this._getFirstVisibleSubSection(x);return y&&(y.getId()===w);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return w===this._oFirstVisibleSection.getId()||w===this._oFirstVisibleSubSection.getId();}return false;};
t.prototype._getFirstVisibleSubSection=function(v){if(!v){return;}var w;this._aSectionBases.every(function(x){if(x.getParent()&&(x.getParent().getId()===v.getId())){w=x;return false;}return true;});return w;};
t.prototype._initAnchorBarScroll=function(){var v=this.oCore.byId(this.getSelectedSection()),w;this._requestAdjustLayout(true);w=v?this._computeScrollPosition(v):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:w}},true);};
t.prototype._setAsCurrentSection=function(v){var w,x,y;if(this._sScrolledSectionId===v){return;}h.debug("ObjectPageLayout :: current section is "+v);this._sScrolledSectionId=v;w=this.getAggregation("_anchorBar");if(w&&this._getInternalAnchorBarVisible()){x=this.oCore.byId(v);y=x&&x instanceof c&&(x.getTitle().trim()===""||!x._getInternalTitleVisible()||x.getParent()._getIsHidden());if(y){v=x.getParent().getId();h.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+v);}if(x&&this._oSectionInfo[v]){w.setSelectedButton(this._oSectionInfo[v].buttonId);this.setAssociation("selectedSection",b._getClosestSection(v).getId(),true);this._setSectionsFocusValues(v);}}};
t.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};
t.prototype._onUpdateContentSize=function(E){var v;if(E.size.height===0||E.size.width===0){h.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}this._adjustHeaderHeights();this._requestAdjustLayout().then(function(){v=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(v);}.bind(this));};
t.prototype._onUpdateScreenSize=function(E){var v=this.getHeaderTitle(),H=this._getHeaderContent(),w=E.size.width,x=E.size.height,y=E.oldSize.height,z=(x!==y),B,I=H&&H.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(E.size.height===0||E.size.width===0){h.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){h.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(I&&(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader())){this.invalidate();}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._scrollTo(0,0);}if(v&&v.isDynamic()){v._onResize(w);this._updateMedia(w,t.DYNAMIC_HEADERS_MEDIA);}this._updateMedia(w,t.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}B=this.getSelectedSection();if((y===0)&&z&&!this._isClosestScrolledSection(B)){B!==null?this.scrollToSection(B,0):this._selectFirstVisibleSection();}this._scrollTo(this._$opWrapper.scrollTop(),0);if((y===0)&&z&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading();}}.bind(this),this._getDOMCalculationDelay());};
t.prototype._onUpdateHeaderTitleSize=function(E){if(E.size.height===0||E.size.width===0){h.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){h.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return;}this._adjustHeaderHeights();this._requestAdjustLayout();};
t.prototype._shouldSnapHeaderOnScroll=function(v){return(v>0)&&(v>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};
t.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0;};
t.prototype._isContentScrolledToBottom=function(){return this._oScrollContainerLastState.iScrollableContentLength<=(this._oScrollContainerLastState.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight);};
t.prototype._isContentLengthDecreased=function(v){if(v){return((v.iScrollableContentLength>this._oScrollContainerLastState.iScrollableContentLength)&&(v.iSpacerHeight===this._oScrollContainerLastState.iSpacerHeight));}};
t.prototype._canReachScrollTop=function(v,E){var w;E=E||0;w=this._oScrollContainerLastState.iScrollableContentLength+E-this._oScrollContainerLastState.iScrollableViewportHeight;return w>=v;};
t.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL");}};
t.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}};
t.prototype._onScroll=function(E,I){var v=Math.max(Math.ceil(E.target.scrollTop),0),$=this._$opWrapper.length&&this._$opWrapper[0],w=this._$spacer.length&&this._$spacer[0],x=w.offsetHeight,y,H=this.getHeaderTitle(),z=this._shouldSnapHeaderOnScroll(v),B=this._shouldPreserveHeaderInTitleArea(),G=false,J=this._oScrollContainerLastState;this._oScrollContainerLastState={iScrollTop:v,iScrollableContentLength:Math.ceil(this._getScrollableContentLength()),iScrollableViewportHeight:$.offsetHeight,iSpacerHeight:x};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}if(!$||!w){return;}y=this.iScreenHeight;if(y===0){return;}if(this._getSectionInfoIsDirty()){return;}if(J&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(J)){var N=J.iScrollableContentLength-this._oScrollContainerLastState.iScrollableContentLength;if(!this._canReachScrollTop(J.iScrollTop)&&this._canReachScrollTop(J.iScrollTop,N)){var Q=x+N;this._$spacer.height(Q+"px");this._scrollTo(J.iScrollTop);return;}}if(z&&!B){y-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!B){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!B&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(z,!!(E&&E.type==="scroll"));}if(!B){this._adjustHeaderTitleBackgroundPosition(v);}h.debug("ObjectPageLayout :: lazy loading : Scrolling at "+v,"----------------------------------------");this._updateSelectionOnScroll(v);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(I,v,E.timeStamp,y);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(v===0){q(document.getElementById(this.getId()+"-scroll")).css("z-index","1000");G=false;}else if(!G){G=true;q(document.getElementById(this.getId()+"-scroll")).css("z-index","0");}}};
t.prototype._updateSelectionOnScroll=function(v){var w=this.iScreenHeight,x,y;if(w===0){return;}x=this._getClosestScrolledSectionId(v,w);y=this._getClosestScrolledSectionId(v,w,true);if(x){var z=this.getDirectScrollingToSection();if(x!==this._sScrolledSectionId){h.debug("ObjectPageLayout :: closest id "+x,"----------------------------------------");var z=this.getDirectScrollingToSection();if(z&&z!==x){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(x);}else if(x===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(y!==this._sScrolledSubSectionId){var B=b._getClosestSection(x),E=this.oCore.byId(y);this._sScrolledSubSectionId=y;this.fireEvent("_sectionChange",{section:B,subSection:E});this.fireEvent("sectionChange",{section:B,subSection:E});}}};
t.prototype._getSnapPosition=function(){var v=this.iHeaderContentHeight,w=this._getTitleHeightDelta();v-=Math.max(w,this._iHeaderContentPaddingBottom);return v;};
t.prototype._getTitleHeightDelta=function(){var v=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;v=Math.max(v,0);v=Math.min(v,t.MAX_SNAP_POSITION_OFFSET);return v;};
t.prototype._getClosestScrolledSectionId=function(v,w,x){x=!!x;v=Math.ceil(v);var y=v+w,z,B=x||this._bMobileScenario;q.each(this._oSectionInfo,function(I,E){var G,H,J,N,Q,U=this.getSelectedSection();G=this.oCore.byId(I);if(!G){return;}H=G.getParent();J=H instanceof b&&H._getIsHidden();if(this.getUseIconTabBar()&&U){Q=this.oCore.byId(U);if(!Q){return;}if(E.isSection&&E.sectionReference!=Q){return true;}if(!E.isSection&&Q.indexOfSubSection(E.sectionReference)<0){return true;}}if(E.isSection||(B&&!J)){if(!z&&(E.sectionReference._getInternalVisible()===true)){N=this._getFirstVisibleSubSection(E.sectionReference);if(E.isSection&&x&&N){z=N.getId();}else{z=I;}}if(E.isSection&&x){return true;}if(E.positionTop<=y&&v<=E.positionBottom){if(E.positionTop<=v&&E.positionBottom>v){z=I;return false;}}}}.bind(this));return z;};
t.prototype._toggleHeader=function(v,U){var H;if(v===this._bStickyAnchorBar){return;}H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!v,U);}if(!this._bStickyAnchorBar&&v){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!v){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}};
t.prototype._restoreFocusAfter=function(v){var w=this.oCore.byId(this.oCore.getCurrentFocusedControlId());v.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){w&&w.$().trigger("focus");}}return this;};
t.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};
t.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var v=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(v);this._toggleHeaderStyleRules(false);}return this;};
t.prototype._toggleHeaderStyleRules=function(v){v=!!v;var V=v?"hidden":"inherit";this._bStickyAnchorBar=v;this._$headerContent.css("overflow",V);this._$headerContent.toggleClass("sapContrastPlus",!v);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",v);this._$anchorBar.css("visibility",V);if(u(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!v);}this.fireToggleAnchorBar({fixed:v});if(!v&&!this.iAnchorBarHeight){this._requestAdjustLayout();}};
t.prototype.getScrollDelegate=function(){return this._oScroller;};
t.prototype.setHeaderTitle=function(H,v){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._onAfterHeaderTitleRendering.bind(this)});}this.setAggregation("headerTitle",H,v);this._oObserver&&this._oObserver.disconnect();this._oObserver=new M(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(H,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(H){this._createHeaderContent();}if(this._hasDynamicTitle()){this._iHeaderContentPaddingBottom=o.toPx(P.get("_sap_f_DynamicPageHeader_PaddingBottom"));}return this;};
t.prototype._onAfterHeaderTitleRendering=function(){var H=this.getHeaderTitle(),$=H&&H.$(),v;if(!H||!$.length){return;}v=$.height();if(v!==this._iCachedHeaderTitleHeight){this._adjustHeaderHeights();this._iCachedHeaderTitleHeight=v;}};
t.prototype._onModifyHeaderTitle=function(v){var H=this.getAggregation("_headerContent");H&&v.current&&H.setBackgroundDesign(v.current);};
t.prototype.invalidate=function(v){this._bInvalidatedAndNotRerendered=true;if(this.getUseIconTabBar()&&v&&(v instanceof b)&&!v.isActive()&&this._oSectionInfo[v.getId()]){return;}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}a.prototype.invalidate.apply(this,arguments);};
t.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),v=H&&H.supportsBackgroundDesign()&&H.getBackgroundDesign(),w=this.getAggregation("_headerContent"),x,N;var y=H?H.getCompatibleHeaderContentClass():d;if(!(w instanceof y)){x=this.getAggregation("_headerContent");if(x){x.destroy();}N=y.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");v&&N.setBackgroundDesign(v);this.setAggregation("_headerContent",N,true);}};
t.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};
t.prototype._adjustHeaderTitleBackgroundPosition=function(v){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-v)+"px");}}}};
t.prototype._adjustHeaderHeights=function(){var v=this.getHeaderTitle(),w=true;if(v&&!v.supportsAdaptLayoutForDomElement()){w=false;}if(this._$titleArea.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.round(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.outerHeight():this._$anchorBar.outerHeight();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$titleArea.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(w);}else{this.iHeaderTitleHeight=this._$titleArea.is(":visible")?this._$titleArea.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(w);}this._adjustHeaderBackgroundSize();h.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{h.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};
t.prototype._appendTitleCloneToDOM=function(E){var $=this.getHeaderTitle().$(),v=$.clone();v.css({left:"-10000px",top:"-10000px",width:$.width()+"px",position:"absolute"});v.toggleClass("sapUxAPObjectPageHeaderStickied",E);v.appendTo(this._$titleArea.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptObjectPageHeaderIndentifierLine(v);}return v;};
t.prototype._obtainSnappedTitleHeight=function(v){var w=this.getHeaderTitle(),$,H;if(!w){return 0;}if(v){$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();}else if(w.snap){H=this._obtainTitleHeightViaStateChange(true);}return H;};
t.prototype._obtainExpandedTitleHeight=function(v){var w=this.getHeaderTitle(),$,H;if(!w){return 0;}if(v){$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();}else if(w.unSnap){H=this._obtainTitleHeightViaStateChange(false);}return H;};
t.prototype._obtainTitleHeightViaStateChange=function(v){var w=this.getHeaderTitle(),H,x=this._$sectionsContainer.height(),y,z=(v)?w.snap:w.unSnap,B=(v)?w.unSnap:w.snap;z.call(w,false);H=w.$().outerHeight();B.call(w,false);y=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(x,y);return H;};
t.prototype._adjustSpacerHeightUponUnsnapping=function(v,w){var x;if(v!=w){x=this._$spacer.height()-(w-v);this._$spacer.height(x);}};
t.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),v=l.ObjectPageHeaderDesign.Light;if(H!=null){v=H.getHeaderDesign();}return v;};
t.prototype._getVisibleSections=function(){return this.getSections().filter(function(v){return v.getVisible()&&v._getInternalVisible();});};
t.prototype._setSectionsFocusValues=function(v){var w=this._getVisibleSections()||[],$,x='0',N='-1',y="tabindex",z,B=w[0];w.forEach(function(E){$=E.$();if(v===E.sId){$.attr(y,x);z=E;E._setSubSectionsFocusValues();}else{$.attr(y,N);E._disableSubSectionsFocus();}});if(!z&&w.length>0){B.$().attr(y,x);B._setSubSectionsFocusValues();z=B;}return z;};
t.prototype.setShowHeaderContent=function(v){var w=this.getShowHeaderContent(),H;if(w!==v){if(w&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",v,true);H=this._getHeaderContent();this.$().toggleClass("sapUxAPObjectPageLayoutNoHeaderContent",!v||!H);if(H){H.setProperty("visible",v);}}return this;};
t.prototype._headerTitleChangeHandler=function(I){var v;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}v=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(v,this);this._getHeaderContent().invalidate();v.destroy();};
t.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};
t.prototype.insertHeaderContent=function(v,I,w){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",v,I,w);}return this._getHeaderContent().insertAggregation("content",v,I,w);};
t.prototype.addHeaderContent=function(v,w){if(!this._getHeaderContent()){return this.addAggregation("headerContent",v,w);}return this._getHeaderContent().addAggregation("content",v,w);};
t.prototype.removeAllHeaderContent=function(v){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",v);}return this._getHeaderContent().removeAllAggregation("content",v);};
t.prototype.removeHeaderContent=function(v,w){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",v,w);}return this._getHeaderContent().removeAggregation("content",v,w);};
t.prototype.destroyHeaderContent=function(v){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",v);}return this._getHeaderContent().destroyAggregation("content",v);};
t.prototype.indexOfHeaderContent=function(v){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",v);}return this._getHeaderContent().indexOfAggregation("content",v);};
t.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};
t.prototype._getHeaderContentDomRef=function(){var H=this._getHeaderContent();return H&&H.getDomRef();};
t.prototype._connectModelsForSections=function(v){v=v||[];v.forEach(function(w){w.connectToModels();});};
t.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};
t.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};
t.prototype._shiftHeaderTitle=function(){var v=this._calculateShiftOffset(),w=v.sStyleAttribute,x=v.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+w,x+"px");};
t.prototype._isFirstSection=function(v){var w=this._getVisibleSections();if(v===w[0]){return true;}return false;};
t.prototype._isValidStoredSubSectionInfo=function(){var v=this.getSelectedSection(),w=this.oCore.byId(v),x;if(!w||!this._oStoredScrolledSubSectionInfo){return false;}x=this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId);return x&&this._sectionCanBeRenderedByUXRules(x)&&(w.indexOfSubSection(x)>=0);};
t.prototype._restoreScrollPosition=function(){var v=this._isValidStoredSubSectionInfo(),w;if(v){w=this._computeScrollPosition(this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(w,0);}else{this.scrollToSection(this.getSelectedSection(),0);}};
t.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady||!this._oScroller){return;}var v=this._oScroller.getScrollTop(),w=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true),x;if(w){x=v-this._computeScrollPosition(this.oCore.byId(w));}this._iStoredScrollTop=v;this._oStoredScrolledSubSectionInfo={sSubSectionId:w,iOffset:x};this._oCurrentTabSection=null;};
t.prototype.onkeyup=function(E){var v,w;if(E.which===K.TAB){v=this.oCore.getCurrentFocusedControlId();w=v&&this.oCore.byId(v);if(w&&this._isFirstSection(w)){this._scrollTo(0,0);}}};
t.prototype.setShowFooter=function(v){var w=this.setProperty("showFooter",v,true);this._toggleFooter(v);return w;};
t.prototype._toggleFooter=function(v){var U,w=this.getFooter();if(!u(w)||!u(this._$footerWrapper)){return;}U=this.oCore.getConfiguration().getAnimationMode()!==C.AnimationMode.none;if(U){this._toggleFooterAnimation(v,w);}else{this._$footerWrapper.toggleClass("sapUiHidden",!v);}this._requestAdjustLayout();};
t.prototype._toggleFooterAnimation=function(v,w){this._$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,w));this._bIsFooterAanimationGoing=true;if(v){this._$footerWrapper.removeClass("sapUiHidden");}w.toggleStyleClass(t.SHOW_FOOTER_CLASS_NAME,v);w.toggleStyleClass(t.HIDE_FOOTER_CLASS_NAME,!v);};
t.prototype._onToggleFooterAnimationEnd=function(v){this._$footerWrapper.off("webkitAnimationEnd animationend");if(v.hasStyleClass(t.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");v.removeStyleClass(t.HIDE_FOOTER_CLASS_NAME);}else{v.removeStyleClass(t.SHOW_FOOTER_CLASS_NAME);}this._bIsFooterAanimationGoing=false;};
t.prototype.clone=function(){var v,H,w;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);v=a.prototype.clone.apply(this,arguments);H=this._getHeaderContent();w=v._getHeaderContent();if(w){w.destroy();}if(H){v.setAggregation("_headerContent",H.clone(),true);}return v;};
t.prototype._cloneProxiedAggregations=function(v){var w=this.mAggregations[v];if(Array.isArray(w)&&w.length===0){w=this["get"+v.charAt(0).toUpperCase()+v.slice(1)]();}this.mAggregations[v]=w;};
t.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};
t.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};
t.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed();};
t.prototype._headerBiggerThanAllowedToBeFixed=function(){var v=this._getOwnHeight();return this._getEntireHeaderHeight()>t.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*v;};
t.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight();};
t.prototype._getOwnHeight=function(){return this._getHeight(this);};
t.prototype._getHeight=function(v){return!(v instanceof a)?0:v.$().outerHeight()||0;};
t.prototype._getEntireHeaderHeight=function(){var v=0,H=0,w=this.getHeaderTitle(),x=this._getHeaderContent();if(u(w)){v=w.$().outerHeight();}if(u(x)){H=x.$().outerHeight();}return v+H;};
t.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();this._restorePinButtonFocus();}};
t.prototype._restorePinButtonFocus=function(){var H=this._getHeaderContent();if(u(H)&&H.supportsPinUnpin()){H._focusPinButton();}};
t.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._togglePinButtonARIAState(this._bPinned);this._updateToggleHeaderVisualIndicators();if(u($)){$.addClass("sapUxAPObjectPageLayoutHeaderPinned");}};
t.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(u($)){$.removeClass("sapUxAPObjectPageLayoutHeaderPinned");}};
t.prototype._togglePinButtonARIAState=function(v){var H=this._getHeaderContent();if(u(H)&&H.supportsPinUnpin()){H._updateARIAPinButtonState(v);}};
t.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};
t.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._bHeaderBiggerThanAllowedHeight=false;return;}this._bHeaderBiggerThanAllowedHeight=true;if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};
t.prototype._hasDynamicTitle=function(){var v=this.getHeaderTitle();return v&&v.isDynamic();};
t.prototype._attachVisualIndicatorsPressHandlers=function(v,w){var x=this.getHeaderTitle(),H=this._getHeaderContent();if(u(x)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){x.attachEvent(t.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){v.call(w);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(u(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(t.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){v.call(w);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};
t.prototype._hasVisibleDynamicTitleAndHeader=function(){var v=this.getHeaderTitle(),H=this.getHeaderContent();return u(v)&&v.isDynamic()&&v.getVisible()&&u(H)&&H.length>0;};
t.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var v=this.getHeaderTitle();return u(v)&&v.isDynamic()&&!!v.getSnappedTitleOnMobile()&&D.system.phone;};
t.prototype._updateToggleHeaderVisualIndicators=function(){var H,v,E,w=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!w){v=false;E=false;}else{H=this._bHeaderExpanded;v=H;E=!H&&!this._hasDynamicTitleWithSnappedTitleOnMobile();}this._toggleCollapseVisualIndicator(v);this._toggleExpandVisualIndicator(E);};
t.prototype._updateTitleVisualState=function(){var v=this.getHeaderTitle(),w=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",w);if(u(v)){v._toggleFocusableState(w);}};
t.prototype._focusCollapseVisualIndicator=function(){var v=this._getHeaderContent();if(u(v)){v._focusCollapseButton();}};
t.prototype._focusExpandVisualIndicator=function(){var v=this.getHeaderTitle();if(u(v)){v._focusExpandButton();}};
t.prototype._toggleExpandVisualIndicator=function(v){var w=this.getHeaderTitle();if(u(w)){w._toggleExpandButton(v);}};
t.prototype._toggleCollapseVisualIndicator=function(v){var w=this._getHeaderContent();if(u(w)){w._toggleCollapseButton(v);}};
t.prototype._attachVisualIndicatorMouseOverHandlers=function(v,w,x){var H=this._getHeaderContent();if(u(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(t.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,v,x);H.attachEvent(t.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,w,x);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};
t.prototype._attachTitleMouseOverHandlers=function(v,w,x){var y=this.getHeaderTitle();if(u(y)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){y.attachEvent(t.EVENTS.TITLE_MOUSE_OVER,v,x);y.attachEvent(t.EVENTS.TITLE_MOUSE_OUT,w,x);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};
t.prototype._suppressScroll=function(){this._bSuppressScroll=true;};
t.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};
t.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};
t.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};
t.prototype._getHeight=function(v){return!(v instanceof a)?0:v.$().outerHeight()||0;};
t.prototype._getWidth=function(v){var w=v.getDomRef();return!(v instanceof a)?0:(w&&w.offsetWidth)||0;};
t.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};
t.prototype._setSectionInfoIsDirty=function(v){this.bSectionInfoIsDirty=v;};
t.prototype._getAriaLabelText=function(E,v){var H=this.getHeaderTitle(),w=H?H.getTitleText():null,x;if(H&&w){x=w;if(v){x+=" "+t._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITH_TITLE");}}else{x=t._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITHOUT_TITLE");}return x;};
t.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){return this._getDOMRefHeight(this.$("footerWrapper").get(0));}return 0;};
t.prototype._getDOMRefHeight=function(v){return v.parentElement?v.getBoundingClientRect().height:0;};
t.prototype._updateAriaLabels=function(){var v=this.getLandmarkInfo(),w=this._getAriaLabelText("ROOT",true),H=this._getAriaLabelText("HEADER",true),N=this._getAriaLabelText("NAVIGATION",false),x=this._getAriaLabelText("NAVTOOLBAR",true),y=v&&v.getHeaderLabel(),z=v&&v.getRootLabel(),B=v&&v.getNavigationLabel();if(!z){this.$().attr("aria-label",w);}if(!y){this.$("headerTitle").attr("aria-label",H);}if(!B){this.$("anchorBar").attr("aria-label",N);this.$("stickyAnchorBar").attr("aria-label",N);}this.$("anchBar").attr("aria-label",x);};
t.prototype._formatLandmarkInfo=function(v,w){if(v){var x=v["get"+w+"Role"]()||"",y=v["get"+w+"Label"]()||"";if(x===r.None){x='';}return{role:x.toLowerCase(),label:y};}return{};};
t.prototype._getHeaderTag=function(v){if(v&&v.getHeaderRole()!==r.None){return t.DIV;}return t.HEADER;};
t.prototype._getFooterTag=function(v){if(v&&v.getFooterRole()!==r.None){return t.DIV;}return t.FOOTER;};
function u(v){if(arguments.length===1){return Array.isArray(v)?v.length>0:!!v;}return Array.prototype.slice.call(arguments).every(function(w){return u(w);});}
return t;});
sap.ui.predefine('sap/uxap/ObjectPageLayoutABHelper',["sap/ui/thirdparty/jquery","sap/ui/base/Object","sap/ui/core/Core","sap/ui/core/CustomData","sap/ui/core/Configuration","sap/ui/base/ManagedObjectObserver","./AnchorBar","sap/m/Button","sap/m/MenuButton","sap/m/Menu","sap/m/MenuItem","sap/ui/core/IconPool"],function(q,B,C,a,b,M,A,c,d,e,f,I){"use strict";
var g=B.extend("sap.uxap._helpers.AB",{
constructor:function(o){this._oObjectPageLayout=o;this._oObserver=new M(this._proxyStateChanges.bind(this));this._aMenusWithAttachPressHandler=[];},
getInterface:function(){return this;}
});
g._focusSection=function(s,p){var S=s.getDomRef();if(S){S.focus(p);}};
g.prototype.getObjectPageLayout=function(){return this._oObjectPageLayout;};
g.prototype._proxyStateChanges=function(o){var O=o.object,i=this._findExistingClone(O),p=o.name,v=o.current,s="set"+h(p);if(i){i[s].call(i,v);}};
g.prototype._findExistingClone=function(o){var i,s=o.getId()+"-__clone",j=this._getAnchorBar(),k=j.getContent();k.some(function(l){if(l.getId().indexOf(s)===0){i=l;return true;}});return i;};
g.prototype._getAnchorBar=function(){var o=this.getObjectPageLayout(),i=o.getAggregation("_anchorBar");if(!i){i=new A({id:o.getId()+"-anchBar",showPopover:o.getShowAnchorBarPopover(),backgroundDesign:o.getBackgroundDesignAnchorBar()});this.getObjectPageLayout().setAggregation("_anchorBar",i,true);}return i;};
g.prototype._setCustomData=function(o,s,O,i){O._oSectionInfo[s.getId()].buttonId=o.getId();o.addCustomData(new a({key:"sectionId",value:s.getId()}));o.addCustomData(new a({key:"bTitleVisible",value:s._getInternalTitleVisible()}));if(!i){o.addCustomData(new a({key:"secondLevel",value:true}));}};
g.prototype._buildAnchorBar=function(){var o=this.getObjectPageLayout(),s=o.getSections()||[],i=this._getAnchorBar(),p=q.proxy(i._handleDirectScroll,i),j,k,m,l;if(i&&this.getObjectPageLayout().getShowAnchorBar()){i._resetControl();this._oObserver.disconnect();s.forEach(function(S){if(!S.getVisible()||!S._getInternalVisible()){return;}var n,r=S.getSubSections()||[];n=this._buildAnchorBarButton(S,true);if(n){i.addContent(n);if(n instanceof d){var t=new e({});n.enhanceAccessibilityState=function(E,u){var v=i.getContent(),w=v.indexOf(E.getParent());if(w!==-1){u.role="option";u.setsize=v.length;u.posinset=w+1;}};t._setCustomEnhanceAccStateFunction(function(E,u){u.controls=E.data("sectionId");});n.setMenu(t);}r.forEach(function(u){if(!u.getVisible()||!u._getInternalVisible()){return;}var v=this._buildAnchorBarButton(u,false),w=i.getId()+"-"+u.getId()+"-anchor";if(v){i.addContent(v);}if(n instanceof d){l=u.getCustomAnchorBarButton();if(l){j=l.getText();k=l.getIcon();}else{j=u._getInternalTitle()||u.getTitle();k='';}m=new f(w,{"text":j,"icon":k});m.addCustomData(new a({key:"sectionId",value:u.getId()}));m.attachPress(p);this._setCustomData(m,u,o,false);n.getMenu().addItem(m);}},this);}},this);}};
g.prototype._moveFocusOnSection=function(s){var S=s.data(),o=sap.ui.getCore().byId(S.sectionId),F={preventScroll:true},D;if(o){if(o.isActive()){g._focusSection(o,F);}else{D={"onAfterRendering":function(){o.removeEventDelegate(D);g._focusSection(o,F);}};o.addEventDelegate(D);}}};
g.prototype._instantiateAnchorBarButton=function(i,s,j){var k,S;if(i){k=d;S={type:"Transparent",buttonMode:"Split",useDefaultActionOnly:true,ariaDescribedBy:s};}else{k=c;S={ariaDescribedBy:s};}if(j){S.id=j;}return new k(S);};
g.prototype._buildAnchorBarButton=function(s,i){var o=null,O=this.getObjectPageLayout(),j,k=this._getAnchorBar(),l,S,H,v,m=s.getAggregation("subSections"),p=q.proxy(k._handleDirectScroll,k);if(s.getVisible()&&s._getInternalVisible()){j=s.getCustomAnchorBarButton();if(!j){l=k.getId()+"-"+s.getId()+"-anchor";if(i){if(m&&m.length>1){v=m.filter(function(n){return n.getVisible()&&n._getInternalVisible();}).length;}}H=i&&v>1&&k.getShowPopover();if(H){o=this._instantiateAnchorBarButton(true,s,l);o.attachDefaultAction(p);o._getButtonControl().attachPress(function(){this.getParent().focus();});o._getButtonControl().attachArrowPress(function(){var n=o._getButtonControl();if(this._aMenusWithAttachPressHandler[n.getId()]){return;}o.getMenu().attachItemSelected(function(E){this._moveFocusOnSection(E.getParameter("item"));},this);this._aMenusWithAttachPressHandler[n.getId()]=true;},this);o.addCustomData(new a({key:"bHasSubMenu",value:true}));}else if(i){o=this._instantiateAnchorBarButton(false,s,l);o.attachPress(function(E){this._moveFocusOnSection(E.getSource());},this);o.attachPress(p);}else{S=k.getId()+"-"+s.getId()+"-sub-anchor";o=this._instantiateAnchorBarButton(false,s,S);}var t=(s._getInternalTitle()!="")?s._getInternalTitle():s.getTitle();o.setText(t);}else{o=j.clone();o.attachPress(function(E){this._moveFocusOnSection(E.getSource());},this);o.attachPress(p);this._oObserver.observe(j,{properties:true});}this._setCustomData(o,s,O,i);}return o;};
function h(n){return n.substring(0,1).toUpperCase()+n.substring(1);}
return g;});
sap.ui.predefine('sap/uxap/ObjectPageLayoutRenderer',["sap/ui/Device"],function(D){"use strict";var O={apiVersion:2};
O.render=function(r,c){var s,h=c.getHeaderTitle(),a=null,R=sap.uxap.ObjectPageLayout._getLibraryResourceBundle(),i=c.getHeaderContent()&&c.getHeaderContent().length>0&&c.getShowHeaderContent(),I=c.getShowTitleInHeaderContent()&&c.getShowHeaderContent(),b=i||I,u=c.getUseIconTabBar(),t=c.getToggleHeaderOnTitleClick()&&c.getHeaderTitle()&&c.getHeaderTitle().supportsToggleHeaderOnTitleClick(),d=c._getAriaLabelText("ROOT",true),H=c._getAriaLabelText("HEADER",true),B=c.getBackgroundDesignAnchorBar(),l=c.getLandmarkInfo(),e=c._getHeaderTag(l),f=c._getFooterTag(l),g=l&&l.getHeaderRole(),j=l&&l.getHeaderLabel(),k=l&&l.getRootRole(),m=l&&l.getRootLabel(),n=l&&l.getNavigationRole();if(c.getShowAnchorBar()&&c._getInternalAnchorBarVisible()){a=c.getAggregation("_anchorBar");}r.openStart("div",c);if(!k){r.attr("role","main");}r.attr("aria-roledescription",R.getText("ROOT_ROLE_DESCRIPTION"));if(!m){r.attr("aria-label",d);}r.class("sapUxAPObjectPageLayout");if(t){r.class("sapUxAPObjectPageLayoutTitleClickEnabled");}if(!b){r.class("sapUxAPObjectPageLayoutNoHeaderContent");}if(!a||!a.getVisible()){r.class("sapUxAPObjectPageLayoutNoAnchorBar");}r.style("height",c.getHeight());r.accessibilityState(c,c._formatLandmarkInfo(l,"Root"));r.openEnd();if(D.system.desktop){r.renderControl(c._getCustomScrollBar());}r.openStart(e,c.getId()+"-headerTitle");if(!g){r.attr("role","banner");}r.attr("aria-roledescription",R.getText("HEADER_ROLE_DESCRIPTION"));if(!j){r.attr("aria-label",H);}r.attr("data-sap-ui-customfastnavgroup",true).class("sapUxAPObjectPageHeaderTitle").class("sapContrastPlus").accessibilityState(c,c._formatLandmarkInfo(l,"Header")).openEnd();if(h){r.renderControl(h);}this._renderHeaderContentDOM(r,c,c._bHeaderInTitleArea,"-stickyHeaderContent");r.openStart("div",c.getId()+"-stickyAnchorBar");r.attr("data-sap-ui-customfastnavgroup",true);if(!n){r.attr("role","navigation");}r.attr("aria-roledescription",R.getText("NAVIGATION_ROLE_DESCRIPTION"));if(!c._bHeaderInTitleArea){r.attr("aria-hidden","true");}r.class("sapUxAPObjectPageStickyAnchorBar").class("sapUxAPObjectPageNavigation").class("ui-helper-clearfix");if(B){r.class("sapUxAPObjectPageNavigation"+B);}r.accessibilityState(c,c._formatLandmarkInfo(l,"Navigation"));r.openEnd();this._renderAnchorBar(r,c,a,c._bHeaderInTitleArea);r.close("div");r.close(e);r.openStart("div",c.getId()+"-opwrapper").class("sapUxAPObjectPageWrapper");if(h&&(!h.supportsTitleInHeaderContent()||!(c.getShowTitleInHeaderContent()&&h.getShowTitleSelector()))){r.class("sapUxAPObjectPageWrapperTransform");}r.openEnd();r.openStart("div",c.getId()+"-scroll").class("sapUxAPObjectPageScroll").openEnd();this._renderHeaderContentDOM(r,c,!c._bHeaderInTitleArea,"-headerContent",true);r.openStart("section",c.getId()+"-anchorBar");r.attr("data-sap-ui-customfastnavgroup",true);if(!n){r.attr("role","navigation");}r.attr("aria-roledescription",R.getText("NAVIGATION_ROLE_DESCRIPTION"));r.class("sapUxAPObjectPageNavigation").class("ui-helper-clearfix").class("sapContrastPlus");if(B){r.class("sapUxAPObjectPageNavigation"+B);}r.accessibilityState(c,c._formatLandmarkInfo(l,"Navigation"));r.openEnd();this._renderAnchorBar(r,c,a,!c._bHeaderInTitleArea);r.close("section");r.openStart("section",c.getId()+"-sectionsContainer");r.class("sapUxAPObjectPageContainer");r.class("ui-helper-clearfix");if(!a){r.class("sapUxAPObjectPageContainerNoBar");}r.accessibilityState(c,c._formatLandmarkInfo(l,"Content"));r.openEnd();s=c._getSectionsToRender();if(Array.isArray(s)){s.forEach(function(S){r.renderControl(S);if(u){c._oCurrentTabSection=S;}});}r.close("section");this.renderFooterContent(r,c);r.openStart("div",c.getId()+"-spacer").openEnd().close("div");r.openStart("span",c.getId()+"-skipFastGroupAnchor").class("sapUiPseudoInvisibleText").openEnd().close("span");r.close("div");r.close("div");this._renderFooterContentInternal(r,c,f,l,R);r.close("div");};
O._renderAnchorBar=function(r,c,a,R){var s=c.getAggregation("sections"),h;if(R){h=c._getHeaderContent();if(c.getIsChildPage()&&h&&h.supportsChildPageDesign()){r.openStart("div",c.getId()+"-childPageBar");if(Array.isArray(s)&&s.length>1){r.class('sapUxAPObjectChildPage');}r.openEnd();r.close("div");}if(a){r.renderControl(a);}}};
O._renderHeaderContentDOM=function(r,c,R,i,a){r.openStart("header",c.getId()+i).class("ui-helper-clearfix").class("sapUxAPObjectPageHeaderDetails").class("sapUxAPObjectPageHeaderDetailsDesign-"+c._getHeaderDesign());if(a){r.class("sapContrastPlus");}r.attr("data-sap-ui-customfastnavgroup",true).openEnd();if(R){this.renderHeaderContent(r,c);}r.close("header");};
O.renderHeaderContent=function(r,c){r.renderControl(c._getHeaderContent());};
O.renderFooterContent=function(r,c){};
O._renderFooterContentInternal=function(r,o,f,l,R){var F=o.getFooter(),b=l&&l.getFooterRole();if(!F){return;}r.openStart(f,o.getId()+"-footerWrapper");r.class("sapUxAPObjectPageFooter").class("sapMFooter-CTX").class("sapContrast").class("sapContrastPlus");if(!o.getShowFooter()){r.class("sapUiHidden");}if(!b){r.attr("role","region");}r.attr("aria-roledescription",R.getText("FOOTER_ROLE_DESCRIPTION"));r.accessibilityState(o,o._formatLandmarkInfo(l,"Footer"));r.openEnd();F.addStyleClass("sapUxAPObjectPageFloatingFooter");r.renderControl(F);r.close(f);};
O._rerenderHeaderContentArea=function(r,c){var h=c._bHeaderInTitleArea?"stickyHeaderContent":"headerContent",$;this.renderHeaderContent(r,c);$=c.$(h)[0];if($){r.flush($);}};
return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageLazyLoader',['./library','sap/ui/core/Element','sap/ui/core/StashedControlSupport',"sap/base/assert"],function(l,E,S,a){"use strict";
var L=E.extend("sap.uxap.ObjectPageLazyLoader",{metadata:{library:"sap.uxap",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},defaultAggregation:"content"}});
S.mixInto(L);
L.prototype.setParent=function(p){if(!(p===null||p instanceof sap.uxap.ObjectPageSubSection)){a(false,"setParent(): oParent must be an instance of sap.uxap.ObjectPageSubSection or null");}return E.prototype.setParent.apply(this,arguments);};
return L;});
sap.ui.predefine('sap/uxap/ObjectPageSection',["sap/ui/core/InvisibleText","./ObjectPageSectionBase","sap/ui/Device","sap/m/Button","sap/ui/core/StashedControlSupport","./ObjectPageSubSection","./library","sap/m/library","./ObjectPageSectionRenderer"],function(I,O,D,B,S,a,l,m,b){"use strict";var c=m.ButtonType;
var d=O.extend("sap.uxap.ObjectPageSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"subSections",aggregations:{subSections:{type:"sap.uxap.ObjectPageSubSection",multiple:true,singularName:"subSection"},ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_showHideAllButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_showHideButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{selectedSubSection:{type:"sap.uxap.ObjectPageSubSection",multiple:false}},designtime:"sap/uxap/designtime/ObjectPageSection.designtime"}});
d.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;
d._getClosestSection=function(s){var o=(typeof s==="string"&&sap.ui.getCore().byId(s))||s;return(o instanceof a)?o.getParent():o;};
d._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
d.prototype._expandSection=function(){O.prototype._expandSection.call(this)._updateShowHideAllButton(!this._thereAreHiddenSubSections());};
d.prototype.init=function(){O.prototype.init.call(this);this._sContainerSelector=".sapUxAPObjectPageSectionContainer";};
d.prototype.exit=function(){this._detachMediaContainerWidthChange(this._updateImportance,this);};
d.prototype.setTitle=function(v){O.prototype.setTitle.call(this,v);var A=this.getAggregation("ariaLabelledBy"),s=d._getLibraryResourceBundle().getText("SECTION_CONTROL_NAME");if(A){sap.ui.getCore().byId(A.getId()).setText(v+" "+s);}return this;};
d.prototype._getImportanceLevelToHide=function(C){var o=this._getObjectPageLayout(),M=C||this._getCurrentMediaContainerRange(),s=o&&o.getShowOnlyHighImportance();return this._determineTheLowestLevelOfImportanceToShow(M.name,s);};
d.prototype._updateImportance=function(C){var o=this._getObjectPageLayout(),i=this._getImportanceLevelToHide(C);this.getSubSections().forEach(function(s){s._applyImportanceRules(i);});this._applyImportanceRules(i);this._updateShowHideAllButton(false);if(o&&this.getDomRef()){o._requestAdjustLayout();}};
d.prototype._determineTheLowestLevelOfImportanceToShow=function(M,s){if(s||M==="Phone"){return l.Importance.High;}if(M==="Tablet"){return l.Importance.Medium;}return l.Importance.Low;};
d.prototype.connectToModels=function(){this.getSubSections().forEach(function(s){s.connectToModels();});};
d.prototype._allowPropagationToLoadedViews=function(A){this.getSubSections().forEach(function(s){s._allowPropagationToLoadedViews(A);});};
d.prototype.onBeforeRendering=function(){var A="ariaLabelledBy";if(!this.getAggregation(A)){this.setAggregation(A,this._getAriaLabelledBy(),true);}this._detachMediaContainerWidthChange(this._updateImportance,this);this._updateImportance();};
d.prototype.onAfterRendering=function(){this._attachMediaContainerWidthChange(this._updateImportance,this);};
d.prototype._getAriaLabelledBy=function(){var L="",t=this._getTitle();if(t){L+=t+" ";}L+=d._getLibraryResourceBundle().getText("SECTION_CONTROL_NAME");return new I({text:L}).toStatic();};
d.prototype._isTitleVisible=function(){return this.getShowTitle()&&this._getInternalTitleVisible();};
d.prototype._setSubSectionsFocusValues=function(){var s=this.getSubSections()||[],L=this.getSelectedSubSection(),p;if(s.length===0){return this;}if(s.length===1){s[0]._setToFocusable(false);return this;}s.forEach(function(o){if(L===o.sId){o._setToFocusable(true);p=true;}else{o._setToFocusable(false);}});if(!p){s[0]._setToFocusable(true);}return this;};
d.prototype._disableSubSectionsFocus=function(){var s=this.getSubSections()||[];s.forEach(function(o){o._setToFocusable(false);});return this;};
d.prototype._thereAreHiddenSubSections=function(){return this.getSubSections().some(function(s){return s._getIsHidden();});};
d.prototype._updateShowHideSubSections=function(h){this.getSubSections().forEach(function(s){if(h&&s._shouldBeHidden()){s._updateShowHideState(true);}else if(!h){s._updateShowHideState(false);}});};
d.prototype._getShouldDisplayShowHideAllButton=function(){return this.getSubSections().some(function(s){return s._shouldBeHidden();});};
d.prototype._showHideContentAllContent=function(){var s=this._thereAreHiddenSubSections();if(this._getIsHidden()&&s){this._updateShowHideState(false);}this._updateShowHideSubSections(!s);this._updateShowHideAllButton(s);};
d.prototype._updateShowHideState=function(h){if(this._getIsHidden()===h){return this;}this._updateShowHideButton(h);this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton());return O.prototype._updateShowHideState.call(this,h);};
d.prototype._updateShowHideAllButton=function(h){this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()).setText(this._getShowHideAllButtonText(h));};
d.prototype._getShowHideAllButton=function(){if(!this.getAggregation("_showHideAllButton")){this.setAggregation("_showHideAllButton",new B({visible:this._getShouldDisplayShowHideAllButton(),text:this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),press:this._showHideContentAllContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true);}return this.getAggregation("_showHideAllButton");};
d.prototype._getShowHideButtonText=function(h){return d._getLibraryResourceBundle().getText(h?"HIDE":"SHOW");};
d.prototype._getShowHideAllButtonText=function(h){return d._getLibraryResourceBundle().getText(h?"HIDE_ALL":"SHOW_ALL");};
d.prototype._updateShowHideButton=function(h){this._getShowHideButton().setVisible(this._shouldBeHidden()).setText(this._getShowHideButtonText(!h));};
d.prototype._getShowHideButton=function(){if(!this.getAggregation("_showHideButton")){this.setAggregation("_showHideButton",new B({visible:this._shouldBeHidden(),text:this._getShowHideButtonText(!this._getIsHidden()),press:this._showHideContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true);}return this.getAggregation("_showHideButton");};
S.mixInto(d);return d;});
sap.ui.predefine('sap/uxap/ObjectPageSectionBase',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/library","./library","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(q,C,c,l,L,K){"use strict";var T=c.TitleLevel;
var O=C.extend("sap.uxap.ObjectPageSectionBase",{
metadata:{"abstract":true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:T.Auto},visible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}},aggregations:{customAnchorBarButton:{type:"sap.m.Button",multiple:false}}},
renderer:null
});
O.prototype.init=function(){this._bInternalVisible=true;this._bInternalTitleVisible=true;this._sInternalTitle="";this._sInternalTitleLevel=T.Auto;this._isHidden=false;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();};
O.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._requestAdjustLayout().catch(function(){L.debug("ObjectPageSectionBase :: cannot adjustLayout",this);});this._getObjectPageLayout()._setSectionsFocusValues();}};
O.prototype.setCustomAnchorBarButton=function(b){var r=this.setAggregation("customAnchorBarButton",b,true);if(this._getObjectPageLayout()){this._getObjectPageLayout()._updateNavigation();}return r;};
O.prototype._setInternalVisible=function(v,i){if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};
O.prototype._getInternalVisible=function(){return this._bInternalVisible;};
O.prototype._setInternalTitleVisible=function(v,i){if(v!=this._bInternalTitleVisible){this._bInternalTitleVisible=v;if(i){this.invalidate();}}};
O.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible;};
O.prototype._setInternalTitle=function(v,i){if(v!=this._sInternalTitle){this._sInternalTitle=v;if(i){this.invalidate();}}};
O.prototype._getTitle=function(){return this._getInternalTitle()||this.getTitle();};
O.prototype._getInternalTitle=function(){return this._sInternalTitle;};
O.prototype._getARIALevel=function(){return this._getTitleLevel().slice(-1);};
O.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return(t===T.Auto)?this._getInternalTitleLevel():t;};
O.prototype._setInternalTitleLevel=function(t){this._sInternalTitleLevel=t;};
O.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel;};
O.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};
O.prototype._notifyObjectPageLayout=function(){if(this._getObjectPageLayout()&&this._getObjectPageLayout().$().length){this._getObjectPageLayout()._requestAdjustLayoutAndUxRules();}};
["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(m){O.prototype[m]=function(a,o,i,s){if(["addAggregation","removeAggregation"].indexOf(m)>-1){s=i;}if(["removeAllAggregation","destroyAggregation"].indexOf(m)>-1){s=o;}var r=C.prototype[m].apply(this,arguments);if(s!==true){this._notifyObjectPageLayout();}return r;};});
O.prototype.setVisible=function(v,s){if(this.getVisible()===v){return this;}if(!this._getObjectPageLayout()){return this.setProperty("visible",v,s);}this.setProperty("visible",v,true);this._notifyObjectPageLayout();this.invalidate();return this;};
O.prototype.setTitle=function(v,s){this.setProperty("title",v,s);this._notifyObjectPageLayout();return this;};
O.prototype._shouldBeHidden=function(){return O._importanceMap[this.getImportance()]>O._importanceMap[this._sCurrentLowestImportanceLevelToShow];};
O._importanceMap={"Low":3,"Medium":2,"High":1};
O.prototype._updateShowHideState=function(h){var o=this._getObjectPageLayout();this._isHidden=h;this.$().children(this._sContainerSelector).toggle(!h);if(o){o._requestAdjustLayout();}return this;};
O.prototype._getIsHidden=function(){return this._isHidden;};
O.prototype._expandSection=function(){return this._updateShowHideState(false);};
O.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden());};
O.prototype._applyImportanceRules=function(s){this._sCurrentLowestImportanceLevelToShow=s;if(this.getDomRef()){this._updateShowHideState(this._shouldBeHidden());}else{this._isHidden=this._shouldBeHidden();}};
O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
O.prototype.onkeydown=function(e){if(e.keyCode===K.SPACE&&e.srcControl.isA("sap.uxap.ObjectPageSection")){e.preventDefault();}if(e.keyCode===K.F7){var s=this.getSubSections(),f=s[0],o;if(s.length===1){o=f._oLastFocusedControlF7;if(o){o.$().trigger("focus");}else{f.$().firstFocusableDomRef().focus();}}else{if(f.getActions().length){f.getActions()[0].$().trigger("focus");}}}};
O.prototype.onsapdown=function(e){this._handleFocusing(e,e.currentTarget.nextSibling);};
O.prototype._handleFocusing=function(e,E){var s;if(this._targetIsCorrect(e)&&E){s=q(e.currentTarget).parent().children();e.preventDefault();E.focus();if(s.length>1){this._scrollParent(q(E).attr("id"));}}};
O.prototype._targetIsCorrect=function(e){return e.srcControl===this;};
O.prototype.onsapright=function(e){var m=this._bRtl?"onsapup":"onsapdown";this[m](e);};
O.prototype.onsapup=function(e){this._handleFocusing(e,e.currentTarget.previousSibling);};
O.prototype.onsapleft=function(e){var m=this._bRtl?"onsapdown":"onsapup";this[m](e);};
O.prototype.onsaphome=function(e){this._handleFocusing(e,e.currentTarget.parentElement.firstChild);};
O.prototype.onsapend=function(e){this._handleFocusing(e,e.currentTarget.parentElement.lastChild);};
O.prototype.onsappageup=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S-(O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[0]){s[0].focus();f=q(s[0]).attr("id");}if(s.length>1){this._scrollParent(f);}};
O.prototype.onsappagedown=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S+O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[s.length-1]){s[s.length-1].focus();f=q(s[s.length-1]).attr("id");}if(s.length>1){this._scrollParent(f);}};
O.prototype._scrollParent=function(i){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(i,0,10);}};
return O;});
sap.ui.predefine('sap/uxap/ObjectPageSectionRenderer',function(){"use strict";var O={apiVersion:2};
O.render=function(r,c){var t,T,a=sap.ui.getCore().getConfiguration().getAccessibility(),l=c.getAggregation("ariaLabelledBy");if(!c.getVisible()||!c._getInternalVisible()){return;}t=c._getTitle();T=c._isTitleVisible();r.openStart("section",c).class("sapUxAPObjectPageSection");if(!T){r.class("sapUxAPObjectPageSectionNoTitle");}r.attr("role","region");if(a&&l){r.attr("aria-labelledby",l.getId());}r.openEnd();r.openStart("div",c.getId()+"-header").attr("role","heading").attr("aria-level",c._getARIALevel()).class("sapUxAPObjectPageSectionHeader").class(T?"":"sapUxAPObjectPageSectionHeaderHidden").openEnd();r.openStart("div",c.getId()+"-title").class("sapUxAPObjectPageSectionTitle");if(c.getTitleUppercase()){r.class("sapUxAPObjectPageSectionTitleUppercase");}r.openEnd();r.text(t);r.close("div");if(T){r.renderControl(c._getShowHideAllButton());r.renderControl(c._getShowHideButton());}r.close("div");r.openStart("div").class("sapUxAPObjectPageSectionContainer");if(c._isHidden){r.style("display","none");}r.openEnd();c.getSubSections().forEach(r.renderControl,r);r.close("div");r.close("section");};
return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageSubSection',["sap/ui/thirdparty/jquery","sap/ui/layout/Grid","sap/ui/layout/GridData","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/Device","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","sap/m/TitlePropagationSupport","./library","sap/m/library","./ObjectPageSubSectionRenderer","sap/base/Log","sap/ui/base/DataType","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(q,G,a,O,b,B,c,D,S,d,T,l,m,e,f,g,K){"use strict";var h=m.ButtonType;var i=l.ObjectPageSubSectionMode;var j=l.ObjectPageSubSectionLayout;
var k=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:i.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designtime:"sap/uxap/designtime/ObjectPageSubSection.designtime"}});
T.call(k.prototype,"blocks",function(){return this._getTitleDomId();});k.FIT_CONTAINER_CLASS="sapUxAPObjectPageSubSectionFitContainer";
k._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
k.prototype.init=function(){O.prototype.init.call(this);this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._sMoreContainerSelector=".sapUxAPSubSectionSeeMoreContainer";this._oObserver=new d(k.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._switchSubSectionMode(this.getMode());this._initTitlePropagationSupport();this._sBorrowedTitleDomId=false;this._height="";};
k.prototype._getHeight=function(){return this._height;};
k.prototype._setHeight=function(v){var t,o;if(this._height===v){return;}t=g.getType("sap.ui.core.CSSSize");if(!t.isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+t.getName()+" for property \"_height\" of "+this);}this._height=v;o=this.getDomRef();if(o){o.style.height=v;}};
k.prototype._getTitleDomId=function(){if(this._sBorrowedTitleDomId){return this._sBorrowedTitleDomId;}if(!this.getTitle().trim()){return false;}if(this._getInternalTitleVisible()){return this.getId()+"-headerTitle";}return false;};
k.prototype._setBorrowedTitleDomId=function(I){this._sBorrowedTitleDomId=I;};
k.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};
k.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);}return this.getAggregation("_grid");};
k.prototype._hasVisibleActions=function(){var A=this.getActions()||[];if(A.length===0){return false;}return A.filter(function(o){return o.getVisible();}).length>0;};
k.prototype._observeChanges=function(C){var o=C.object,s=C.name,M=C.mutation,n=C.child,H;if(o===this){if(s==="actions"){if(M==="insert"){this._observeAction(n);}else if(M==="remove"){this._unobserveAction(n);}}}else if(s==="visible"){H=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!H){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions());}}};
k.prototype._observeAction=function(C){this._oObserver.observe(C,{properties:["visible"]});};
k.prototype._unobserveAction=function(C){this._oObserver.unobserve(C,{properties:["visible"]});};
["addStyleClass","toggleStyleClass","removeStyleClass"].forEach(function(M){k.prototype[M]=function(s,n){if(s===k.FIT_CONTAINER_CLASS){this._notifyObjectPageLayout();}return O.prototype[M].apply(this,arguments);};});
k.prototype._unStashControls=function(){S.getStashedControls(this.getId()).forEach(function(C){C.setStashed(false);});};
k.prototype.connectToModels=function(){var n=this.getBlocks()||[],M=this.getMoreBlocks()||[],C=this.getMode();this._unStashControls();n.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});if(M.length>0&&C===i.Expanded){M.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});}};
k.prototype._allowPropagationToLoadedViews=function(A){var n=this.getBlocks()||[],M=this.getMoreBlocks()||[];n.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});M.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});};
k.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(A){var o=this.mAggregations[A];if(!o||o.length===0){this.mAggregations[A]=this._aAggregationProxy[A];}},this);return O.prototype.clone.apply(this,arguments);};
k.prototype._cleanProxiedAggregations=function(){var p=this._aAggregationProxy;Object.keys(p).forEach(function(s){p[s].forEach(function(o){o.destroy();});});};
k.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}if(this._oSeeLessButton){this._oSeeLessButton.destroy();this._oSeeLessButton=null;}this._oCurrentlyVisibleSeeMoreLessButton=null;this._cleanProxiedAggregations();if(O.prototype.exit){O.prototype.exit.call(this);}};
k.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}this._$spacer=q(document.getElementById(o.getId()+"-spacer"));if(this._bShouldFocusSeeMoreLessButton){this._bShouldFocusSeeMoreLessButton=false;this._oCurrentlyVisibleSeeMoreLessButton.focus();}};
k.prototype.onBeforeRendering=function(){var o=this._getObjectPageLayout();if(!o){return;}if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(o);this.refreshSeeMoreVisibility();};
k.prototype._applyLayout=function(L){var v,o=this._getGrid(),C=this.getMode(),s=L.getSubSectionLayout(),n=this._calculateLayoutConfiguration(s,L),p=this.getBlocks(),A=p.concat(this.getMoreBlocks());this._oLayoutConfig=n;this._resetLayoutData(A);if(C===i.Expanded){v=A;}else{v=p;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(r){this._setBlockMode(r,C);o.addAggregation("content",r,true);},this);}catch(E){f.error("ObjectPageSubSection :: error while building layout "+s+": "+E);}return this;};
k.prototype._calculateLayoutConfiguration=function(L,o){var n={M:2,L:3,XL:4},p=n.L,E=n.XL,t=(L===j.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){p-=1;E-=1;}if(u){p-=1;}n.L=p;n.XL=E;return n;};
k.prototype.refreshSeeMoreVisibility=function(){var s=this._getSeeMoreButton(),o=this._getSeeLessButton();this._bBlockHasMore=!!this.getMoreBlocks().length;if(!this._bBlockHasMore){this._bBlockHasMore=this.getBlocks().some(function(n){if(n instanceof B&&n.getVisible()&&n.getShowSubSectionMore()){return true;}});}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",this._bBlockHasMore);s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);o.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);return this._bBlockHasMore;};
k.prototype.setMode=function(M){if(this.getMode()!==M){this._switchSubSectionMode(M);if(this._bRenderedFirstTime){this.rerender();}}return this;};
k.prototype.onkeydown=function(E){if(E.keyCode===K.SPACE&&E.srcControl.isA("sap.uxap.ObjectPageSubSection")){E.preventDefault();}if(E.keyCode===K.F7){E.stopPropagation();var t=sap.ui.getCore().byId(E.target.id);if(t instanceof k){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};
k.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().trigger("focus");}else{this.getParent().$().trigger("focus");}};
k.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().trigger("focus");}else{this.$().firstFocusableDomRef().focus();}};
k.prototype._calcBlockColumnLayout=function(n,C){var o=12,v,M,L,X,p;M={iRemaining:C.M,iColumnConfig:C.M};L={iRemaining:C.L,iColumnConfig:C.L};X={iRemaining:C.XL,iColumnConfig:C.XL};p=[X,L,M];v=n.filter(function(r){return r.getVisible&&r.getVisible();});v.forEach(function(r,I){p.forEach(function(s){s.iCalculatedSize=this._calculateBlockSize(r,s.iRemaining,v,I,s.iColumnConfig);},this);r.setLayoutData(new a(r.getId()+"-layoutData",{spanS:o,spanM:M.iCalculatedSize*(o/M.iColumnConfig),spanL:L.iCalculatedSize*(o/L.iColumnConfig),spanXL:X.iCalculatedSize*(o/X.iColumnConfig),linebreakM:(I>0&&M.iRemaining===M.iColumnConfig),linebreakL:(I>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(I>0&&X.iRemaining===X.iColumnConfig)}));p.forEach(function(s){s.iRemaining-=s.iCalculatedSize;if(s.iRemaining<1){s.iRemaining=s.iColumnConfig;}});},this);return v;};
k.prototype._calculateBlockSize=function(o,r,v,C,M){var n,F=M,p;if(!this._hasAutoLayout(o)){return Math.min(M,parseInt(o.getColumnLayout()));}for(p=1;p<=F;p++){n=this._calcLayout(v[C+p]);if(n<r){r-=n;}else{break;}}return r;};
k.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout());}return L;};
k.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};
k.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}q.each(this._aAggregationProxy,q.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A,true),true);},this));this._bRenderedFirstTime=true;};
k.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};
k.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};
k.prototype._setAggregation=function(A,v,s){this._aAggregationProxy[A]=v;if(s!==true){this._notifyObjectPageLayout();this.invalidate();}return this._aAggregationProxy[A];};
k.prototype.addAggregation=function(A,o,s){var n;if(o instanceof b){o.getContent().forEach(function(C){this.addAggregation(A,C,true);},this);o.removeAllContent();o.destroy();this.invalidate();return this;}if(this.hasProxy(A)){n=this._getAggregation(A);n.push(o);this._setAggregation(A,n,s);if(o instanceof B||o instanceof b){o.setParent(this);}return this;}return O.prototype.addAggregation.apply(this,arguments);};
k.prototype.insertBlock=function(o,I){f.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",o);};
k.prototype.insertMoreBlock=function(o,I){f.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",o);};
k.prototype.removeAllAggregation=function(A,s){var I;if(this.hasProxy(A)){I=this._getAggregation(A);this._setAggregation(A,[],s);return I.slice();}return O.prototype.removeAllAggregation.apply(this,arguments);};
k.prototype.removeAggregation=function(A,o){var r=false,I;if(this.hasProxy(A)){I=this._getAggregation(A);I.forEach(function(n,p){if(n.getId()===o.getId()){I.splice(p,1);this._setAggregation(A,I);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};
k.prototype.indexOfAggregation=function(A,o){var I=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(n,p){if(n.getId()===o.getId()){I=p;return true;}},this);return I;}return O.prototype.indexOfAggregation.apply(this,arguments);};
k.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};
k.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};
k.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new c(this.getId()+"--seeMore",{type:h.Transparent,iconFirst:false,text:k._getLibraryResourceBundle().getText("SHOW_MORE"),ariaLabelledBy:this.getId()}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};
k.prototype._getSeeLessButton=function(){if(!this._oSeeLessButton){this._oSeeLessButton=new c(this.getId()+"--seeLess",{type:h.Transparent,iconFirst:false,text:k._getLibraryResourceBundle().getText("SHOW_LESS"),ariaLabelledBy:this.getId()}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeLessButton;};
k.prototype._seeMoreLessControlPressHandler=function(E){var C=this.getMode(),t,M=this.getMoreBlocks()||[];if(C===i.Expanded){t=i.Collapsed;}else{t=i.Expanded;M.forEach(function(o){if(o instanceof B){o.setMode(C);o.connectToModels();}},this);}this._switchSubSectionMode(t);this._bShouldFocusSeeMoreLessButton=true;};
k.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===i.Collapsed){this.setProperty("mode",i.Collapsed);this._oCurrentlyVisibleSeeMoreLessButton=this._getSeeMoreButton().setVisible(true);this._getSeeLessButton().setVisible(false);}else{this.setProperty("mode",i.Expanded);this._getSeeMoreButton().setVisible(false);this._oCurrentlyVisibleSeeMoreLessButton=this._getSeeLessButton().setVisible(true);}};
k.prototype._setBlockMode=function(o,M){if(o instanceof B){o.setMode(M);}else{f.debug("ObjectPageSubSection :: cannot propagate mode "+M+" to "+o.getMetadata().getName());}};
k.prototype._setToFocusable=function(F){var s='0',n='-1',t="tabindex";if(F){this.$().attr(t,s);}else{this.$().attr(t,n);}return this;};
k.prototype._getUseTitleOnTheLeft=function(){var o=this._getObjectPageLayout();return o&&(o.getSubSectionLayout()===j.TitleOnLeft);};
k.prototype._resetLayoutData=function(n){n.forEach(function(o){if(o.getLayoutData()){o.destroyLayoutData();}},this);};
k.prototype._updateShowHideState=function(H){if(this._getIsHidden()===H){return this;}this.$().children(this._sMoreContainerSelector).toggle(!H);return O.prototype._updateShowHideState.call(this,H);};
k.prototype.getVisibleBlocksCount=function(){var v=S.getStashedControls(this.getId()).length;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(M){if(M.getVisible&&!M.getVisible()){return true;}v++;});return v;};
return k;});
sap.ui.predefine('sap/uxap/ObjectPageSubSectionRenderer',function(){"use strict";var O={apiVersion:2};
O.render=function(r,c){var a,h,s,H,b,u,d,A=sap.ui.getCore().getConfiguration().getAccessibility();if(!c.getVisible()||!c._getInternalVisible()){return;}a=c.getActions()||[];b=a.length>0;s=c.getShowTitle();h=(c._getInternalTitleVisible()&&(c.getTitle().trim()!==""))&&s;H=h||b;d=c._hasVisibleActions();r.openStart("div",c).attr("role","region").style("height",c._getHeight());if(c._bBlockHasMore){r.class("sapUxAPObjectPageSubSectionWithSeeMore");}r.class("sapUxAPObjectPageSubSection").class("ui-helper-clearfix");if(A){if(h){r.attr("aria-labelledby",c.getId()+"-headerTitle");}else{r.attr("aria-label",sap.uxap.ObjectPageSubSection._getLibraryResourceBundle().getText("SUBSECTION_CONTROL_NAME"));}}r.openEnd();if(H){r.openStart("div",c.getId()+"-header").class("sapUxAPObjectPageSubSectionHeader");if(!h&&!d){r.class("sapUiHidden");}u=c._getUseTitleOnTheLeft();if(u){r.class("titleOnLeftLayout");}r.openEnd();r.openStart("div",c.getId()+"-headerTitle");if(h){r.attr("role","heading").attr("aria-level",c._getARIALevel());}r.class('sapUxAPObjectPageSubSectionHeaderTitle');if(c.getTitleUppercase()){r.class("sapUxAPObjectPageSubSectionHeaderTitleUppercase");}r.attr("data-sap-ui-customfastnavgroup",true).openEnd();if(h){r.text(c.getTitle());}r.close("div");if(b){r.openStart("div").class('sapUxAPObjectPageSubSectionHeaderActions').attr("data-sap-ui-customfastnavgroup",true).openEnd();a.forEach(r.renderControl,r);r.close("div");}r.close("div");}r.openStart("div").class("ui-helper-clearfix").class("sapUxAPBlockContainer");if(c._isHidden){r.style("display","none");}r.openEnd();r.renderControl(c._getGrid());r.close("div");r.openStart("div").class("sapUxAPSubSectionSeeMoreContainer");if(c._isHidden){r.style("display","none");}r.openEnd();r.renderControl(c._getSeeMoreButton());r.renderControl(c._getSeeLessButton());r.close("div");r.close("div");};
return O;},true);
sap.ui.predefine('sap/uxap/ThrottledTaskHelper',["sap/ui/thirdparty/jquery",'sap/ui/base/Object'],function(q,B){"use strict";
var T=B.extend("ThrottledTask",{
constructor:function(t,d,c){this._fnTask=t;this._iDelay=d;this._oContext=c;this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._iTimer=null;this._oTaskOptions=null;},
reSchedule:function(i,t){var r=this._getPromise();if(this._iTimer){clearTimeout(this._iTimer);this._iTimer=null;}this._oTaskOptions=this._mergeOptions(this._oTaskOptions||{},t);if(i){var s=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(s);return r;}this._iTimer=setTimeout(function(){if(this._oPromise){var s=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(s);}}.bind(this),this._iDelay);return r;},
_getPromise:function(){if(!this._oPromise){this._oPromise=new window.Promise(function(r,a){this._fnResolvePromise=r;this._fnRejectPromise=a;}.bind(this));}return this._oPromise;},
_completePromise:function(s){var c=(s)?this._fnResolvePromise:this._fnRejectPromise;c();this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._oTaskOptions=null;},
_mergeOptions:function(o,n){var m=q.extend({},o,n);q.each(m,function(k){m[k]=o[k]||n[k];});return m;}
});
return T;});
sap.ui.predefine('sap/uxap/changeHandler/AddIFrameObjectPageLayout',["sap/ui/fl/Utils","sap/base/Log","sap/ui/fl/changeHandler/AddIFrame","sap/ui/fl/changeHandler/common/getTargetAggregationIndex","sap/ui/fl/changeHandler/common/createIFrame"],function(U,L,B,g,c){"use strict";var A=Object.assign({},B);
A.applyChange=function(C,o,p){var m=p.modifier;var a=C.getDefinition();var s=a.content.targetAggregation;if(s!=="sections"){return B.applyChange(C,o,p);}var v=p.view;var b=p.appComponent;var d=a.content.selector;var D=sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("SECTION_TITLE_FOR_IFRAME");var O=m.createControl("sap.uxap.ObjectPageSection",b,v,d,{title:D},false);var e=Object.create(d);e.id+="-subSection";var f=m.createControl("sap.uxap.ObjectPageSubSection",b,v,e,{title:D},false);m.insertAggregation(O,"subSections",f,0,v);var i=Object.create(d);i.id+="-iframe";var I=c(C,p,i);m.insertAggregation(f,"blocks",I,0,v);var h=g(C,o,p);m.insertAggregation(o,"sections",O,h,v);C.setRevertData([m.getId(O)]);};
return A;},true);
sap.ui.predefine('sap/uxap/changeHandler/MoveObjectPageSection',["sap/ui/fl/changeHandler/MoveControls","sap/ui/core/Core","sap/base/util/merge","sap/ui/thirdparty/jquery"],function(M,C,m,q){"use strict";var a=q.extend({},M);
a.applyChange=function(c,o,p){var j=p.modifier.targets==="jsControlTree";if(j){o._suppressScroll();}var r=M.applyChange.call(this,c,o,p);if(j){o.attachEventOnce("onAfterRenderingDOMReady",function(){o._resumeScroll(false);});}return r;};
a.revertChange=function(c,o,p){var j=p.modifier.targets==="jsControlTree";if(j){o._suppressScroll();}var r=M.revertChange.call(this,c,o,p);if(j){o.attachEventOnce("onAfterRenderingDOMReady",function(){o._resumeScroll(false);});}return r;};
a.completeChangeContent=function(c,s,p){var S=C.byId(s.source.id),t=C.byId(s.target.id);if(S.isA("sap.uxap.AnchorBar")&&t.isA("sap.uxap.AnchorBar")){this._mapAnchorsToSections(s,p);}return M.completeChangeContent.apply(this,arguments);};
a._mapAnchorsToSections=function(s,p){var S,o,b=p.modifier,l=b.bySelector(s.selector,p.appComponent,p.view),A=l._getVisibleSections();function g(c){var d=C.byId(c),e=d.data("sectionId");return C.byId(e);}s.movedElements.forEach(function(e){var c=A[e.targetIndex];e.targetIndex=b.findIndexInParentAggregation(c);S=g(e.id);if(!S||!S.getParent()){throw new Error("Cannot map anchor to section");}o={id:S.getParent().getId(),aggregation:S.sParentAggregationName};e.id=S.getId();});m(s.source,o);m(s.target,o);};
return a;},true);
sap.ui.predefine('sap/uxap/changeHandler/RenameObjectPageSection',["sap/ui/fl/Utils","sap/base/Log","sap/ui/fl/changeHandler/BaseRename"],function(U,L,B){"use strict";var r={propertyName:"title",changePropertyName:"newText",translationTextType:"XGRP"};var R=B.createRenameChangeHandler(r);
R._getControlForRename=function(c,m){var s=m.getAggregation(c,"subSections");if(s&&s.length===1&&(m.getPropertyBindingOrProperty(s[0],"title"))&&m.getProperty(m.getParent(c),"subSectionLayout")==="TitleOnTop"){return s[0];}return c;};
R.applyChange=function(c,C,p){var m=p.modifier,P=r.propertyName,o=c.getDefinition(),t=o.texts[r.changePropertyName],v=t.value,a=R._getControlForRename(C,m);if(typeof v==="string"&&v.trim()===""){throw new Error("Change cannot be applied as ObjectPageSubSection's title cannot be empty: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}if(o.texts&&t&&typeof(v)==="string"){c.setRevertData(m.getPropertyBindingOrProperty(a,P));m.setPropertyBindingOrProperty(a,P,v);return true;}else{L.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}};
R.revertChange=function(c,C,p){var o=c.getRevertData(),m=p.modifier,a=R._getControlForRename(C,m),P=r.propertyName;if(o||o===""){m.setPropertyBindingOrProperty(a,P,o);c.resetRevertData();return true;}else{L.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");}};
return R;},true);
sap.ui.predefine('sap/uxap/component/Component',["sap/uxap/library","sap/ui/core/UIComponent","sap/ui/core/library","sap/base/Log","sap/ui/core/Component"],function(l,U,c,L){"use strict";var V=c.mvc.ViewType;var O=l.ObjectPageConfigurationMode;
var C=U.extend("sap.uxap.component.Component",{
metadata:{},
init:function(){this._oModel=null;this._oViewConfig={viewData:{component:this}};switch(this.oComponentData.mode){case O.JsonURL:this._oModel=new U(this.oComponentData.jsonConfigurationURL);this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=V.XML;break;case O.JsonModel:this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=V.XML;break;default:L.error("UxAPComponent :: missing bootstrap information. Expecting one of the following: JsonURL, JsonModel and FacetsAnnotation");}U.prototype.init.call(this);},
createContent:function(){var o;this._oView=sap.ui.view(this._oViewConfig);if(this._oModel){o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this._oModel);}this._oView.setModel(this._oModel,"objectPageLayoutMetadata");}return this._oView;},
propagateProperties:function(n){if(this.oComponentData.mode===O.JsonModel){var o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this.getModel("objectPageLayoutMetadata"));}}return U.prototype.propagateProperties.apply(this,arguments);},
destroy:function(){if(this._oView){this._oView.destroy();this._oView=null;}if(this._oModel){this._oModel.destroy();this._oModel=null;}if(U.prototype.destroy){U.prototype.destroy.call(this);}}
});
return C;});
sap.ui.predefine('sap/uxap/component/ObjectPageComponentContainer',['sap/ui/core/ComponentContainer',"sap/base/Log",'sap/ui/core/Component'],function(C,L){"use strict";
var O=C.extend("sap.uxap.component.ObjectPageComponentContainer",{
metadata:{properties:{"jsonConfigurationURL":{type:"string",group:"Behavior"},"mode":{type:"sap.uxap.ObjectPageConfigurationMode",group:"Behavior"}}},
init:function(){this.setPropagateModel(true);this.setName("sap.uxap.component");},
onBeforeRendering:function(){this._oComponent||(this._oComponent=sap.ui.component("sap.uxap"));if(!this._oComponent){this._oComponent=sap.ui.component({name:this.getName(),url:this.getUrl(),componentData:{jsonConfigurationURL:this.getJsonConfigurationURL(),mode:this.getMode()}});this.setComponent(this._oComponent,true);}if(C.prototype.onBeforeRendering){C.prototype.onBeforeRendering.call(this);}},
getObjectPageLayoutInstance:function(){var o=null;if(this._oComponent&&this._oComponent._oView){o=this._oComponent._oView.byId("ObjectPageLayout");}else{L.error("ObjectPageComponentContainer :: cannot find children ObjectPageLayout, has it been rendered already?");}return o;},
renderer:"sap.ui.core.ComponentContainerRenderer"
});
return O;});
sap.ui.predefine('sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller',["jquery.sap.global","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/base/ManagedObject","sap/ui/core/mvc/Controller","sap/base/Log","sap/base/util/ObjectPath","sap/ui/thirdparty/jquery"],function(q,B,C,M,a,L,O,Q){"use strict";return a.extend("sap.uxap.component.ObjectPageLayoutUXDrivenFactory",{connectToComponent:function(m){var h=Q.isEmptyObject(m.getData());m.setDefaultBindingMode(B.OneWay);var H=Q.proxy(function(){if(h){m.detachRequestCompleted(H);}var o=new C(m,"/headerTitle"),b=this.getView().byId("ObjectPageLayout");if(o.getProperty("")){try{this._oHeader=this.controlFactory(b.getId(),o);b.setHeaderTitle(this._oHeader);}catch(e){L.error("ObjectPageLayoutFactory :: error in header creation from config: "+e);}}},this);if(h){m.attachRequestCompleted(H);}else{H();}},controlFactory:function(p,b){var c=b.getProperty(""),o,d,e;try{d=sap.ui.requireSync(c.Type.replace(/\./g,"/"));e=d.getMetadata();Q.each(e._mAllEvents,Q.proxy(function(s,f){if(typeof c[s]=="string"){c[s]=this.convertEventHandler(c[s]);}},this));o=M.create(c);Q.each(e._mAllProperties,Q.proxy(function(P,f){if(c[P]){o.bindProperty(P,"objectPageLayoutMetadata>"+b.getPath()+"/"+P);}},this));}catch(E){L.error("ObjectPageLayoutFactory :: error in control creation from config: "+E);}return o;},convertEventHandler:function(s){var n=window,N=s.split('.');try{Q.each(N,function(i,b){n=n[b];});}catch(e){L.error("ObjectPageLayoutFactory :: undefined event handler: "+s+". Did you forget to require its static class?");n=undefined;}return n;}});});
sap.ui.predefine('sap/uxap/flexibility/ObjectPageDynamicHeaderTitle.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(C,S,M){"use strict";return{"hideControl":"default","unhideControl":"default","combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}},"moveActions":{"changeHandler":M},"moveControls":"default"};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageHeader.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton"],function(C,S){"use strict";return{"combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"moveControls":"default","splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageHeaderActionButton.flexibility',["sap/ui/fl/changeHandler/BaseRename"],function(B){"use strict";return{"hideControl":"default","rename":B.createRenameChangeHandler({propertyName:"text",translationTextType:"XBUT"}),"unhideControl":"default"};});
sap.ui.predefine('sap/uxap/flexibility/ObjectPageLayout.flexibility',['sap/uxap/changeHandler/MoveObjectPageSection','sap/uxap/changeHandler/AddIFrameObjectPageLayout'],function(M,A){"use strict";return{"moveControls":{"changeHandler":M,"layers":{"USER":true}},"addIFrame":{"changeHandler":A}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageSection.flexibility',['sap/uxap/changeHandler/RenameObjectPageSection'],function(R){"use strict";return{"rename":R,"moveControls":"default","hideControl":{"changeHandler":"default","layers":{"USER":true}},"unhideControl":{"changeHandler":"default","layers":{"USER":true}},"stashControl":{"changeHandler":"default","layers":{"USER":true}},"unstashControl":{"changeHandler":"default","layers":{"USER":true}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageSubSection.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/ui/fl/changeHandler/BaseRename"],function(C,S,B){"use strict";return{"hideControl":"default","unhideControl":"default","rename":B.createRenameChangeHandler({propertyName:"title",translationTextType:"XGRP"}),"combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"moveControls":"default","splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}}};},true);
sap.ui.predefine('sap/uxap/library',["sap/ui/core/Core","sap/ui/base/DataType","sap/ui/Device","sap/ui/core/library","sap/m/library","sap/ui/layout/library"],function(C,D,a){"use strict";sap.ui.getCore().initLibrary({name:"sap.uxap",dependencies:["sap.ui.core","sap.m","sap.ui.layout"],designtime:"sap/uxap/designtime/library.designtime",types:["sap.uxap.BlockBaseColumnLayout","sap.uxap.BlockBaseFormAdjustment","sap.uxap.Importance","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],interfaces:["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"],controls:["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],elements:["sap.uxap.ModelMapping","sap.uxap.ObjectPageAccessibleLandmarkInfo","sap.uxap.ObjectPageHeaderLayoutData","sap.uxap.ObjectPageLazyLoader"],version:"1.82.2",extensions:{flChangeHandlers:{"sap.uxap.ObjectPageHeader":"sap/uxap/flexibility/ObjectPageHeader","sap.uxap.ObjectPageLayout":"sap/uxap/flexibility/ObjectPageLayout","sap.uxap.ObjectPageSection":"sap/uxap/flexibility/ObjectPageSection","sap.uxap.ObjectPageSubSection":"sap/uxap/flexibility/ObjectPageSubSection","sap.uxap.ObjectPageDynamicHeaderTitle":"sap/uxap/flexibility/ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageHeaderActionButton":"sap/uxap/flexibility/ObjectPageHeaderActionButton","sap.ui.core._StashedControl":{"unstashControl":{"changeHandler":"default","layers":{"USER":true}},"stashControl":{"changeHandler":"default","layers":{"USER":true}}}},"sap.ui.support":{publicRules:true}}});sap.uxap.BlockBaseColumnLayout=D.createType('sap.uxap.BlockBaseColumnLayout',{isValid:function(v){return/^(auto|[1-4]{1})$/.test(v);}},D.getType('string'));sap.uxap.BlockBaseFormAdjustment={BlockColumns:"BlockColumns",OneColumn:"OneColumn",None:"None"};sap.uxap.ObjectPageConfigurationMode={JsonURL:"JsonURL",JsonModel:"JsonModel"};sap.uxap.ObjectPageHeaderDesign={Light:"Light",Dark:"Dark"};sap.uxap.ObjectPageHeaderPictureShape={Circle:"Circle",Square:"Square"};sap.uxap.ObjectPageSubSectionLayout={TitleOnTop:"TitleOnTop",TitleOnLeft:"TitleOnLeft"};sap.uxap.ObjectPageSubSectionMode={Collapsed:"Collapsed",Expanded:"Expanded"};sap.uxap.Importance={Low:"Low",Medium:"Medium",High:"High"};sap.uxap.Utilities={getClosestOPL:function(c){while(c&&!(c instanceof sap.uxap.ObjectPageLayout)){c=c.getParent();}return c;},isPhoneScenario:function(r){if(a.system.phone){return true;}return sap.uxap.Utilities._isCurrentMediaSize("Phone",r);},isTabletScenario:function(r){return sap.uxap.Utilities._isCurrentMediaSize("Tablet",r);},_isCurrentMediaSize:function(m,r){return r&&r.name===m;},getChildPosition:function(e,c){var E=e instanceof jQuery?e:jQuery(e),$=c instanceof jQuery?c:jQuery(c),b=jQuery(document.documentElement),o=E.position(),O=E.offsetParent(),A;while(!O.is($)&&!O.is(b)){A=O.position();o.top+=A.top;o.left+=A.left;O=O.offsetParent();}return o;}};return sap.uxap;});
sap.ui.require.preload({
	"sap/uxap/component/ObjectPageLayoutUXDrivenFactory.view.xml":'<mvc:View xmlns:mvc="sap.ui.core.mvc" xmlns="sap.uxap" height="100%" controllerName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory"><ObjectPageLayout id="ObjectPageLayout" subSectionLayout="{objectPageLayoutMetadata&gt;/subSectionLayout}" showAnchorBar="{objectPageLayoutMetadata&gt;/showAnchorBar}" height="{objectPageLayoutMetadata&gt;/height}" enableLazyLoading="{objectPageLayoutMetadata&gt;/enableLazyLoading}" sections="{objectPageLayoutMetadata&gt;/sections}" headerContent="{path:\'objectPageLayoutMetadata&gt;/headerContent\',factory:\'.controlFactory\'}" showAnchorBarPopover="{objectPageLayoutMetadata&gt;/showAnchorBarPopover}" upperCaseAnchorBar="{objectPageLayoutMetadata&gt;/upperCaseAnchorBar}" useIconTabBar="{objectPageLayoutMetadata&gt;/useIconTabBar}" showHeaderContent="{objectPageLayoutMetadata&gt;/showHeaderContent}" useTwoColumnsForLargeScreen="{objectPageLayoutMetadata&gt;/useTwoColumnsForLargeScreen}" showTitleInHeaderContent="{objectPageLayoutMetadata&gt;/showTitleInHeaderContent}" showOnlyHighImportance="{objectPageLayoutMetadata&gt;/showOnlyHighImportance}" isChildPage="{objectPageLayoutMetadata&gt;/isChildPage}" alwaysShowContentHeader="{objectPageLayoutMetadata&gt;/alwaysShowContentHeader}" showEditHeaderButton="{objectPageLayoutMetadata&gt;/showEditHeaderButton}"><sections><ObjectPageSection id="ObjectPageSection" title="{objectPageLayoutMetadata&gt;title}" importance="{objectPageLayoutMetadata&gt;importance}" showTitle="{objectPageLayoutMetadata&gt;showTitle}" subSections="{objectPageLayoutMetadata&gt;subSections}" visible="{objectPageLayoutMetadata&gt;visible}"><subSections><ObjectPageSubSection id="ObjectPageSubSection" title="{objectPageLayoutMetadata&gt;title}" visible="{objectPageLayoutMetadata&gt;visible}" mode="{objectPageLayoutMetadata&gt;mode}" importance="{objectPageLayoutMetadata&gt;importance}" actions="{path:\'objectPageLayoutMetadata&gt;actions\',factory:\'.controlFactory\'}" blocks="{path:\'objectPageLayoutMetadata&gt;blocks\',factory:\'.controlFactory\'}" moreBlocks="{path:\'objectPageLayoutMetadata&gt;moreBlocks\',factory:\'.controlFactory\'}"/></subSections></ObjectPageSection></sections></ObjectPageLayout></mvc:View>',
	"sap/uxap/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.uxap","type":"library","embeds":["component"],"applicationVersion":{"version":"1.82.2"},"title":"SAP UxAP","description":"SAP UxAP","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.82","libs":{"sap.ui.core":{"minVersion":"1.82.2"},"sap.m":{"minVersion":"1.82.2"},"sap.ui.layout":{"minVersion":"1.82.2"},"sap.f":{"minVersion":"1.82.2","lazy":true}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en-US","en-US-sappsd","en-US-saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","rigi","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],"elements":["sap.uxap.ModelMapping","sap.uxap.ObjectPageAccessibleLandmarkInfo","sap.uxap.ObjectPageHeaderLayoutData","sap.uxap.ObjectPageLazyLoader"],"types":["sap.uxap.BlockBaseColumnLayout","sap.uxap.BlockBaseFormAdjustment","sap.uxap.Importance","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],"interfaces":["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"]}}}}'
},"sap/uxap/library-preload"
);
//# sourceMappingURL=library-preload.js.map