/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','sap/ui/unified/DateTypeRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/YearRangePicker','./calendar/CalendarDate',"sap/ui/core/date/UniversalDate",'./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale','sap/ui/events/KeyCodes',"./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,D,b,H,M,c,Y,d,e,U,l,f,g,R,h,K,j,k,m,n,q){"use strict";var o=sap.ui.getCore(),p=sap.ui.core.CalendarType;var r=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},yearRangePicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});r.prototype.init=function(){this._iBreakPointTablet=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._iColumns=1;this._oYearFormat=g.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var F=this._createMonth(this.getId()+"--Month0");F.attachEvent("focus",this._handleFocus,this);F.attachEvent("select",y,this);F.attachEvent("_renderMonth",x,this);F.attachEvent("_bindMousemove",z,this);F.attachEvent("_unbindMousemove",A,this);F._bNoThemeChange=true;this.addAggregation("month",F);this._initilizeMonthPicker();this._initilizeYearPicker();this._initilizeYearRangePicker();this._resizeProxy=s.bind(this);this._oSelectedMonth;this._bSkipCancelButtonRendering=false;this._bActionTriggeredFromSecondHeader=false;};r.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}if(this._afterHeaderRenderAdjustCSS){this.removeDelegate(this._afterHeaderRenderAdjustCSS);this._afterHeaderRenderAdjustCSS=null;}if(this._afterSecondHeaderRenderAdjustCSS){this.removeDelegate(this._afterSecondHeaderRenderAdjustCSS);this._afterSecondHeaderRenderAdjustCSS=null;}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};r.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(i);i.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",i);};r.prototype._createOnAfterRenderingDelegate=function(i){return{onAfterRendering:function(){if(i.getVisible()&&!i.getVisibleButton1()){i.$().find(".sapUiCalHeadB2").addClass("sapUiCalSingleYearButton");}if(i.getVisible()&&!i._getVisibleButton3()){this._isTwoMonthsInTwoColumns()&&i.$().find(".sapUiCalHeadB4").addClass("sapUiCalSingleYearButton");}}.bind(this)};};r.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead",{visible:false});S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this._afterSecondHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(S);S.addDelegate(this._afterSecondHeaderRenderAdjustCSS);this.setAggregation("secondMonthHeader",S);};r.prototype._initilizeMonthPicker=function(){var i=new c(this.getId()+"--MP");i._bCalendar=true;i.attachEvent("select",this._selectMonth,this);i.attachEvent("pageChange",B,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);i._setSelectedDatesControlOrigin(this);};r.prototype._initilizeYearPicker=function(){var i=new Y(this.getId()+"--YP");i._bCalendar=true;i.attachEvent("select",this._selectYear,this);i.attachEvent("pageChange",E,this);this.setAggregation("yearPicker",i);i._setSelectedDatesControlOrigin(this);};r.prototype._initilizeYearRangePicker=function(){var i=new d(this.getId()+"--YRP");i.attachEvent("select",this._selectYearRange,this);i.setPrimaryCalendarType(this.getPrimaryCalendarType());this.setAggregation("yearRangePicker",i);};r.prototype._createMonth=function(i){var F=new M(i,{width:"100%"});F._bCalendar=true;F.attachEvent("datehovered",this._handleDateHovered,this);F.attachEvent("weekNumberSelect",this._handleWeekNumberSelect,this);return F;};r.prototype._handleWeekNumberSelect=function(i){var F=this.fireWeekNumberSelect({weekNumber:i.getParameter("weekNumber"),weekDays:i.getParameter("weekDays")});if(!F){i.preventDefault();}return this;};r.prototype._handleDateHovered=function(F){var G=this.getAggregation("month"),I=F.getParameter("date1"),J=F.getParameter("date2"),i;for(i=0;i<G.length;i++){G[i]._markDatesBetweenStartAndHoveredDate(I,J);}};r.prototype.onBeforeRendering=function(){var F=this.getAggregation("month"),G,I=F[0].getDate(),J=this._getFocusedDate(),N=this.getAggregation("header");if(F.length>1&&I){G=e.fromLocalJSDate(I,this.getPrimaryCalendarType());}else if(F.length>1){G=t.call(this,this._getFocusedDate());}else{G=J;}for(var i=0;i<F.length;i++){I=new e(G);if(i>0){I.setMonth(I.getMonth()+i,1);}var O=I;if(J.getYear()===I.getYear()&&J.getMonth()===I.getMonth()){O=J;}F[i].displayDate(O.toLocalJSDate());F[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(G);this._iSize=0;if(!this._getSucessorsPickerPopup()){N.setVisibleButton1(true);N.setVisibleButton2(true);}};r.prototype.onAfterRendering=function(i){if(!this._getSucessorsPickerPopup()){u.call(this);}if(w.call(this)>1||this._bInitMonth){i.size={width:this.getDomRef().offsetWidth};s.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};r.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof D))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=setTimeout(this._invalidateMonth.bind(this,O),0);}};r.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};r.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};r.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};r.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};r.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};r.prototype._setSpecialDatesControlOrigin=function(i){this._oSpecialDatesControlOrigin=i;};r.prototype.getSpecialDates=function(){var P=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin.getSpecialDates();}if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};r.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};r.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};r.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();this._toggleTwoMonthsInTwoColumnsCSS();}return this;};r.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};r.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};r.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new e(i,this.getPrimaryCalendarType());};r.prototype.focusDate=function(i){v.call(this,i,false);return this;};r.prototype.displayDate=function(i){v.call(this,i,true);return this;};r.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=e.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new e(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};r.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};r.prototype.setMonths=function(F){this._bDateRangeChanged=undefined;this.setProperty("months",F,false);F=w.call(this);var G=this.getAggregation("month");var i=0;var I;if(G.length<F){for(i=G.length;i<F;i++){I=this._createMonth(this.getId()+"--Month"+i);I.attachEvent("focus",this._handleFocus,this);I.attachEvent("select",y,this);I.attachEvent("_renderMonth",x,this);I.attachEvent("_bindMousemove",z,this);I.attachEvent("_unbindMousemove",A,this);I._bNoThemeChange=true;this.addAggregation("month",I);}}else if(G.length>F){for(i=G.length;i>F;i--){I=this.removeAggregation("month",i-1);I.destroy();}if(F==1){this._bInitMonth=true;}}if(F>1&&G[0].getDate()){G[0].setProperty("date",null,true);}return this;};r.prototype.setPrimaryCalendarType=function(F){var G=this.getAggregation("month"),I,J,N,O,i;this.setProperty("primaryCalendarType",F);this._adjustYearRangeDisplay();this._oYearFormat=g.getDateInstance({format:"y",calendarType:F});if(this._oFocusedDate){this._oFocusedDate=new e(this._oFocusedDate,F);}this._oMinDate=new e(this._oMinDate,F);this._oMaxDate=new e(this._oMaxDate,F);for(i=0;i<G.length;i++){I=G[i];I.setPrimaryCalendarType(F);}if(!this._getSucessorsPickerPopup()){J=this._getMonthPicker();J.setPrimaryCalendarType(F);N=this._getYearPicker();N.setPrimaryCalendarType(F);O=this.getAggregation("yearRangePicker");O.setPrimaryCalendarType(F);}return this;};r.prototype.setSecondaryCalendarType=function(F){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",F);this._oYearFormatSecondary=g.getDateInstance({format:"y",calendarType:F});var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];I.setSecondaryCalendarType(F);}return this;};r.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};r.prototype._getActiveHeaderAggregation=function(){if(this._bActionTriggeredFromSecondHeader&&this._isTwoMonthsInOneColumn()){return this.getAggregation("secondMonthHeader");}else{return this.getAggregation("header");}};r.prototype._setIsSecondHeaderButtonAction=function(i){if(i.getSource().sParentAggregationName==="secondMonthHeader"||i.sId==="pressButton3"||i.sId==="pressButton4"){this._bActionTriggeredFromSecondHeader=true;}else{this._bActionTriggeredFromSecondHeader=false;}};r.prototype.setMinDate=function(i){var P=this.getPrimaryCalendarType(),F;if(m(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(P);}else{a._checkJSDateObject(i);this._oMinDate=e.fromLocalJSDate(i,P);var G=this._oMinDate.getYear();a._checkYearInValidRange(G);if(this._oMaxDate.isBefore(this._oMinDate)){n.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=e.fromLocalJSDate(i,P);this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(e.fromLocalJSDate(i,P));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){F=this._oMinDate.getYear();this._getYearPicker()._oMinDate.setYear(F);this.getAggregation("yearRangePicker")._oMinDate.setYear(F);}return this;};r.prototype.setMaxDate=function(i){var P,F;if(m(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(P);}else{a._checkJSDateObject(i);this._oMaxDate=e.fromLocalJSDate(i,P);var G=this._oMaxDate.getYear();a._checkYearInValidRange(G);if(this._oMinDate.isAfter(this._oMaxDate)){n.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=e.fromLocalJSDate(i,P);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(e.fromLocalJSDate(i,P));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){F=this._oMaxDate.getYear();this._getYearPicker()._oMaxDate.setYear(F);this.getAggregation("yearRangePicker")._oMaxDate.setYear(F);}return this;};r.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){n.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};r.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var F=new h(i);this._oLocaleData=L.getInstance(F);}return this._oLocaleData;};r.prototype._getShowMonthHeader=function(){var i=w.call(this);if(i>2){return true;}else{return false;}};r.prototype._getMonthPicker=function(){return this.getAggregation("monthPicker");};r.prototype._getYearPicker=function(){return this.getAggregation("yearPicker");};r.prototype._getYearRangePicker=function(){return this.getAggregation("yearRangePicker");};r.prototype.onclick=function(i){var F=i.target;if(i.isMarked("delayedMouseEvent")){return;}if(F.id==this.getId()+"-cancel"){this.onsapescape(i);}};r.prototype.onmousedown=function(i){if(i.cancelable){i.preventDefault();}i.setMark("cancelAutoClose");};r.prototype.onsapescape=function(i){this.fireCancel();this._closedPickers();if(!this._getSucessorsPickerPopup()){this._updateHeadersButtons();this._setHeaderText(this._getFocusedDate());}};r.prototype.onsapshow=function(i){var F=i.which||i.keyCode;if(this._bPoupupMode&&F!==K.F4){this._closedPickers();this.fireCancel();i.preventDefault();}};r.prototype.onkeydown=function(i){var F=i.which||i.keyCode,S=i.shiftKey;if(F!==K.F4){return;}i.preventDefault();switch(this._iMode){case 0:if(S){this._showYearPicker();}else{this._showMonthPicker();}break;case 1:if(S){this._showYearPicker();}break;case 2:if(S){this._showYearRangePicker();}break;default:}};r.prototype.onsaphide=r.prototype.onsapshow;r.prototype.onsaptabnext=function(i){var F=this.getAggregation("header");if(k(this.getDomRef("content"),i.target)){if(F.getVisibleButton1()){F.getDomRef("B1").focus();i.preventDefault();}else if(F.getVisibleButton2()){F.getDomRef("B2").focus();i.preventDefault();}else if(!this._bPoupupMode){this._clearTabindex0();}else{this._clearTabindex0();i.preventDefault();}}else if(i.target.id===F.getId()+"-B1"){F.getVisibleButton2()&&F.getDomRef("B2").focus();i.preventDefault();}else if(i.target.id===F.getId()+"-B2"){if(this._bPoupupMode){this._moveFocusToCalContent();i.preventDefault();}else{this._clearTabindex0();}}};r.prototype.onsaptabprevious=function(i){var F=this.getAggregation("header");if(k(this.getDomRef("content"),i.target)){if(this._bPoupupMode){if(F.getVisibleButton2()){F.getDomRef("B2").focus();}else{F.getVisibleButton1()&&F.getDomRef("B1").focus();}i.preventDefault();}else{this._clearTabindex0();}}else if(i.target.id===F.getId()+"-B1"){this._moveFocusToCalContent();i.preventDefault();}else if(i.target.id===F.getId()+"-B2"){if(F.getVisibleButton1()){F.getDomRef("B1").focus();}else{this._moveFocusToCalContent();}i.preventDefault();}};r.prototype._clearTabindex0=function(){var F=this.getAggregation("month"),G=this._getMonthPicker(),I=this.getAggregation("yearPicker"),J=this.getAggregation("yearRangePicker"),N,i;for(i=0;i<F.length;i++){N=F[i];q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}};r.prototype._moveFocusToCalContent=function(){var F=this.getAggregation("yearPicker"),G=this._getMonthPicker(),I=this.getAggregation("month"),J,N,O,i;switch(this._iMode){case 0:O=this._getFocusedDate();for(i=0;i<I.length;i++){J=I[i];N=e.fromLocalJSDate(J.getDate(),this.getPrimaryCalendarType());if(O.isSame(N)){J._oItemNavigation.focusItem(J._oItemNavigation.getFocusedIndex());}else{q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){G._oItemNavigation.focusItem(G._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){F._oItemNavigation.focusItem(F._oItemNavigation.getFocusedIndex());}break;}};r.prototype.onfocusin=function(i){if(i.target.id==this.getId()+"-end"){this._focusOnShiftTab();if(!this._bPoupupMode){this._clearTabindex0();}}this.$("end").attr("tabindex","-1");};r.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header"),F=i.getDomRef("B2");if(F){F.focus();}else{this.focus();}};r.prototype.onsapfocusleave=function(F){var G,I,J,N;if(!F.relatedControlId||!k(this.getDomRef(),sap.ui.getCore().byId(F.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){G=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<G.length;i++){I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){J=this._getMonthPicker();q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){N=this._getYearPicker();q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};r.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0],F=this._getMonthPicker(),G=this._getYearPicker(),I=this._getYearRangePicker();switch(this._iMode){case 0:return i.getFocusDomRef();case 1:return F.getFocusDomRef();case 2:return G.getFocusDomRef();case 3:return I.getFocusDomRef();default:return;}};r.prototype.onThemeChanged=function(){var F;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){F=this._getMonthPicker();this._showMonthPicker(true);F._bNoThemeChange=false;F.onThemeChanged(arguments);F._bNoThemeChange=true;this._bLongMonth=F._bLongMonth;this._hideMonthPicker(true);}var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];I._bNoThemeChange=false;I.onThemeChanged(arguments);I._bNoThemeChange=true;}var J;if(G.length>1){J=e.fromLocalJSDate(G[0].getDate(),this.getPrimaryCalendarType());}else{J=this._getFocusedDate();}this._setHeaderText(J);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!this._getSucessorsPickerPopup()){u.call(this);}};r.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};r.prototype._togglePrevNext=function(i,F){var G=this._oMaxDate.getYear();var I=this._oMinDate.getYear();var J=this._oMaxDate.getMonth();var N=this._oMinDate.getMonth();var O=this.getAggregation("header");var P=w.call(this);var Q=new e(i,this.getPrimaryCalendarType());if(this._iMode==0&&P>1){Q=t.call(this,i);Q.setMonth(Q.getMonth()+P-1);Q.setDate(a._daysInMonth(Q));}else{Q.setDate(a._daysInMonth(Q));}var S=Q.getYear();var T=Q.getMonth();if(S>G||(S==G&&(!F||T>=J))||(this._iMode==1&&this._getSucessorsPickerPopup())){O.setEnabledNext(false);}else{O.setEnabledNext(true);}if(this._iMode==0&&P>1){Q.setMonth(Q.getMonth()-P+1,1);}else{Q.setDate(1);}S=Q.getYear();T=Q.getMonth();if(S<I||(S==I&&(!F||T<=N))||(this._iMode==1&&this._getSucessorsPickerPopup())){O.setEnabledPrevious(false);}else{O.setEnabledPrevious(true);}};r.prototype._togglePrevNexYearPicker=function(){var i=this.getAggregation("yearRangePicker"),F=this._getYearPicker(),P=this.getPrimaryCalendarType(),G=new e(this._oMinDate,P),I=new e(this._oMaxDate,P),J=this.getAggregation("header"),N=1,O,Q;if(i.getDomRef()&&i.getDomRef().style.display===""){Q=i.getYears();O=e.fromLocalJSDate(i.getFirstRenderedDate());N=i.getRangeSize();}else{Q=F.getYears();O=e.fromLocalJSDate(F.getFirstRenderedDate());}O.setYear(O.getYear()+Math.floor(Q/2)*N);I.setYear(I.getYear()-Math.ceil(Q/2)*N);I.setMonth(11,31);G.setYear(G.getYear()+Math.floor(Q/2)*N+1);G.setMonth(0,1);J.setEnabledNext(O.isSameOrBefore(I));J.setEnabledPrevious(O.isSameOrAfter(G));};r.prototype._handlePrevious=function(i){var F=this._getFocusedDate(),G=w.call(this),I,J,S=false;switch(this._iMode){case 0:if(G>1){I=e.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());I.setDate(1);this._setFocusedDate(I);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var N=this._getSecondaryCalendarType();if(N){J=new e(F,N);J.setMonth(0,1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(J.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());this._getMonthPicker()._setYear(F.getYear());this._renderPicker(this._getMonthPicker());break;case 2:this._getYearPicker().previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;case 3:this.getAggregation("yearRangePicker").previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;}};r.prototype._handleNext=function(i){var F=this._getFocusedDate(),G=w.call(this),I,J;switch(this._iMode){case 0:if(G>1){I=e.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());I.setMonth(I.getMonth(),1);this._setFocusedDate(I);F=this._getFocusedDate();}F.setMonth(F.getMonth()+1,1);this._renderMonth(false,false,false,true);break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){J=new e(F,S);J.setMonth(0,1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(J.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());this._getMonthPicker()._setYear(F.getYear());this._renderPicker(this._getMonthPicker());break;case 2:this._getYearPicker().nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;case 3:this.getAggregation("yearRangePicker").nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;}};r.prototype._getYearString=function(){var i=this._getYearPicker(),F=i.getDomRef(),G=this._getFocusedDate(),I,J;if(i&&F&&F.style.display===""){I=Math.floor(i.getYears()/2);J=i._oItemNavigation.getItemDomRefs()[I].getAttribute("data-sap-year-start");G=e.fromLocalJSDate(i._oFormatYyyymmdd.parse(J),this.getPrimaryCalendarType());G.setDate(1);}return this._oYearFormat.format(U.getInstance(G.toUTCJSDate(),G.getCalendarType()),true);};r.prototype._getDisplayedMonths=function(F){var G=[];var I=F.getMonth();var J=w.call(this);if(J>1){for(var i=0;i<J;i++){G.push((I+i)%12);}}else{G.push(I);}return G;};r.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=e.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new e(F,S);var G=F.getMonth();var I=e.fromLocalJSDate(i[i.length-1].getDate(),P);I.setDate(a._daysInMonth(I));I=new e(I,S);var J=I.getMonth();return{start:G,end:J};};r.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;case 3:this._hideYearRangePicker();break;}};r.prototype._setDisabledMonths=function(i,F){var G=0;var I=11;if(i==this._oMinDate.getYear()){G=this._oMinDate.getMonth();}if(i==this._oMaxDate.getYear()){I=this._oMaxDate.getMonth();}if(!F){F=this._getMonthPicker();}F.setMinMax(G,I);};r.prototype._handleFocus=function(i){var F=e.fromLocalJSDate(i.getParameter("date"),this.getPrimaryCalendarType());var O=i.getParameter("otherMonth");var G=i.getParameter("restoreOldDate");if(G){if(!m(this._getFocusedDate(),F)){this._renderMonth(false,false,true);}}else{this._focusDate(F,O);}};r.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};r.prototype._renderMonth=function(S,I,N,F){var G=this._getFocusedDate(),J=this.getAggregation("month"),O=false,P,Q,T,i=0,V;for(i=0;i<J.length;i++){V=F?0:i;P=J[i];if(P.checkDateFocusable(G.toLocalJSDate())&&J[V].getDate()&&G.getMonth()===J[V].getDate().getMonth()){O=true;}if(O||J.length==1){if(!S){P.setDate(G.toLocalJSDate());}else{P.displayDate(G.toLocalJSDate());}break;}}if(!O){T=new e(G,this.getPrimaryCalendarType());if(J.length>1){T=t.call(this,T);for(i=0;i<J.length;i++){P=J[i];Q=new e(T,this.getPrimaryCalendarType());Q.setMonth(T.getMonth()+i);if(!S&&a._isSameMonthAndYear(Q,G)){P.setDate(G.toLocalJSDate());}else{P.displayDate(Q.toLocalJSDate());}}}this._updateHeader(T);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!N){this.fireStartDateChange();}}};r.prototype._showMonthPicker=function(S){var i=this._getFocusedDate(),F=this._getMonthPicker(),G=new e(this._getFocusedDate());this._iMode===2&&this._hideYearPicker(true);this._updateMonthButtonVisibility();this._renderPicker(F);if(this._bActionTriggeredFromSecondHeader){G.setDate(1);G.setMonth(G.getMonth()+1);F._setYear(G.getYear());}else{F._setYear(i.getYear());}this._showOverlay();if(!S&&this._bActionTriggeredFromSecondHeader){F.setMonth(G.getMonth());this._setDisabledMonths(G.getYear(),F);}else if(!S){F.setMonth(i.getMonth());this._setDisabledMonths(i.getYear(),F);}this._iMode=1;this._togglePrevNext(i,false);this._setHeaderText(this._getFocusedDate());};r.prototype._renderPicker=function(P){var i=sap.ui.getCore().createRenderManager(),$=this.$("content");if($[0]){i.renderControl(P);i.flush($[0],false,true);i.destroy();}};r.prototype._hideMonthPicker=function(S){var F=this._getMonthPicker();this._iMode=0;F.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(w.call(this)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._updateHeadersButtons();this._togglePrevNext(this._getFocusedDate(),true);this._bActionTriggeredFromSecondHeader=false;};r.prototype._showYearPicker=function(){var i=this._getFocusedDate(),F=this._getYearPicker(),G,I;this._iMode===1&&this._hideMonthPicker(true);F.getDomRef()?F.$().css("display",""):this._renderPicker(F);this._showOverlay();F.setDate(i.toLocalJSDate());if(w.call(this)==1){G=this.getAggregation("month")[0];I=G.$("days").find(".sapUiCalItem");if(I.length==28){F.$().addClass("sapUiCalYearNoTop");}else{F.$().removeClass("sapUiCalYearNoTop");}}this._togglePrevNexYearPicker();this._iMode=2;if(this._isTwoMonthsInOneColumn()){this._updateActiveHeaderYearButtonVisibility();}else{this._updateHeadersButtons();}if(this._bActionTriggeredFromSecondHeader&&this.getAggregation("month")[1].getDate().getFullYear()>this._getFocusedDate().getYear()){var S=i.toLocalJSDate();S.setFullYear(S.getFullYear()+1);F.setDate(S);this._updateHeadersYearPrimaryText(this._getYearString());}else{F.setDate(i.toLocalJSDate());this._updateHeadersYearPrimaryText(this._getYearString());}};r.prototype._hideYearPicker=function(S){this._iMode=0;var F=this._getYearPicker();F.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(w.call(this)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._updateActiveHeaderYearButtonVisibility();this._togglePrevNext(this._getFocusedDate(),true);this._bActionTriggeredFromSecondHeader=false;};r.prototype._focusDate=function(i,O,N){var F;var G=false;var I=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;G=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;G=true;}else{F=i;}if(this._focusDateExtend){I=this._focusDateExtend(i,O,N);}var J=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(G||O){this._renderMonth(false,J,N);}if(I){this.fireStartDateChange();}};r.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var F=this.getAggregation("month");if(F){for(var i=0;i<F.length;i++){var G=F[i];G._bDateRangeChanged=true;G._bInvalidateSync=true;G._bNoFocus=true;G.invalidate(O);G._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};r.prototype._setHeaderText=function(i){var F=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var G=this._getLocaleData();var I=[];var J=[];var N=[];var O=[];var P;var Q=false;var T;var V;var W;var X;var Z;var $=this.getPrimaryCalendarType();var a1=this._getSecondaryCalendarType();var b1="";if(this._bLongMonth||!this._bNamesLengthChecked){I=G.getMonthsStandAlone("wide",$);}else{Q=true;I=G.getMonthsStandAlone("abbreviated",$);J=G.getMonthsStandAlone("wide",$);}if(a1){N=G.getMonthsStandAlone("abbreviated",a1);O=G.getMonthsStandAlone("wide",a1);var c1=this._getDisplayedSecondaryMonths($,a1);if(c1.start==c1.end){W=N[c1.start];b1=O[c1.start];}else{Z=G.getIntervalPattern();W=Z.replace(/\{0\}/,N[c1.start]).replace(/\{1\}/,N[c1.end]);b1=Z.replace(/\{0\}/,O[c1.start]).replace(/\{1\}/,O[c1.end]);}}F.setAdditionalTextButton1(W);F._setAdditionalTextButton3(W);S.setAdditionalTextButton1(W);var d1=this._getDisplayedMonths(i);this._sFirstMonthName=T=I[d1[0]];V=I[d1[d1.length-1]];if(d1.length>1&&!this._bShowOneMonth){if(!Z){Z=G.getIntervalPattern();}W=Z.replace(/\{0\}/,T).replace(/\{1\}/,V);P=J.length?Z.replace(/\{0\}/,J[d1[0]]).replace(/\{1\}/,J[d1[d1.length-1]]):W;if(this._isTwoMonthsInTwoColumns()||this._isTwoMonthsInOneColumn()){W=T;}}else{W=T;P=J[d1[0]]||W;}if(!this._getSucessorsPickerPopup()&&b1){P+=", "+b1;}F.setTextButton1(W);F.setAriaLabelButton1(P);F._setTextButton3(V);F._setAriaLabelButton3(V);S.setTextButton1(V);S.setAriaLabelButton1(V);var e1=new e(i,$);e1.setDate(1);X=this._oYearFormat.format(e1.toUTCJSDate(),true);if(e1.getMonth()===11){this._updateHeadersYearPrimaryText(X,(parseInt(X)+1).toString());}else{this._updateHeadersYearPrimaryText(X,X);}if(a1){e1=new e(e1,a1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(e1.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:W,sYear:X,sAriaLabel:P,bShort:Q};};r.prototype._handleButton1=function(i){if(this._iMode!=1){this._setIsSecondHeaderButtonAction(i);this._showMonthPicker();}else{this._hideMonthPicker();}};r.prototype._handleButton2=function(i){if(this._iMode<=1){this._setIsSecondHeaderButtonAction(i);this._showYearPicker();}else{this._hideYearPicker();this._showYearRangePicker();}};r.prototype._selectMonth=function(){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this._getMonthPicker(),G=i._focusedMonth||i._focusedMonth===0?i._focusedMonth:i.getMonth(),S;if(!!i._iYear){S=new e(i._iYear,G-1,1);}else{S=new e(this._getFocusedDate()._oUDate.getFullYear(),G-1,1);}if(this._bActionTriggeredFromSecondHeader&&S.getYear()>=a._minDate().getYear()){F.setYear(S.getYear());F.setMonth(S.getMonth());G=F.getMonth();}else if(F.getYear()===a._maxDate().getYear()&&G===11){G-=1;F.setMonth(G);}else{F.setMonth(G);}if(G!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};r.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};r.prototype._selectYear=function(){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType()),i=F.getMonth(),G=this._getYearPicker(),I=e.fromLocalJSDate(G.getDate(),this.getPrimaryCalendarType());if(!this._bActionTriggeredFromSecondHeader){I.setMonth(i,F.getDate());}else{I.setYear(i===11?I.getYear()-1:I.getYear());I.setMonth(i,F.getDate());}F=I;this._focusDate(F,true);this._hideYearPicker();this._updateHeadersButtons();this._setHeaderText(this._getFocusedDate());};r.prototype._selectYearRange=function(){var i=this.getAggregation("yearRangePicker"),F=this.getAggregation("header"),G=i.getRangeSize(),P=this.getPrimaryCalendarType(),S=e.fromLocalJSDate(i.getDate(),P),I=new e(S.getYear()+G-1,0,1,P),J=this._getFocusedDate(),N,O;S.setMonth(0,1);J.setYear(S.getYear()+Math.floor(G/2));this._setFocusedDate(J);this._hideYearRangePicker();this._showYearPicker();N=this._oYearFormat.format(U.getInstance(S.toUTCJSDate(),S.getCalendarType()),true);O=this._oYearFormat.format(U.getInstance(I.toUTCJSDate(),I.getCalendarType()),true);F.setTextButton2(N+" - "+O);F._setTextButton4(N+" - "+O);};r.prototype._showYearRangePicker=function(){var i=this.getAggregation("yearRangePicker"),F=this._getYearPicker(),G=e.fromLocalJSDate(F.getFirstRenderedDate(),this.getPrimaryCalendarType());i.getDomRef()?i.$().css("display",""):this._renderPicker(i);this._showOverlay();i.setDate(G.toLocalJSDate());this._togglePrevNexYearPicker();this._iMode=3;this._updateHeadersButtons();};r.prototype._hideYearRangePicker=function(){this._iMode=0;this.getAggregation("yearRangePicker").$().css("display","none");this._hideOverlay();this._bActionTriggeredFromSecondHeader=false;};r.prototype._showOverlay=function(){this.$("contentOver").css("display","");};r.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};r.prototype._setColumns=function(i){this._iColumns=i;return this;};r.prototype._getColumns=function(){return this._iColumns;};r.prototype._updateMonthButtonVisibility=function(){var i=this._getActiveHeaderAggregation();if(this._bActionTriggeredFromSecondHeader){this._isTwoMonthsInOneColumn()?i.setVisibleButton1(!i.getVisibleButton1()):i._setVisibleButton3(!i._getVisibleButton3());}else{i.setVisibleButton1(false);}return this;};r.prototype._updateActiveHeaderYearButtonVisibility=function(){var i=this._getActiveHeaderAggregation();if(this._bActionTriggeredFromSecondHeader){this._isTwoMonthsInOneColumn()?i.setVisibleButton1(!i.getVisibleButton1()):i._setVisibleButton3(!i._getVisibleButton3());}else{i.setVisibleButton1(!i.getVisibleButton1());}return this;};r.prototype._updateHeadersButtonsHelper=function(i,F,G,I){var J=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");J.setVisibleButton1(i);J.setVisibleButton2(F);J._setVisibleButton3(G);J._setVisibleButton4(I);if(S.getVisible()){S.setVisibleButton1(i);S.setVisibleButton2(F);S._setVisibleButton3(G);S._setVisibleButton4(I);}};r.prototype._updateHeadersButtons=function(){var S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else{this._updateHeadersButtonsHelper(true,true,false,false);}}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);if(this._iMode===2){this._bActionTriggeredFromSecondHeader?this._updateHeadersButtonsHelper(true,true,false,true):this._updateHeadersButtonsHelper(false,true,true,true);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else if(this._iMode===1){this._bActionTriggeredFromSecondHeader?this._updateHeadersButtonsHelper(true,true,false,true):this._updateHeadersButtonsHelper(false,true,true,true);}else{this._updateHeadersButtonsHelper(true,true,true,true);}}else{S.setVisible(false);if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else{this._updateHeadersButtonsHelper(true,true,false,false);}}if(this._getSucessorsPickerPopup()){this.getAggregation("header").setVisibleButton2(false);}};r.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};r.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){if(o.getConfiguration().getLocale().getLanguage().toLowerCase()==="ja"||o.getConfiguration().getLocale().getLanguage().toLowerCase()==="zh"){this.addStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}else{this.addStyleClass("sapUiCalTwoMonthsTwoColumns");this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}};r.prototype._isTwoMonthsInOneColumn=function(){var i=w.call(this);return this._getColumns()===1&&i===2;};r.prototype._isTwoMonthsInTwoColumns=function(){var i=w.call(this);return this._getColumns()===2&&i===2;};r.prototype._updateHeadersYearPrimaryText=function(F,S){var i=this._getYearPicker(),G=this.getAggregation("header"),I=this.getAggregation("secondMonthHeader"),J=F,N=F,O=S||F,P=this.getPrimaryCalendarType();if(this._iMode===2&&i&&i.getDomRef()){var Q=i._oItemNavigation.getItemDomRefs(),T=Q[0].getAttribute("data-sap-year-start"),V=Q[Q.length-1].getAttribute("data-sap-year-start"),W=e.fromLocalJSDate(i._oFormatYyyymmdd.parse(T),P),X=e.fromLocalJSDate(i._oFormatYyyymmdd.parse(V),P),Z,$;W.setDate(1);X.setDate(1);Z=this._oYearFormat.format(U.getInstance(W.toUTCJSDate(),W.getCalendarType()),true);$=this._oYearFormat.format(U.getInstance(X.toUTCJSDate(),X.getCalendarType()),true);if(this._bActionTriggeredFromSecondHeader){O=Z+" - "+$;}else{N=Z+" - "+$;}}G._setTextButton4(O);G._setAriaLabelButton4(O);I.setTextButton2(O);I.setAriaLabelButton2(O);G.setTextButton2(N);G.setAriaLabelButton2(J);};r.prototype._updateHeadersYearAdditionalText=function(i){var F=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader"),G=F.getAriaLabelButton2();if(i){G+=", "+i;F.setAriaLabelButton2(G);}F.setAdditionalTextButton2(i);F._setAdditionalTextButton4(i);S.setAdditionalTextButton2(i);};r.prototype._adjustYearRangeDisplay=function(){var i=this.getAggregation("yearRangePicker");if(!this._getSucessorsPickerPopup()){switch(this.getPrimaryCalendarType()){case p.Japanese:i.setColumns(1);i.setYears(4);break;case p.Gregorian:i.setColumns(3);i.setYears(9);break;default:i.setColumns(2);i.setYears(8);}}};r.prototype._getSpecialDates=function(){var P=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin._getSpecialDates();}if(P&&P._getSpecialDates){return P._getSpecialDates();}else{var F=this.getSpecialDates();for(var i=0;i<F.length;i++){var N=F[i].getSecondaryType()===l.CalendarDayType.NonWorking&&F[i].getType()!==l.CalendarDayType.NonWorking;if(N){var G=new b();G.setType(F[i].getSecondaryType());G.setStartDate(F[i].getStartDate());if(F[i].getEndDate()){G.setEndDate(F[i].getEndDate());}F.push(G);}}return F;}};function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=e.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=e.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new e(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new e(this._oMaxDate,i);}}function s(F){var W=F.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var G=w.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(G<this._getColumns()){this._setColumns(G);}if(this._getColumns()>2&&G>this._getColumns()){var I=this._getColumns();var J=0.0;var N=this._getColumns();while(I>=2){var P=G%I;if(P==0){N=I;break;}else{var Q=P/I;if(Q>J){J=Q;N=I;}}I--;}this._setColumns(N);}var S;var T=this.getAggregation("month");if(this._getColumns()>1){S=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{S="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<T.length;i++){var V=T[i];V.setWidth(S);}}this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}function t(i){var F=new e(i,this.getPrimaryCalendarType());F.setDate(1);var G=w.call(this);if(G<=12){var I=i.getMonth();if(12%G>0&&I+G>11){I=12-G;}F.setMonth(I);}return F;}function u(){var i,F,G;if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);i=this._getMonthPicker();this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){F=this.getAggregation("month");G;if(F.length>1){G=e.fromLocalJSDate(F[0].getDate(),this.getPrimaryCalendarType());}else{G=this._getFocusedDate();}this._setHeaderText(G);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}else if(w.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}function v(i,S){var F,G;if(!i){return;}F=e.fromLocalJSDate(i,this.getPrimaryCalendarType());G=F.getYear();a._checkYearInValidRange(G);if(a._isOutside(F,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(F);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}function w(){if(f.system.phone){return 1;}else{return this.getMonths();}}function x(i){this.fireEvent("_renderMonth",{days:i.getParameter("days")});}function y(F){if(w.call(this)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];if(I.getId()!=F.oSource.getId()){I._updateSelection();}}}this._oSelectedMonth=F.oSource;this.fireSelect();}function z(F){var G,I,i;if(w.call(this)>1){G=this.getAggregation("month");for(i=0;i<G.length;i++){I=G[i];if(I.getId()!=F.oSource.getId()){I._bindMousemove();}}}}function A(F){var G,I,i;if(w.call(this)>1){G=this.getAggregation("month");for(i=0;i<G.length;i++){I=G[i];if(I.getId()!=F.oSource.getId()){I._unbindMousemove();}}}}function B(i){var O=i.getParameter("offset");if(O>0){this._handleNext(i);}if(O<0){this._handlePrevious(i);}}function E(){this._updateHeadersYearPrimaryText(this._getYearString());}return r;});
