/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/f/PlanningCalendarInCard","sap/f/PlanningCalendarInCardRow","sap/f/PlanningCalendarInCardLegend","sap/m/library","sap/m/PlanningCalendar",'sap/ui/core/format/DateFormat',"sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/unified/CalendarAppointment","sap/ui/unified/DateTypeRange","sap/ui/unified/CalendarLegendItem"],function(l,B,a,b,P,c,d,L,e,D,F,f,C,g,h){"use strict";var A=l.AreaType,i=L.PlanningCalendarBuiltInView;var j=B.extend("sap.ui.integration.cards.CalendarContent",{renderer:{}});j.prototype._createCalendar=function(){this._oCalendar=new P(this.getId()+"-PC",{showWeekNumbers:true,builtInViews:[i.OneMonth],rows:[new c(this.getId()+"-Row",{})],intervalSelect:function(E){this._setParameters(E,E.getParameter("startDate"));}.bind(this)});this.setAggregation("_content",this._oCalendar);this._oCalendar.attachEvent("_todayPressed",new Date(),this._setParameters);};j.prototype.init=function(){B.prototype.init.apply(this,arguments);this._createCalendar();this.fireEvent("_actionContentReady");};j.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oAppointmentTemplate){this._oAppointmentTemplate.destroy();this._oAppointmentTemplate=null;}if(this._oHeaderTemplate){this._oHeaderTemplate.destroy();this._oHeaderTemplate=null;}if(this._oSpecialDateTemplate){this._oSpecialDateTemplate.destroy();this._oSpecialDateTemplate=null;}if(this._oCalendarLegendItemTemplate){this._oCalendarLegendItemTemplate.destroy();this._oCalendarLegendItemTemplate=null;}if(this._oAppointmentLegendItemTemplate){this._oAppointmentLegendItemTemplate.destroy();this._oAppointmentLegendItemTemplate=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};j.prototype.onDataChanged=function(){this._setParameters();};j.prototype.onBeforeRendering=function(){this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);};j.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return this;}if(o.item){this._addItem(o.item);}if(o.specialDate){this._addSpecialDate(o.specialDate);}if(o.legendItem){this._addLegendItem(o.legendItem);}if(o.date){this._addDate(o.date);}if(o.maxItems){this._addMaxItems(o.maxItems);}if(o.maxLegendItems){this._addMaxLegendItems(o.maxLegendItems);}if(o.noItemsText){this._addNoItemsText(o.noItemsText);}if(o.moreItems&&o.moreItems.actions){this._oActions.setAreaType(A.Content);this._oActions.attach(o.moreItems,this._oCalendar.getRows()[0]._getMoreButton());}return this;};j.prototype._setParameters=function(E,o){var k=o?o:this._oCalendar.getStartDate(),s=new Date(k.getFullYear(),k.getMonth(),k.getDate()),m=new Date(k.getFullYear(),k.getMonth(),k.getDate()),n=this.getConfiguration&&this.getConfiguration(),I=n&&n.item&&n.item.path,M,p,q,v,t;m.setDate(m.getDate()+1);q=I?this.getModel().getProperty(I).filter(function(r){var S=new Date(r.start).getTime(),u=new Date(r.end).getTime();if((S>=s.getTime()&&S<m.getTime())||(u>=s.getTime()&&u<m.getTime())||(S<=s.getTime()&&u>m.getTime())){return r;}}):[];if(n&&typeof n.maxItems==="object"){M=n&&this.getConfiguration().maxItems&&"/"+this.getConfiguration().maxItems.binding.getPath();p=this.getModel().getProperty(M);}else{p=n&&this.getConfiguration().maxItems;}t=q.length;if(t<p){v=t;}else{v=p;}this._iVisibleItems=v;this._iAllItems=t;if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);}};j.prototype.formatDate=function(t){var o=D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}).parse(t);if(!o){o=D.getInstance({pattern:"yyyy-MM-dd"}).parse(t);}return o;};j.prototype._addItem=function(I){var m={title:I.template.title,text:I.template.text,type:I.template.type},o,k={title:I.template.title,text:I.template.text,type:I.template.type},n;if(I.template.startDate){m.startDate=a.formattedProperty(I.template.startDate,this.formatDate);}if(I.template.endDate){m.endDate=a.formattedProperty(I.template.endDate,this.formatDate);}if(I.template.icon&&I.template.icon.src){m.icon=a.formattedProperty(I.template.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));}this._oAppointmentTemplate=new C(m);o={path:I.path,template:this._oAppointmentTemplate,filters:new F({path:"visualization",operator:f.Contains,value1:"appointment"})};this._bindAggregation("appointments",this._oCalendar.getRows()[0],o);if(I.template.startDate){k.startDate=a.formattedProperty(I.template.startDate,this.formatDate);}if(I.template.endDate){k.endDate=a.formattedProperty(I.template.endDate,this.formatDate);}if(I.template.icon&&I.template.icon.src){k.icon=a.formattedProperty(I.template.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));}this._oHeaderTemplate=new C(k);n={path:I.path,template:this._oHeaderTemplate,filters:new F({path:"visualization",operator:f.Contains,value1:"blocker"})};this._bindAggregation("intervalHeaders",this._oCalendar.getRows()[0],n);};j.prototype._addSpecialDate=function(s){var S=s.template,o;if(S.startDate){S.startDate=a.formattedProperty(S.startDate,this.formatDate);}if(S.endDate){S.endDate=a.formattedProperty(S.endDate,this.formatDate);}this._oSpecialDateTemplate=new g(S);o={path:s.path,template:this._oSpecialDateTemplate};this._bindAggregation("specialDates",this._oCalendar,o);};j.prototype._addLegendItem=function(m){var k={text:m.template.text,type:m.template.type},n={text:m.template.text,type:m.template.type},o,p;this._oCalendarLegendItemTemplate=new h(k);o={path:m.path,template:this._oCalendarLegendItemTemplate,filters:new F({path:"category",operator:f.Contains,value1:"calendar"})};this._bindAggregation("items",this._oCalendar._getLegend(),o);this._oAppointmentLegendItemTemplate=new h(n);p={path:m.path,template:this._oAppointmentLegendItemTemplate,filters:new F({path:"category",operator:f.Contains,value1:"appointment"})};this._bindAggregation("appointmentItems",this._oCalendar._getLegend(),p);};j.prototype._addDate=function(t){if(b.isBindingInfo(t)){t&&this._oCalendar.bindProperty("startDate",a.formattedProperty(t,this.formatDate));}else{this._oCalendar.setStartDate(this.formatDate(t));}};j.prototype._addMaxItems=function(m){if(b.isBindingInfo(m)){m&&this._oCalendar.getRows()[0].bindProperty("visibleAppointmentsCount",m);}else{this._oCalendar.getRows()[0].setVisibleAppointmentsCount(m);}};j.prototype._addMaxLegendItems=function(m){if(b.isBindingInfo(m)){m&&this._oCalendar._getLegend().bindProperty("visibleLegendItemsCount",m);}else{this._oCalendar._getLegend().setVisibleLegendItemsCount(m);}};j.prototype._addNoItemsText=function(n){if(b.isBindingInfo(n)){n&&this._oCalendar.getRows()[0].bindProperty("noAppointmentsText",n);}else{this._oCalendar.getRows()[0].setNoAppointmentsText(n);}};return j;});
