/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/m/List','sap/m/StandardListItem','sap/m/ResponsivePopover','sap/ui/core/Control','sap/ui/core/delegate/ScrollEnablement','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','./TokenizerRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/EnabledPropagator","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(l,L,S,R,C,a,D,I,b,T,c,K,d,E,q){"use strict";var e=l.TokenizerRenderMode,P=l.PlacementType,f=l.ListMode;var g=C.extend("sap.m.Tokenizer",{metadata:{library:"sap.m",properties:{editable:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},renderMode:{type:"string",group:"Misc",defaultValue:e.Loose},hiddenTokensCount:{type:"int",group:"Misc",defaultValue:0,visibility:"hidden"}},defaultAggregation:"tokens",aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},_tokensInfo:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}}}});var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");E.apply(g.prototype,[true]);g.prototype.init=function(){this.allowTextSelection(false);this._oTokensWidthMap={};this._oIndicator=null;this._oScroller=new a(this,this.getId()+"-scrollContainer",{horizontal:true,vertical:false,nonTouchScrolling:true});if(sap.ui.getCore().getConfiguration().getAccessibility()){var A=new I({text:r.getText("TOKENIZER_ARIA_CONTAIN_TOKEN")});this.setAggregation("_tokensInfo",A);}};g.prototype._handleNMoreIndicatorPress=function(){this._togglePopup(this.getTokensPopup());};g.prototype._getTokensList=function(){if(!this._oTokensList){this._oTokensList=new L({width:"auto",mode:f.Delete}).attachDelete(this._handleListItemDelete,this);}return this._oTokensList;};g.prototype._setPopoverMode=function(m){var s={},p=this.getTokensPopup();switch(m){case f.Delete:s={showArrow:false,placement:P.VerticalPreferredBottom};break;default:s={showArrow:true,placement:P.Auto};break;}p.setShowArrow(s.showArrow);p.setPlacement(s.placement);this._getTokensList().setMode(m);};g.prototype._fillTokensList=function(o,F){o.destroyItems();F=F?F:function(){return true;};this.getTokens().filter(F).forEach(function(t){o.addItem(this._mapTokenToListItem(t));},this);};g.prototype._handleListItemDelete=function(o){var h,i,j,k=o.getParameter("listItem"),s=k&&k.data("tokenId"),t;t=this.getTokens().filter(function(m){return(m.getId()===s)&&m.getEditable();})[0];if(t){this.fireTokenUpdate({addedTokens:[],removedTokens:[t],type:g.TokenUpdateType.Removed});h=this._getTokensList().getItems();j=h.indexOf(k);i=(j===h.length-1)?h[h.length-2]:h[j+1];i&&i.focus();this.removeAggregation("tokens",t,true);k.destroy();t.destroy();this._adjustTokensVisibility();}};g.prototype.getTokensPopup=function(){if(this._oPopup){return this._oPopup;}this._oPopup=new R({showArrow:false,showHeader:false,placement:P.Auto,offsetX:0,offsetY:3,horizontalScrolling:false,content:this._getTokensList()}).attachBeforeOpen(function(){var p=this._oPopup;if(p.getContent&&!p.getContent().length){p.addContent(this._getTokensList());}this._fillTokensList(this._getTokensList());},this);this.addDependent(this._oPopup);if(D.system.phone){this._oPopup.setEndButton(new sap.m.Button({text:r.getText("SUGGESTIONSPOPOVER_CLOSE_BUTTON"),press:function(){this._oPopup.close();}.bind(this)}));}return this._oPopup;};g.prototype._togglePopup=function(p){var o,h=this.getDomRef(),i=p.isOpen(),j=this.getEditable();this._setPopoverMode(j?f.Delete:f.None);if(i){p.close();}else{o=j||this.hasOneTruncatedToken()?h:this._oIndicator[0];o=o&&o.className.indexOf("sapUiHidden")===-1?o:h;p.openBy(o||h);}};g.prototype._mapTokenToListItem=function(t){if(!t){return null;}var o=new S({selected:true}).data("tokenId",t.getId());o.setTitle(t.getText());return o;};g.prototype._getPixelWidth=function(){var m=this.getMaxWidth(),t,o=this.getDomRef(),p;if(!o){return;}p=parseInt(this.$().css("padding-left"));if(m.indexOf("px")===-1){t=o.clientWidth;}else{t=parseInt(this.getMaxWidth());}return t-p;};g.prototype._adjustTokensVisibility=function(){if(!this.getDomRef()){return;}var t=this._getPixelWidth(),h=this._getVisibleTokens().reverse(),i=h.length,j,F,k,m=-1;h.some(function(o,n){t=t-this._oTokensWidthMap[o.getId()];if(t<0){m=n;return true;}else{F=t;}},this);if(i===1&&m!==-1){this.setFirstTokenTruncated(true);return;}else if(i===1&&h[0].getTruncated()){this.setFirstTokenTruncated(false);}if(m>-1){for(k=0;k<i;k++){if(k>=m){h[k].addStyleClass("sapMHiddenToken");}else{h[k].removeStyleClass("sapMHiddenToken");}}this._handleNMoreIndicator(i-m);j=this._oIndicator.width();if(j>=F){m=m-1;this._handleNMoreIndicator(i-m);h[m].addStyleClass("sapMHiddenToken");}this._setHiddenTokensCount(i-m);}else{this._setHiddenTokensCount(0);this._showAllTokens();}};g.prototype.setFirstTokenTruncated=function(v){var t=this.getTokens()[0];t&&t.setTruncated(v);if(v){this.addStyleClass("sapMTokenizerOneLongToken");}else{this.removeStyleClass("sapMTokenizerOneLongToken");this.scrollToEnd();}return this;};g.prototype.hasOneTruncatedToken=function(){return this.getTokens().length===1&&this.getTokens()[0].getTruncated();};g.prototype._handleNMoreIndicator=function(h){if(!this.getDomRef()){return this;}if(h){var s="MULTIINPUT_SHOW_MORE_TOKENS";if(h===this._getVisibleTokens().length){if(h===1){s="TOKENIZER_SHOW_ALL_ITEM";}else{s="TOKENIZER_SHOW_ALL_ITEMS";}}this._oIndicator.html(r.getText(s,h));}return this;};g.prototype._getVisibleTokens=function(){return this.getTokens().filter(function(t){return t.getVisible();});};g.prototype._showAllTokens=function(){this._getVisibleTokens().forEach(function(t){t.removeStyleClass("sapMHiddenToken");});};g.prototype.getScrollDelegate=function(){return this._oScroller;};g.prototype.scrollToEnd=function(){var h=this.getDomRef(),s;if(!this.getDomRef()){return;}s=this.$().find(".sapMTokenizerScrollContainer")[0];if(D.browser.msie){setTimeout(function(){h.scrollLeft=s.scrollWidth;});}else{h.scrollLeft=s.scrollWidth;}};g.prototype._registerResizeHandler=function(){if(!this._sResizeHandlerId){this._sResizeHandlerId=b.register(this.getDomRef(),this._handleResize.bind(this));}};g.prototype._handleResize=function(){this._useCollapsedMode(this.getRenderMode());this.scrollToEnd();};g.prototype.setPixelWidth=function(n){if(typeof n!=="number"){d.warning("Tokenizer.setPixelWidth called with invalid parameter. Expected parameter of type number.");return;}this.setWidth(n+"px");if(this._oScroller){this._oScroller.refresh();}};g.prototype.scrollToStart=function(){var h=this.getDomRef();if(!h){return;}h.scrollLeft=0;};g.prototype.getScrollWidth=function(){if(!this.getDomRef()){return 0;}return this.$().children(".sapMTokenizerScrollContainer")[0].scrollWidth;};g.prototype.onBeforeRendering=function(){this._setTokensAria();};g.prototype.onAfterRendering=function(){var s=this.getRenderMode();this._oIndicator=this.$().find(".sapMTokenizerIndicator");this._updateTokensAriaSetAttributes();this._useCollapsedMode(s);this._registerResizeHandler();if(s===e.Loose){this.scrollToEnd();}};g.prototype.onThemeChanged=function(){this.getTokens().forEach(function(t){if(t.getDomRef()&&!t.$().hasClass("sapMHiddenToken")&&!t.getTruncated()){this._oTokensWidthMap[t.getId()]=t.$().outerWidth(true);}}.bind(this));this._useCollapsedMode(this.getRenderMode());};g.prototype._useCollapsedMode=function(s){var t=this._getVisibleTokens();if(!t.length){return;}if(s===e.Narrow){this._adjustTokensVisibility();}else{this._setHiddenTokensCount(0);this._showAllTokens();}};g.prototype.onsapfocusleave=function(o){if(document.activeElement===this.getDomRef()||!this._checkFocus()){this._changeAllTokensSelection(false);this._oSelectionOrigin=null;}};g.prototype.onkeydown=function(o){var s;if(!this.getEnabled()){return;}if(o.which===K.TAB){this._changeAllTokensSelection(false);}if((o.ctrlKey||o.metaKey)&&o.which===K.A){s=this.getSelectedTokens().length<this._getVisibleTokens().length;if(this._getVisibleTokens().length>0){this.focus();this._changeAllTokensSelection(s);o.preventDefault();o.stopPropagation();}}if((o.ctrlKey||o.metaKey)&&(o.which===K.C||o.which===K.INSERT)){this._copy();}if(((o.ctrlKey||o.metaKey)&&o.which===K.X)||(o.shiftKey&&o.which===K.DELETE)){if(this.getEditable()){this._cut();}else{this._copy();}}};g.prototype.onsappreviousmodifiers=function(o){this.onsapprevious(o);};g.prototype.onsapnextmodifiers=function(o){this.onsapnext(o);};g.prototype.onsaphomemodifiers=function(o){this._selectRange(false);};g.prototype.onsapendmodifiers=function(o){this._selectRange(true);};g.prototype._selectRange=function(F){var o={},t=this._getVisibleTokens(),h=q(document.activeElement).control()[0],j=t.indexOf(h);if(!h||!h.isA("sap.m.Token")){return;}if(F){o.start=j;o.end=t.length-1;}else{o.start=0;o.end=j;}if(o.start<o.end){for(var i=o.start;i<=o.end;i++){t[i].setSelected(true);}}};g.prototype._copy=function(){var s=this.getSelectedTokens(),h="",t,j=function(o){if(o.clipboardData){o.clipboardData.setData('text/plain',h);}else{o.originalEvent.clipboardData.setData('text/plain',h);}o.preventDefault();};for(var i=0;i<s.length;i++){t=s[i];h+=(i>0?"\r\n":"")+t.getText();}if(!h){return;}if(D.browser.msie&&window.clipboardData){window.clipboardData.setData("text",h);}else{document.addEventListener('copy',j);document.execCommand('copy');document.removeEventListener('copy',j);}};g.prototype._cut=function(){var s=this,h=s.getSelectedTokens(),j="",k=[],m,t,n=function(o){if(o.clipboardData){o.clipboardData.setData('text/plain',j);}else{o.originalEvent.clipboardData.setData('text/plain',j);}o.preventDefault();};m=s.fireTokenUpdate({addedTokens:[],removedTokens:k,type:g.TokenUpdateType.Removed});for(var i=0;i<h.length;i++){t=h[i];j+=(i>0?"\r\n":"")+t.getText();if(m&&t.getEditable()){s.removeToken(t);k.push(t);t.destroy();}}if(!j){return;}if(D.browser.msie&&window.clipboardData){window.clipboardData.setData("text",j);}else{document.addEventListener('cut',n);document.execCommand('cut');document.removeEventListener('cut',n);}};g.prototype.onsapbackspace=function(o){var s=this.getSelectedTokens();if(!this.getEnabled()){return;}if(s.length<2){o.preventDefault();this.onsapprevious(o);}else{this._focusUnselectedToken(o);}this._handleKeyboardDelete(o);o.setMarked();};g.prototype._focusUnselectedToken=function(o){var s=this.getSelectedTokens(),t=this._getVisibleTokens(),i,h;if(o.keyCode===K.DELETE){i=t.indexOf(s[s.length-1]);h=t[i+1];}if(o.keyCode===K.BACKSPACE){i=t.indexOf(s[0]);h=t[i-1];}if(h){h.focus();}else{o.setMarked("forwardFocusToParent");this.focus();}};g.prototype.onsapdelete=function(o){var s;if(!this.getEnabled()){return;}s=this.getSelectedTokens();if(s.length<2){this.onsapnext(o);}else{this._focusUnselectedToken(o);}this._handleKeyboardDelete(o);o.setMarked();};g.prototype._handleKeyboardDelete=function(o){var t;if(this.getEditable()){t=q(o.target).control()[0];if(t&&t.isA("sap.m.Token")){this.handleTokenDeletion(t);}this._removeSelectedTokens();if(!this._getVisibleTokens().length){o.setMarked("forwardFocusToParent");}}};g.prototype._ensureTokenVisible=function(t){if(!t||!t.getDomRef()||!this.getDomRef()){return;}var i=this.$().offset().left,h=this.$().width(),j=t.$().offset().left,k=t.$().width();if(this._getVisibleTokens().indexOf(t)===0){this.$().scrollLeft(0);return;}if(j<i){this.$().scrollLeft(this.$().scrollLeft()-i+j);}if(j-i+k>h){this.$().scrollLeft(this.$().scrollLeft()+(j-i+k-h));}};g.prototype.ontap=function(o){var s=o.shiftKey,h=(o.ctrlKey||o.metaKey),t=o.getMark("tokenTap"),j=o.getMark("tokenDeletePress"),k=this._getVisibleTokens(),F,m,n,M,p;if(j||!t||(!s&&h)){this._oSelectionOrigin=null;return;}if(!s){this._oSelectionOrigin=t;this._changeAllTokensSelection(false,t,true);}F=t;if(this._oSelectionOrigin){F=this._oSelectionOrigin;}else{this._oSelectionOrigin=F;}m=this.indexOfToken(F);n=this.indexOfToken(t);M=Math.min(m,n);p=Math.max(m,n);k.forEach(function(u,i){if(i>=M&&i<=p){u.setSelected(true);}else if(!h){u.setSelected(false);}});};g.prototype.onsapprevious=function(o){var t=this._getVisibleTokens(),i=t.length;if(i===0){return;}var F=q(document.activeElement).control()[0];var h=F?t.indexOf(F):-1;if(h===0){o.setMarked("forwardFocusToParent");return;}var j,k;if(h>0){j=t[h-1];j.focus();}else{j=t[t.length-1];j.focus();}if(o.shiftKey){k=t[h];j.setSelected(true);k.setSelected(true);}o.setMarked();o.preventDefault();};g.prototype.onsapnext=function(o){var t=this._getVisibleTokens(),i=t.length;if(i===0){return;}var F=q(document.activeElement).control()[0];var h=F?t.indexOf(F):-1;if(h<i-1){var n=t[h+1],j=t[h];n.focus();if(o.shiftKey){n.setSelected(true);j.setSelected(true);}this._ensureTokenVisible(n);}else{o.setMarked("forwardFocusToParent");return;}o.setMarked();o.preventDefault();};g.prototype.addValidator=function(v){d.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};g.prototype.removeValidator=function(v){d.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};g.prototype.removeAllValidators=function(){d.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};g.prototype.addValidateToken=function(p){d.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};g.prototype._parseString=function(s){return s.split(/\r\n|\r|\n/g);};g.prototype._checkFocus=function(){return this.getDomRef()&&c(this.getDomRef(),document.activeElement);};g.prototype.addToken=function(t,s){var p=this.getParent();t.setProperty("editableParent",this.getEditable());if(p instanceof sap.m.MultiInput){if(p.getMaxTokens()!==undefined&&p.getTokens().length>=p.getMaxTokens()){return this;}}this.addAggregation("tokens",t,s);this.fireTokenChange({token:t,type:g.TokenChangeType.Added});t.addEventDelegate({onAfterRendering:function(){if(sap.ui.getCore().isThemeApplied()&&t.getDomRef()&&!t.getTruncated()&&!t.$().hasClass("sapMHiddenToken")){this._oTokensWidthMap[t.getId()]=t.$().outerWidth(true);}}.bind(this)});t.attachSelect(function(){var F=this.hasOneTruncatedToken()?t:this;if(!this.hasOneTruncatedToken()||this.hasStyleClass("sapMTokenizerIndicatorDisabled")){return;}this.getTokensPopup().setInitialFocus(F);this._togglePopup(this.getTokensPopup());}.bind(this));t.getAggregation("deleteIcon").attachPress(function(){if(this.getEnabled()){this.handleTokenDeletion(t);}}.bind(this));return this;};g.prototype.removeToken=function(t){t=this.removeAggregation("tokens",t);this._updateTokensAriaSetAttributes();!this.getTokens().length&&this.setFirstTokenTruncated(false);this.fireTokenChange({token:t,type:g.TokenChangeType.Removed});if(this.getTokensPopup().isOpen()){this._fillTokensList(this._getTokensList());}return t;};g.prototype.setTokens=function(t){var o=this.getTokens();this.removeAllTokens(false);var i;for(i=0;i<t.length;i++){this.addToken(t[i],true);}this.invalidate();this.fireTokenChange({addedTokens:t,removedTokens:o,type:g.TokenChangeType.TokensChanged});};g.prototype.removeAllTokens=function(F){var t=this.getTokens();var h=this.removeAllAggregation("tokens");this.setFirstTokenTruncated(false);if(typeof(F)==="boolean"&&!F){return h;}this.fireTokenChange({addedTokens:[],removedTokens:t,type:g.TokenChangeType.TokensChanged});this.fireTokenChange({tokens:t,type:g.TokenChangeType.RemovedAll});return h;};g.prototype.updateTokens=function(){this.destroyTokens();this.updateAggregation("tokens");};g.prototype.destroyTokens=function(){this.setFirstTokenTruncated(false);return this.destroyAggregation("tokens");};g.prototype._removeSelectedTokens=function(){var t=this.getSelectedTokens();if(t.length===0){return this;}this.handleTokenDeletion(t);this._doSelect();return this;};g.prototype.handleTokenDeletion=function(t){var o,i,h,j=[];j=j.concat(t);o=this.fireTokenUpdate({addedTokens:[],removedTokens:j,type:g.TokenUpdateType.Removed});if(!o){return;}for(i=0;i<j.length;i++){h=j[i];if(h.getEditable()){h.destroy();}}this.scrollToEnd();if(this.getTokensPopup().isOpen()){this._fillTokensList(this._getTokensList());}this.fireTokenChange({addedTokens:[],removedTokens:j,type:g.TokenChangeType.TokensChanged});};g.prototype.selectAllTokens=function(s){if(s===undefined){s=true;}this._changeAllTokensSelection(s);return this;};g.prototype._changeAllTokensSelection=function(s,t,h){var i=this._getVisibleTokens();i.filter(function(o){return o!==t;}).forEach(function(o){o.setSelected(s);});if(!h){this._doSelect();}return this;};g.prototype.getSelectedTokens=function(){return this._getVisibleTokens().filter(function(t){return t.getSelected();});};g.prototype.onsaphome=function(o){var A=this.getTokens().filter(function(t){return t.getDomRef()&&!t.getDomRef().classList.contains("sapMHiddenToken");});A.length&&A[0].focus();this.scrollToStart();o.preventDefault();};g.prototype.onsapend=function(o){var t=this._getVisibleTokens(),h=t[t.length-1];if(h.getDomRef()!==document.activeElement){h.focus();this.scrollToEnd();o.stopPropagation();}else{o.setMarked("forwardFocusToParent");}o.preventDefault();};g.prototype.onclick=function(o){var F;if(!this.getEnabled()){return;}F=!this.hasStyleClass("sapMTokenizerIndicatorDisabled")&&(o.target===this.getFocusDomRef()||o.target.classList.contains("sapMTokenizerIndicator"));if(F){this._handleNMoreIndicatorPress();}};g.prototype.ontouchstart=function(o){o.setMarked();if(D.browser.chrome&&window.getSelection()){window.getSelection().removeAllRanges();}};g.prototype.exit=function(){this._deregisterResizeHandler();if(this._oTokensList){this._oTokensList.destroy();this._oTokensList=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._oPopup){this._oPopup.destroy();this._oPopup=null;}this._oTokensWidthMap=null;this._oIndicator=null;this._aTokenValidators=null;};g.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){b.deregister(this._sResizeHandlerId);delete this._sResizeHandlerId;}};g.prototype._setTokensAria=function(){var t=this._getVisibleTokens().length,i,s="";if(sap.ui.getCore().getConfiguration().getAccessibility()){i=this.getAggregation("_tokensInfo");switch(t){case 0:s=r.getText("TOKENIZER_ARIA_CONTAIN_TOKEN");break;case 1:s=r.getText("TOKENIZER_ARIA_CONTAIN_ONE_TOKEN");break;default:s=r.getText("TOKENIZER_ARIA_CONTAIN_SEVERAL_TOKENS",t);break;}i.setText(s);}};g.prototype._updateTokensAriaSetAttributes=function(){var t=this.getTokens(),h=t.length;for(var i=0;i<h;i++){var o=t[i].getDomRef();if(o){o.setAttribute("aria-posinset",i+1);o.setAttribute("aria-setsize",h);}}};g.prototype._doSelect=function(){if(this._checkFocus()&&this._bCopyToClipboardSupport){var F=document.activeElement;var s=window.getSelection();s.removeAllRanges();if(this.getSelectedTokens().length){var o=document.createRange();o.selectNodeContents(this.getDomRef("clip"));s.addRange(o);}if(window.clipboardData&&F.id===this.getId()+"-clip"&&this.getDomRef()){this.getDomRef().focus();}}};g.prototype.setEditable=function(h){var t=this.getTokens();t.forEach(function(o){o.setProperty("editableParent",h);});this.setProperty("editable",h);return this;};g.prototype._setHiddenTokensCount=function(i){i=this.validateProperty("hiddenTokensCount",i);return this.setProperty("hiddenTokensCount",i);};g.prototype.getHiddenTokensCount=function(){return this.getProperty("hiddenTokensCount");};g.prototype.getTokensInfoId=function(){return this.getAggregation("_tokensInfo").getId();};g.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};g.TokenUpdateType={Added:"added",Removed:"removed"};return g;});
