﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/redshift-data/RedshiftDataAPIService_EXPORTS.h>
#include <aws/redshift-data/RedshiftDataAPIServiceRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace RedshiftDataAPIService
{
namespace Model
{

  /**
   */
  class AWS_REDSHIFTDATAAPISERVICE_API CancelStatementRequest : public RedshiftDataAPIServiceRequest
  {
  public:
    CancelStatementRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "CancelStatement"; }

    Aws::String SerializePayload() const override;

    Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    /**
     * <p>The identifier of the SQL statement to cancel. This value is a universally
     * unique identifier (UUID) generated by Amazon Redshift Data API. This identifier
     * is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>,
     * and <code>ListStatements</code>. </p>
     */
    inline const Aws::String& GetId() const{ return m_id; }

    /**
     * <p>The identifier of the SQL statement to cancel. This value is a universally
     * unique identifier (UUID) generated by Amazon Redshift Data API. This identifier
     * is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>,
     * and <code>ListStatements</code>. </p>
     */
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }

    /**
     * <p>The identifier of the SQL statement to cancel. This value is a universally
     * unique identifier (UUID) generated by Amazon Redshift Data API. This identifier
     * is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>,
     * and <code>ListStatements</code>. </p>
     */
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }

    /**
     * <p>The identifier of the SQL statement to cancel. This value is a universally
     * unique identifier (UUID) generated by Amazon Redshift Data API. This identifier
     * is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>,
     * and <code>ListStatements</code>. </p>
     */
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }

    /**
     * <p>The identifier of the SQL statement to cancel. This value is a universally
     * unique identifier (UUID) generated by Amazon Redshift Data API. This identifier
     * is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>,
     * and <code>ListStatements</code>. </p>
     */
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }

    /**
     * <p>The identifier of the SQL statement to cancel. This value is a universally
     * unique identifier (UUID) generated by Amazon Redshift Data API. This identifier
     * is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>,
     * and <code>ListStatements</code>. </p>
     */
    inline CancelStatementRequest& WithId(const Aws::String& value) { SetId(value); return *this;}

    /**
     * <p>The identifier of the SQL statement to cancel. This value is a universally
     * unique identifier (UUID) generated by Amazon Redshift Data API. This identifier
     * is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>,
     * and <code>ListStatements</code>. </p>
     */
    inline CancelStatementRequest& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}

    /**
     * <p>The identifier of the SQL statement to cancel. This value is a universally
     * unique identifier (UUID) generated by Amazon Redshift Data API. This identifier
     * is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>,
     * and <code>ListStatements</code>. </p>
     */
    inline CancelStatementRequest& WithId(const char* value) { SetId(value); return *this;}

  private:

    Aws::String m_id;
    bool m_idHasBeenSet = false;
  };

} // namespace Model
} // namespace RedshiftDataAPIService
} // namespace Aws
