﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/opensearch/OpenSearchService_EXPORTS.h>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace OpenSearchService
{
namespace Model
{

  /**
   * <p>Specifies the configuration for cold storage options such as
   * enabled</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/ColdStorageOptions">AWS
   * API Reference</a></p>
   */
  class AWS_OPENSEARCHSERVICE_API ColdStorageOptions
  {
  public:
    ColdStorageOptions();
    ColdStorageOptions(Aws::Utils::Json::JsonView jsonValue);
    ColdStorageOptions& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Enable cold storage option. Accepted values true or false</p>
     */
    inline bool GetEnabled() const{ return m_enabled; }

    /**
     * <p>Enable cold storage option. Accepted values true or false</p>
     */
    inline bool EnabledHasBeenSet() const { return m_enabledHasBeenSet; }

    /**
     * <p>Enable cold storage option. Accepted values true or false</p>
     */
    inline void SetEnabled(bool value) { m_enabledHasBeenSet = true; m_enabled = value; }

    /**
     * <p>Enable cold storage option. Accepted values true or false</p>
     */
    inline ColdStorageOptions& WithEnabled(bool value) { SetEnabled(value); return *this;}

  private:

    bool m_enabled;
    bool m_enabledHasBeenSet = false;
  };

} // namespace Model
} // namespace OpenSearchService
} // namespace Aws
