﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/OrganizationScanEc2InstanceWithFindings.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>Organization-wide Malware Protection configurations.</p><p><h3>See Also:</h3>
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/OrganizationMalwareProtectionConfiguration">AWS
   * API Reference</a></p>
   */
  class AWS_GUARDDUTY_API OrganizationMalwareProtectionConfiguration
  {
  public:
    OrganizationMalwareProtectionConfiguration();
    OrganizationMalwareProtectionConfiguration(Aws::Utils::Json::JsonView jsonValue);
    OrganizationMalwareProtectionConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Whether Malware Protection for EC2 instances with findings should be
     * auto-enabled for new members joining the organization.</p>
     */
    inline const OrganizationScanEc2InstanceWithFindings& GetScanEc2InstanceWithFindings() const{ return m_scanEc2InstanceWithFindings; }

    /**
     * <p>Whether Malware Protection for EC2 instances with findings should be
     * auto-enabled for new members joining the organization.</p>
     */
    inline bool ScanEc2InstanceWithFindingsHasBeenSet() const { return m_scanEc2InstanceWithFindingsHasBeenSet; }

    /**
     * <p>Whether Malware Protection for EC2 instances with findings should be
     * auto-enabled for new members joining the organization.</p>
     */
    inline void SetScanEc2InstanceWithFindings(const OrganizationScanEc2InstanceWithFindings& value) { m_scanEc2InstanceWithFindingsHasBeenSet = true; m_scanEc2InstanceWithFindings = value; }

    /**
     * <p>Whether Malware Protection for EC2 instances with findings should be
     * auto-enabled for new members joining the organization.</p>
     */
    inline void SetScanEc2InstanceWithFindings(OrganizationScanEc2InstanceWithFindings&& value) { m_scanEc2InstanceWithFindingsHasBeenSet = true; m_scanEc2InstanceWithFindings = std::move(value); }

    /**
     * <p>Whether Malware Protection for EC2 instances with findings should be
     * auto-enabled for new members joining the organization.</p>
     */
    inline OrganizationMalwareProtectionConfiguration& WithScanEc2InstanceWithFindings(const OrganizationScanEc2InstanceWithFindings& value) { SetScanEc2InstanceWithFindings(value); return *this;}

    /**
     * <p>Whether Malware Protection for EC2 instances with findings should be
     * auto-enabled for new members joining the organization.</p>
     */
    inline OrganizationMalwareProtectionConfiguration& WithScanEc2InstanceWithFindings(OrganizationScanEc2InstanceWithFindings&& value) { SetScanEc2InstanceWithFindings(std::move(value)); return *this;}

  private:

    OrganizationScanEc2InstanceWithFindings m_scanEc2InstanceWithFindings;
    bool m_scanEc2InstanceWithFindingsHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
