
#ifndef KIRIGAMI2_EXPORT_H
#define KIRIGAMI2_EXPORT_H

#ifdef KIRIGAMI2_STATIC_DEFINE
#  define KIRIGAMI2_EXPORT
#  define KIRIGAMI2_NO_EXPORT
#else
#  ifndef KIRIGAMI2_EXPORT
#    ifdef KF5Kirigami2_EXPORTS
        /* We are building this library */
#      define KIRIGAMI2_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KIRIGAMI2_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KIRIGAMI2_NO_EXPORT
#    define KIRIGAMI2_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KIRIGAMI2_DECL_DEPRECATED
#  define KIRIGAMI2_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KIRIGAMI2_DECL_DEPRECATED_EXPORT
#  define KIRIGAMI2_DECL_DEPRECATED_EXPORT KIRIGAMI2_EXPORT KIRIGAMI2_DECL_DEPRECATED
#endif

#ifndef KIRIGAMI2_DECL_DEPRECATED_NO_EXPORT
#  define KIRIGAMI2_DECL_DEPRECATED_NO_EXPORT KIRIGAMI2_NO_EXPORT KIRIGAMI2_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KIRIGAMI2_NO_DEPRECATED
#    define KIRIGAMI2_NO_DEPRECATED
#  endif
#endif

#define KIRIGAMI2_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

#if defined(KIRIGAMI2_NO_DEPRECATED)
#  undef KIRIGAMI2_DEPRECATED
#  define KIRIGAMI2_DEPRECATED_EXPORT KIRIGAMI2_EXPORT
#  define KIRIGAMI2_DEPRECATED_NO_EXPORT KIRIGAMI2_NO_EXPORT
#elif defined(KIRIGAMI2_NO_DEPRECATED_WARNINGS)
#  define KIRIGAMI2_DEPRECATED
#  define KIRIGAMI2_DEPRECATED_EXPORT KIRIGAMI2_EXPORT
#  define KIRIGAMI2_DEPRECATED_NO_EXPORT KIRIGAMI2_NO_EXPORT
#else
#  define KIRIGAMI2_DEPRECATED KIRIGAMI2_DECL_DEPRECATED
#  define KIRIGAMI2_DEPRECATED_EXPORT KIRIGAMI2_DECL_DEPRECATED_EXPORT
#  define KIRIGAMI2_DEPRECATED_NO_EXPORT KIRIGAMI2_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KIRIGAMI2_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KIRIGAMI2_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KIRIGAMI2_NO_DEPRECATED
#  define KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56300
#endif
#ifdef KIRIGAMI2_NO_DEPRECATED_WARNINGS
#  define KIRIGAMI2_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KIRIGAMI2_DEPRECATED_WARNINGS_SINCE
#  ifdef KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KIRIGAMI2_DEPRECATED_WARNINGS_SINCE KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KIRIGAMI2_DEPRECATED_WARNINGS_SINCE 0x56300
#  endif
#endif

#ifndef KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50000
#endif

#ifdef KIRIGAMI2_DEPRECATED
#  define KIRIGAMI2_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KIRIGAMI2_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KIRIGAMI2_DEPRECATED_WARNINGS_SINCE >= 0x55000
#  define KIRIGAMI2_DEPRECATED_VERSION_5_80(text) KIRIGAMI2_DECL_DEPRECATED_TEXT(text)
#else
#  define KIRIGAMI2_DEPRECATED_VERSION_5_80(text)
#endif

#if KIRIGAMI2_DEPRECATED_WARNINGS_SINCE >= 0x55600
#  define KIRIGAMI2_DEPRECATED_VERSION_5_86(text) KIRIGAMI2_DECL_DEPRECATED_TEXT(text)
#else
#  define KIRIGAMI2_DEPRECATED_VERSION_5_86(text)
#endif
#define KIRIGAMI2_DEPRECATED_VERSION_5(minor, text)      KIRIGAMI2_DEPRECATED_VERSION_5_##minor(text)
#define KIRIGAMI2_DEPRECATED_VERSION(major, minor, text) KIRIGAMI2_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KIRIGAMI2_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIRIGAMI2_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KIRIGAMI2_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KIRIGAMI2_DEPRECATED_VERSION(major, minor, text)
#  define KIRIGAMI2_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIRIGAMI2_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KIRIGAMI2_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KIRIGAMI2_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KIRIGAMI2_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KIRIGAMI2_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KIRIGAMI2_EXPORT_H


#define KIRIGAMI2_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

#if defined(KIRIGAMI2_NO_DEPRECATED)
#  undef KIRIGAMI2_DEPRECATED
#  define KIRIGAMI2_DEPRECATED_EXPORT KIRIGAMI2_EXPORT
#  define KIRIGAMI2_DEPRECATED_NO_EXPORT KIRIGAMI2_NO_EXPORT
#elif defined(KIRIGAMI2_NO_DEPRECATED_WARNINGS)
#  define KIRIGAMI2_DEPRECATED
#  define KIRIGAMI2_DEPRECATED_EXPORT KIRIGAMI2_EXPORT
#  define KIRIGAMI2_DEPRECATED_NO_EXPORT KIRIGAMI2_NO_EXPORT
#else
#  define KIRIGAMI2_DEPRECATED KIRIGAMI2_DECL_DEPRECATED
#  define KIRIGAMI2_DEPRECATED_EXPORT KIRIGAMI2_DECL_DEPRECATED_EXPORT
#  define KIRIGAMI2_DEPRECATED_NO_EXPORT KIRIGAMI2_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KIRIGAMI2_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KIRIGAMI2_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KIRIGAMI2_NO_DEPRECATED
#  define KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56300
#endif
#ifdef KIRIGAMI2_NO_DEPRECATED_WARNINGS
#  define KIRIGAMI2_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KIRIGAMI2_DEPRECATED_WARNINGS_SINCE
#  ifdef KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KIRIGAMI2_DEPRECATED_WARNINGS_SINCE KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KIRIGAMI2_DEPRECATED_WARNINGS_SINCE 0x56300
#  endif
#endif

#ifndef KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50000
#endif

#ifdef KIRIGAMI2_DEPRECATED
#  define KIRIGAMI2_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KIRIGAMI2_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KIRIGAMI2_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KIRIGAMI2_DEPRECATED_WARNINGS_SINCE >= 0x55000
#  define KIRIGAMI2_DEPRECATED_VERSION_5_80(text) KIRIGAMI2_DECL_DEPRECATED_TEXT(text)
#else
#  define KIRIGAMI2_DEPRECATED_VERSION_5_80(text)
#endif

#if KIRIGAMI2_DEPRECATED_WARNINGS_SINCE >= 0x55600
#  define KIRIGAMI2_DEPRECATED_VERSION_5_86(text) KIRIGAMI2_DECL_DEPRECATED_TEXT(text)
#else
#  define KIRIGAMI2_DEPRECATED_VERSION_5_86(text)
#endif
#define KIRIGAMI2_DEPRECATED_VERSION_5(minor, text)      KIRIGAMI2_DEPRECATED_VERSION_5_##minor(text)
#define KIRIGAMI2_DEPRECATED_VERSION(major, minor, text) KIRIGAMI2_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KIRIGAMI2_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIRIGAMI2_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KIRIGAMI2_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KIRIGAMI2_DEPRECATED_VERSION(major, minor, text)
#  define KIRIGAMI2_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIRIGAMI2_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KIRIGAMI2_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KIRIGAMI2_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KIRIGAMI2_EXPORT_H */
