function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import React, { Component } from "react";
import PropTypes from "prop-types";
import _pick from "lodash/pick";
import _get from "lodash/get";
import _isEmpty from "lodash/isEmpty";
import { default as DefaultErrorList } from "./ErrorList";
import { getDefaultFormState, retrieveSchema, shouldRender, toIdSchema, getDefaultRegistry, deepEquals, toPathSchema, isObject } from "../utils";
import validateFormData, { toErrorList } from "../validate";
import { mergeObjects } from "../utils";

var Form =
/*#__PURE__*/
function (_Component) {
  _inherits(Form, _Component);

  function Form(props) {
    var _this;

    _classCallCheck(this, Form);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Form).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "getUsedFormData", function (formData, fields) {
      //for the case of a single input form
      if (fields.length === 0 && _typeof(formData) !== "object") {
        return formData;
      }

      var data = _pick(formData, fields);

      if (Array.isArray(formData)) {
        return Object.keys(data).map(function (key) {
          return data[key];
        });
      }

      return data;
    });

    _defineProperty(_assertThisInitialized(_this), "getFieldNames", function (pathSchema, formData) {
      var getAllPaths = function getAllPaths(_obj) {
        var acc = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        var paths = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [""];
        Object.keys(_obj).forEach(function (key) {
          if (_typeof(_obj[key]) === "object") {
            var newPaths = paths.map(function (path) {
              return "".concat(path, ".").concat(key);
            }); // If an object is marked with additionalProperties, all its keys are valid

            if (_obj[key].__rjsf_additionalProperties && _obj[key].$name !== "") {
              acc.push(_obj[key].$name);
            } else {
              getAllPaths(_obj[key], acc, newPaths);
            }
          } else if (key === "$name" && _obj[key] !== "") {
            paths.forEach(function (path) {
              path = path.replace(/^\./, "");

              var formValue = _get(formData, path); // adds path to fieldNames if it points to a value
              // or an empty object/array


              if (_typeof(formValue) !== "object" || _isEmpty(formValue)) {
                acc.push(path);
              }
            });
          }
        });
        return acc;
      };

      return getAllPaths(pathSchema);
    });

    _defineProperty(_assertThisInitialized(_this), "onChange", function (formData, newErrorSchema) {
      if (isObject(formData) || Array.isArray(formData)) {
        var newState = _this.getStateFromProps(_this.props, formData);

        formData = newState.formData;
      }

      var mustValidate = !_this.props.noValidate && _this.props.liveValidate;
      var state = {
        formData: formData
      };
      var newFormData = formData;

      if (_this.props.omitExtraData === true && _this.props.liveOmit === true) {
        var retrievedSchema = retrieveSchema(_this.state.schema, _this.state.schema, formData);
        var pathSchema = toPathSchema(retrievedSchema, "", _this.state.schema, formData);

        var fieldNames = _this.getFieldNames(pathSchema, formData);

        newFormData = _this.getUsedFormData(formData, fieldNames);
        state = {
          formData: newFormData
        };
      }

      if (mustValidate) {
        var schemaValidation = _this.validate(newFormData);

        var errors = schemaValidation.errors;
        var errorSchema = schemaValidation.errorSchema;
        var schemaValidationErrors = errors;
        var schemaValidationErrorSchema = errorSchema;

        if (_this.props.extraErrors) {
          errorSchema = mergeObjects(errorSchema, _this.props.extraErrors, !!"concat arrays");
          errors = toErrorList(errorSchema);
        }

        state = {
          formData: newFormData,
          errors: errors,
          errorSchema: errorSchema,
          schemaValidationErrors: schemaValidationErrors,
          schemaValidationErrorSchema: schemaValidationErrorSchema
        };
      } else if (!_this.props.noValidate && newErrorSchema) {
        var _errorSchema = _this.props.extraErrors ? mergeObjects(newErrorSchema, _this.props.extraErrors, !!"concat arrays") : newErrorSchema;

        state = {
          formData: newFormData,
          errorSchema: _errorSchema,
          errors: toErrorList(_errorSchema)
        };
      }

      _this.setState(state, function () {
        return _this.props.onChange && _this.props.onChange(_this.state);
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onBlur", function () {
      if (_this.props.onBlur) {
        var _this$props;

        (_this$props = _this.props).onBlur.apply(_this$props, arguments);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onFocus", function () {
      if (_this.props.onFocus) {
        var _this$props2;

        (_this$props2 = _this.props).onFocus.apply(_this$props2, arguments);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onSubmit", function (event) {
      event.preventDefault();

      if (event.target !== event.currentTarget) {
        return;
      }

      event.persist();
      var newFormData = _this.state.formData;

      if (_this.props.omitExtraData === true) {
        var retrievedSchema = retrieveSchema(_this.state.schema, _this.state.schema, newFormData);
        var pathSchema = toPathSchema(retrievedSchema, "", _this.state.schema, newFormData);

        var fieldNames = _this.getFieldNames(pathSchema, newFormData);

        newFormData = _this.getUsedFormData(newFormData, fieldNames);
      }

      if (!_this.props.noValidate) {
        var schemaValidation = _this.validate(newFormData);

        var _errors = schemaValidation.errors;
        var _errorSchema2 = schemaValidation.errorSchema;
        var schemaValidationErrors = _errors;
        var schemaValidationErrorSchema = _errorSchema2;

        if (Object.keys(_errors).length > 0) {
          if (_this.props.extraErrors) {
            _errorSchema2 = mergeObjects(_errorSchema2, _this.props.extraErrors, !!"concat arrays");
            _errors = toErrorList(_errorSchema2);
          }

          _this.setState({
            errors: _errors,
            errorSchema: _errorSchema2,
            schemaValidationErrors: schemaValidationErrors,
            schemaValidationErrorSchema: schemaValidationErrorSchema
          }, function () {
            if (_this.props.onError) {
              _this.props.onError(_errors);
            } else {
              console.error("Form validation failed", _errors);
            }
          });

          return;
        }
      } // There are no errors generated through schema validation.
      // Check for user provided errors and update state accordingly.


      var errorSchema;
      var errors;

      if (_this.props.extraErrors) {
        errorSchema = _this.props.extraErrors;
        errors = toErrorList(errorSchema);
      } else {
        errorSchema = {};
        errors = [];
      }

      _this.setState({
        formData: newFormData,
        errors: errors,
        errorSchema: errorSchema,
        schemaValidationErrors: [],
        schemaValidationErrorSchema: {}
      }, function () {
        if (_this.props.onSubmit) {
          _this.props.onSubmit(_objectSpread({}, _this.state, {
            formData: newFormData,
            status: "submitted"
          }), event);
        }
      });
    });

    _this.state = _this.getStateFromProps(props, props.formData);

    if (_this.props.onChange && !deepEquals(_this.state.formData, _this.props.formData)) {
      _this.props.onChange(_this.state);
    }

    _this.formElement = null;
    return _this;
  }

  _createClass(Form, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      var nextState = this.getStateFromProps(nextProps, nextProps.formData);

      if (!deepEquals(nextState.formData, nextProps.formData) && !deepEquals(nextState.formData, this.state.formData) && this.props.onChange) {
        this.props.onChange(nextState);
      }

      this.setState(nextState);
    }
  }, {
    key: "getStateFromProps",
    value: function getStateFromProps(props, inputFormData) {
      var state = this.state || {};
      var schema = "schema" in props ? props.schema : this.props.schema;
      var uiSchema = "uiSchema" in props ? props.uiSchema : this.props.uiSchema;
      var edit = typeof inputFormData !== "undefined";
      var liveValidate = "liveValidate" in props ? props.liveValidate : this.props.liveValidate;
      var mustValidate = edit && !props.noValidate && liveValidate;
      var rootSchema = schema;
      var formData = getDefaultFormState(schema, inputFormData, rootSchema);
      var retrievedSchema = retrieveSchema(schema, rootSchema, formData);
      var customFormats = props.customFormats;
      var additionalMetaSchemas = props.additionalMetaSchemas;

      var getCurrentErrors = function getCurrentErrors() {
        if (props.noValidate) {
          return {
            errors: [],
            errorSchema: {}
          };
        } else if (!props.liveValidate) {
          return {
            errors: state.schemaValidationErrors || [],
            errorSchema: state.schemaValidationErrorSchema || {}
          };
        }

        return {
          errors: state.errors || [],
          errorSchema: state.errorSchema || {}
        };
      };

      var errors, errorSchema, schemaValidationErrors, schemaValidationErrorSchema;

      if (mustValidate) {
        var schemaValidation = this.validate(formData, schema, additionalMetaSchemas, customFormats);
        errors = schemaValidation.errors;
        errorSchema = schemaValidation.errorSchema;
        schemaValidationErrors = errors;
        schemaValidationErrorSchema = errorSchema;
      } else {
        var currentErrors = getCurrentErrors();
        errors = currentErrors.errors;
        errorSchema = currentErrors.errorSchema;
        schemaValidationErrors = state.schemaValidationErrors;
        schemaValidationErrorSchema = state.schemaValidationErrorSchema;
      }

      if (props.extraErrors) {
        errorSchema = mergeObjects(errorSchema, props.extraErrors, !!"concat arrays");
        errors = toErrorList(errorSchema);
      }

      var idSchema = toIdSchema(retrievedSchema, uiSchema["ui:rootFieldId"], rootSchema, formData, props.idPrefix, props.idSeparator);
      var nextState = {
        schema: schema,
        uiSchema: uiSchema,
        idSchema: idSchema,
        formData: formData,
        edit: edit,
        errors: errors,
        errorSchema: errorSchema,
        additionalMetaSchemas: additionalMetaSchemas
      };

      if (schemaValidationErrors) {
        nextState.schemaValidationErrors = schemaValidationErrors;
        nextState.schemaValidationErrorSchema = schemaValidationErrorSchema;
      }

      return nextState;
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      return shouldRender(this, nextProps, nextState);
    }
  }, {
    key: "validate",
    value: function validate(formData) {
      var schema = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.props.schema;
      var additionalMetaSchemas = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.props.additionalMetaSchemas;
      var customFormats = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : this.props.customFormats;
      var _this$props3 = this.props,
          validate = _this$props3.validate,
          transformErrors = _this$props3.transformErrors;

      var _this$getRegistry = this.getRegistry(),
          rootSchema = _this$getRegistry.rootSchema;

      var resolvedSchema = retrieveSchema(schema, rootSchema, formData);
      return validateFormData(formData, resolvedSchema, validate, transformErrors, additionalMetaSchemas, customFormats);
    }
  }, {
    key: "renderErrors",
    value: function renderErrors() {
      var _this$state = this.state,
          errors = _this$state.errors,
          errorSchema = _this$state.errorSchema,
          schema = _this$state.schema,
          uiSchema = _this$state.uiSchema;
      var _this$props4 = this.props,
          ErrorList = _this$props4.ErrorList,
          showErrorList = _this$props4.showErrorList,
          formContext = _this$props4.formContext;

      if (errors.length && showErrorList != false) {
        return React.createElement(ErrorList, {
          errors: errors,
          errorSchema: errorSchema,
          schema: schema,
          uiSchema: uiSchema,
          formContext: formContext
        });
      }

      return null;
    }
  }, {
    key: "getRegistry",
    value: function getRegistry() {
      // For BC, accept passed SchemaField and TitleField props and pass them to
      // the "fields" registry one.
      var _getDefaultRegistry = getDefaultRegistry(),
          fields = _getDefaultRegistry.fields,
          widgets = _getDefaultRegistry.widgets;

      return {
        fields: _objectSpread({}, fields, this.props.fields),
        widgets: _objectSpread({}, widgets, this.props.widgets),
        ArrayFieldTemplate: this.props.ArrayFieldTemplate,
        ObjectFieldTemplate: this.props.ObjectFieldTemplate,
        FieldTemplate: this.props.FieldTemplate,
        definitions: this.props.schema.definitions || {},
        rootSchema: this.props.schema,
        formContext: this.props.formContext || {}
      };
    }
  }, {
    key: "submit",
    value: function submit() {
      if (this.formElement) {
        this.formElement.dispatchEvent(new CustomEvent("submit", {
          cancelable: true
        }));
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props5 = this.props,
          children = _this$props5.children,
          id = _this$props5.id,
          idPrefix = _this$props5.idPrefix,
          idSeparator = _this$props5.idSeparator,
          className = _this$props5.className,
          tagName = _this$props5.tagName,
          name = _this$props5.name,
          method = _this$props5.method,
          target = _this$props5.target,
          action = _this$props5.action,
          deprecatedAutocomplete = _this$props5.autocomplete,
          currentAutoComplete = _this$props5.autoComplete,
          enctype = _this$props5.enctype,
          acceptcharset = _this$props5.acceptcharset,
          noHtml5Validate = _this$props5.noHtml5Validate,
          disabled = _this$props5.disabled,
          readonly = _this$props5.readonly,
          formContext = _this$props5.formContext,
          _internalFormWrapper = _this$props5._internalFormWrapper;
      var _this$state2 = this.state,
          schema = _this$state2.schema,
          uiSchema = _this$state2.uiSchema,
          formData = _this$state2.formData,
          errorSchema = _this$state2.errorSchema,
          idSchema = _this$state2.idSchema;
      var registry = this.getRegistry();
      var _SchemaField = registry.fields.SchemaField; // The `semantic-ui` and `material-ui` themes have `_internalFormWrapper`s that take an `as` prop that is the
      // PropTypes.elementType to use for the inner tag so we'll need to pass `tagName` along if it is provided.
      // NOTE, the `as` prop is native to `semantic-ui` and is emulated in the `material-ui` theme

      var as = _internalFormWrapper ? tagName : undefined;
      var FormTag = _internalFormWrapper || tagName || "form";
      var SubmitButton = registry.widgets.SubmitButton;

      if (deprecatedAutocomplete) {
        console.warn("Using autocomplete property of Form is deprecated, use autoComplete instead.");
      }

      var autoComplete = currentAutoComplete ? currentAutoComplete : deprecatedAutocomplete;
      return React.createElement(FormTag, {
        className: className ? className : "rjsf",
        id: id,
        name: name,
        method: method,
        target: target,
        action: action,
        autoComplete: autoComplete,
        encType: enctype,
        acceptCharset: acceptcharset,
        noValidate: noHtml5Validate,
        onSubmit: this.onSubmit,
        as: as,
        ref: function ref(form) {
          _this2.formElement = form;
        }
      }, this.renderErrors(), React.createElement(_SchemaField, {
        schema: schema,
        uiSchema: uiSchema,
        errorSchema: errorSchema,
        idSchema: idSchema,
        idPrefix: idPrefix,
        idSeparator: idSeparator,
        formContext: formContext,
        formData: formData,
        onChange: this.onChange,
        onBlur: this.onBlur,
        onFocus: this.onFocus,
        registry: registry,
        disabled: disabled,
        readonly: readonly
      }), children ? children : React.createElement(SubmitButton, {
        uiSchema: uiSchema
      }));
    }
  }]);

  return Form;
}(Component);

_defineProperty(Form, "defaultProps", {
  uiSchema: {},
  noValidate: false,
  liveValidate: false,
  disabled: false,
  readonly: false,
  noHtml5Validate: false,
  ErrorList: DefaultErrorList,
  omitExtraData: false
});

export { Form as default };

if (process.env.NODE_ENV !== "production") {
  Form.propTypes = {
    schema: PropTypes.object.isRequired,
    uiSchema: PropTypes.object,
    formData: PropTypes.any,
    disabled: PropTypes.bool,
    readonly: PropTypes.bool,
    widgets: PropTypes.objectOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object])),
    fields: PropTypes.objectOf(PropTypes.elementType),
    ArrayFieldTemplate: PropTypes.elementType,
    ObjectFieldTemplate: PropTypes.elementType,
    FieldTemplate: PropTypes.elementType,
    ErrorList: PropTypes.func,
    onChange: PropTypes.func,
    onError: PropTypes.func,
    showErrorList: PropTypes.bool,
    onSubmit: PropTypes.func,
    id: PropTypes.string,
    className: PropTypes.string,
    tagName: PropTypes.elementType,
    _internalFormWrapper: PropTypes.elementType,
    name: PropTypes.string,
    method: PropTypes.string,
    target: PropTypes.string,
    action: PropTypes.string,
    autocomplete: PropTypes.string,
    autoComplete: PropTypes.string,
    enctype: PropTypes.string,
    acceptcharset: PropTypes.string,
    noValidate: PropTypes.bool,
    noHtml5Validate: PropTypes.bool,
    liveValidate: PropTypes.bool,
    validate: PropTypes.func,
    transformErrors: PropTypes.func,
    formContext: PropTypes.object,
    customFormats: PropTypes.object,
    additionalMetaSchemas: PropTypes.arrayOf(PropTypes.object),
    omitExtraData: PropTypes.bool,
    extraErrors: PropTypes.object
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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