function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import IconButton from "../IconButton";
import React from "react";
import PropTypes from "prop-types";
import * as types from "../../types";
import { ADDITIONAL_PROPERTY_FLAG, isSelect, retrieveSchema, toIdSchema, getDefaultRegistry, mergeObjects, deepEquals, getSchemaType, getDisplayLabel } from "../../utils";
var REQUIRED_FIELD_SYMBOL = "*";
var COMPONENT_TYPES = {
  array: "ArrayField",
  "boolean": "BooleanField",
  integer: "NumberField",
  number: "NumberField",
  object: "ObjectField",
  string: "StringField",
  "null": "NullField"
};

function getFieldComponent(schema, uiSchema, idSchema, fields) {
  var field = uiSchema["ui:field"];

  if (typeof field === "function") {
    return field;
  }

  if (typeof field === "string" && field in fields) {
    return fields[field];
  }

  var componentName = COMPONENT_TYPES[getSchemaType(schema)]; // If the type is not defined and the schema uses 'anyOf' or 'oneOf', don't
  // render a field and let the MultiSchemaField component handle the form display

  if (!componentName && (schema.anyOf || schema.oneOf)) {
    return function () {
      return null;
    };
  }

  return componentName in fields ? fields[componentName] : function () {
    var UnsupportedField = fields.UnsupportedField;
    return React.createElement(UnsupportedField, {
      schema: schema,
      idSchema: idSchema,
      reason: "Unknown field type ".concat(schema.type)
    });
  };
}

function Label(props) {
  var label = props.label,
      required = props.required,
      id = props.id;

  if (!label) {
    return null;
  }

  return React.createElement("label", {
    className: "control-label",
    htmlFor: id
  }, label, required && React.createElement("span", {
    className: "required"
  }, REQUIRED_FIELD_SYMBOL));
}

function LabelInput(props) {
  var id = props.id,
      label = props.label,
      onChange = props.onChange;
  return React.createElement("input", {
    className: "form-control",
    type: "text",
    id: id,
    onBlur: function onBlur(event) {
      return onChange(event.target.value);
    },
    defaultValue: label
  });
}

function Help(props) {
  var id = props.id,
      help = props.help;

  if (!help) {
    return null;
  }

  if (typeof help === "string") {
    return React.createElement("p", {
      id: id,
      className: "help-block"
    }, help);
  }

  return React.createElement("div", {
    id: id,
    className: "help-block"
  }, help);
}

function ErrorList(props) {
  var _props$errors = props.errors,
      errors = _props$errors === void 0 ? [] : _props$errors;

  if (errors.length === 0) {
    return null;
  }

  return React.createElement("div", null, React.createElement("ul", {
    className: "error-detail bs-callout bs-callout-info"
  }, errors.filter(function (elem) {
    return !!elem;
  }).map(function (error, index) {
    return React.createElement("li", {
      className: "text-danger",
      key: index
    }, error);
  })));
}

function DefaultTemplate(props) {
  var id = props.id,
      label = props.label,
      children = props.children,
      errors = props.errors,
      help = props.help,
      description = props.description,
      hidden = props.hidden,
      required = props.required,
      displayLabel = props.displayLabel;

  if (hidden) {
    return React.createElement("div", {
      className: "hidden"
    }, children);
  }

  return React.createElement(WrapIfAdditional, props, displayLabel && React.createElement(Label, {
    label: label,
    required: required,
    id: id
  }), displayLabel && description ? description : null, children, errors, help);
}

if (process.env.NODE_ENV !== "production") {
  DefaultTemplate.propTypes = {
    id: PropTypes.string,
    classNames: PropTypes.string,
    label: PropTypes.string,
    children: PropTypes.node.isRequired,
    errors: PropTypes.element,
    rawErrors: PropTypes.arrayOf(PropTypes.string),
    help: PropTypes.element,
    rawHelp: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
    description: PropTypes.element,
    rawDescription: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
    hidden: PropTypes.bool,
    required: PropTypes.bool,
    readonly: PropTypes.bool,
    displayLabel: PropTypes.bool,
    fields: PropTypes.object,
    formContext: PropTypes.object
  };
}

DefaultTemplate.defaultProps = {
  hidden: false,
  readonly: false,
  required: false,
  displayLabel: true
};

function WrapIfAdditional(props) {
  var id = props.id,
      classNames = props.classNames,
      disabled = props.disabled,
      label = props.label,
      onKeyChange = props.onKeyChange,
      onDropPropertyClick = props.onDropPropertyClick,
      readonly = props.readonly,
      required = props.required,
      schema = props.schema;
  var keyLabel = "".concat(label, " Key"); // i18n ?

  var additional = schema.hasOwnProperty(ADDITIONAL_PROPERTY_FLAG);

  if (!additional) {
    return React.createElement("div", {
      className: classNames
    }, props.children);
  }

  return React.createElement("div", {
    className: classNames
  }, React.createElement("div", {
    className: "row"
  }, React.createElement("div", {
    className: "col-xs-5 form-additional"
  }, React.createElement("div", {
    className: "form-group"
  }, React.createElement(Label, {
    label: keyLabel,
    required: required,
    id: "".concat(id, "-key")
  }), React.createElement(LabelInput, {
    label: label,
    required: required,
    id: "".concat(id, "-key"),
    onChange: onKeyChange
  }))), React.createElement("div", {
    className: "form-additional form-group col-xs-5"
  }, props.children), React.createElement("div", {
    className: "col-xs-2"
  }, React.createElement(IconButton, {
    type: "danger",
    icon: "remove",
    className: "array-item-remove btn-block",
    tabIndex: "-1",
    style: {
      border: "0"
    },
    disabled: disabled || readonly,
    onClick: onDropPropertyClick(label)
  }))));
}

function SchemaFieldRender(props) {
  var uiSchema = props.uiSchema,
      formData = props.formData,
      errorSchema = props.errorSchema,
      idPrefix = props.idPrefix,
      idSeparator = props.idSeparator,
      name = props.name,
      onChange = props.onChange,
      onKeyChange = props.onKeyChange,
      onDropPropertyClick = props.onDropPropertyClick,
      required = props.required,
      _props$registry = props.registry,
      registry = _props$registry === void 0 ? getDefaultRegistry() : _props$registry,
      _props$wasPropertyKey = props.wasPropertyKeyModified,
      wasPropertyKeyModified = _props$wasPropertyKey === void 0 ? false : _props$wasPropertyKey;
  var rootSchema = registry.rootSchema,
      fields = registry.fields,
      formContext = registry.formContext;
  var FieldTemplate = uiSchema["ui:FieldTemplate"] || registry.FieldTemplate || DefaultTemplate;
  var idSchema = props.idSchema;
  var schema = retrieveSchema(props.schema, rootSchema, formData);
  idSchema = mergeObjects(toIdSchema(schema, null, rootSchema, formData, idPrefix, idSeparator), idSchema);
  var FieldComponent = getFieldComponent(schema, uiSchema, idSchema, fields);
  var DescriptionField = fields.DescriptionField;
  var disabled = Boolean(props.disabled || uiSchema["ui:disabled"]);
  var readonly = Boolean(props.readonly || uiSchema["ui:readonly"] || props.schema.readOnly || schema.readOnly);
  var uiSchemaHideError = uiSchema["ui:hideError"]; // Set hideError to the value provided in the uiSchema, otherwise stick with the prop to propagate to children

  var hideError = uiSchemaHideError === undefined ? props.hideError : Boolean(uiSchemaHideError);
  var autofocus = Boolean(props.autofocus || uiSchema["ui:autofocus"]);

  if (Object.keys(schema).length === 0) {
    return null;
  }

  var displayLabel = getDisplayLabel(schema, uiSchema, rootSchema);

  var __errors = errorSchema.__errors,
      fieldErrorSchema = _objectWithoutProperties(errorSchema, ["__errors"]); // See #439: uiSchema: Don't pass consumed class names to child components


  var field = React.createElement(FieldComponent, _extends({}, props, {
    idSchema: idSchema,
    schema: schema,
    uiSchema: _objectSpread({}, uiSchema, {
      classNames: undefined
    }),
    disabled: disabled,
    readonly: readonly,
    hideError: hideError,
    autofocus: autofocus,
    errorSchema: fieldErrorSchema,
    formContext: formContext,
    rawErrors: __errors
  }));
  var id = idSchema.$id; // If this schema has a title defined, but the user has set a new key/label, retain their input.

  var label;

  if (wasPropertyKeyModified) {
    label = name;
  } else {
    label = uiSchema["ui:title"] || props.schema.title || schema.title || name;
  }

  var description = uiSchema["ui:description"] || props.schema.description || schema.description;
  var errors = __errors;
  var help = uiSchema["ui:help"];
  var hidden = uiSchema["ui:widget"] === "hidden";
  var classNames = ["form-group", "field", "field-".concat(schema.type)];

  if (!hideError && errors && errors.length > 0) {
    classNames.push("field-error has-error has-danger");
  }

  classNames.push(uiSchema.classNames);
  classNames = classNames.join(" ").trim();
  var fieldProps = {
    description: React.createElement(DescriptionField, {
      id: id + "__description",
      description: description,
      formContext: formContext
    }),
    rawDescription: description,
    help: React.createElement(Help, {
      id: id + "__help",
      help: help
    }),
    rawHelp: typeof help === "string" ? help : undefined,
    errors: hideError ? undefined : React.createElement(ErrorList, {
      errors: errors
    }),
    rawErrors: hideError ? undefined : errors,
    id: id,
    label: label,
    hidden: hidden,
    onChange: onChange,
    onKeyChange: onKeyChange,
    onDropPropertyClick: onDropPropertyClick,
    required: required,
    disabled: disabled,
    readonly: readonly,
    hideError: hideError,
    displayLabel: displayLabel,
    classNames: classNames,
    formContext: formContext,
    formData: formData,
    fields: fields,
    schema: schema,
    uiSchema: uiSchema,
    registry: registry
  };
  var _AnyOfField = registry.fields.AnyOfField;
  var _OneOfField = registry.fields.OneOfField;
  return React.createElement(FieldTemplate, fieldProps, React.createElement(React.Fragment, null, field, schema.anyOf && !isSelect(schema) && React.createElement(_AnyOfField, {
    disabled: disabled,
    readonly: readonly,
    hideError: hideError,
    errorSchema: errorSchema,
    formData: formData,
    idPrefix: idPrefix,
    idSchema: idSchema,
    idSeparator: idSeparator,
    onBlur: props.onBlur,
    onChange: props.onChange,
    onFocus: props.onFocus,
    options: schema.anyOf.map(function (_schema) {
      return retrieveSchema(_schema, rootSchema, formData);
    }),
    baseType: schema.type,
    registry: registry,
    schema: schema,
    uiSchema: uiSchema
  }), schema.oneOf && !isSelect(schema) && React.createElement(_OneOfField, {
    disabled: disabled,
    readonly: readonly,
    hideError: hideError,
    errorSchema: errorSchema,
    formData: formData,
    idPrefix: idPrefix,
    idSchema: idSchema,
    idSeparator: idSeparator,
    onBlur: props.onBlur,
    onChange: props.onChange,
    onFocus: props.onFocus,
    options: schema.oneOf.map(function (_schema) {
      return retrieveSchema(_schema, rootSchema, formData);
    }),
    baseType: schema.type,
    registry: registry,
    schema: schema,
    uiSchema: uiSchema
  })));
}

var SchemaField =
/*#__PURE__*/
function (_React$Component) {
  _inherits(SchemaField, _React$Component);

  function SchemaField() {
    _classCallCheck(this, SchemaField);

    return _possibleConstructorReturn(this, _getPrototypeOf(SchemaField).apply(this, arguments));
  }

  _createClass(SchemaField, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      return !deepEquals(this.props, nextProps);
    }
  }, {
    key: "render",
    value: function render() {
      return SchemaFieldRender(this.props);
    }
  }]);

  return SchemaField;
}(React.Component);

SchemaField.defaultProps = {
  uiSchema: {},
  errorSchema: {},
  idSchema: {},
  disabled: false,
  readonly: false,
  autofocus: false,
  hideError: false
};

if (process.env.NODE_ENV !== "production") {
  SchemaField.propTypes = {
    schema: PropTypes.object.isRequired,
    uiSchema: PropTypes.object,
    idSchema: PropTypes.object,
    formData: PropTypes.any,
    errorSchema: PropTypes.object,
    registry: types.registry.isRequired
  };
}

export default SchemaField;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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