"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _pick2 = _interopRequireDefault(require("lodash/pick"));

var _get2 = _interopRequireDefault(require("lodash/get"));

var _isEmpty2 = _interopRequireDefault(require("lodash/isEmpty"));

var _ErrorList = _interopRequireDefault(require("./ErrorList"));

var _utils = require("../utils");

var _validate = _interopRequireWildcard(require("../validate"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Form =
/*#__PURE__*/
function (_Component) {
  _inherits(Form, _Component);

  function Form(props) {
    var _this;

    _classCallCheck(this, Form);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Form).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "getUsedFormData", function (formData, fields) {
      //for the case of a single input form
      if (fields.length === 0 && _typeof(formData) !== "object") {
        return formData;
      }

      var data = (0, _pick2["default"])(formData, fields);

      if (Array.isArray(formData)) {
        return Object.keys(data).map(function (key) {
          return data[key];
        });
      }

      return data;
    });

    _defineProperty(_assertThisInitialized(_this), "getFieldNames", function (pathSchema, formData) {
      var getAllPaths = function getAllPaths(_obj) {
        var acc = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        var paths = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [""];
        Object.keys(_obj).forEach(function (key) {
          if (_typeof(_obj[key]) === "object") {
            var newPaths = paths.map(function (path) {
              return "".concat(path, ".").concat(key);
            }); // If an object is marked with additionalProperties, all its keys are valid

            if (_obj[key].__rjsf_additionalProperties && _obj[key].$name !== "") {
              acc.push(_obj[key].$name);
            } else {
              getAllPaths(_obj[key], acc, newPaths);
            }
          } else if (key === "$name" && _obj[key] !== "") {
            paths.forEach(function (path) {
              path = path.replace(/^\./, "");
              var formValue = (0, _get2["default"])(formData, path); // adds path to fieldNames if it points to a value
              // or an empty object/array

              if (_typeof(formValue) !== "object" || (0, _isEmpty2["default"])(formValue)) {
                acc.push(path);
              }
            });
          }
        });
        return acc;
      };

      return getAllPaths(pathSchema);
    });

    _defineProperty(_assertThisInitialized(_this), "onChange", function (formData, newErrorSchema) {
      if ((0, _utils.isObject)(formData) || Array.isArray(formData)) {
        var newState = _this.getStateFromProps(_this.props, formData);

        formData = newState.formData;
      }

      var mustValidate = !_this.props.noValidate && _this.props.liveValidate;
      var state = {
        formData: formData
      };
      var newFormData = formData;

      if (_this.props.omitExtraData === true && _this.props.liveOmit === true) {
        var retrievedSchema = (0, _utils.retrieveSchema)(_this.state.schema, _this.state.schema, formData);
        var pathSchema = (0, _utils.toPathSchema)(retrievedSchema, "", _this.state.schema, formData);

        var fieldNames = _this.getFieldNames(pathSchema, formData);

        newFormData = _this.getUsedFormData(formData, fieldNames);
        state = {
          formData: newFormData
        };
      }

      if (mustValidate) {
        var schemaValidation = _this.validate(newFormData);

        var errors = schemaValidation.errors;
        var errorSchema = schemaValidation.errorSchema;
        var schemaValidationErrors = errors;
        var schemaValidationErrorSchema = errorSchema;

        if (_this.props.extraErrors) {
          errorSchema = (0, _utils.mergeObjects)(errorSchema, _this.props.extraErrors, !!"concat arrays");
          errors = (0, _validate.toErrorList)(errorSchema);
        }

        state = {
          formData: newFormData,
          errors: errors,
          errorSchema: errorSchema,
          schemaValidationErrors: schemaValidationErrors,
          schemaValidationErrorSchema: schemaValidationErrorSchema
        };
      } else if (!_this.props.noValidate && newErrorSchema) {
        var _errorSchema = _this.props.extraErrors ? (0, _utils.mergeObjects)(newErrorSchema, _this.props.extraErrors, !!"concat arrays") : newErrorSchema;

        state = {
          formData: newFormData,
          errorSchema: _errorSchema,
          errors: (0, _validate.toErrorList)(_errorSchema)
        };
      }

      _this.setState(state, function () {
        return _this.props.onChange && _this.props.onChange(_this.state);
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onBlur", function () {
      if (_this.props.onBlur) {
        var _this$props;

        (_this$props = _this.props).onBlur.apply(_this$props, arguments);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onFocus", function () {
      if (_this.props.onFocus) {
        var _this$props2;

        (_this$props2 = _this.props).onFocus.apply(_this$props2, arguments);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onSubmit", function (event) {
      event.preventDefault();

      if (event.target !== event.currentTarget) {
        return;
      }

      event.persist();
      var newFormData = _this.state.formData;

      if (_this.props.omitExtraData === true) {
        var retrievedSchema = (0, _utils.retrieveSchema)(_this.state.schema, _this.state.schema, newFormData);
        var pathSchema = (0, _utils.toPathSchema)(retrievedSchema, "", _this.state.schema, newFormData);

        var fieldNames = _this.getFieldNames(pathSchema, newFormData);

        newFormData = _this.getUsedFormData(newFormData, fieldNames);
      }

      if (!_this.props.noValidate) {
        var schemaValidation = _this.validate(newFormData);

        var _errors = schemaValidation.errors;
        var _errorSchema2 = schemaValidation.errorSchema;
        var schemaValidationErrors = _errors;
        var schemaValidationErrorSchema = _errorSchema2;

        if (Object.keys(_errors).length > 0) {
          if (_this.props.extraErrors) {
            _errorSchema2 = (0, _utils.mergeObjects)(_errorSchema2, _this.props.extraErrors, !!"concat arrays");
            _errors = (0, _validate.toErrorList)(_errorSchema2);
          }

          _this.setState({
            errors: _errors,
            errorSchema: _errorSchema2,
            schemaValidationErrors: schemaValidationErrors,
            schemaValidationErrorSchema: schemaValidationErrorSchema
          }, function () {
            if (_this.props.onError) {
              _this.props.onError(_errors);
            } else {
              console.error("Form validation failed", _errors);
            }
          });

          return;
        }
      } // There are no errors generated through schema validation.
      // Check for user provided errors and update state accordingly.


      var errorSchema;
      var errors;

      if (_this.props.extraErrors) {
        errorSchema = _this.props.extraErrors;
        errors = (0, _validate.toErrorList)(errorSchema);
      } else {
        errorSchema = {};
        errors = [];
      }

      _this.setState({
        formData: newFormData,
        errors: errors,
        errorSchema: errorSchema,
        schemaValidationErrors: [],
        schemaValidationErrorSchema: {}
      }, function () {
        if (_this.props.onSubmit) {
          _this.props.onSubmit(_objectSpread({}, _this.state, {
            formData: newFormData,
            status: "submitted"
          }), event);
        }
      });
    });

    _this.state = _this.getStateFromProps(props, props.formData);

    if (_this.props.onChange && !(0, _utils.deepEquals)(_this.state.formData, _this.props.formData)) {
      _this.props.onChange(_this.state);
    }

    _this.formElement = null;
    return _this;
  }

  _createClass(Form, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      var nextState = this.getStateFromProps(nextProps, nextProps.formData);

      if (!(0, _utils.deepEquals)(nextState.formData, nextProps.formData) && !(0, _utils.deepEquals)(nextState.formData, this.state.formData) && this.props.onChange) {
        this.props.onChange(nextState);
      }

      this.setState(nextState);
    }
  }, {
    key: "getStateFromProps",
    value: function getStateFromProps(props, inputFormData) {
      var state = this.state || {};
      var schema = "schema" in props ? props.schema : this.props.schema;
      var uiSchema = "uiSchema" in props ? props.uiSchema : this.props.uiSchema;
      var edit = typeof inputFormData !== "undefined";
      var liveValidate = "liveValidate" in props ? props.liveValidate : this.props.liveValidate;
      var mustValidate = edit && !props.noValidate && liveValidate;
      var rootSchema = schema;
      var formData = (0, _utils.getDefaultFormState)(schema, inputFormData, rootSchema);
      var retrievedSchema = (0, _utils.retrieveSchema)(schema, rootSchema, formData);
      var customFormats = props.customFormats;
      var additionalMetaSchemas = props.additionalMetaSchemas;

      var getCurrentErrors = function getCurrentErrors() {
        if (props.noValidate) {
          return {
            errors: [],
            errorSchema: {}
          };
        } else if (!props.liveValidate) {
          return {
            errors: state.schemaValidationErrors || [],
            errorSchema: state.schemaValidationErrorSchema || {}
          };
        }

        return {
          errors: state.errors || [],
          errorSchema: state.errorSchema || {}
        };
      };

      var errors, errorSchema, schemaValidationErrors, schemaValidationErrorSchema;

      if (mustValidate) {
        var schemaValidation = this.validate(formData, schema, additionalMetaSchemas, customFormats);
        errors = schemaValidation.errors;
        errorSchema = schemaValidation.errorSchema;
        schemaValidationErrors = errors;
        schemaValidationErrorSchema = errorSchema;
      } else {
        var currentErrors = getCurrentErrors();
        errors = currentErrors.errors;
        errorSchema = currentErrors.errorSchema;
        schemaValidationErrors = state.schemaValidationErrors;
        schemaValidationErrorSchema = state.schemaValidationErrorSchema;
      }

      if (props.extraErrors) {
        errorSchema = (0, _utils.mergeObjects)(errorSchema, props.extraErrors, !!"concat arrays");
        errors = (0, _validate.toErrorList)(errorSchema);
      }

      var idSchema = (0, _utils.toIdSchema)(retrievedSchema, uiSchema["ui:rootFieldId"], rootSchema, formData, props.idPrefix, props.idSeparator);
      var nextState = {
        schema: schema,
        uiSchema: uiSchema,
        idSchema: idSchema,
        formData: formData,
        edit: edit,
        errors: errors,
        errorSchema: errorSchema,
        additionalMetaSchemas: additionalMetaSchemas
      };

      if (schemaValidationErrors) {
        nextState.schemaValidationErrors = schemaValidationErrors;
        nextState.schemaValidationErrorSchema = schemaValidationErrorSchema;
      }

      return nextState;
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      return (0, _utils.shouldRender)(this, nextProps, nextState);
    }
  }, {
    key: "validate",
    value: function validate(formData) {
      var schema = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.props.schema;
      var additionalMetaSchemas = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.props.additionalMetaSchemas;
      var customFormats = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : this.props.customFormats;
      var _this$props3 = this.props,
          validate = _this$props3.validate,
          transformErrors = _this$props3.transformErrors;

      var _this$getRegistry = this.getRegistry(),
          rootSchema = _this$getRegistry.rootSchema;

      var resolvedSchema = (0, _utils.retrieveSchema)(schema, rootSchema, formData);
      return (0, _validate["default"])(formData, resolvedSchema, validate, transformErrors, additionalMetaSchemas, customFormats);
    }
  }, {
    key: "renderErrors",
    value: function renderErrors() {
      var _this$state = this.state,
          errors = _this$state.errors,
          errorSchema = _this$state.errorSchema,
          schema = _this$state.schema,
          uiSchema = _this$state.uiSchema;
      var _this$props4 = this.props,
          ErrorList = _this$props4.ErrorList,
          showErrorList = _this$props4.showErrorList,
          formContext = _this$props4.formContext;

      if (errors.length && showErrorList != false) {
        return _react["default"].createElement(ErrorList, {
          errors: errors,
          errorSchema: errorSchema,
          schema: schema,
          uiSchema: uiSchema,
          formContext: formContext
        });
      }

      return null;
    }
  }, {
    key: "getRegistry",
    value: function getRegistry() {
      // For BC, accept passed SchemaField and TitleField props and pass them to
      // the "fields" registry one.
      var _getDefaultRegistry = (0, _utils.getDefaultRegistry)(),
          fields = _getDefaultRegistry.fields,
          widgets = _getDefaultRegistry.widgets;

      return {
        fields: _objectSpread({}, fields, this.props.fields),
        widgets: _objectSpread({}, widgets, this.props.widgets),
        ArrayFieldTemplate: this.props.ArrayFieldTemplate,
        ObjectFieldTemplate: this.props.ObjectFieldTemplate,
        FieldTemplate: this.props.FieldTemplate,
        definitions: this.props.schema.definitions || {},
        rootSchema: this.props.schema,
        formContext: this.props.formContext || {}
      };
    }
  }, {
    key: "submit",
    value: function submit() {
      if (this.formElement) {
        this.formElement.dispatchEvent(new CustomEvent("submit", {
          cancelable: true
        }));
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props5 = this.props,
          children = _this$props5.children,
          id = _this$props5.id,
          idPrefix = _this$props5.idPrefix,
          idSeparator = _this$props5.idSeparator,
          className = _this$props5.className,
          tagName = _this$props5.tagName,
          name = _this$props5.name,
          method = _this$props5.method,
          target = _this$props5.target,
          action = _this$props5.action,
          deprecatedAutocomplete = _this$props5.autocomplete,
          currentAutoComplete = _this$props5.autoComplete,
          enctype = _this$props5.enctype,
          acceptcharset = _this$props5.acceptcharset,
          noHtml5Validate = _this$props5.noHtml5Validate,
          disabled = _this$props5.disabled,
          readonly = _this$props5.readonly,
          formContext = _this$props5.formContext,
          _internalFormWrapper = _this$props5._internalFormWrapper;
      var _this$state2 = this.state,
          schema = _this$state2.schema,
          uiSchema = _this$state2.uiSchema,
          formData = _this$state2.formData,
          errorSchema = _this$state2.errorSchema,
          idSchema = _this$state2.idSchema;
      var registry = this.getRegistry();
      var _SchemaField = registry.fields.SchemaField; // The `semantic-ui` and `material-ui` themes have `_internalFormWrapper`s that take an `as` prop that is the
      // PropTypes.elementType to use for the inner tag so we'll need to pass `tagName` along if it is provided.
      // NOTE, the `as` prop is native to `semantic-ui` and is emulated in the `material-ui` theme

      var as = _internalFormWrapper ? tagName : undefined;
      var FormTag = _internalFormWrapper || tagName || "form";
      var SubmitButton = registry.widgets.SubmitButton;

      if (deprecatedAutocomplete) {
        console.warn("Using autocomplete property of Form is deprecated, use autoComplete instead.");
      }

      var autoComplete = currentAutoComplete ? currentAutoComplete : deprecatedAutocomplete;
      return _react["default"].createElement(FormTag, {
        className: className ? className : "rjsf",
        id: id,
        name: name,
        method: method,
        target: target,
        action: action,
        autoComplete: autoComplete,
        encType: enctype,
        acceptCharset: acceptcharset,
        noValidate: noHtml5Validate,
        onSubmit: this.onSubmit,
        as: as,
        ref: function ref(form) {
          _this2.formElement = form;
        }
      }, this.renderErrors(), _react["default"].createElement(_SchemaField, {
        schema: schema,
        uiSchema: uiSchema,
        errorSchema: errorSchema,
        idSchema: idSchema,
        idPrefix: idPrefix,
        idSeparator: idSeparator,
        formContext: formContext,
        formData: formData,
        onChange: this.onChange,
        onBlur: this.onBlur,
        onFocus: this.onFocus,
        registry: registry,
        disabled: disabled,
        readonly: readonly
      }), children ? children : _react["default"].createElement(SubmitButton, {
        uiSchema: uiSchema
      }));
    }
  }]);

  return Form;
}(_react.Component);

exports["default"] = Form;

_defineProperty(Form, "defaultProps", {
  uiSchema: {},
  noValidate: false,
  liveValidate: false,
  disabled: false,
  readonly: false,
  noHtml5Validate: false,
  ErrorList: _ErrorList["default"],
  omitExtraData: false
});

if (process.env.NODE_ENV !== "production") {
  Form.propTypes = {
    schema: _propTypes["default"].object.isRequired,
    uiSchema: _propTypes["default"].object,
    formData: _propTypes["default"].any,
    disabled: _propTypes["default"].bool,
    readonly: _propTypes["default"].bool,
    widgets: _propTypes["default"].objectOf(_propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].object])),
    fields: _propTypes["default"].objectOf(_propTypes["default"].elementType),
    ArrayFieldTemplate: _propTypes["default"].elementType,
    ObjectFieldTemplate: _propTypes["default"].elementType,
    FieldTemplate: _propTypes["default"].elementType,
    ErrorList: _propTypes["default"].func,
    onChange: _propTypes["default"].func,
    onError: _propTypes["default"].func,
    showErrorList: _propTypes["default"].bool,
    onSubmit: _propTypes["default"].func,
    id: _propTypes["default"].string,
    className: _propTypes["default"].string,
    tagName: _propTypes["default"].elementType,
    _internalFormWrapper: _propTypes["default"].elementType,
    name: _propTypes["default"].string,
    method: _propTypes["default"].string,
    target: _propTypes["default"].string,
    action: _propTypes["default"].string,
    autocomplete: _propTypes["default"].string,
    autoComplete: _propTypes["default"].string,
    enctype: _propTypes["default"].string,
    acceptcharset: _propTypes["default"].string,
    noValidate: _propTypes["default"].bool,
    noHtml5Validate: _propTypes["default"].bool,
    liveValidate: _propTypes["default"].bool,
    validate: _propTypes["default"].func,
    transformErrors: _propTypes["default"].func,
    formContext: _propTypes["default"].object,
    customFormats: _propTypes["default"].object,
    additionalMetaSchemas: _propTypes["default"].arrayOf(_propTypes["default"].object),
    omitExtraData: _propTypes["default"].bool,
    extraErrors: _propTypes["default"].object
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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