//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.8
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * An enumeration representing the different types of log messages.
 **/
public enum LogMessageType implements java.io.Serializable
{
    /**
     * The {@link Logger} received a print message.
     **/
    PrintMessage(0),
    /**
     * The {@link Logger} received a trace message.
     **/
    TraceMessage(1),
    /**
     * The {@link Logger} received a warning message.
     **/
    WarningMessage(2),
    /**
     * The {@link Logger} received an error message.
     **/
    ErrorMessage(3);

    public int value()
    {
        return _value;
    }

    public static LogMessageType valueOf(int v)
    {
        switch(v)
        {
        case 0:
            return PrintMessage;
        case 1:
            return TraceMessage;
        case 2:
            return WarningMessage;
        case 3:
            return ErrorMessage;
        }
        return null;
    }

    private LogMessageType(int v)
    {
        _value = v;
    }

    public void ice_write(OutputStream ostr)
    {
        ostr.writeEnum(_value, 3);
    }

    public static void ice_write(OutputStream ostr, LogMessageType v)
    {
        if(v == null)
        {
            ostr.writeEnum(com.zeroc.Ice.LogMessageType.PrintMessage.value(), 3);
        }
        else
        {
            ostr.writeEnum(v.value(), 3);
        }
    }

    public static LogMessageType ice_read(InputStream istr)
    {
        int v = istr.readEnum(3);
        return validate(v);
    }

    public static void ice_write(OutputStream ostr, int tag, java.util.Optional<LogMessageType> v)
    {
        if(v != null && v.isPresent())
        {
            ice_write(ostr, tag, v.get());
        }
    }

    public static void ice_write(OutputStream ostr, int tag, LogMessageType v)
    {
        if(ostr.writeOptional(tag, com.zeroc.Ice.OptionalFormat.Size))
        {
            ice_write(ostr, v);
        }
    }

    public static java.util.Optional<LogMessageType> ice_read(InputStream istr, int tag)
    {
        if(istr.readOptional(tag, com.zeroc.Ice.OptionalFormat.Size))
        {
            return java.util.Optional.of(ice_read(istr));
        }
        else
        {
            return java.util.Optional.empty();
        }
    }

    private static LogMessageType validate(int v)
    {
        final LogMessageType e = valueOf(v);
        if(e == null)
        {
            throw new MarshalException("enumerator value " + v + " is out of range");
        }
        return e;
    }

    private final int _value;
}
