//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.8
//
// <auto-generated>
//
// Generated from file `FileParser.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * <code>icegridadmin</code> provides a {@link FileParser}
 * object to transform XML files into {@link ApplicationDescriptor}
 * objects.
 **/
public interface FileParserPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @return The application descriptor.
     * @throws ParseException Raised if an error occurred during parsing.
     **/
    default ApplicationDescriptor parse(String xmlFile, AdminPrx adminProxy)
        throws ParseException
    {
        return parse(xmlFile, adminProxy, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param context The Context map to send with the invocation.
     * @return The application descriptor.
     * @throws ParseException Raised if an error occurred during parsing.
     **/
    default ApplicationDescriptor parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> context)
        throws ParseException
    {
        try
        {
            return _iceI_parseAsync(xmlFile, adminProxy, context, true).waitForResponseOrUserEx();
        }
        catch(ParseException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @return The application descriptor.
     **/
    default java.util.concurrent.CompletableFuture<ApplicationDescriptor> parseAsync(String xmlFile, AdminPrx adminProxy)
    {
        return _iceI_parseAsync(xmlFile, adminProxy, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Parse a file.
     * @param xmlFile Full pathname to the file.
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * @param context The Context map to send with the invocation.
     * @return The application descriptor.
     **/
    default java.util.concurrent.CompletableFuture<ApplicationDescriptor> parseAsync(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> context)
    {
        return _iceI_parseAsync(xmlFile, adminProxy, context, false);
    }

    /**
     * @hidden
     * @param iceP_xmlFile -
     * @param iceP_adminProxy -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<ApplicationDescriptor> _iceI_parseAsync(String iceP_xmlFile, AdminPrx iceP_adminProxy, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<ApplicationDescriptor> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "parse", com.zeroc.Ice.OperationMode.Idempotent, sync, _iceE_parse);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_xmlFile);
                     ostr.writeProxy(iceP_adminProxy);
                 }, istr -> {
                     ApplicationDescriptor ret;
                     ret = ApplicationDescriptor.ice_read(istr);
                     istr.readPendingValues();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_parse =
    {
        ParseException.class
    };

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileParserPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), FileParserPrx.class, _FileParserPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileParserPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), FileParserPrx.class, _FileParserPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileParserPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), FileParserPrx.class, _FileParserPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static FileParserPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), FileParserPrx.class, _FileParserPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static FileParserPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, FileParserPrx.class, _FileParserPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static FileParserPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, FileParserPrx.class, _FileParserPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default FileParserPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (FileParserPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default FileParserPrx ice_adapterId(String newAdapterId)
    {
        return (FileParserPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default FileParserPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (FileParserPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default FileParserPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (FileParserPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default FileParserPrx ice_invocationTimeout(int newTimeout)
    {
        return (FileParserPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default FileParserPrx ice_connectionCached(boolean newCache)
    {
        return (FileParserPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default FileParserPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (FileParserPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default FileParserPrx ice_secure(boolean b)
    {
        return (FileParserPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default FileParserPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (FileParserPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default FileParserPrx ice_preferSecure(boolean b)
    {
        return (FileParserPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default FileParserPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (FileParserPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default FileParserPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (FileParserPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default FileParserPrx ice_collocationOptimized(boolean b)
    {
        return (FileParserPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default FileParserPrx ice_twoway()
    {
        return (FileParserPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default FileParserPrx ice_oneway()
    {
        return (FileParserPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default FileParserPrx ice_batchOneway()
    {
        return (FileParserPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default FileParserPrx ice_datagram()
    {
        return (FileParserPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default FileParserPrx ice_batchDatagram()
    {
        return (FileParserPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default FileParserPrx ice_compress(boolean co)
    {
        return (FileParserPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default FileParserPrx ice_timeout(int t)
    {
        return (FileParserPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default FileParserPrx ice_connectionId(String connectionId)
    {
        return (FileParserPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default FileParserPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (FileParserPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceGrid::FileParser";
    }
}
