/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.SelectableHttpMessagesContainer;
import org.zaproxy.zap.view.messagecontainer.http.SingleHttpMessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuComponent;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuItemMessageContainer;

public abstract class PopupMenuItemHttpMessageContainer
extends ExtensionPopupMenuItemMessageContainer {
    private static final long serialVersionUID = -4769111731197641466L;
    private static final Logger logger = LogManager.getLogger(PopupMenuItemHttpMessageContainer.class);
    private Invoker invoker = null;
    private HttpMessageContainer httpMessageContainer = null;
    private final boolean multiSelect;

    public PopupMenuItemHttpMessageContainer(String label) {
        this(label, false);
    }

    public PopupMenuItemHttpMessageContainer(String label, boolean multiSelect) {
        super(label);
        this.multiSelect = multiSelect;
        this.addActionListener(new PerformActionsActionListener());
    }

    protected boolean isMultiSelect() {
        return this.multiSelect;
    }

    protected Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> messageContainer) {
        this.resetState();
        if (!(messageContainer instanceof HttpMessageContainer)) {
            return false;
        }
        HttpMessageContainer httpMessageContainer = (HttpMessageContainer)messageContainer;
        if (!this.isEnable(httpMessageContainer)) {
            return false;
        }
        this.invoker = PopupMenuItemHttpMessageContainer.getInvoker(httpMessageContainer);
        if (!this.isEnableForInvoker(this.invoker, httpMessageContainer)) {
            this.invoker = null;
            return false;
        }
        boolean enabled = this.isButtonEnabledForHttpMessageContainerState(httpMessageContainer);
        if (enabled && !this.isSafe()) {
            Control.Mode mode = Control.getSingleton().getMode();
            if (mode.equals((Object)Control.Mode.protect)) {
                enabled = this.isSelectedMessagesInSessionScope(httpMessageContainer);
            } else if (mode.equals((Object)Control.Mode.safe)) {
                enabled = false;
            }
        }
        if (enabled) {
            this.httpMessageContainer = httpMessageContainer;
        }
        this.setEnabled(enabled);
        return true;
    }

    @Override
    public void dismissed(ExtensionPopupMenuComponent selectedMenuComponent) {
        super.dismissed(selectedMenuComponent);
        if (this != selectedMenuComponent) {
            this.resetState();
        }
    }

    private void resetState() {
        this.invoker = null;
        this.httpMessageContainer = null;
    }

    protected boolean isEnable(HttpMessageContainer httpMessageContainer) {
        return httpMessageContainer instanceof SelectableHttpMessagesContainer || httpMessageContainer instanceof SingleHttpMessageContainer;
    }

    private static Invoker getInvoker(HttpMessageContainer httpMessageContainer) {
        Invoker invoker;
        switch (httpMessageContainer.getName()) {
            case "History Table": {
                invoker = Invoker.HISTORY_PANEL;
                break;
            }
            case "treeSite": {
                invoker = Invoker.SITES_PANEL;
                break;
            }
            case "treeAlert": {
                invoker = Invoker.ALERTS_PANEL;
                break;
            }
            case "SearchHttpMessageContainer": {
                invoker = Invoker.SEARCH_PANEL;
                break;
            }
            case "SpiderHttpMessageContainer": {
                invoker = Invoker.SPIDER_PANEL;
                break;
            }
            case "ActiveScanMessageContainer": {
                invoker = Invoker.ACTIVE_SCANNER_PANEL;
                break;
            }
            case "ForcedBrowseMessageContainer": {
                invoker = Invoker.FORCED_BROWSE_PANEL;
                break;
            }
            case "fuzz.httpfuzzerResultsContentPanel": {
                invoker = Invoker.FUZZER_PANEL;
                break;
            }
            default: {
                invoker = Invoker.UNKNOWN;
            }
        }
        return invoker;
    }

    protected boolean isEnableForInvoker(Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return true;
    }

    protected boolean isButtonEnabledForHttpMessageContainerState(HttpMessageContainer httpMessageContainer) {
        boolean enabled = this.isButtonEnabledForNumberOfSelectedMessages(httpMessageContainer);
        if (enabled) {
            enabled = this.isButtonEnabledForSelectedMessages(httpMessageContainer);
        }
        return enabled;
    }

    protected boolean isButtonEnabledForNumberOfSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForNumberOfSelectedMessages(this.getNumberOfSelectedMessages(httpMessageContainer));
    }

    protected boolean isButtonEnabledForSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForSelectedMessages(this.getSelectedMessages(httpMessageContainer));
    }

    protected int getNumberOfSelectedMessages(HttpMessageContainer httpMessageContainer) {
        if (httpMessageContainer instanceof SelectableHttpMessagesContainer) {
            return ((SelectableHttpMessagesContainer)httpMessageContainer).getNumberOfSelectedMessages();
        }
        if (httpMessageContainer instanceof SingleHttpMessageContainer) {
            return ((SingleHttpMessageContainer)httpMessageContainer).isEmpty() ? 0 : 1;
        }
        return 0;
    }

    protected boolean isButtonEnabledForNumberOfSelectedMessages(int numberOfSelectedMessages) {
        if (numberOfSelectedMessages == 0) {
            return false;
        }
        return numberOfSelectedMessages <= 1 || this.isMultiSelect();
    }

    protected List<HttpMessage> getSelectedMessages(HttpMessageContainer httpMessageContainer) {
        SingleHttpMessageContainer singleMessageContainer;
        if (httpMessageContainer instanceof SelectableHttpMessagesContainer) {
            return ((SelectableHttpMessagesContainer)httpMessageContainer).getSelectedMessages();
        }
        if (httpMessageContainer instanceof SingleHttpMessageContainer && !(singleMessageContainer = (SingleHttpMessageContainer)httpMessageContainer).isEmpty()) {
            ArrayList<HttpMessage> selectedHttpMessages = new ArrayList<HttpMessage>(1);
            selectedHttpMessages.add((HttpMessage)((SingleHttpMessageContainer)httpMessageContainer).getMessage());
            return selectedHttpMessages;
        }
        return Collections.emptyList();
    }

    protected boolean isButtonEnabledForSelectedMessages(List<HttpMessage> httpMessages) {
        for (HttpMessage httpMessage : httpMessages) {
            if (httpMessage == null || this.isButtonEnabledForSelectedHttpMessage(httpMessage)) continue;
            return false;
        }
        return true;
    }

    protected boolean isButtonEnabledForSelectedHttpMessage(HttpMessage httpMessage) {
        return true;
    }

    protected boolean isSelectedMessagesInSessionScope(HttpMessageContainer httpMessageContainer) {
        for (HttpMessage httpMessage : this.getSelectedMessages(httpMessageContainer)) {
            if (httpMessage == null || httpMessage.isInScope()) continue;
            return false;
        }
        return true;
    }

    protected void performActions(HttpMessageContainer httpMessageContainer) {
        this.performActions(this.getSelectedMessages(httpMessageContainer));
    }

    protected void performActions(List<HttpMessage> httpMessages) {
        for (HttpMessage httpMessage : httpMessages) {
            if (httpMessage == null) continue;
            this.performAction(httpMessage);
        }
    }

    protected abstract void performAction(HttpMessage var1);

    private class PerformActionsActionListener
    implements ActionListener {
        private PerformActionsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug("actionPerformed " + (PopupMenuItemHttpMessageContainer.this.invoker != null ? PopupMenuItemHttpMessageContainer.this.invoker.name() : "null invoker") + " " + evt.getActionCommand());
            }
            try {
                PopupMenuItemHttpMessageContainer.this.performActions(PopupMenuItemHttpMessageContainer.this.httpMessageContainer);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            PopupMenuItemHttpMessageContainer.this.resetState();
        }
    }

    protected static enum Invoker {
        SITES_PANEL,
        HISTORY_PANEL,
        ALERTS_PANEL,
        ACTIVE_SCANNER_PANEL,
        SEARCH_PANEL,
        SPIDER_PANEL,
        FUZZER_PANEL,
        FORCED_BROWSE_PANEL,
        UNKNOWN;

    }
}

