/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.script.DefaultEngineWrapper;
import org.zaproxy.zap.extension.script.HttpSenderScript;
import org.zaproxy.zap.extension.script.HttpSenderScriptHelper;
import org.zaproxy.zap.extension.script.HttpSenderScriptListener;
import org.zaproxy.zap.extension.script.JavascriptEngineWrapper;
import org.zaproxy.zap.extension.script.MultipleWriters;
import org.zaproxy.zap.extension.script.OptionsScriptPanel;
import org.zaproxy.zap.extension.script.ProxyListenerScript;
import org.zaproxy.zap.extension.script.ProxyScript;
import org.zaproxy.zap.extension.script.ScriptAPI;
import org.zaproxy.zap.extension.script.ScriptEngineWrapper;
import org.zaproxy.zap.extension.script.ScriptEventListener;
import org.zaproxy.zap.extension.script.ScriptNode;
import org.zaproxy.zap.extension.script.ScriptOutputListener;
import org.zaproxy.zap.extension.script.ScriptParam;
import org.zaproxy.zap.extension.script.ScriptTreeModel;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptUI;
import org.zaproxy.zap.extension.script.ScriptVars;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.extension.script.ScriptsCache;
import org.zaproxy.zap.extension.script.TargetedScript;
import org.zaproxy.zap.utils.Stats;

public class ExtensionScript
extends ExtensionAdaptor
implements CommandLineListener {
    public static final int EXTENSION_ORDER = 60;
    public static final String NAME = "ExtensionScript";
    @Deprecated
    public static final ImageIcon ICON = View.isInitialised() ? ExtensionScript.getScriptIcon() : null;
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static ImageIcon scriptIcon;
    public static final String SCRIPTS_DIR = "scripts";
    public static final String TEMPLATES_DIR;
    private static final String LANG_ENGINE_SEP = " : ";
    @Deprecated
    protected static final String SCRIPT_CONSOLE_HOME_PAGE = "https://github.com/zaproxy/zaproxy/wiki/ScriptConsole";
    protected static final String SCRIPT_NAME_ATT = "zap.script.name";
    public static final String TYPE_HTTP_SENDER = "httpsender";
    public static final String TYPE_PROXY = "proxy";
    public static final String TYPE_STANDALONE = "standalone";
    public static final String TYPE_TARGETED = "targeted";
    private ScriptEngineManager mgr = new ScriptEngineManager();
    private ScriptParam scriptParam = null;
    private OptionsScriptPanel optionsScriptPanel = null;
    private ScriptTreeModel treeModel = null;
    private List<ScriptEngineWrapper> engineWrappers = new ArrayList<ScriptEngineWrapper>();
    private Map<String, ScriptType> typeMap = new HashMap<String, ScriptType>();
    private ProxyListenerScript proxyListener = null;
    private HttpSenderScriptListener httpSenderScriptListener;
    private List<ScriptEventListener> listeners = new ArrayList<ScriptEventListener>();
    private MultipleWriters writers = new MultipleWriters();
    private ScriptUI scriptUI = null;
    private CommandLineArgument[] arguments = new CommandLineArgument[1];
    private static final int ARG_SCRIPT_IDX = 0;
    private static final Logger logger;
    private boolean shouldLoadScriptsOnScriptTypeRegistration;
    private List<File> trackedDirs = Collections.synchronizedList(new ArrayList());
    private List<ScriptOutputListener> outputListeners = new CopyOnWriteArrayList<ScriptOutputListener>();

    public ExtensionScript() {
        super(NAME);
        this.setOrder(60);
        ScriptEngine se = this.mgr.getEngineByName("ECMAScript");
        if (se != null) {
            this.registerScriptEngineWrapper(new JavascriptEngineWrapper(se.getFactory()));
        } else {
            logger.warn("No default JavaScript/ECMAScript engine found, some scripts might no longer work.");
        }
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("script.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        this.registerScriptType(new ScriptType(TYPE_PROXY, "script.type.proxy", this.createIcon("/resource/icon/16/script-proxy.png"), true));
        this.registerScriptType(new ScriptType(TYPE_STANDALONE, "script.type.standalone", this.createIcon("/resource/icon/16/script-standalone.png"), false, new String[]{"append"}));
        this.registerScriptType(new ScriptType(TYPE_TARGETED, "script.type.targeted", this.createIcon("/resource/icon/16/script-targeted.png"), false));
        this.registerScriptType(new ScriptType(TYPE_HTTP_SENDER, "script.type.httpsender", this.createIcon("/resource/icon/16/script-httpsender.png"), true));
        extensionHook.addSessionListener(new ClearScriptVarsOnSessionChange());
        extensionHook.addProxyListener(this.getProxyListener());
        extensionHook.addHttpSenderListener(this.getHttpSenderScriptListener());
        extensionHook.addOptionsParamSet(this.getScriptParam());
        extensionHook.addCommandLine(this.getCommandLineArguments());
        if (this.hasView()) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsScriptPanel());
        } else {
            this.addWriter(new PrintWriter(System.out));
        }
        extensionHook.addApiImplementor(new ScriptAPI(this));
    }

    private ImageIcon createIcon(String resourcePath) {
        if (this.getView() == null) {
            return null;
        }
        return new ImageIcon(ExtensionScript.class.getResource(resourcePath));
    }

    private OptionsScriptPanel getOptionsScriptPanel() {
        if (this.optionsScriptPanel == null) {
            this.optionsScriptPanel = new OptionsScriptPanel(this);
        }
        return this.optionsScriptPanel;
    }

    private ProxyListenerScript getProxyListener() {
        if (this.proxyListener == null) {
            this.proxyListener = new ProxyListenerScript(this);
        }
        return this.proxyListener;
    }

    private HttpSenderScriptListener getHttpSenderScriptListener() {
        if (this.httpSenderScriptListener == null) {
            this.httpSenderScriptListener = new HttpSenderScriptListener(this);
        }
        return this.httpSenderScriptListener;
    }

    public List<String> getScriptingEngines() {
        ArrayList<String> engineNames = new ArrayList<String>();
        List<ScriptEngineFactory> engines = this.mgr.getEngineFactories();
        for (ScriptEngineFactory engine : engines) {
            engineNames.add(engine.getLanguageName() + LANG_ENGINE_SEP + engine.getEngineName());
        }
        for (ScriptEngineWrapper sew : this.engineWrappers) {
            if (!sew.isVisible() || engines.contains(sew.getFactory())) continue;
            engineNames.add(sew.getLanguageName() + LANG_ENGINE_SEP + sew.getEngineName());
        }
        Collections.sort(engineNames);
        return engineNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerScriptEngineWrapper(ScriptEngineWrapper wrapper) {
        logger.debug("registerEngineWrapper " + wrapper.getLanguageName() + LANG_ENGINE_SEP + wrapper.getEngineName());
        this.engineWrappers.add(wrapper);
        this.setScriptEngineWrapper(this.getTreeModel().getScriptsNode(), wrapper, wrapper);
        this.setScriptEngineWrapper(this.getTreeModel().getTemplatesNode(), wrapper, wrapper);
        this.loadTemplates(wrapper);
        List<File> list = this.trackedDirs;
        synchronized (list) {
            String engineName = wrapper.getLanguageName() + LANG_ENGINE_SEP + wrapper.getEngineName();
            for (File dir : this.trackedDirs) {
                for (ScriptType type : this.getScriptTypes()) {
                    this.addScriptsFromDir(dir, type, engineName);
                }
            }
        }
        if (this.scriptUI != null) {
            try {
                this.scriptUI.engineAdded(wrapper);
            }
            catch (Exception e) {
                logger.error("An error occurred while notifying ScriptUI:", (Throwable)e);
            }
        }
    }

    private void setScriptEngineWrapper(ScriptNode baseNode, ScriptEngineWrapper engineWrapper, ScriptEngineWrapper newEngineWrapper) {
        Enumeration<TreeNode> e = baseNode.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            ScriptWrapper scriptWrapper;
            ScriptNode node = (ScriptNode)e.nextElement();
            if (node.getUserObject() == null || !(node.getUserObject() instanceof ScriptWrapper) || !ExtensionScript.hasSameScriptEngine(scriptWrapper = (ScriptWrapper)node.getUserObject(), engineWrapper)) continue;
            scriptWrapper.setEngine(newEngineWrapper);
            if (newEngineWrapper == null) {
                if (!scriptWrapper.isEnabled()) continue;
                this.setEnabled(scriptWrapper, false);
                scriptWrapper.setPreviouslyEnabled(true);
                continue;
            }
            if (!scriptWrapper.isPreviouslyEnabled()) continue;
            this.setEnabled(scriptWrapper, true);
            scriptWrapper.setPreviouslyEnabled(false);
        }
    }

    public static boolean hasSameScriptEngine(ScriptWrapper scriptWrapper, ScriptEngineWrapper engineWrapper) {
        if (scriptWrapper.getEngine() != null) {
            return scriptWrapper.getEngine() == engineWrapper;
        }
        return ExtensionScript.isSameScriptEngine(scriptWrapper.getEngineName(), engineWrapper.getEngineName(), engineWrapper.getLanguageName());
    }

    public static boolean isSameScriptEngine(String name, String engineName, String engineLanguage) {
        if (name == null) {
            return false;
        }
        if (name.indexOf(LANG_ENGINE_SEP) > 0) {
            return name.equals(engineLanguage + LANG_ENGINE_SEP + engineName);
        }
        return name.equals(engineName);
    }

    public void removeScriptEngineWrapper(ScriptEngineWrapper wrapper) {
        logger.debug("Removing script engine: " + wrapper.getLanguageName() + LANG_ENGINE_SEP + wrapper.getEngineName());
        if (this.engineWrappers.remove(wrapper)) {
            if (this.scriptUI != null) {
                try {
                    this.scriptUI.engineRemoved(wrapper);
                }
                catch (Exception e) {
                    logger.error("An error occurred while notifying ScriptUI:", (Throwable)e);
                }
            }
            this.setScriptEngineWrapper(this.getTreeModel().getScriptsNode(), wrapper, null);
            this.processTemplatesOfRemovedEngine(this.getTreeModel().getTemplatesNode(), wrapper);
        }
    }

    private void processTemplatesOfRemovedEngine(ScriptNode baseNode, ScriptEngineWrapper engineWrapper) {
        ArrayList<TreeNode> templateNodes = Collections.list(baseNode.depthFirstEnumeration());
        for (TreeNode tpNode : templateNodes) {
            ScriptWrapper scriptWrapper;
            ScriptNode node = (ScriptNode)tpNode;
            if (node.getUserObject() == null || !(node.getUserObject() instanceof ScriptWrapper) || !ExtensionScript.hasSameScriptEngine(scriptWrapper = (ScriptWrapper)node.getUserObject(), engineWrapper)) continue;
            if (engineWrapper.isDefaultTemplate(scriptWrapper)) {
                this.removeTemplate(scriptWrapper);
                continue;
            }
            scriptWrapper.setEngine(null);
            this.getTreeModel().nodeStructureChanged(scriptWrapper);
        }
    }

    public ScriptEngineWrapper getEngineWrapper(String name) {
        ScriptEngineWrapper sew = this.getEngineWrapperImpl(name);
        if (sew == null) {
            throw new InvalidParameterException("No such engine: " + name);
        }
        return sew;
    }

    private ScriptEngineWrapper getEngineWrapperImpl(String name) {
        for (ScriptEngineWrapper sew : this.engineWrappers) {
            if (!ExtensionScript.isSameScriptEngine(name, sew.getEngineName(), sew.getLanguageName())) continue;
            return sew;
        }
        List<ScriptEngineFactory> engines = this.mgr.getEngineFactories();
        ScriptEngine engine = null;
        for (ScriptEngineFactory e : engines) {
            if (!ExtensionScript.isSameScriptEngine(name, e.getEngineName(), e.getLanguageName())) continue;
            engine = e.getScriptEngine();
            break;
        }
        if (engine != null) {
            DefaultEngineWrapper dew = new DefaultEngineWrapper(engine.getFactory());
            this.registerScriptEngineWrapper(dew);
            return dew;
        }
        return null;
    }

    public String getEngineNameForExtension(String ext) {
        ScriptEngine engine = this.mgr.getEngineByExtension(ext);
        if (engine != null) {
            return engine.getFactory().getLanguageName() + LANG_ENGINE_SEP + engine.getFactory().getEngineName();
        }
        for (ScriptEngineWrapper sew : this.engineWrappers) {
            if (sew.getExtensions() == null) continue;
            for (String extn : sew.getExtensions()) {
                if (!ext.equals(extn)) continue;
                return sew.getLanguageName() + LANG_ENGINE_SEP + sew.getEngineName();
            }
        }
        return null;
    }

    protected ScriptParam getScriptParam() {
        if (this.scriptParam == null) {
            this.scriptParam = new ScriptParam();
        }
        return this.scriptParam;
    }

    public ScriptTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new ScriptTreeModel();
        }
        return this.treeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerScriptType(ScriptType type) {
        if (this.typeMap.containsKey(type.getName())) {
            throw new InvalidParameterException("ScriptType already registered: " + type.getName());
        }
        this.typeMap.put(type.getName(), type);
        this.getTreeModel().addType(type);
        if (this.shouldLoadScriptsOnScriptTypeRegistration) {
            this.addScripts(type);
            this.loadScriptTemplates(type);
        }
        List<File> list = this.trackedDirs;
        synchronized (list) {
            for (File dir : this.trackedDirs) {
                this.addScriptsFromDir(dir, type, null);
            }
        }
    }

    private void addScripts(ScriptType type) {
        for (ScriptWrapper script : this.getScriptParam().getScripts()) {
            if (!type.getName().equals(script.getTypeName())) continue;
            try {
                this.loadScript(script);
                this.addScript(script, false, false);
            }
            catch (MalformedInputException e) {
                logger.warn("Failed to add script \"" + script.getName() + "\", contains invalid character sequence (UTF-8).");
            }
            catch (IOException | InvalidParameterException e) {
                logger.error("Failed to add script: " + script.getName(), (Throwable)e);
            }
        }
    }

    @Deprecated
    public void removeScripType(ScriptType type) {
        this.removeScriptType(type);
    }

    public void removeScriptType(ScriptType type) {
        ScriptType scriptType = this.typeMap.remove(type.getName());
        if (scriptType != null) {
            this.getTreeModel().removeType(scriptType);
        }
    }

    public ScriptType getScriptType(String name) {
        return this.typeMap.get(name);
    }

    public Collection<ScriptType> getScriptTypes() {
        return this.typeMap.values();
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("script.desc");
    }

    private void refreshScript(ScriptWrapper script) {
        for (ScriptEventListener listener : this.listeners) {
            try {
                listener.refreshScript(script);
            }
            catch (Exception e) {
                this.logScriptEventListenerException(listener, script, e);
            }
        }
    }

    private void reloadIfChangedOnDisk(ScriptWrapper script) {
        if (script.hasChangedOnDisk() && !script.isChanged()) {
            try {
                logger.debug("Reloading script as its been changed on disk " + script.getFile().getAbsolutePath());
                script.reloadScript();
            }
            catch (IOException e) {
                logger.error("Failed to reload script " + script.getFile().getAbsolutePath(), (Throwable)e);
            }
        }
    }

    public ScriptWrapper getScript(String name) {
        ScriptWrapper script = this.getScriptImpl(name);
        if (script != null) {
            this.refreshScript(script);
            this.reloadIfChangedOnDisk(script);
        }
        return script;
    }

    private ScriptWrapper getScriptImpl(String name) {
        return this.getTreeModel().getScript(name);
    }

    public ScriptNode addScript(ScriptWrapper script) {
        return this.addScript(script, true);
    }

    public ScriptNode addScript(ScriptWrapper script, boolean display) {
        return this.addScript(script, display, true);
    }

    private ScriptNode addScript(ScriptWrapper script, boolean display, boolean save) {
        if (script == null) {
            return null;
        }
        this.setEngine(script);
        ScriptNode node = this.getTreeModel().addScript(script);
        for (ScriptEventListener listener : this.listeners) {
            try {
                listener.scriptAdded(script, display);
            }
            catch (Exception e) {
                this.logScriptEventListenerException(listener, script, e);
            }
        }
        if (save && script.isLoadOnStart() && script.getFile() != null) {
            this.getScriptParam().addScript(script);
            this.getScriptParam().saveScripts();
        }
        return node;
    }

    private void logScriptEventListenerException(ScriptEventListener listener, ScriptWrapper script, Exception e) {
        String classname = listener.getClass().getCanonicalName();
        String scriptName = script.getName();
        logger.error("Error while notifying '" + classname + "' with script '" + scriptName + "', cause: " + e.getMessage(), (Throwable)e);
    }

    public void saveScript(ScriptWrapper script) throws IOException {
        this.refreshScript(script);
        script.saveScript();
        this.setChanged(script, false);
        this.getScriptParam().removeScript(script);
        this.getScriptParam().addScript(script);
        this.getScriptParam().saveScripts();
        for (ScriptEventListener listener : this.listeners) {
            try {
                listener.scriptSaved(script);
            }
            catch (Exception e) {
                this.logScriptEventListenerException(listener, script, e);
            }
        }
    }

    public void removeScript(ScriptWrapper script) {
        script.setLoadOnStart(false);
        this.getScriptParam().removeScript(script);
        this.getScriptParam().saveScripts();
        this.getTreeModel().removeScript(script);
        for (ScriptEventListener listener : this.listeners) {
            try {
                listener.scriptRemoved(script);
            }
            catch (Exception e) {
                this.logScriptEventListenerException(listener, script, e);
            }
        }
    }

    public void removeTemplate(ScriptWrapper template) {
        this.getTreeModel().removeTemplate(template);
        for (ScriptEventListener listener : this.listeners) {
            try {
                listener.templateRemoved(template);
            }
            catch (Exception e) {
                this.logScriptEventListenerException(listener, template, e);
            }
        }
    }

    public ScriptNode addTemplate(ScriptWrapper template) {
        return this.addTemplate(template, true);
    }

    public ScriptNode addTemplate(ScriptWrapper template, boolean display) {
        if (template == null) {
            return null;
        }
        ScriptNode node = this.getTreeModel().addTemplate(template);
        for (ScriptEventListener listener : this.listeners) {
            try {
                listener.templateAdded(template, display);
            }
            catch (Exception e) {
                this.logScriptEventListenerException(listener, template, e);
            }
        }
        return node;
    }

    @Override
    public void postInit() {
        ScriptEngineWrapper ecmaScriptEngineWrapper = null;
        ArrayList<String[]> scriptsNotAdded = new ArrayList<String[]>(1);
        for (ScriptWrapper script : this.getScriptParam().getScripts()) {
            if (script.getEngine() == null && ExtensionScript.isRhinoScriptEngine(script.getEngineName())) {
                if (ecmaScriptEngineWrapper == null) {
                    ecmaScriptEngineWrapper = this.getEcmaScriptEngineWrapper();
                }
                if (ecmaScriptEngineWrapper != null) {
                    logger.info("Changing [" + script.getName() + "] (ECMAScript) script engine from [" + script.getEngineName() + "] to [" + ecmaScriptEngineWrapper.getEngineName() + "].");
                    script.setEngine(ecmaScriptEngineWrapper);
                }
            }
            try {
                this.loadScript(script);
                if (script.getType() != null) {
                    this.addScript(script, false, false);
                    continue;
                }
                logger.warn("Failed to add script \"" + script.getName() + "\", provided script type \"" + script.getTypeName() + "\" not found, available: " + this.getScriptTypesNames());
                scriptsNotAdded.add(new String[]{script.getName(), script.getEngineName(), Constant.messages.getString("script.info.scriptsNotAdded.error.missingType", script.getTypeName())});
            }
            catch (MalformedInputException e) {
                logger.warn("Failed to add script \"" + script.getName() + "\", contains invalid character sequence (UTF-8).");
                scriptsNotAdded.add(new String[]{script.getName(), script.getEngineName(), Constant.messages.getString("script.info.scriptsNotAdded.error.invalidChars")});
            }
            catch (IOException | InvalidParameterException e) {
                logger.error(e.getMessage(), (Throwable)e);
                scriptsNotAdded.add(new String[]{script.getName(), script.getEngineName(), Constant.messages.getString("script.info.scriptsNotAdded.error.other")});
            }
        }
        this.informScriptsNotAdded(scriptsNotAdded);
        this.loadTemplates();
        for (File dir : this.getScriptParam().getScriptDirs()) {
            int numAdded = this.addScriptsFromDir(dir);
            logger.debug("Added " + numAdded + " scripts from dir: " + dir.getAbsolutePath());
        }
        this.shouldLoadScriptsOnScriptTypeRegistration = true;
        Path defaultScriptsDir = Paths.get(Constant.getZapHome(), SCRIPTS_DIR, SCRIPTS_DIR);
        for (ScriptType scriptType : this.typeMap.values()) {
            Path scriptTypeDir = defaultScriptsDir.resolve(scriptType.getName());
            if (!Files.notExists(scriptTypeDir, new LinkOption[0])) continue;
            try {
                Files.createDirectories(scriptTypeDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.warn("Failed to create directory for script type: " + scriptType.getName(), (Throwable)e);
            }
        }
    }

    private static boolean isRhinoScriptEngine(String engineName) {
        return "Mozilla Rhino".equals(engineName) || "Rhino".equals(engineName);
    }

    private ScriptEngineWrapper getEcmaScriptEngineWrapper() {
        for (ScriptEngineWrapper sew : this.engineWrappers) {
            if (!"ECMAScript".equals(sew.getLanguageName())) continue;
            return sew;
        }
        return null;
    }

    private List<String> getScriptTypesNames() {
        return this.getScriptTypes().stream().collect(ArrayList::new, (c, e) -> c.add(e.getName()), ArrayList::addAll);
    }

    private void informScriptsNotAdded(final List<String[]> scriptsNotAdded) {
        if (!this.hasView() || scriptsNotAdded.isEmpty()) {
            return;
        }
        final ArrayList<Object> optionPaneContents = new ArrayList<Object>(2);
        optionPaneContents.add(Constant.messages.getString("script.info.scriptsNotAdded.message"));
        JXTable table = new JXTable((TableModel)new AbstractTableModel(){
            private static final long serialVersionUID = -457689656746030560L;

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return Constant.messages.getString("script.info.scriptsNotAdded.table.column.scriptName");
                }
                if (column == 1) {
                    return Constant.messages.getString("script.info.scriptsNotAdded.table.column.scriptEngine");
                }
                return Constant.messages.getString("script.info.scriptsNotAdded.table.column.errorCause");
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return ((String[])scriptsNotAdded.get(rowIndex))[columnIndex];
            }

            @Override
            public int getRowCount() {
                return scriptsNotAdded.size();
            }

            @Override
            public int getColumnCount() {
                return 3;
            }
        });
        table.setColumnControlVisible(true);
        table.setVisibleRowCount(Math.min(scriptsNotAdded.size() + 1, 5));
        table.packAll();
        optionPaneContents.add(new JScrollPane((Component)table));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(ExtensionScript.this.getView().getMainFrame(), optionPaneContents.toArray(), "OWASP ZAP", 1);
            }
        });
    }

    public int addScriptsFromDir(File dir) {
        logger.debug("Adding scripts from dir: " + dir.getAbsolutePath());
        this.trackedDirs.add(dir);
        int addedScripts = 0;
        for (ScriptType type : this.getScriptTypes()) {
            addedScripts += this.addScriptsFromDir(dir, type, null);
        }
        return addedScripts;
    }

    private int addScriptsFromDir(File dir, ScriptType type, String targetEngineName) {
        int addedScripts = 0;
        File typeDir = new File(dir, type.getName());
        if (typeDir.exists()) {
            for (File f : typeDir.listFiles()) {
                String ext = f.getName().substring(f.getName().lastIndexOf(".") + 1);
                String engineName = this.getEngineNameForExtension(ext);
                if (engineName != null && (targetEngineName == null || engineName.equals(targetEngineName))) {
                    try {
                        ScriptWrapper sw;
                        String scriptName;
                        if (f.canWrite()) {
                            scriptName = this.getUniqueScriptName(f.getName(), ext);
                            logger.debug("Loading script " + scriptName);
                            sw = new ScriptWrapper(scriptName, "", this.getEngineWrapper(engineName), type, false, f);
                            this.loadScript(sw);
                            this.addScript(sw, false);
                        } else {
                            scriptName = this.getUniqueTemplateName(f.getName(), ext);
                            logger.debug("Loading script " + scriptName);
                            sw = new ScriptWrapper(scriptName, "", this.getEngineWrapper(engineName), type, false, f);
                            this.loadScript(sw);
                            this.addTemplate(sw, false);
                        }
                        ++addedScripts;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                logger.debug("Ignoring " + f.getName());
            }
        }
        return addedScripts;
    }

    public int removeScriptsFromDir(File dir) {
        logger.debug("Removing scripts from dir: " + dir.getAbsolutePath());
        this.trackedDirs.remove(dir);
        int removedScripts = 0;
        for (ScriptType type : this.getScriptTypes()) {
            File locDir = new File(dir, type.getName());
            if (!locDir.exists()) continue;
            for (ScriptWrapper sw : this.getScripts(type)) {
                if (!ExtensionScript.isSavedInDir(sw, locDir)) continue;
                this.removeScript(sw);
                ++removedScripts;
            }
            for (ScriptWrapper sw : this.getTemplates(type)) {
                if (!ExtensionScript.isSavedInDir(sw, locDir)) continue;
                this.removeTemplate(sw);
                ++removedScripts;
            }
        }
        return removedScripts;
    }

    private static boolean isSavedInDir(ScriptWrapper scriptWrapper, File directory) {
        File file = scriptWrapper.getFile();
        if (file == null) {
            return false;
        }
        return file.getParentFile().equals(directory);
    }

    public int getScriptCount(File dir) {
        int scripts = 0;
        for (ScriptType type : this.getScriptTypes()) {
            File locDir = new File(dir, type.getName());
            if (!locDir.exists()) continue;
            for (File f : locDir.listFiles()) {
                String ext = f.getName().substring(f.getName().lastIndexOf(".") + 1);
                String engineName = this.getEngineNameForExtension(ext);
                if (engineName == null) continue;
                ++scripts;
            }
        }
        return scripts;
    }

    private String getUniqueScriptName(String name, String ext) {
        if (this.getScriptImpl(name) == null) {
            return name;
        }
        String stub = name.substring(0, name.length() - ext.length() - 1);
        int index = 1;
        while (this.getScriptImpl(name = stub + "(" + ++index + ")." + ext) != null) {
        }
        return name;
    }

    private String getUniqueTemplateName(String name, String ext) {
        if (this.getTreeModel().getTemplate(name) == null) {
            return name;
        }
        String stub = name.substring(0, name.length() - ext.length() - 1);
        int index = 1;
        do {
            name = stub + "(" + ++index + ")." + ext;
        } while (this.getTreeModel().getTemplate(name) != null);
        return name;
    }

    private void loadTemplates() {
        this.loadTemplates(null);
    }

    private void loadTemplates(ScriptEngineWrapper engine) {
        for (ScriptType type : this.getScriptTypes()) {
            this.loadScriptTemplates(type, engine);
        }
    }

    private void loadScriptTemplates(ScriptType type) {
        this.loadScriptTemplates(type, null);
    }

    private void loadScriptTemplates(ScriptType type, ScriptEngineWrapper engine) {
        File locDir = new File(Constant.getZapHome() + File.separator + TEMPLATES_DIR + File.separator + type.getName());
        File stdDir = new File(Constant.getZapInstall() + File.separator + TEMPLATES_DIR + File.separator + type.getName());
        if (locDir.exists()) {
            for (File f : locDir.listFiles()) {
                this.loadTemplate(f, type, engine, false);
            }
        }
        if (stdDir.exists()) {
            for (File f : stdDir.listFiles()) {
                this.loadTemplate(f, type, engine, true);
            }
        }
    }

    private void loadTemplate(File f, ScriptType type, ScriptEngineWrapper engine, boolean ignoreDuplicates) {
        String ext;
        String engineName;
        if (f.getName().indexOf(".") > 0 && this.getTreeModel().getTemplate(f.getName()) == null && (engineName = this.getEngineNameForExtension(ext = f.getName().substring(f.getName().lastIndexOf(".") + 1))) != null && (engine == null || engine.getExtensions().contains(ext))) {
            try {
                ScriptWrapper template = new ScriptWrapper(f.getName(), "", this.getEngineWrapper(engineName), type, false, f);
                this.loadScript(template);
                this.addTemplate(template);
            }
            catch (InvalidParameterException e) {
                if (!ignoreDuplicates) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public ScriptWrapper loadScript(ScriptWrapper script) throws IOException {
        try {
            return this.loadScript(script, DEFAULT_CHARSET);
        }
        catch (MalformedInputException e) {
            if (Charset.defaultCharset() == DEFAULT_CHARSET) {
                throw e;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to load script [" + script.getName() + "] using [" + DEFAULT_CHARSET + "], falling back to [" + Charset.defaultCharset() + "].", (Throwable)e);
            }
            return this.loadScript(script, Charset.defaultCharset());
        }
    }

    public ScriptWrapper loadScript(ScriptWrapper script, Charset charset) throws IOException {
        if (script == null) {
            throw new IllegalArgumentException("Parameter script must not be null.");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Parameter charset must not be null.");
        }
        script.loadScript(charset);
        if (script.getType() == null) {
            script.setType(this.getScriptType(script.getTypeName()));
        }
        this.setEngine(script);
        return script;
    }

    private void setEngine(ScriptWrapper script) {
        if (script.getEngine() != null) {
            return;
        }
        ScriptEngineWrapper sew = this.getEngineWrapperImpl(script.getEngineName());
        if (sew == null) {
            return;
        }
        script.setEngine(sew);
    }

    public List<ScriptWrapper> getScripts(String type) {
        return this.getScripts(this.getScriptType(type));
    }

    public List<ScriptWrapper> getScripts(ScriptType type) {
        ArrayList<ScriptWrapper> scripts = new ArrayList<ScriptWrapper>();
        if (type == null) {
            return scripts;
        }
        for (ScriptNode node : this.getTreeModel().getNodes(type.getName())) {
            ScriptWrapper script = (ScriptWrapper)node.getUserObject();
            this.refreshScript(script);
            scripts.add((ScriptWrapper)node.getUserObject());
        }
        return scripts;
    }

    public List<ScriptWrapper> getTemplates(ScriptType type) {
        ArrayList<ScriptWrapper> scripts = new ArrayList<ScriptWrapper>();
        if (type == null) {
            return scripts;
        }
        for (ScriptWrapper script : this.getTreeModel().getTemplates(type)) {
            scripts.add(script);
        }
        return scripts;
    }

    private Writer getWriters(ScriptWrapper script) {
        MultipleWriters delegatee = this.writers;
        Writer writer = script.getWriter();
        if (writer != null) {
            MultipleWriters scriptWriters = new MultipleWriters();
            scriptWriters.addWriter(writer);
            scriptWriters.addWriter(this.writers);
            delegatee = scriptWriters;
        }
        return new ScriptWriter(script, delegatee, this.outputListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invocable invokeScript(ScriptWrapper script) throws ScriptException {
        logger.debug("invokeScript " + script.getName());
        this.preInvokeScript(script);
        ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ExtensionFactory.getAddOnLoader());
        try {
            Invocable invocable = this.invokeScriptImpl(script);
            return invocable;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContextClassLoader);
        }
    }

    private void preInvokeScript(ScriptWrapper script) throws ScriptException {
        this.setEngine(script);
        if (script.getEngine() == null) {
            throw new ScriptException("Failed to find script engine: " + script.getEngineName());
        }
        this.refreshScript(script);
        script.setLastErrorDetails("");
        script.setLastException(null);
        script.setLastOutput("");
        for (ScriptEventListener listener : this.listeners) {
            try {
                listener.preInvoke(script);
            }
            catch (Exception e) {
                this.logScriptEventListenerException(listener, script, e);
            }
        }
    }

    private Invocable invokeScriptImpl(ScriptWrapper script) {
        ScriptEngine se = script.getEngine().getEngine();
        Writer writer = this.getWriters(script);
        se.getContext().setWriter(writer);
        se.getContext().setAttribute(SCRIPT_NAME_ATT, script.getName(), 100);
        this.reloadIfChangedOnDisk(script);
        ExtensionScript.recordScriptCalledStats(script);
        try {
            se.eval(script.getContents());
        }
        catch (Exception e) {
            this.handleScriptException(script, writer, e);
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            if (e.getCause() instanceof Exception) {
                this.handleScriptException(script, writer, (Exception)e.getCause());
            }
            this.handleUnspecifiedScriptError(script, writer, e.getMessage());
        }
        if (se instanceof Invocable) {
            return (Invocable)((Object)se);
        }
        return null;
    }

    public Invocable invokeScriptWithOutAddOnLoader(ScriptWrapper script) throws ScriptException {
        logger.debug("invokeScriptWithOutAddOnLoader " + script.getName());
        this.preInvokeScript(script);
        return this.invokeScriptImpl(script);
    }

    public void handleScriptException(ScriptWrapper script, Exception exception) {
        this.handleScriptException(script, this.getWriters(script), exception);
    }

    private void handleScriptException(ScriptWrapper script, Writer writer, Exception exception) {
        ExtensionScript.recordScriptFailedStats(script);
        Exception cause = exception;
        if (cause instanceof ScriptException && cause.getCause() instanceof Exception) {
            cause = (Exception)cause.getCause();
        }
        try {
            writer.append(cause.toString());
        }
        catch (IOException ignore) {
            logger.error(cause.getMessage(), (Throwable)cause);
        }
        this.setError(script, cause);
        this.setEnabled(script, false);
    }

    public void handleScriptError(ScriptWrapper script, String error) {
        ExtensionScript.recordScriptFailedStats(script);
        try {
            this.getWriters(script).append(error);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setError(script, error);
        this.setEnabled(script, false);
    }

    public void invokeTargetedScript(ScriptWrapper script, HttpMessage msg) {
        ExtensionScript.validateScriptType(script, TYPE_TARGETED);
        Writer writer = this.getWriters(script);
        try {
            TargetedScript s = this.getInterface(script, TargetedScript.class);
            if (s != null) {
                ExtensionScript.recordScriptCalledStats(script);
                s.invokeWith(msg);
            } else {
                this.handleUnspecifiedScriptError(script, writer, Constant.messages.getString("script.interface.targeted.error"));
            }
        }
        catch (Exception e) {
            this.handleScriptException(script, writer, e);
        }
    }

    private static void validateScriptType(ScriptWrapper script, String scriptType) throws IllegalArgumentException {
        if (!scriptType.equals(script.getTypeName())) {
            throw new IllegalArgumentException("Script " + script.getName() + " is not a '" + scriptType + "' script: " + script.getTypeName());
        }
    }

    public void handleFailedScriptInterface(ScriptWrapper script, String errorMessage) {
        this.handleUnspecifiedScriptError(script, this.getWriters(script), errorMessage);
    }

    private void handleUnspecifiedScriptError(ScriptWrapper script, Writer writer, String errorMessage) {
        ExtensionScript.recordScriptFailedStats(script);
        try {
            writer.append(errorMessage);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to append script error message because of an exception:", (Throwable)e);
            }
            logger.warn("Failed to append error message: " + errorMessage);
        }
        this.setError(script, errorMessage);
        this.setEnabled(script, false);
    }

    public boolean invokeProxyScript(ScriptWrapper script, HttpMessage msg, boolean request) {
        ExtensionScript.validateScriptType(script, TYPE_PROXY);
        Writer writer = this.getWriters(script);
        try {
            ProxyScript s = this.getInterface(script, ProxyScript.class);
            if (s != null) {
                ExtensionScript.recordScriptCalledStats(script);
                if (request) {
                    return s.proxyRequest(msg);
                }
                return s.proxyResponse(msg);
            }
            this.handleUnspecifiedScriptError(script, writer, Constant.messages.getString("script.interface.proxy.error"));
        }
        catch (Exception e) {
            this.handleScriptException(script, writer, e);
        }
        return true;
    }

    public void invokeSenderScript(ScriptWrapper script, HttpMessage msg, int initiator, HttpSender sender, boolean request) {
        ExtensionScript.validateScriptType(script, TYPE_HTTP_SENDER);
        Writer writer = this.getWriters(script);
        try {
            HttpSenderScript senderScript = this.getInterface(script, HttpSenderScript.class);
            if (senderScript != null) {
                ExtensionScript.recordScriptCalledStats(script);
                if (request) {
                    senderScript.sendingRequest(msg, initiator, new HttpSenderScriptHelper(sender));
                } else {
                    senderScript.responseReceived(msg, initiator, new HttpSenderScriptHelper(sender));
                }
            } else {
                this.handleUnspecifiedScriptError(script, writer, Constant.messages.getString("script.interface.httpsender.error"));
            }
        }
        catch (Exception e) {
            this.handleScriptException(script, writer, e);
        }
    }

    public void setChanged(ScriptWrapper script, boolean changed) {
        script.setChanged(changed);
        ScriptNode node = this.getTreeModel().getNodeForScript(script);
        if (node != null) {
            if (node.getNodeName().equals(script.getName())) {
                this.getTreeModel().nodeStructureChanged(script);
            } else {
                node.setNodeName(script.getName());
                this.getTreeModel().nodeStructureChanged(node.getParent());
            }
        }
        this.notifyScriptChanged(script);
    }

    private void notifyScriptChanged(ScriptWrapper script) {
        for (ScriptEventListener listener : this.listeners) {
            try {
                listener.scriptChanged(script);
            }
            catch (Exception e) {
                this.logScriptEventListenerException(listener, script, e);
            }
        }
    }

    public void setEnabled(ScriptWrapper script, boolean enabled) {
        if (!script.getType().isEnableable()) {
            return;
        }
        if (enabled && script.getEngine() == null) {
            return;
        }
        script.setEnabled(enabled);
        this.getTreeModel().nodeStructureChanged(script);
        this.notifyScriptChanged(script);
    }

    public void setError(ScriptWrapper script, String details) {
        script.setError(true);
        script.setLastErrorDetails(details);
        script.setLastOutput(details);
        this.getTreeModel().nodeStructureChanged(script);
        for (ScriptEventListener listener : this.listeners) {
            try {
                listener.scriptError(script);
            }
            catch (Exception e) {
                this.logScriptEventListenerException(listener, script, e);
            }
        }
    }

    public void setError(ScriptWrapper script, Exception e) {
        script.setLastException(e);
        this.setError(script, e.getMessage());
    }

    public void addListener(ScriptEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ScriptEventListener listener) {
        this.listeners.remove(listener);
    }

    public void addWriter(Writer writer) {
        this.writers.addWriter(writer);
    }

    public void removeWriter(Writer writer) {
        this.writers.removeWriter(writer);
    }

    public void addScriptOutputListener(ScriptOutputListener listener) {
        this.outputListeners.add(Objects.requireNonNull(listener, "The parameter listener must not be null."));
    }

    public void removeScriptOutputListener(ScriptOutputListener listener) {
        this.outputListeners.remove(Objects.requireNonNull(listener, "The parameter listener must not be null."));
    }

    public ScriptUI getScriptUI() {
        return this.scriptUI;
    }

    public void setScriptUI(ScriptUI scriptUI) {
        if (this.scriptUI != null) {
            throw new InvalidParameterException("A script UI has already been set - only one is supported");
        }
        this.scriptUI = scriptUI;
    }

    public void removeScriptUI() {
        this.scriptUI = null;
    }

    public <T> ScriptsCache<T> createScriptsCache(ScriptsCache.Configuration<T> config) {
        return new ScriptsCache<T>(this, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInterface(ScriptWrapper script, Class<T> class1) throws ScriptException, IOException {
        ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ExtensionFactory.getAddOnLoader());
        try {
            T iface = script.getInterface(class1);
            if (iface != null) {
                T t = iface;
                return t;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContextClassLoader);
        }
        if (script.isRunnableStandalone()) {
            return null;
        }
        Invocable invocable = this.invokeScript(script);
        if (invocable != null) {
            return invocable.getInterface(class1);
        }
        return null;
    }

    public <T> T getInterfaceWithOutAddOnLoader(ScriptWrapper script, Class<T> clazz) throws ScriptException, IOException {
        T iface = script.getInterface(clazz);
        if (iface != null) {
            return iface;
        }
        return this.invokeScriptWithOutAddOnLoader(script).getInterface(clazz);
    }

    @Override
    public List<String> getUnsavedResources() {
        ArrayList<String> list = new ArrayList<String>();
        for (ScriptType type : this.getScriptTypes()) {
            for (ScriptWrapper script : this.getScripts(type)) {
                if (!script.isChanged()) continue;
                list.add(Constant.messages.getString("script.resource", script.getName()));
            }
        }
        return list;
    }

    private void openCmdLineFile(File f) throws IOException, ScriptException {
        if (!f.exists()) {
            CommandLine.info(Constant.messages.getString("script.cmdline.nofile", f.getAbsolutePath()));
            return;
        }
        if (!f.canRead()) {
            CommandLine.info(Constant.messages.getString("script.cmdline.noread", f.getAbsolutePath()));
            return;
        }
        int dotIndex = f.getName().lastIndexOf(".");
        if (dotIndex <= 0) {
            CommandLine.info(Constant.messages.getString("script.cmdline.noext", f.getAbsolutePath()));
            return;
        }
        String ext = f.getName().substring(dotIndex + 1);
        String engineName = this.getEngineNameForExtension(ext);
        if (engineName == null) {
            CommandLine.info(Constant.messages.getString("script.cmdline.noengine", ext));
            return;
        }
        ScriptWrapper sw = new ScriptWrapper(f.getName(), "", engineName, this.getScriptType(TYPE_STANDALONE), true, f);
        this.loadScript(sw);
        this.addScript(sw);
        if (!this.hasView()) {
            this.invokeScript(sw);
        }
    }

    @Override
    public void execute(CommandLineArgument[] args) {
        if (args[0].isEnabled()) {
            for (String script : args[0].getArguments()) {
                try {
                    this.openCmdLineFile(new File(script));
                }
                catch (Exception e) {
                    CommandLine.error(e.getMessage(), e);
                }
            }
        }
    }

    private CommandLineArgument[] getCommandLineArguments() {
        this.arguments[0] = new CommandLineArgument("-script", 1, null, "", "-script <script>         " + Constant.messages.getString("script.cmdline.help"));
        return this.arguments;
    }

    @Override
    public boolean handleFile(File file) {
        int dotIndex = file.getName().lastIndexOf(".");
        if (dotIndex <= 0) {
            return false;
        }
        String ext = file.getName().substring(dotIndex + 1);
        String engineName = this.getEngineNameForExtension(ext);
        if (engineName == null) {
            return false;
        }
        try {
            this.openCmdLineFile(file);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public List<String> getHandledExtensions() {
        ArrayList<String> exts = new ArrayList<String>();
        for (ScriptEngineWrapper sew : this.engineWrappers) {
            exts.addAll(sew.getExtensions());
        }
        return exts;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    public static ImageIcon getScriptIcon() {
        if (scriptIcon == null) {
            scriptIcon = new ImageIcon(ExtensionScript.class.getResource("/resource/icon/16/059.png"));
        }
        return scriptIcon;
    }

    public static void recordScriptCalledStats(ScriptWrapper sw) {
        if (sw != null) {
            Stats.incCounter("stats.script.call." + sw.getEngineName() + "." + sw.getTypeName());
        }
    }

    public static void recordScriptFailedStats(ScriptWrapper sw) {
        if (sw != null) {
            Stats.incCounter("stats.script.error." + sw.getEngineName() + "." + sw.getTypeName());
        }
    }

    static {
        TEMPLATES_DIR = SCRIPTS_DIR + File.separator + "templates";
        logger = LogManager.getLogger(ExtensionScript.class);
    }

    private static class ScriptWriter
    extends Writer {
        private final ScriptWrapper script;
        private final Writer delegatee;
        private final List<ScriptOutputListener> outputListeners;

        public ScriptWriter(ScriptWrapper script, Writer delegatee, List<ScriptOutputListener> outputListeners) {
            this.script = Objects.requireNonNull(script);
            this.delegatee = Objects.requireNonNull(delegatee);
            this.outputListeners = Objects.requireNonNull(outputListeners);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.delegatee.write(cbuf, off, len);
            if (!this.outputListeners.isEmpty()) {
                String output = new String(cbuf, off, len);
                this.outputListeners.forEach(e -> e.output(this.script, output));
            }
        }

        @Override
        public void flush() throws IOException {
            this.delegatee.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegatee.close();
        }
    }

    private static class ClearScriptVarsOnSessionChange
    implements SessionChangedListener {
        private ClearScriptVarsOnSessionChange() {
        }

        @Override
        public void sessionChanged(Session session) {
        }

        @Override
        public void sessionAboutToChange(Session session) {
            ScriptVars.clear();
        }

        @Override
        public void sessionScopeChanged(Session session) {
        }

        @Override
        public void sessionModeChanged(Control.Mode mode) {
        }
    }
}

