"use strict";
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Encoder = void 0;
const Converter_1 = require("./Converter");
const EncodedData_1 = require("./EncodedData");
class Encoder {
    static toBase64(data) {
        const decoded = Converter_1.Converter.toArrayBufferView(data);
        const asString = Encoder.fromByteArray(decoded);
        const asBytes = Converter_1.Converter.stringToArrayBufferViewUTF8(asString);
        return new EncodedData_1.EncodedData(asBytes, asString);
    }
    static fromByteArray(decoded) {
        if (typeof window === 'object') {
            const decodedString = Converter_1.Converter.arrayBufferViewToBaselineString(decoded);
            return window.btoa(decodedString);
        }
        return Buffer.from(decoded.buffer).toString('base64');
    }
}
exports.Encoder = Encoder;
//# sourceMappingURL=Encoder.js.map