"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextLink = exports.textLinkStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _colorsV = require("../Identity/colors-v2");

var _Link = require("./Link");

var _excluded = ["color", "fontSize", "bold", "textTransform"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var textLinkStyle = function textLinkStyle(theme, _ref) {
  var _ref$color = _ref.color,
      color = _ref$color === void 0 ? _colorsV.COLOR_V2.BLUE : _ref$color,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '16px' : _ref$fontSize,
      _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? false : _ref$bold,
      _ref$textTransform = _ref.textTransform,
      textTransform = _ref$textTransform === void 0 ? 'none' : _ref$textTransform,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return _objectSpread({}, (0, _Link.linkStyle)(theme, _objectSpread({
    bold: bold,
    color: color,
    fontSize: fontSize,
    textTransform: textTransform
  }, props)));
};

exports.textLinkStyle = textLinkStyle;

var TextLink = function TextLink(props) {
  return (0, _react.jsx)("a", (0, _extends2["default"])({
    css: function css(theme) {
      return textLinkStyle(theme, props);
    },
    rel: "noopener noreferrer"
  }, (0, _Link.filterLinkProps)(props)));
};

exports.TextLink = TextLink;
//# sourceMappingURL=TextLink.js.map