"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Lead = exports.leadStyle = exports.Paragraph = exports.paragraphStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _mediaQueries = require("../mediaQueries");

var _Text = require("./Text");

var _excluded = ["block"],
    _excluded2 = ["block", "center", "fontSize"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var paragraphStyle = function paragraphStyle(theme, _ref) {
  var _ref$block = _ref.block,
      block = _ref$block === void 0 ? true : _ref$block,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block
  }, props))), {}, {
    marginBottom: '16px',
    marginTop: 0
  });
};

exports.paragraphStyle = paragraphStyle;

var Paragraph = function Paragraph(props) {
  return (0, _react.jsx)("p", (0, _extends2["default"])({
    css: function css(theme) {
      return paragraphStyle(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.Paragraph = Paragraph;

var leadStyle = function leadStyle(theme, _ref2) {
  var _ref2$block = _ref2.block,
      block = _ref2$block === void 0 ? true : _ref2$block,
      _ref2$center = _ref2.center,
      center = _ref2$center === void 0 ? true : _ref2$center,
      _ref2$fontSize = _ref2.fontSize,
      fontSize = _ref2$fontSize === void 0 ? '24px' : _ref2$fontSize,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded2);
  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    center: center,
    fontSize: fontSize
  }, props))), {}, (0, _defineProperty2["default"])({
    marginBottom: '56px',
    marginTop: 0
  }, _mediaQueries.media[_mediaQueries.QueryKeys.MOBILE], {
    fontSize: '20px'
  }));
};

exports.leadStyle = leadStyle;

var Lead = function Lead(props) {
  return (0, _react.jsx)("p", (0, _extends2["default"])({
    css: function css(theme) {
      return leadStyle(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.Lead = Lead;
//# sourceMappingURL=Paragraph.js.map