"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelLink = exports.Label = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _Link = require("./Link");

var _Text = require("./Text");

var _Identity = require("../Identity");

var _excluded = ["markInvalid", "bold", "color", "fontSize"],
    _excluded2 = ["fontSize"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var labelStyle = function labelStyle(theme, _ref) {
  var markInvalid = _ref.markInvalid,
      _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? false : _ref$bold,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? theme.general.color : _ref$color,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '12px' : _ref$fontSize,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    bold: bold,
    color: color,
    fontSize: fontSize
  }, props))), {}, {
    '&:focus-within': {
      color: _Identity.COLOR.BLUE
    },
    color: markInvalid ? _Identity.COLOR.RED : 'initial',
    width: '100%'
  });
};

var Label = function Label(props) {
  return (0, _react.jsx)("label", (0, _extends2["default"])({
    css: function css(theme) {
      return labelStyle(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.Label = Label;

var labelLinkStyle = function labelLinkStyle(theme, _ref2) {
  var _ref2$fontSize = _ref2.fontSize,
      fontSize = _ref2$fontSize === void 0 ? '12px' : _ref2$fontSize,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded2);
  return _objectSpread({}, (0, _Link.linkStyle)(theme, _objectSpread({
    fontSize: fontSize
  }, props)));
};

var LabelLink = function LabelLink(props) {
  return (0, _react.jsx)("a", (0, _extends2["default"])({
    css: function css(theme) {
      return labelLinkStyle(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.LabelLink = LabelLink;
//# sourceMappingURL=Label.js.map