"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.H4 = exports.h4Style = exports.H3 = exports.h3Style = exports.H2 = exports.h2Style = exports.H1 = exports.h1Style = exports.Heading = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _mediaQueries = require("../mediaQueries");

var _Text = require("./Text");

var _excluded = ["level"],
    _excluded2 = ["block", "color", "level", "noWrap", "textTransform"],
    _excluded3 = ["block", "color", "noWrap", "textTransform"],
    _excluded4 = ["block", "color", "noWrap", "textTransform"],
    _excluded5 = ["block", "color", "noWrap", "textTransform"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var Heading = function Heading(_ref) {
  var level = _ref.level,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);

  switch (level) {
    case '2':
      return (0, _react.jsx)(H2, props);

    case '3':
      return (0, _react.jsx)(H3, props);

    case '4':
      return (0, _react.jsx)(H4, props);

    case '1':
    default:
      return (0, _react.jsx)(H1, props);
  }
};

exports.Heading = Heading;

var h1Style = function h1Style(theme, _ref2) {
  var _ref2$block = _ref2.block,
      block = _ref2$block === void 0 ? true : _ref2$block,
      _ref2$color = _ref2.color,
      color = _ref2$color === void 0 ? theme.general.color : _ref2$color,
      _ref2$level = _ref2.level,
      level = _ref2$level === void 0 ? '1' : _ref2$level,
      _ref2$noWrap = _ref2.noWrap,
      noWrap = _ref2$noWrap === void 0 ? false : _ref2$noWrap,
      _ref2$textTransform = _ref2.textTransform,
      textTransform = _ref2$textTransform === void 0 ? 'none' : _ref2$textTransform,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded2);
  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    color: color,
    noWrap: noWrap,
    textTransform: textTransform
  }, props))), {}, (0, _defineProperty2["default"])({
    fontSize: '48px',
    fontWeight: 300,
    lineHeight: '56px',
    marginBottom: '64px',
    marginTop: 0,
    minHeight: '48px'
  }, _mediaQueries.media[_mediaQueries.QueryKeys.MOBILE], {
    fontSize: '40px',
    lineHeight: '48px'
  }));
};

exports.h1Style = h1Style;

var H1 = function H1(props) {
  return (0, _react.jsx)("h1", (0, _extends2["default"])({
    css: function css(theme) {
      return h1Style(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.H1 = H1;

var h2Style = function h2Style(theme, _ref3) {
  var _ref3$block = _ref3.block,
      block = _ref3$block === void 0 ? true : _ref3$block,
      _ref3$color = _ref3.color,
      color = _ref3$color === void 0 ? theme.general.color : _ref3$color,
      _ref3$noWrap = _ref3.noWrap,
      noWrap = _ref3$noWrap === void 0 ? false : _ref3$noWrap,
      _ref3$textTransform = _ref3.textTransform,
      textTransform = _ref3$textTransform === void 0 ? 'none' : _ref3$textTransform,
      props = (0, _objectWithoutProperties2["default"])(_ref3, _excluded3);
  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    color: color,
    noWrap: noWrap,
    textTransform: textTransform
  }, props))), {}, (0, _defineProperty2["default"])({
    fontSize: '20px',
    fontWeight: 700,
    lineHeight: '28px',
    marginBottom: '24px',
    marginTop: '32px'
  }, _mediaQueries.media[_mediaQueries.QueryKeys.MOBILE], {
    fontSize: '18px',
    lineHeight: '26px',
    marginBottom: '20px',
    marginTop: '26px'
  }));
};

exports.h2Style = h2Style;

var H2 = function H2(props) {
  return (0, _react.jsx)("h2", (0, _extends2["default"])({
    css: function css(theme) {
      return h2Style(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.H2 = H2;

var h3Style = function h3Style(theme, _ref4) {
  var _ref4$block = _ref4.block,
      block = _ref4$block === void 0 ? true : _ref4$block,
      _ref4$color = _ref4.color,
      color = _ref4$color === void 0 ? theme.general.color : _ref4$color,
      _ref4$noWrap = _ref4.noWrap,
      noWrap = _ref4$noWrap === void 0 ? false : _ref4$noWrap,
      _ref4$textTransform = _ref4.textTransform,
      textTransform = _ref4$textTransform === void 0 ? 'none' : _ref4$textTransform,
      props = (0, _objectWithoutProperties2["default"])(_ref4, _excluded4);
  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    color: color,
    noWrap: noWrap,
    textTransform: textTransform
  }, props))), {}, {
    fontSize: '16px',
    fontWeight: 600,
    marginBottom: '16px'
  });
};

exports.h3Style = h3Style;

var H3 = function H3(props) {
  return (0, _react.jsx)("h3", (0, _extends2["default"])({
    css: function css(theme) {
      return h3Style(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.H3 = H3;

var h4Style = function h4Style(theme, _ref5) {
  var _ref5$block = _ref5.block,
      block = _ref5$block === void 0 ? true : _ref5$block,
      _ref5$color = _ref5.color,
      color = _ref5$color === void 0 ? theme.general.color : _ref5$color,
      _ref5$noWrap = _ref5.noWrap,
      noWrap = _ref5$noWrap === void 0 ? false : _ref5$noWrap,
      _ref5$textTransform = _ref5.textTransform,
      textTransform = _ref5$textTransform === void 0 ? 'none' : _ref5$textTransform,
      props = (0, _objectWithoutProperties2["default"])(_ref5, _excluded5);
  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    color: color,
    noWrap: noWrap,
    textTransform: textTransform
  }, props))), {}, {
    fontSize: '11px',
    fontWeight: 300,
    marginBottom: '5px',
    marginTop: '20px'
  });
};

exports.h4Style = h4Style;

var H4 = function H4(props) {
  return (0, _react.jsx)("h3", (0, _extends2["default"])({
    css: function css(theme) {
      return h4Style(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.H4 = H4;
//# sourceMappingURL=Heading.js.map