"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuLink = exports.filterMenuLinkProps = exports.MENU_LINK_CLASSNAME = exports.menuLinkStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _mediaQueries = require("../../mediaQueries");

var _Text = require("../../Text");

var _util = require("../../util");

var _HeaderSubMenu = require("./HeaderSubMenu");

var _excluded = ["bold", "color", "fontSize", "textTransform", "button"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var menuLinkStyle = function menuLinkStyle(theme, _ref) {
  var _objectSpread2;

  var _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? true : _ref$bold,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? theme.general.color : _ref$color,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '11px' : _ref$fontSize,
      _ref$textTransform = _ref.textTransform,
      textTransform = _ref$textTransform === void 0 ? 'uppercase' : _ref$textTransform,
      _ref$button = _ref.button,
      button = _ref$button === void 0 ? false : _ref$button,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return _objectSpread(_objectSpread({}, (0, _Text.linkStyle)(theme, _objectSpread({
    bold: bold,
    color: color,
    fontSize: fontSize,
    textTransform: textTransform
  }, props))), {}, (_objectSpread2 = {}, (0, _defineProperty2["default"])(_objectSpread2, _mediaQueries.media[_mediaQueries.QueryKeys.DESKTOP], (0, _defineProperty2["default"])({
    '&:first-of-type': {
      marginLeft: 0
    },
    '&:last-of-type': {
      marginRight: 0
    },
    margin: '0 26px 0 10px'
  }, ".".concat(_HeaderSubMenu.DESKTOP_HEADER_SUB_MENU_CLASSNAME, " &"), {
    '&:first-of-type': {
      marginLeft: '10px'
    },
    '&:last-of-type': {
      marginRight: '26px'
    }
  })), (0, _defineProperty2["default"])(_objectSpread2, _mediaQueries.media[_mediaQueries.QueryKeys.TABLET_DOWN], {
    border: 'none',
    fontSize: '32px !important',
    fontWeight: 300,
    maxWidth: '480px',
    padding: '8px 24px',
    textTransform: 'none !important'
  }), (0, _defineProperty2["default"])(_objectSpread2, "border", button ? '1px solid rgb(219, 226, 231)' : undefined), (0, _defineProperty2["default"])(_objectSpread2, "borderRadius", button ? '4px' : undefined), (0, _defineProperty2["default"])(_objectSpread2, "padding", button ? '10px 16px' : undefined), _objectSpread2));
};

exports.menuLinkStyle = menuLinkStyle;
var MENU_LINK_CLASSNAME = 'menu-link';
exports.MENU_LINK_CLASSNAME = MENU_LINK_CLASSNAME;

var filterMenuLinkProps = function filterMenuLinkProps(props) {
  return (0, _util.filterProps)((0, _Text.filterLinkProps)(props), ['button']);
};

exports.filterMenuLinkProps = filterMenuLinkProps;

var MenuLink = function MenuLink(props) {
  return (0, _react.jsx)("a", (0, _extends2["default"])({
    className: MENU_LINK_CLASSNAME,
    css: function css(theme) {
      return menuLinkStyle(theme, props);
    }
  }, filterMenuLinkProps(props)));
};

exports.MenuLink = MenuLink;
//# sourceMappingURL=MenuLink.js.map