"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlexBox = exports.filterFlexBoxProps = exports.flexBoxStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _util = require("../util");

/*
 * Wire
 * Copyright (C) 2017 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */

/** @jsx jsx */
var flexBoxStyle = function flexBoxStyle(_ref) {
  var _ref$align = _ref.align,
      align = _ref$align === void 0 ? 'flex-start' : _ref$align,
      _ref$column = _ref.column,
      column = _ref$column === void 0 ? false : _ref$column,
      _ref$justify = _ref.justify,
      justify = _ref$justify === void 0 ? 'flex-start' : _ref$justify,
      _ref$flexWrap = _ref.flexWrap,
      flexWrap = _ref$flexWrap === void 0 ? 'nowrap' : _ref$flexWrap;
  return {
    alignItems: align,
    display: 'flex',
    flexDirection: column ? 'column' : 'row',
    flexWrap: flexWrap,
    justifyContent: justify
  };
};

exports.flexBoxStyle = flexBoxStyle;

var filterFlexBoxProps = function filterFlexBoxProps(props) {
  return (0, _util.filterProps)(props, ['align', 'column', 'justify', 'flexWrap']);
};

exports.filterFlexBoxProps = filterFlexBoxProps;

var FlexBox = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    ref: ref,
    css: flexBoxStyle(props)
  }, filterFlexBoxProps(props)));
});

exports.FlexBox = FlexBox;
//# sourceMappingURL=FlexBox.js.map