"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultTransition = exports.ANIMATION = exports.EASE = exports.DURATION = void 0;

var _taggedTemplateLiteral2 = _interopRequireDefault(require("@babel/runtime/helpers/taggedTemplateLiteral"));

var _react = require("@emotion/react");

var _templateObject, _templateObject2, _templateObject3, _templateObject4, _templateObject5;

// https://motion.wire.com/_guidelines_/rules.html

/**
 * Duration exception - When a motion longer than 0.7 seconds is needed use a multiplier of 700.
 */
var DURATION = {
  DEFAULT: 550,
  EXTRA_LONG: 2400,
  PROACTIVE_FAST: 150,
  PROACTIVE_SLOW: 350,
  SYSTEM: 700
};
/**
 * The rule of thumb is using Quart Out when animating only the object's opacity,
 * otherwise use Expo Out ease.
 */

exports.DURATION = DURATION;
var EASE = {
  EXPONENTIAL: 'cubic-bezier(0.19, 1, 0.22, 1)',
  QUART: 'cubic-bezier(0.165, 0.84, 0.44, 1)'
};
exports.EASE = EASE;
var ANIMATION = {
  bottomUpMovement: (0, _react.keyframes)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2["default"])(["\n    0% {\n      transform: translateY(100%);\n    }\n    100% {\n      transform: translateY(0);\n    }\n  "]))),
  fadeIn: (0, _react.keyframes)(_templateObject2 || (_templateObject2 = (0, _taggedTemplateLiteral2["default"])(["\n    0% {\n      opacity: 0;\n    }\n    100% {\n      opacity: 1;\n    }\n  "]))),
  rotate: (0, _react.keyframes)(_templateObject3 || (_templateObject3 = (0, _taggedTemplateLiteral2["default"])(["\n    0% {\n      transform: rotate(0);\n    }\n    100% {\n      transform: rotate(360deg);\n    }\n  "]))),
  topDownMovement: (0, _react.keyframes)(_templateObject4 || (_templateObject4 = (0, _taggedTemplateLiteral2["default"])(["\n    0% {\n      transform: translateY(-100%);\n    }\n    100% {\n      transform: translateY(0);\n    }\n  "]))),
  topDownMovementLight: (0, _react.keyframes)(_templateObject5 || (_templateObject5 = (0, _taggedTemplateLiteral2["default"])(["\n    0% {\n      transform: translateY(-20%);\n    }\n    100% {\n      transform: translateY(0);\n    }\n  "])))
};
exports.ANIMATION = ANIMATION;
var defaultTransition = 'all 0.24s';
exports.defaultTransition = defaultTransition;
//# sourceMappingURL=motions.js.map