"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalStyle = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _emotionNormalize = _interopRequireDefault(require("emotion-normalize"));

var _TextLink = require("./Text/TextLink");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var globalStyles = function globalStyles(theme) {
  return {
    '*': {
      boxSizing: 'border-box'
    },
    a: _objectSpread({}, (0, _TextLink.textLinkStyle)(theme, {})),
    'b, strong': {
      fontWeight: 600
    },
    body: {
      MozOsxFontSmoothing: 'grayscale',
      WebkitFontSmoothing: 'antialiased',
      background: theme.general.backgroundColor,
      color: theme.general.color,
      display: 'flex',
      flexDirection: 'column',
      fontFamily: '-apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica Neue, Helvetica, Arial, sans-serif',
      fontWeight: 300,
      lineHeight: 1.5,
      minHeight: '100vh',
      transition: 'background 0.15s'
    },
    html: {
      background: theme.general.backgroundColor,
      transition: 'background 0.15s'
    },
    p: {
      marginTop: 0
    }
  };
};

var globalStyle = function globalStyle(theme) {
  return /*#__PURE__*/(0, _react.css)(_emotionNormalize["default"], " ", globalStyles(theme), ";" + (process.env.NODE_ENV === "production" ? "" : ";label:globalStyle;"), process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
};

var GlobalStyle = (0, _react.withTheme)(function (_ref) {
  var theme = _ref.theme;
  return (0, _react.jsx)(_react.Global, {
    styles: globalStyle(theme)
  });
});
exports.GlobalStyle = GlobalStyle;
//# sourceMappingURL=GlobalStyle.js.map