"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Select = exports.selectStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = require("@emotion/react");

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _Identity = require("../Identity");

var _util = require("../util");

var _Input = require("./Input");

var _react2 = _interopRequireWildcard(require("react"));

var _InputLabel = _interopRequireDefault(require("./InputLabel"));

var _excluded = ["disabled", "markInvalid"],
    _excluded2 = ["id", "label", "error", "helperText", "options", "value", "onChange", "required", "markInvalid", "dataUieName", "wrapperCSS"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var ArrowDown = function ArrowDown(theme) {
  return "\n    <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 16 16\">\n        <path fill=\"".concat(theme.general.color, "\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M7.99963 12.5711L15.6565 4.91421L14.2423 3.5L7.99963 9.74264L1.75699 3.5L0.342773 4.91421L7.99963 12.5711Z\"/>\n    </svg>\n");
};

var selectStyle = function selectStyle(theme, _ref) {
  var _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      markInvalid = _ref.markInvalid,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  var error = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return _objectSpread(_objectSpread({}, (0, _Input.inputStyle)(theme, props)), {}, {
    '&:-moz-focusring': {
      color: 'transparent',
      textShadow: '0 0 0 #000'
    },
    '&:disabled': {
      color: _Identity.COLOR_V2.GRAY
    },
    appearance: 'none',
    background: disabled ? "".concat(theme.Input.backgroundColorDisabled, " center right 16px no-repeat url(\"").concat((0, _util.inlineSVG)(ArrowDown(theme)), "\")") : "".concat(theme.Input.backgroundColor, " center right 16px no-repeat url(\"").concat((0, _util.inlineSVG)(ArrowDown(theme)), "\")"),
    boxShadow: markInvalid ? "0 0 0 1px ".concat(_Identity.COLOR_V2.RED) : "0 0 0 1px ".concat(_Identity.COLOR_V2.GRAY_40),
    cursor: disabled ? 'normal' : 'pointer',
    fontSize: '16px',
    fontWeight: 300,
    paddingRight: '30px',
    textAlign: 'left',
    marginBottom: error && '8px',
    '&:invalid, option:first-of-type': {
      color: _Identity.COLOR_V2.RED
    }
  }, !disabled && {
    '&:hover': {
      boxShadow: "0 0 0 1px ".concat(_Identity.COLOR_V2.GRAY_60)
    },
    '&:focus, &:active': {
      boxShadow: "0 0 0 1px ".concat(_Identity.COLOR_V2.BLUE)
    }
  });
};

exports.selectStyle = selectStyle;

var dropdownStyles = function dropdownStyles(theme, isDropdownOpen) {
  return {
    height: isDropdownOpen ? 'auto' : 0,
    visibility: isDropdownOpen ? 'visible' : 'hidden',
    margin: '3px 0 0',
    padding: 0,
    borderRadius: '10px',
    border: "1px solid ".concat(_Identity.COLOR_V2.BLUE),
    position: 'absolute',
    top: '100%',
    left: 0,
    width: '100%',
    maxHeight: '240px',
    overflowY: 'auto',
    zIndex: 9
  };
};

var dropdownOptionStyles = function dropdownOptionStyles(theme, isSelected) {
  return {
    background: isSelected ? _Identity.COLOR_V2.BLUE : _Identity.COLOR_V2.WHITE,
    listStyle: 'none',
    padding: '10px 20px 14px',
    cursor: 'pointer',
    fontSize: '16px',
    fontWeight: 300,
    lineHeight: '24px',
    letterSpacing: '0.05px',
    color: isSelected ? _Identity.COLOR_V2.WHITE : _Identity.COLOR_V2.BLACK,
    '&:first-of-type': {
      borderRadius: '10px 10px 0 0'
    },
    '&:last-of-type': {
      borderRadius: '0 0 10px 10px'
    },
    '&:not(:last-of-type)': {
      borderBottom: "1px solid ".concat(_Identity.COLOR_V2.GRAY_40)
    },
    '&:hover, &:active, &:focus': {
      background: _Identity.COLOR_V2.BLUE,
      borderColor: _Identity.COLOR_V2.BLUE,
      color: _Identity.COLOR_V2.WHITE
    }
  };
};

var filterSelectProps = function filterSelectProps(props) {
  return (0, _util.filterProps)(props, ['markInvalid']);
};

var placeholderText = '- Please select -';

var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "bjn8wh",
  styles: "position:relative"
} : {
  name: "tvi1yf-Select",
  styles: "position:relative;label:Select;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var Select = function Select(_ref2) {
  var id = _ref2.id,
      label = _ref2.label,
      error = _ref2.error,
      helperText = _ref2.helperText,
      _ref2$options = _ref2.options,
      options = _ref2$options === void 0 ? [] : _ref2$options,
      _ref2$value = _ref2.value,
      value = _ref2$value === void 0 ? null : _ref2$value,
      onChange = _ref2.onChange,
      required = _ref2.required,
      markInvalid = _ref2.markInvalid,
      dataUieName = _ref2.dataUieName,
      _ref2$wrapperCSS = _ref2.wrapperCSS,
      wrapperCSS = _ref2$wrapperCSS === void 0 ? {} : _ref2$wrapperCSS,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded2);
  var currentOption = options.findIndex(function (option) {
    return option.value === (value === null || value === void 0 ? void 0 : value.value);
  });
  var selectContainerRef = (0, _react2.useRef)(null);
  var listRef = (0, _react2.useRef)(null);

  var _useState = (0, _react2.useState)(false),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      isDropdownOpen = _useState2[0],
      setIsDropdownOpen = _useState2[1];

  var _useState3 = (0, _react2.useState)(currentOption === -1 ? null : currentOption),
      _useState4 = (0, _slicedToArray2["default"])(_useState3, 2),
      selectedOption = _useState4[0],
      setSelectedOption = _useState4[1];

  var hasSelectedOption = selectedOption !== null;
  var hasError = !!error;

  var scrollToCurrentOption = function scrollToCurrentOption(idx) {
    if (listRef.current) {
      var listSelectedOption = listRef.current.children[idx];
      var getYPosition = listSelectedOption && listSelectedOption.offsetTop;
      listRef.current.scroll({
        top: getYPosition !== null && getYPosition !== void 0 ? getYPosition : 0,
        behavior: 'smooth'
      });
    }
  };

  var onToggleDropdown = function onToggleDropdown() {
    return setIsDropdownOpen(function (prevState) {
      return !prevState;
    });
  };

  var onOptionSelect = function onOptionSelect(idx) {
    setSelectedOption(idx);
    onChange(options[idx].value);
    scrollToCurrentOption(idx);
  };

  var onOptionChange = function onOptionChange(idx) {
    onOptionSelect(idx);
    setIsDropdownOpen(false);
  };

  var handleListKeyDown = function handleListKeyDown(e) {
    switch (e.key) {
      case 'Escape':
        e.preventDefault();
        setIsDropdownOpen(false);
        break;

      case 'ArrowUp':
      case 'ArrowLeft':
        if (!isDropdownOpen) {
          setIsDropdownOpen(true);
        }

        e.preventDefault();
        onOptionSelect(selectedOption - 1 >= 0 ? selectedOption - 1 : options.length - 1);
        break;

      case 'ArrowDown':
      case 'ArrowRight':
        if (!isDropdownOpen) {
          setIsDropdownOpen(true);
        }

        e.preventDefault();

        if (selectedOption === null) {
          onOptionSelect(0);
        } else {
          onOptionSelect(selectedOption === options.length - 1 ? 0 : selectedOption + 1);
        }

        break;

      default:
        break;
    }
  };

  var handleKeyDown = function handleKeyDown(index) {
    return function (e) {
      switch (e.key) {
        case ' ':
        case 'SpaceBar':
        case 'Enter':
          e.preventDefault();
          onOptionChange(index);
          break;

        default:
          break;
      }
    };
  };

  var handleOutsideClick = function handleOutsideClick(event) {
    if (selectContainerRef.current && !selectContainerRef.current.contains(event.target)) {
      setIsDropdownOpen(false);
    }
  };

  (0, _react2.useEffect)(function () {
    window.addEventListener('click', handleOutsideClick);
    return function () {
      window.removeEventListener('click', handleOutsideClick);
    };
  }, []);
  return (0, _react.jsx)("div", {
    css: /*#__PURE__*/(0, _react.css)(_objectSpread({
      marginBottom: markInvalid ? '2px' : '20px',
      width: '100%',
      '&:focus-within label': {
        color: _Identity.COLOR_V2.BLUE
      }
    }, wrapperCSS), process.env.NODE_ENV === "production" ? "" : ";label:Select;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"),
    "data-uie-name": dataUieName,
    ref: selectContainerRef
  }, label && (0, _react.jsx)(_InputLabel["default"], {
    htmlFor: id,
    isRequired: required,
    markInvalid: markInvalid
  }, label), (0, _react.jsx)("div", {
    css: _ref3
  }, (0, _react.jsx)("button", (0, _extends2["default"])({
    type: "button",
    "aria-activedescendant": hasSelectedOption ? value.label : '',
    "aria-expanded": isDropdownOpen,
    "aria-haspopup": "listbox",
    "aria-labelledby": id,
    id: id,
    onClick: onToggleDropdown,
    onKeyDown: handleListKeyDown,
    css: function css(theme) {
      return selectStyle(theme, props, hasError);
    }
  }, filterSelectProps(props), {
    "data-uie-name": dataUieName
  }, hasSelectedOption && {
    'data-value': value.value
  }), hasSelectedOption ? value.label : placeholderText), (0, _react.jsx)("ul", (0, _extends2["default"])({
    ref: listRef,
    role: "listbox",
    "aria-labelledby": id,
    tabIndex: -1,
    onKeyDown: handleListKeyDown,
    css: function css(theme) {
      return dropdownStyles(theme, isDropdownOpen);
    }
  }, dataUieName && {
    'data-uie-name': "dropdown-".concat(dataUieName)
  }), options.map(function (option, index) {
    var isSelected = currentOption == index;
    return (0, _react.jsx)("li", (0, _extends2["default"])({
      key: option.value,
      id: option.value.toString(),
      role: "option",
      "aria-selected": isSelected,
      tabIndex: 0,
      onKeyDown: handleKeyDown(index),
      onClick: function onClick() {
        return onOptionChange(index);
      },
      css: function css(theme) {
        return dropdownOptionStyles(theme, isSelected);
      }
    }, dataUieName && {
      'data-uie-name': "option-".concat(dataUieName),
      'data-uie-value': option.value
    }), option.label, option.description && (0, _react.jsx)("p", {
      css: /*#__PURE__*/(0, _react.css)({
        marginBottom: 0,
        fontSize: '14px',
        color: isSelected ? _Identity.COLOR_V2.WHITE : _Identity.COLOR_V2.GRAY_80
      }, process.env.NODE_ENV === "production" ? "" : ";label:Select;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
    }, option.description));
  }))), !hasError && helperText && (0, _react.jsx)("p", {
    css: /*#__PURE__*/(0, _react.css)({
      fontSize: '12px',
      fontWeight: 400,
      color: _Identity.COLOR_V2.GRAY_80,
      marginTop: 8
    }, process.env.NODE_ENV === "production" ? "" : ";label:Select;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  }, helperText), error);
};

exports.Select = Select;
//# sourceMappingURL=Select.js.map