"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundIconButton = exports.roundIconButtonStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _Identity = require("../Identity");

var _Misc = require("../Misc/");

var _Button = require("./Button");

var _excluded = ["children"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var roundIconButtonStyle = function roundIconButtonStyle(theme, props) {
  return _objectSpread(_objectSpread({}, (0, _Button.buttonStyle)(theme, props)), {}, {
    alignItems: 'center',
    borderRadius: '50%',
    display: 'flex',
    height: "".concat(props.size, "px"),
    justifyContent: 'center',
    lineHeight: 'initial',
    margin: '0 auto',
    minWidth: "".concat(props.size, "px"),
    padding: 0,
    width: "".concat(props.size, "px")
  });
};

exports.roundIconButtonStyle = roundIconButtonStyle;

var RoundIconButton = function RoundIconButton(_ref) {
  var children = _ref.children,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return (0, _react.jsx)("button", (0, _extends2["default"])({
    css: function css(theme) {
      return roundIconButtonStyle(theme, props);
    }
  }, (0, _Button.filterButtonProps)(props)), (0, _Misc.childrenWithDefaultProps)({
    children: children,
    defaultProps: {
      color: _Identity.COLOR.WHITE
    }
  }));
};

exports.RoundIconButton = RoundIconButton;
RoundIconButton.defaultProps = {
  backgroundColor: _Identity.COLOR.BLUE,
  size: 32
};
//# sourceMappingURL=RoundIconButton.js.map