"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowManager = void 0;
const electron_1 = require("electron");
const path = __importStar(require("path"));
const getLogger_1 = require("../logging/getLogger");
const logger = (0, getLogger_1.getLogger)(path.basename(__filename));
class WindowManager {
    static getPrimaryWindow() {
        const [primaryWindow] = WindowManager.primaryWindowId
            ? [electron_1.BrowserWindow.fromId(WindowManager.primaryWindowId)]
            : electron_1.BrowserWindow.getAllWindows();
        if (primaryWindow) {
            logger.info(`Got primaryWindow with ID "${primaryWindow.id}"`);
            return primaryWindow;
        }
        return undefined;
    }
    static setPrimaryWindowId(newPrimaryWindowId) {
        logger.info(`Setting primary window ID to "${newPrimaryWindowId}" ...`);
        WindowManager.primaryWindowId = newPrimaryWindowId;
    }
    static showPrimaryWindow() {
        const browserWindow = WindowManager.getPrimaryWindow();
        if (browserWindow) {
            if (browserWindow.isMinimized()) {
                browserWindow.restore();
            }
            else if (!browserWindow.isVisible()) {
                browserWindow.show();
            }
            browserWindow.focus();
        }
    }
    static sendActionToPrimaryWindow(action, ...args) {
        const primaryWindow = WindowManager.getPrimaryWindow();
        if (primaryWindow) {
            logger.info(`Sending action "${action}" to window with ID "${primaryWindow.id}":`, { args });
            primaryWindow.webContents.send(action, ...args);
        }
        else {
            logger.warn(`Got no primary window, can't send action "${action}".`);
        }
    }
    static flushActionsQueue() {
        const actions = WindowManager.actionsQueue;
        if (actions) {
            actions.forEach(({ action, args }) => this.sendActionToPrimaryWindow(action, ...args));
            WindowManager.actionsQueue = [];
        }
    }
    static sendActionAndFocusWindow(action, ...args) {
        return __awaiter(this, void 0, void 0, function* () {
            yield electron_1.app.whenReady();
            const primaryWindow = WindowManager.getPrimaryWindow();
            if (primaryWindow) {
                if (primaryWindow.webContents.isLoading()) {
                    WindowManager.actionsQueue.push({ action, args });
                }
                else {
                    if (!primaryWindow.isVisible()) {
                        primaryWindow.show();
                        primaryWindow.focus();
                    }
                    primaryWindow.webContents.send(action, ...args);
                }
            }
            else {
                logger.warn(`Got no primary window, can't send action "${action}".`);
            }
        });
    }
}
exports.WindowManager = WindowManager;
WindowManager.actionsQueue = [];
//# sourceMappingURL=WindowManager.js.map