"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLogger = exports.ENABLE_LOGGING = exports.LOGGER_NAMESPACE = void 0;
const commons_1 = require("@wireapp/commons");
const Electron = __importStar(require("electron"));
const path = __importStar(require("path"));
const config_1 = require("../settings/config");
const mainProcess = process || require('@electron/remote').process;
const app = Electron.app || require('@electron/remote').app;
const logDir = path.join(app.getPath('userData'), 'logs');
const logFile = path.join(logDir, 'electron.log');
const isDevelopment = config_1.config.environment !== 'production';
const forceLogging = mainProcess.argv.includes('--enable-logging');
exports.LOGGER_NAMESPACE = '@wireapp/desktop';
exports.ENABLE_LOGGING = isDevelopment || forceLogging;
function getLogger(name) {
    const options = {
        logFilePath: logFile,
        namespace: exports.LOGGER_NAMESPACE,
        separator: '/',
    };
    if (exports.ENABLE_LOGGING) {
        options.forceEnable = true;
    }
    return commons_1.LogFactory.getLogger(name, options);
}
exports.getLogger = getLogger;
//# sourceMappingURL=getLogger.js.map