"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setLocale = exports.getText = exports.getCurrent = exports.SUPPORTED_LANGUAGES = exports.supportedSpellCheckLanguages = exports.LANGUAGES = void 0;
const Electron = __importStar(require("electron"));
const config_1 = require("../settings/config");
const ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
const SettingsType_1 = require("../settings/SettingsType");
const cs_CZ_json_1 = __importDefault(require("./cs-CZ.json"));
const da_DK_json_1 = __importDefault(require("./da-DK.json"));
const de_DE_json_1 = __importDefault(require("./de-DE.json"));
const el_GR_json_1 = __importDefault(require("./el-GR.json"));
const en_US_json_1 = __importDefault(require("./en-US.json"));
const es_ES_json_1 = __importDefault(require("./es-ES.json"));
const et_EE_json_1 = __importDefault(require("./et-EE.json"));
const fi_FI_json_1 = __importDefault(require("./fi-FI.json"));
const fr_FR_json_1 = __importDefault(require("./fr-FR.json"));
const hr_HR_json_1 = __importDefault(require("./hr-HR.json"));
const hu_HU_json_1 = __importDefault(require("./hu-HU.json"));
const it_IT_json_1 = __importDefault(require("./it-IT.json"));
const lt_LT_json_1 = __importDefault(require("./lt-LT.json"));
const nl_NL_json_1 = __importDefault(require("./nl-NL.json"));
const pl_PL_json_1 = __importDefault(require("./pl-PL.json"));
const pt_BR_json_1 = __importDefault(require("./pt-BR.json"));
const ro_RO_json_1 = __importDefault(require("./ro-RO.json"));
const ru_RU_json_1 = __importDefault(require("./ru-RU.json"));
const si_LK_json_1 = __importDefault(require("./si-LK.json"));
const sk_SK_json_1 = __importDefault(require("./sk-SK.json"));
const sl_SI_json_1 = __importDefault(require("./sl-SI.json"));
const tr_TR_json_1 = __importDefault(require("./tr-TR.json"));
const uk_UA_json_1 = __importDefault(require("./uk-UA.json"));
const zh_CN_json_1 = __importDefault(require("./zh-CN.json"));
const app = Electron.app || require('@electron/remote').app;
exports.LANGUAGES = {
    cs: cs_CZ_json_1.default,
    da: da_DK_json_1.default,
    de: de_DE_json_1.default,
    el: el_GR_json_1.default,
    en: en_US_json_1.default,
    es: es_ES_json_1.default,
    et: et_EE_json_1.default,
    fi: fi_FI_json_1.default,
    fr: fr_FR_json_1.default,
    hr: hr_HR_json_1.default,
    hu: hu_HU_json_1.default,
    it: it_IT_json_1.default,
    lt: lt_LT_json_1.default,
    nl: nl_NL_json_1.default,
    pl: pl_PL_json_1.default,
    pt: pt_BR_json_1.default,
    ro: ro_RO_json_1.default,
    ru: ru_RU_json_1.default,
    si: si_LK_json_1.default,
    sk: sk_SK_json_1.default,
    sl: sl_SI_json_1.default,
    tr: tr_TR_json_1.default,
    uk: uk_UA_json_1.default,
    zh: zh_CN_json_1.default,
};
exports.supportedSpellCheckLanguages = {
    cs: ['cs', 'cs-CZ'],
    da: ['da', 'da-DK'],
    de: ['de', 'de-DE'],
    el: ['el', 'el-GR'],
    en: ['en', 'en-US'],
    es: ['es', 'es-ES'],
    et: ['et', 'et-EE'],
    fi: ['fi', 'fi-FI'],
    fr: ['fr', 'fr-FR'],
    hr: ['hr', 'hr-HR'],
    hu: ['hu', 'hu-HU'],
    it: ['it', 'it-IT'],
    lt: ['lt', 'lt-LT'],
    nl: ['nl', 'nl-NL'],
    pl: ['pl', 'pl-PL'],
    pt: ['pt', 'pt-BR'],
    ro: ['ro', 'ro-RO'],
    ru: ['ru', 'ru-RU'],
    si: ['si', 'si-LK'],
    sk: ['sk', 'sk-SK'],
    sl: ['sl', 'sl-SI'],
    tr: ['tr', 'tr-TR'],
    uk: ['uk', 'uk-UA'],
    zh: ['zh', 'zh-CN'],
};
exports.SUPPORTED_LANGUAGES = {
    en: 'English',
    cs: 'Čeština',
    da: 'Dansk',
    de: 'Deutsch',
    el: 'Ελληνικά',
    et: 'Eesti',
    es: 'Español',
    fr: 'Français',
    hr: 'Hrvatski',
    it: 'Italiano',
    lt: 'Lietuvos',
    hu: 'Magyar',
    nl: 'Nederlands',
    pl: 'Polski',
    pt: 'Português do Brasil',
    ro: 'Română',
    ru: 'Русский',
    si: 'සිංහල',
    sk: 'Slovenčina',
    sl: 'Slovenščina',
    fi: 'Suomi',
    tr: 'Türkçe',
    uk: 'Українська',
    zh: '简体中文',
};
let current;
const getCurrent = () => {
    if (!current) {
        const defaultLocale = parseLocale(app.getLocale().substring(0, 2));
        current = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.LOCALE, defaultLocale);
    }
    return current;
};
exports.getCurrent = getCurrent;
const parseLocale = (locale) => {
    const languageKeys = Object.keys(exports.SUPPORTED_LANGUAGES);
    return languageKeys.find(languageKey => languageKey === locale) || languageKeys[0];
};
const customReplacements = {
    brandName: config_1.config.name,
};
const getText = (stringIdentifier, paramReplacements) => {
    const strings = (0, exports.getCurrent)();
    let translationText = exports.LANGUAGES[strings][stringIdentifier] || exports.LANGUAGES.en[stringIdentifier];
    if (!translationText) {
        throw new Error(`Translation for "${stringIdentifier}" could not be found.`);
    }
    const replacements = Object.assign(Object.assign({}, customReplacements), paramReplacements);
    for (const replacement of Object.keys(replacements)) {
        const regex = new RegExp(`{${replacement}}`, 'g');
        if (translationText.match(regex)) {
            translationText = translationText.replace(regex, replacements[replacement]);
        }
    }
    return translationText;
};
exports.getText = getText;
const setLocale = (locale) => {
    current = parseLocale(locale);
    ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.LOCALE, current);
};
exports.setLocale = setLocale;
//# sourceMappingURL=index.js.map