import type * as lsp from 'vscode-languageserver';
import tsp from 'typescript/lib/protocol.d.js';
import { LspDocuments } from './document.js';
import type { TypeScriptInitializationOptions } from './ts-protocol.js';
import type { TspClient } from './tsp-client.js';
export interface WorkspaceConfiguration {
    javascript?: WorkspaceConfigurationLanguageOptions;
    typescript?: WorkspaceConfigurationLanguageOptions;
    completions?: WorkspaceConfigurationCompletionOptions;
    diagnostics?: WorkspaceConfigurationDiagnosticsOptions;
    implicitProjectConfiguration?: WorkspaceConfigurationImplicitProjectConfigurationOptions;
}
export interface WorkspaceConfigurationLanguageOptions {
    format?: tsp.FormatCodeSettings;
    inlayHints?: TypeScriptInlayHintsPreferences;
}
export interface WorkspaceConfigurationImplicitProjectConfigurationOptions {
    checkJs?: boolean;
    experimentalDecorators?: boolean;
    module?: string;
    strictFunctionTypes?: boolean;
    strictNullChecks?: boolean;
    target?: string;
}
export declare type TypeScriptInlayHintsPreferences = Pick<tsp.UserPreferences, 'includeInlayParameterNameHints' | 'includeInlayParameterNameHintsWhenArgumentMatchesName' | 'includeInlayFunctionParameterTypeHints' | 'includeInlayVariableTypeHints' | 'includeInlayVariableTypeHintsWhenTypeMatchesName' | 'includeInlayPropertyDeclarationTypeHints' | 'includeInlayFunctionLikeReturnTypeHints' | 'includeInlayEnumMemberValueHints'>;
interface WorkspaceConfigurationDiagnosticsOptions {
    ignoredCodes?: number[];
}
export interface WorkspaceConfigurationCompletionOptions {
    completeFunctionCalls?: boolean;
}
export declare class ConfigurationManager {
    private readonly documents;
    tsPreferences: Required<tsp.UserPreferences>;
    workspaceConfiguration: WorkspaceConfiguration;
    private tspClient;
    constructor(documents: LspDocuments);
    mergeTsPreferences(preferences: tsp.UserPreferences): void;
    setWorkspaceConfiguration(configuration: WorkspaceConfiguration): void;
    setAndConfigureTspClient(workspaceFolder: string | undefined, client: TspClient, hostInfo?: TypeScriptInitializationOptions['hostInfo']): void;
    configureGloballyFromDocument(filename: string, formattingOptions?: lsp.FormattingOptions): Promise<void>;
    getPreferences(filename: string): tsp.UserPreferences;
    private getFormattingOptions;
    private getQuoteStylePreference;
    private getWorkspacePreferencesForFile;
    private getAutoImportFileExcludePatternsPreference;
}
export {};
//# sourceMappingURL=configuration-manager.d.ts.map