/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// BufferPacking
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class BufferPackingBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BufferPackingBase;

  BufferPackingBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferPackingBase(const BufferPackingBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-packing");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-packing"; }

  ::llvm::StringRef getDescription() const override { return "Pass to pack allocated buffer to reduce memory consumption."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferPacking");
  }
  ::llvm::StringRef getName() const override { return "BufferPacking"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<func::FuncDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<arith::ArithmeticDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferPackingBase<DerivedT>)

protected:
  ::mlir::Pass::Option<unsigned> window_size_{*this, "window-size", ::llvm::cl::desc("The window size blurs the start position of anallocated buffer. Buffers allocated in the same sliding window areaare treated equally in terms of starting position, withing thesliding window area they are sorted by memory size.A window size of zero sorts the buffers only by memory size."), ::llvm::cl::init(5)};
};

//===----------------------------------------------------------------------===//
// BufferReuse
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class BufferReuseBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BufferReuseBase;

  BufferReuseBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BufferReuseBase(const BufferReuseBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("buffer-reuse");
  }
  ::llvm::StringRef getArgument() const override { return "buffer-reuse"; }

  ::llvm::StringRef getDescription() const override { return "Reuses already allocated buffers to save allocation operations if it is provably safe."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BufferReuse");
  }
  ::llvm::StringRef getName() const override { return "BufferReuse"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BufferReuseBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// CollapseParallelLoopsTo1DPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CollapseParallelLoopsTo1DPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = CollapseParallelLoopsTo1DPassBase;

  CollapseParallelLoopsTo1DPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  CollapseParallelLoopsTo1DPassBase(const CollapseParallelLoopsTo1DPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("collapse-parallel-loops-to-1d");
  }
  ::llvm::StringRef getArgument() const override { return "collapse-parallel-loops-to-1d"; }

  ::llvm::StringRef getDescription() const override { return "Collapses multidimensional loops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("CollapseParallelLoopsTo1DPass");
  }
  ::llvm::StringRef getName() const override { return "CollapseParallelLoopsTo1DPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(CollapseParallelLoopsTo1DPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// ComputeOpAndFuncBufferizePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ComputeOpAndFuncBufferizePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = ComputeOpAndFuncBufferizePassBase;

  ComputeOpAndFuncBufferizePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ComputeOpAndFuncBufferizePassBase(const ComputeOpAndFuncBufferizePassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("computeop-and-func-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "computeop-and-func-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform compute operations (hlo and linalg) on values to buffer based ones."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ComputeOpAndFuncBufferizePass");
  }
  ::llvm::StringRef getName() const override { return "ComputeOpAndFuncBufferizePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ComputeOpAndFuncBufferizePassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// CopyRemoval
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CopyRemovalBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = CopyRemovalBase;

  CopyRemovalBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  CopyRemovalBase(const CopyRemovalBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("copy-removal");
  }
  ::llvm::StringRef getArgument() const override { return "copy-removal"; }

  ::llvm::StringRef getDescription() const override { return "Removes redundant operations that implement a CopyOpInterface, if the intersection of the useranges fromcopy source and target only contains the CopyOp."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("CopyRemoval");
  }
  ::llvm::StringRef getName() const override { return "CopyRemoval"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(CopyRemovalBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// FinalBufferizePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class FinalBufferizePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = FinalBufferizePassBase;

  FinalBufferizePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  FinalBufferizePassBase(const FinalBufferizePassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("final-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "final-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform late operations on values to buffer based ones."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FinalBufferizePass");
  }
  ::llvm::StringRef getName() const override { return "FinalBufferizePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FinalBufferizePassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<uint64_t> alignment_{*this, "alignment", ::llvm::cl::desc("Memory alignment"), ::llvm::cl::init(64)};
};

//===----------------------------------------------------------------------===//
// GenericHostToLLVMPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class GenericHostToLLVMPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = GenericHostToLLVMPassBase;

  GenericHostToLLVMPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  GenericHostToLLVMPassBase(const GenericHostToLLVMPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("generic-host-to-llvm");
  }
  ::llvm::StringRef getArgument() const override { return "generic-host-to-llvm"; }

  ::llvm::StringRef getDescription() const override { return "Pass to lower common dialects resulting from HLO to LLVM."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GenericHostToLLVMPass");
  }
  ::llvm::StringRef getName() const override { return "GenericHostToLLVMPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(GenericHostToLLVMPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// LowerIndexCastPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LowerIndexCastPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = LowerIndexCastPassBase;

  LowerIndexCastPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LowerIndexCastPassBase(const LowerIndexCastPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("lower-index-cast");
  }
  ::llvm::StringRef getArgument() const override { return "lower-index-cast"; }

  ::llvm::StringRef getDescription() const override { return "Lower index cast on tensors to tensor dialect"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LowerIndexCastPass");
  }
  ::llvm::StringRef getName() const override { return "LowerIndexCastPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LowerIndexCastPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// MemoryCount
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class MemoryCountBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = MemoryCountBase;

  MemoryCountBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  MemoryCountBase(const MemoryCountBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("memory-count");
  }
  ::llvm::StringRef getArgument() const override { return "memory-count"; }

  ::llvm::StringRef getDescription() const override { return "Test pass to count the allocated memory of a module."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MemoryCount");
  }
  ::llvm::StringRef getName() const override { return "MemoryCount"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(MemoryCountBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// OneShotBufferize
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class OneShotBufferizeBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = OneShotBufferizeBase;

  OneShotBufferizeBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  OneShotBufferizeBase(const OneShotBufferizeBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("hlo-one-shot-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "hlo-one-shot-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "One shot bufferization pass."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OneShotBufferize");
  }
  ::llvm::StringRef getName() const override { return "OneShotBufferize"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OneShotBufferizeBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// PropagateStaticShapesToKernelPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class PropagateStaticShapesToKernelPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = PropagateStaticShapesToKernelPassBase;

  PropagateStaticShapesToKernelPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  PropagateStaticShapesToKernelPassBase(const PropagateStaticShapesToKernelPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("propagate-static-shapes");
  }
  ::llvm::StringRef getArgument() const override { return "propagate-static-shapes"; }

  ::llvm::StringRef getDescription() const override { return "Pass to rewrite statically shaped kernel arguments to a pointer."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PropagateStaticShapesToKernelPass");
  }
  ::llvm::StringRef getName() const override { return "PropagateStaticShapesToKernelPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(PropagateStaticShapesToKernelPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<std::string> ptr_type_opt{*this, "convert_pointer_args", ::llvm::cl::desc("Pointer type to convert pointer arguments to")};
};

//===----------------------------------------------------------------------===//
// ShapeSimplification
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ShapeSimplificationBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = ShapeSimplificationBase;

  ShapeSimplificationBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ShapeSimplificationBase(const ShapeSimplificationBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("shape-simplification");
  }
  ::llvm::StringRef getArgument() const override { return "shape-simplification"; }

  ::llvm::StringRef getDescription() const override { return "Simplify shape ops"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ShapeSimplification");
  }
  ::llvm::StringRef getName() const override { return "ShapeSimplification"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ShapeSimplificationBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// SymbolicShapeOptimization
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SymbolicShapeOptimizationBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = SymbolicShapeOptimizationBase;

  SymbolicShapeOptimizationBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  SymbolicShapeOptimizationBase(const SymbolicShapeOptimizationBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("symbolic-shape-optimization");
  }
  ::llvm::StringRef getArgument() const override { return "symbolic-shape-optimization"; }

  ::llvm::StringRef getDescription() const override { return "Analyzes shapes and performs shape-related optimizations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SymbolicShapeOptimization");
  }
  ::llvm::StringRef getName() const override { return "SymbolicShapeOptimization"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SymbolicShapeOptimizationBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// TestShapeComponentAnalysis
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TestShapeComponentAnalysisBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = TestShapeComponentAnalysisBase;

  TestShapeComponentAnalysisBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TestShapeComponentAnalysisBase(const TestShapeComponentAnalysisBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("test-print-shape-components");
  }
  ::llvm::StringRef getArgument() const override { return "test-print-shape-components"; }

  ::llvm::StringRef getDescription() const override { return "Test pass for analyzing shape components."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TestShapeComponentAnalysis");
  }
  ::llvm::StringRef getName() const override { return "TestShapeComponentAnalysis"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TestShapeComponentAnalysisBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// TestUserange
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TestUserangeBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = TestUserangeBase;

  TestUserangeBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TestUserangeBase(const TestUserangeBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("test-print-userange");
  }
  ::llvm::StringRef getArgument() const override { return "test-print-userange"; }

  ::llvm::StringRef getDescription() const override { return "Test pass for checking userange intervals."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TestUserange");
  }
  ::llvm::StringRef getName() const override { return "TestUserange"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TestUserangeBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// TileLoopsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TileLoopsPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = TileLoopsPassBase;

  TileLoopsPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TileLoopsPassBase(const TileLoopsPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tile-loops");
  }
  ::llvm::StringRef getArgument() const override { return "tile-loops"; }

  ::llvm::StringRef getDescription() const override { return "Tiles parallel loops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TileLoopsPass");
  }
  ::llvm::StringRef getName() const override { return "TileLoopsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<AffineDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TileLoopsPassBase<DerivedT>)

protected:
  ::mlir::Pass::ListOption<int64_t> tile_sizes_{*this, "tile-sizes", ::llvm::cl::desc("The size of the tile in each dimension, expressed as the number of `unroll_factors_` in that dimension."), llvm::cl::ZeroOrMore};
  ::mlir::Pass::ListOption<int64_t> unroll_factors_{*this, "unroll-factors", ::llvm::cl::desc("The unroll factor in each dimension, expressed as the number of elements in that dimension."), llvm::cl::ZeroOrMore};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// BufferPacking Registration
//===----------------------------------------------------------------------===//

inline void registerBufferPackingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferPackingPass();
  });
}

//===----------------------------------------------------------------------===//
// BufferReuse Registration
//===----------------------------------------------------------------------===//

inline void registerBufferReusePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBufferReusePass();
  });
}

//===----------------------------------------------------------------------===//
// CollapseParallelLoopsTo1DPass Registration
//===----------------------------------------------------------------------===//

inline void registerCollapseParallelLoopsTo1DPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createCollapseParallelLoopsTo1DPass();
  });
}

//===----------------------------------------------------------------------===//
// ComputeOpAndFuncBufferizePass Registration
//===----------------------------------------------------------------------===//

inline void registerComputeOpAndFuncBufferizePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createComputeOpAndFuncBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// CopyRemoval Registration
//===----------------------------------------------------------------------===//

inline void registerCopyRemovalPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createCopyRemovalPass();
  });
}

//===----------------------------------------------------------------------===//
// FinalBufferizePass Registration
//===----------------------------------------------------------------------===//

inline void registerFinalBufferizePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createFinalBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// GenericHostToLLVMPass Registration
//===----------------------------------------------------------------------===//

inline void registerGenericHostToLLVMPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return hlo::createGenericHostToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// LowerIndexCastPass Registration
//===----------------------------------------------------------------------===//

inline void registerLowerIndexCastPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLowerIndexCastPass();
  });
}

//===----------------------------------------------------------------------===//
// MemoryCount Registration
//===----------------------------------------------------------------------===//

inline void registerMemoryCountPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createMemoryCountPass();
  });
}

//===----------------------------------------------------------------------===//
// OneShotBufferize Registration
//===----------------------------------------------------------------------===//

inline void registerOneShotBufferizePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return hlo::createOneShotBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// PropagateStaticShapesToKernelPass Registration
//===----------------------------------------------------------------------===//

inline void registerPropagateStaticShapesToKernelPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createPropagateStaticShapesToKernelPass();
  });
}

//===----------------------------------------------------------------------===//
// ShapeSimplification Registration
//===----------------------------------------------------------------------===//

inline void registerShapeSimplificationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createShapeSimplification();
  });
}

//===----------------------------------------------------------------------===//
// SymbolicShapeOptimization Registration
//===----------------------------------------------------------------------===//

inline void registerSymbolicShapeOptimizationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createSymbolicShapeOptimizationPass();
  });
}

//===----------------------------------------------------------------------===//
// TestShapeComponentAnalysis Registration
//===----------------------------------------------------------------------===//

inline void registerTestShapeComponentAnalysisPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTestShapeComponentAnalysisPass();
  });
}

//===----------------------------------------------------------------------===//
// TestUserange Registration
//===----------------------------------------------------------------------===//

inline void registerTestUserangePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTestUserangePass();
  });
}

//===----------------------------------------------------------------------===//
// TileLoopsPass Registration
//===----------------------------------------------------------------------===//

inline void registerTileLoopsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTileLoopsPass();
  });
}

//===----------------------------------------------------------------------===//
// LMHLOTransforms Registration
//===----------------------------------------------------------------------===//

inline void registerLMHLOTransformsPasses() {
  registerBufferPackingPass();
  registerBufferReusePass();
  registerCollapseParallelLoopsTo1DPassPass();
  registerComputeOpAndFuncBufferizePassPass();
  registerCopyRemovalPass();
  registerFinalBufferizePassPass();
  registerGenericHostToLLVMPassPass();
  registerLowerIndexCastPassPass();
  registerMemoryCountPass();
  registerOneShotBufferizePass();
  registerPropagateStaticShapesToKernelPassPass();
  registerShapeSimplificationPass();
  registerSymbolicShapeOptimizationPass();
  registerTestShapeComponentAnalysisPass();
  registerTestUserangePass();
  registerTileLoopsPassPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
