/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::tfg::CaseOp,
::mlir::tfg::CaseRegionOp,
::mlir::tfg::ConditionOp,
::mlir::tfg::ForOp,
::mlir::tfg::ForRegionOp,
::mlir::tfg::GetResultOp,
::mlir::tfg::GraphFuncOp,
::mlir::tfg::GraphOp,
::mlir::tfg::IfOp,
::mlir::tfg::IfRegionOp,
::mlir::tfg::ReturnOp,
::mlir::tfg::StatefulCaseOp,
::mlir::tfg::StatefulCaseRegionOp,
::mlir::tfg::StatefulIfOp,
::mlir::tfg::StatefulIfRegionOp,
::mlir::tfg::StatefulWhileOp,
::mlir::tfg::StatefulWhileRegionOp,
::mlir::tfg::StatelessCaseOp,
::mlir::tfg::StatelessCaseRegionOp,
::mlir::tfg::StatelessIfOp,
::mlir::tfg::StatelessIfRegionOp,
::mlir::tfg::StatelessWhileOp,
::mlir::tfg::StatelessWhileRegionOp,
::mlir::tfg::WhileOp,
::mlir::tfg::WhileRegionOp,
::mlir::tfg::YieldOp
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace mlir {
namespace tfg {

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops0(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(32)); }(type.cast<::mlir::ShapedType>().getElementType()))) || ((type.isa<::mlir::tf_type::OpaqueTensorType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be  or opaque tensor type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (true); }(type.cast<::mlir::ShapedType>().getElementType()))) || ((type.isa<::mlir::tf_type::OpaqueTensorType>()))) || ((type.isa<::mlir::tf_type::ControlType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any tensor or control type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (true); }(type.cast<::mlir::ShapedType>().getElementType()))) || ((type.isa<::mlir::tf_type::OpaqueTensorType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be  or opaque tensor type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isa<::mlir::tf_type::ControlType>()))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be , but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(32)); }(type.cast<::mlir::ShapedType>().getElementType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be tensor of 32-bit signless integer values, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops5(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(1)); }(type.cast<::mlir::ShapedType>().getElementType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be tensor of 1-bit signless integer values, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops6(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isa<::mlir::tf_type::OpaqueTensorType>()))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be , but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops7(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(1)); }(type.cast<::mlir::ShapedType>().getElementType()))) || ((type.isa<::mlir::tf_type::OpaqueTensorType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be  or opaque tensor type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops8(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((true))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops0(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::FuncAttr>())); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: an array of functions";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: type array attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: An array of shapes.";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::DictionaryAttr>())); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: an array of dictionaries";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops4(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tfg::RegionAttr>())); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: case region preserved attributes";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops5(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::tf_type::FuncAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops6(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::DictionaryAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: dictionary of named attribute values";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops7(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::tfg::RegionAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: Region attributes, argument and result attributes.";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops8(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::StringAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: string attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops9(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::IntegerAttr>())) && ((attr.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(32))))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops10(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::UnitAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: unit attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops11(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::FunctionType>())))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: type attribute of function type";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops12(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::ArrayAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: array attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops13(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::FlatSymbolRefAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: flat symbol reference attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops14(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::DenseIntElementsAttr>())) && ((attr.cast<::mlir::DenseIntElementsAttr>().getType().getElementType().isSignlessInteger(32))))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: 32-bit signless integer elements attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops15(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::StringAttr>())); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: string array attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops16(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::tf_type::VersionAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: An Attribute describing the version for a TensorFlow Graph";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops17(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: any type attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops18(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::IntegerAttr>())) && ((attr.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64))))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: 64-bit signless integer attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_region_constraint_ops0(
    ::mlir::Operation *op, ::mlir::Region &region, ::llvm::StringRef regionName,
    unsigned regionIndex) {
  if (!((::llvm::hasNItems(region, 1)))) {
    return op->emitOpError("region #") << regionIndex
        << (regionName.empty() ? " " : " ('" + regionName + "') ")
        << "failed to verify constraint: region with 1 blocks";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_region_constraint_ops1(
    ::mlir::Operation *op, ::mlir::Region &region, ::llvm::StringRef regionName,
    unsigned regionIndex) {
  if (!((true))) {
    return op->emitOpError("region #") << regionIndex
        << (regionName.empty() ? " " : " ('" + regionName + "') ")
        << "failed to verify constraint: any region";
  }
  return ::mlir::success();
}
} // namespace tfg
} // namespace mlir
namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::CaseOp definitions
//===----------------------------------------------------------------------===//

CaseOpAdaptor::CaseOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.Case", odsAttrs.getContext());
}

CaseOpAdaptor::CaseOpAdaptor(CaseOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange CaseOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> CaseOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange CaseOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CaseOpAdaptor::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange CaseOpAdaptor::args() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr CaseOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr CaseOpAdaptor::branchesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, CaseOp::branchesAttrName(*odsOpName)).cast<::mlir::ArrayAttr>();
  return attr;
}

::mlir::ArrayAttr CaseOpAdaptor::branches() {
  auto attr = branchesAttr();
  return attr;
}

::mlir::ArrayAttr CaseOpAdaptor::TinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, CaseOp::TinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > CaseOpAdaptor::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr CaseOpAdaptor::ToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, CaseOp::ToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > CaseOpAdaptor::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr CaseOpAdaptor::output_shapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, CaseOp::output_shapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > CaseOpAdaptor::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::LogicalResult CaseOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.Case' op ""requires attribute 'branches'");
    if (namedAttrIt->getName() == CaseOp::branchesAttrName(*odsOpName)) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == CaseOp::TinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == CaseOp::ToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == CaseOp::output_shapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branches && !(((tblgen_branches.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branches.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::FuncAttr>())); }))))
    return emitError(loc, "'tfg.Case' op ""attribute 'branches' failed to satisfy constraint: an array of functions");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.Case' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.Case' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.Case' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void CaseOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!llvm::empty(resultGroup0))
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!llvm::empty(resultGroup1))
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> CaseOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range CaseOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CaseOp::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range CaseOp::args() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange CaseOp::branch_indexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange CaseOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> CaseOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range CaseOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range CaseOp::outs() {
  return getODSResults(0);
}

::mlir::Value CaseOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::ArrayAttr CaseOp::branchesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, branchesAttrName()).cast<::mlir::ArrayAttr>();
}

::mlir::ArrayAttr CaseOp::branches() {
  auto attr = branchesAttr();
  return attr;
}

::mlir::ArrayAttr CaseOp::TinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, TinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > CaseOp::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr CaseOp::ToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, ToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > CaseOp::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr CaseOp::output_shapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, output_shapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > CaseOp::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void CaseOp::branchesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(branchesAttrName(), attr);
}

void CaseOp::TinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(TinAttrName(), attr);
}

void CaseOp::ToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(ToutAttrName(), attr);
}

void CaseOp::output_shapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(output_shapesAttrName(), attr);
}

::mlir::Attribute CaseOp::removeTinAttr() {
  return (*this)->removeAttr(TinAttrName());
}

::mlir::Attribute CaseOp::removeToutAttr() {
  return (*this)->removeAttr(ToutAttrName());
}

::mlir::Attribute CaseOp::removeOutput_shapesAttr() {
  return (*this)->removeAttr(output_shapesAttrName());
}

void CaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value branch_index, ValueRange args, ArrayAttr branches) {
      build(odsBuilder, odsState, results, branch_index, args, branches,
            /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void CaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(branchesAttrName(odsState.name), branches);
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void CaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(branchesAttrName(odsState.name), branches);
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CaseOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CaseOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'branches'");
    if (namedAttrIt->getName() == branchesAttrName()) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == TinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == ToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == output_shapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops0(*this, tblgen_branches, "branches")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CaseOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult CaseOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyCaseLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::CaseOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::CaseRegionOp definitions
//===----------------------------------------------------------------------===//

CaseRegionOpAdaptor::CaseRegionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.CaseRegion", odsAttrs.getContext());
}

CaseRegionOpAdaptor::CaseRegionOpAdaptor(CaseRegionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange CaseRegionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> CaseRegionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange CaseRegionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CaseRegionOpAdaptor::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange CaseRegionOpAdaptor::ctls() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr CaseRegionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr CaseRegionOpAdaptor::branch_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, CaseRegionOp::branch_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > CaseRegionOpAdaptor::branch_attrs() {
  auto attr = branch_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr CaseRegionOpAdaptor::region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, CaseRegionOp::region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > CaseRegionOpAdaptor::region_attrs() {
  auto attr = region_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::RegionRange CaseRegionOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::RegionRange CaseRegionOpAdaptor::branches() {
  return odsRegions.drop_front(0);
}

::mlir::LogicalResult CaseRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == CaseRegionOp::branch_attrsAttrName(*odsOpName)) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == CaseRegionOp::region_attrsAttrName(*odsOpName)) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branch_attrs && !(((tblgen_branch_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branch_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::DictionaryAttr>())); }))))
    return emitError(loc, "'tfg.CaseRegion' op ""attribute 'branch_attrs' failed to satisfy constraint: an array of dictionaries");

  if (tblgen_region_attrs && !(((tblgen_region_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_region_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tfg::RegionAttr>())); }))))
    return emitError(loc, "'tfg.CaseRegion' op ""attribute 'region_attrs' failed to satisfy constraint: case region preserved attributes");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CaseRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range CaseRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CaseRegionOp::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range CaseRegionOp::ctls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange CaseRegionOp::branch_indexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange CaseRegionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> CaseRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range CaseRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range CaseRegionOp::outs() {
  return getODSResults(0);
}

::mlir::Value CaseRegionOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::MutableArrayRef<::mlir::Region> CaseRegionOp::branches() {
  return (*this)->getRegions().drop_front(0);
}

::mlir::ArrayAttr CaseRegionOp::branch_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, branch_attrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > CaseRegionOp::branch_attrs() {
  auto attr = branch_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr CaseRegionOp::region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, region_attrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > CaseRegionOp::region_attrs() {
  auto attr = region_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void CaseRegionOp::branch_attrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(branch_attrsAttrName(), attr);
}

void CaseRegionOp::region_attrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(region_attrsAttrName(), attr);
}

::mlir::Attribute CaseRegionOp::removeBranch_attrsAttr() {
  return (*this)->removeAttr(branch_attrsAttrName());
}

::mlir::Attribute CaseRegionOp::removeRegion_attrsAttr() {
  return (*this)->removeAttr(region_attrsAttrName());
}

void CaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
  odsState.addAttribute(branch_attrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
  odsState.addAttribute(region_attrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void CaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
  odsState.addAttribute(branch_attrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
  odsState.addAttribute(region_attrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CaseRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != numRegions; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CaseRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == branch_attrsAttrName()) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == region_attrsAttrName()) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops3(*this, tblgen_branch_attrs, "branch_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops4(*this, tblgen_region_attrs, "region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : branches())
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "branches", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult CaseRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult CaseRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand branch_indexRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> branch_indexOperands(branch_indexRawOperands);  ::llvm::SMLoc branch_indexOperandsLoc;
  (void)branch_indexOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::llvm::SmallVector<std::unique_ptr<::mlir::Region>, 2> branchesRegions;
  ::llvm::ArrayRef<::mlir::Type> branch_indexTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  branch_indexOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(branch_indexRawOperands[0]))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  {
    std::unique_ptr<::mlir::Region> region;
    auto firstRegionResult = parser.parseOptionalRegion(region);
    if (firstRegionResult.hasValue()) {
      if (failed(*firstRegionResult))
        return ::mlir::failure();
      branchesRegions.emplace_back(std::move(region));

      // Parse any trailing regions.
      while (succeeded(parser.parseOptionalComma())) {
        region = std::make_unique<::mlir::Region>();
        if (parser.parseRegion(*region))
          return ::mlir::failure();
        branchesRegions.emplace_back(std::move(region));
      }
    }
  }

  for (auto &region : branchesRegions)
    if (region->empty()) region->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType branch_index__outs_functionType;
  if (parser.parseType(branch_index__outs_functionType))
    return ::mlir::failure();
  branch_indexTypes = branch_index__outs_functionType.getInputs();
  outsTypes = branch_index__outs_functionType.getResults();
  result.addRegions(branchesRegions);
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(branch_indexOperands, branch_indexTypes, branch_indexOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CaseRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << branch_index();
  if (!ctls().empty()) {
  _odsPrinter << ' ';
  _odsPrinter << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter << ' ';
    llvm::interleaveComma(branches(), _odsPrinter, [&](::mlir::Region &region) {
        _odsPrinter.printRegion(region);
    });
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{});
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(branch_index().getType()), outs().getTypes());
}

StringRef CaseRegionOp::getDefaultDialect() { return "tfg"; }
void CaseRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp CaseRegionOp::branch_yield(unsigned idx) {
  return cast<YieldOp>(branch_block(idx).getTerminator());
}

void CaseRegionOp::getSuccessorRegions(
    Optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetCaseLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void CaseRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(getNumRegions(), /*Elt=*/{0, 1});
}

LogicalResult CaseRegionOp::verify() { return VerifyCaseLikeRegionOp(*this); }

BlockArgument CaseRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument CaseRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument CaseRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument CaseRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::CaseRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::ConditionOp definitions
//===----------------------------------------------------------------------===//

ConditionOpAdaptor::ConditionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.condition", odsAttrs.getContext());
}

ConditionOpAdaptor::ConditionOpAdaptor(ConditionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange ConditionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> ConditionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, ConditionOp::operand_segment_sizesAttrName(*odsOpName)).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::ValueRange ConditionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ConditionOpAdaptor::cond() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange ConditionOpAdaptor::args() {
  return getODSOperands(1);
}

::mlir::ValueRange ConditionOpAdaptor::ctls() {
  return getODSOperands(2);
}

::mlir::DictionaryAttr ConditionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::LogicalResult ConditionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.condition' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == ConditionOp::operand_segment_sizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 3)
      return emitError(loc, "'tfg.condition' op ""'operand_segment_sizes' attribute for specifying operand segments must have 3 "
                "elements, but got ") << numElements;
  }
    return ::mlir::success();
}

std::pair<unsigned, unsigned> ConditionOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName()).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::Operation::operand_range ConditionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ConditionOp::cond() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range ConditionOp::args() {
  return getODSOperands(1);
}

::mlir::Operation::operand_range ConditionOp::ctls() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange ConditionOp::condMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ConditionOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ConditionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> ConditionOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ConditionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void ConditionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::ValueRange ctls) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({1, static_cast<int32_t>(args.size()), static_cast<int32_t>(ctls.size())}));
}

void ConditionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::ValueRange ctls) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({1, static_cast<int32_t>(args.size()), static_cast<int32_t>(ctls.size())}));
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ConditionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ConditionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == operand_segment_sizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 3)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 3 "
                "elements, but got ") << numElements;
  }
    {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ConditionOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ConditionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand condRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> condOperands(condRawOperands);  ::llvm::SMLoc condOperandsLoc;
  (void)condOperandsLoc;
  ::mlir::Type condRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> condTypes(condRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> argsOperands;
  ::llvm::SMLoc argsOperandsLoc;
  (void)argsOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> argsTypes;

  condOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(condRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::TensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    condRawTypes[0] = type;
  }
  if (succeeded(parser.parseOptionalLParen())) {

  argsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(argsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalColon())) {

  if (parser.parseTypeList(argsTypes))
    return ::mlir::failure();
  }
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getI32VectorAttr({1, static_cast<int32_t>(argsOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  if (parser.resolveOperands(condOperands, condTypes, condOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(argsOperands, argsTypes, argsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ConditionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << cond();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = cond().getType();
    if (auto validType = type.dyn_cast<::mlir::TensorType>())
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  if (!args().empty()) {
  _odsPrinter << ' ';
  _odsPrinter << "(";
  _odsPrinter << args();
  _odsPrinter << ")";
  }
  if (!ctls().empty()) {
  _odsPrinter << ' ' << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{"operand_segment_sizes", });
  if (!args().empty()) {
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << args().getTypes();
  }
}

void ConditionOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::ConditionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::ForOp definitions
//===----------------------------------------------------------------------===//

ForOpAdaptor::ForOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.For", odsAttrs.getContext());
}

ForOpAdaptor::ForOpAdaptor(ForOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange ForOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> ForOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange ForOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ForOpAdaptor::start() {
  return *getODSOperands(0).begin();
}

::mlir::Value ForOpAdaptor::limit() {
  return *getODSOperands(1).begin();
}

::mlir::Value ForOpAdaptor::delta() {
  return *getODSOperands(2).begin();
}

::mlir::ValueRange ForOpAdaptor::args() {
  return getODSOperands(3);
}

::mlir::DictionaryAttr ForOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr ForOpAdaptor::bodyAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, ForOp::bodyAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr ForOpAdaptor::body() {
  auto attr = bodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::ArrayAttr ForOpAdaptor::TAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, ForOp::TAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > ForOpAdaptor::T() {
  auto attr = TAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::LogicalResult ForOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.For' op ""requires attribute 'body'");
    if (namedAttrIt->getName() == ForOp::bodyAttrName(*odsOpName)) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == ForOp::TAttrName(*odsOpName)) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_body && !((tblgen_body.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.For' op ""attribute 'body' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_T && !(((tblgen_T.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_T.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.For' op ""attribute 'T' failed to satisfy constraint: type array attribute");
  return ::mlir::success();
}

void ForOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!llvm::empty(resultGroup0))
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!llvm::empty(resultGroup1))
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> ForOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range ForOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ForOp::start() {
  return *getODSOperands(0).begin();
}

::mlir::Value ForOp::limit() {
  return *getODSOperands(1).begin();
}

::mlir::Value ForOp::delta() {
  return *getODSOperands(2).begin();
}

::mlir::Operation::operand_range ForOp::args() {
  return getODSOperands(3);
}

::mlir::MutableOperandRange ForOp::startMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange ForOp::limitMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange ForOp::deltaMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange ForOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> ForOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range ForOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range ForOp::outs() {
  return getODSResults(0);
}

::mlir::Value ForOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::tf_type::FuncAttr ForOp::bodyAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, bodyAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr ForOp::body() {
  auto attr = bodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::ArrayAttr ForOp::TAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, TAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > ForOp::T() {
  auto attr = TAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void ForOp::bodyAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(bodyAttrName(), attr);
}

void ForOp::TAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(TAttrName(), attr);
}

::mlir::Attribute ForOp::removeTAttr() {
  return (*this)->removeAttr(TAttrName());
}

void ForOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value start, Value limit, Value delta, ValueRange args, FuncAttr body) {
      build(odsBuilder, odsState, results, start, limit, delta, args, body,
            /*T=*/{});
    
}

void ForOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value start, ::mlir::Value limit, ::mlir::Value delta, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr body, /*optional*/::mlir::ArrayAttr T) {
  odsState.addOperands(start);
  odsState.addOperands(limit);
  odsState.addOperands(delta);
  odsState.addOperands(args);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void ForOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value start, ::mlir::Value limit, ::mlir::Value delta, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr body, /*optional*/::mlir::ArrayAttr T) {
  odsState.addOperands(start);
  odsState.addOperands(limit);
  odsState.addOperands(delta);
  odsState.addOperands(args);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ForOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ForOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'body'");
    if (namedAttrIt->getName() == bodyAttrName()) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == TAttrName()) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_body, "body")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_T, "T")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ForOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::ForOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::ForRegionOp definitions
//===----------------------------------------------------------------------===//

ForRegionOpAdaptor::ForRegionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.ForRegion", odsAttrs.getContext());
}

ForRegionOpAdaptor::ForRegionOpAdaptor(ForRegionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange ForRegionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> ForRegionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, ForRegionOp::operand_segment_sizesAttrName(*odsOpName)).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::ValueRange ForRegionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ForRegionOpAdaptor::start() {
  return *getODSOperands(0).begin();
}

::mlir::Value ForRegionOpAdaptor::limit() {
  return *getODSOperands(1).begin();
}

::mlir::Value ForRegionOpAdaptor::delta() {
  return *getODSOperands(2).begin();
}

::mlir::ValueRange ForRegionOpAdaptor::init() {
  return getODSOperands(3);
}

::mlir::ValueRange ForRegionOpAdaptor::ctls() {
  return getODSOperands(4);
}

::mlir::DictionaryAttr ForRegionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::DictionaryAttr ForRegionOpAdaptor::body_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, ForRegionOp::body_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > ForRegionOpAdaptor::body_attrs() {
  auto attr = body_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr ForRegionOpAdaptor::region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, ForRegionOp::region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> ForRegionOpAdaptor::region_attrs() {
  auto attr = region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::RegionRange ForRegionOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::Region &ForRegionOpAdaptor::body_region() {
  return *odsRegions[0];
}

::mlir::LogicalResult ForRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.ForRegion' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == ForRegionOp::operand_segment_sizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == ForRegionOp::body_attrsAttrName(*odsOpName)) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == ForRegionOp::region_attrsAttrName(*odsOpName)) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 5)
      return emitError(loc, "'tfg.ForRegion' op ""'operand_segment_sizes' attribute for specifying operand segments must have 5 "
                "elements, but got ") << numElements;
  }

  if (tblgen_body_attrs && !((tblgen_body_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.ForRegion' op ""attribute 'body_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_region_attrs && !((tblgen_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.ForRegion' op ""attribute 'region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ForRegionOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName()).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::Operation::operand_range ForRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ForRegionOp::start() {
  return *getODSOperands(0).begin();
}

::mlir::Value ForRegionOp::limit() {
  return *getODSOperands(1).begin();
}

::mlir::Value ForRegionOp::delta() {
  return *getODSOperands(2).begin();
}

::mlir::Operation::operand_range ForRegionOp::init() {
  return getODSOperands(3);
}

::mlir::Operation::operand_range ForRegionOp::ctls() {
  return getODSOperands(4);
}

::mlir::MutableOperandRange ForRegionOp::startMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ForRegionOp::limitMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ForRegionOp::deltaMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ForRegionOp::initMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ForRegionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> ForRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range ForRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range ForRegionOp::outs() {
  return getODSResults(0);
}

::mlir::Value ForRegionOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::Region &ForRegionOp::body_region() {
  return (*this)->getRegion(0);
}

::mlir::DictionaryAttr ForRegionOp::body_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, body_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > ForRegionOp::body_attrs() {
  auto attr = body_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr ForRegionOp::region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> ForRegionOp::region_attrs() {
  auto attr = region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

void ForRegionOp::body_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(body_attrsAttrName(), attr);
}

void ForRegionOp::region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(region_attrsAttrName(), attr);
}

::mlir::Attribute ForRegionOp::removeBody_attrsAttr() {
  return (*this)->removeAttr(body_attrsAttrName());
}

::mlir::Attribute ForRegionOp::removeRegion_attrsAttr() {
  return (*this)->removeAttr(region_attrsAttrName());
}

void ForRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value start, ::mlir::Value limit, ::mlir::Value delta, ::mlir::ValueRange init, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr region_attrs) {
  odsState.addOperands(start);
  odsState.addOperands(limit);
  odsState.addOperands(delta);
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({1, 1, 1, static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (region_attrs) {
  odsState.addAttribute(region_attrsAttrName(odsState.name), region_attrs);
  }
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void ForRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value start, ::mlir::Value limit, ::mlir::Value delta, ::mlir::ValueRange init, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr region_attrs) {
  odsState.addOperands(start);
  odsState.addOperands(limit);
  odsState.addOperands(delta);
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({1, 1, 1, static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (region_attrs) {
  odsState.addAttribute(region_attrsAttrName(odsState.name), region_attrs);
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ForRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ForRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == operand_segment_sizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == body_attrsAttrName()) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == region_attrsAttrName()) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 5)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 5 "
                "elements, but got ") << numElements;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_body_attrs, "body_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_region_attrs, "region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "body_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult ForRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ForRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> initOperands;
  ::llvm::SMLoc initOperandsLoc;
  (void)initOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand startRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> startOperands(startRawOperands);  ::llvm::SMLoc startOperandsLoc;
  (void)startOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand limitRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> limitOperands(limitRawOperands);  ::llvm::SMLoc limitOperandsLoc;
  (void)limitOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand deltaRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> deltaOperands(deltaRawOperands);  ::llvm::SMLoc deltaOperandsLoc;
  (void)deltaOperandsLoc;
  std::unique_ptr<::mlir::Region> body_regionRegion = std::make_unique<::mlir::Region>();
  ::mlir::Type startRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> startTypes(startRawTypes);
  ::mlir::Type limitRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> limitTypes(limitRawTypes);
  ::mlir::Type deltaRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> deltaTypes(deltaRawTypes);
  ::llvm::SmallVector<::mlir::Type, 1> initTypes;
  ::llvm::SmallVector<::mlir::Type, 1> outsTypes;
  if (succeeded(parser.parseOptionalLParen())) {

  initOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(initOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseKeyword("from"))
    return ::mlir::failure();

  startOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(startRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseKeyword("to"))
    return ::mlir::failure();

  limitOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(limitRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseKeyword("by"))
    return ::mlir::failure();

  deltaOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(deltaRawOperands[0]))
    return ::mlir::failure();

  if (parser.parseRegion(*body_regionRegion))
    return ::mlir::failure();

  if (body_regionRegion->empty()) body_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    ::mlir::TensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    startRawTypes[0] = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::TensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    limitRawTypes[0] = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::TensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    deltaRawTypes[0] = type;
  }
  if (succeeded(parser.parseOptionalComma())) {

  if (parser.parseTypeList(initTypes))
    return ::mlir::failure();
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalArrow())) {
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseTypeList(outsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  result.addRegion(std::move(body_regionRegion));
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getI32VectorAttr({1, 1, 1, static_cast<int32_t>(initOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(startOperands, startTypes, startOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(limitOperands, limitTypes, limitOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(deltaOperands, deltaTypes, deltaOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(initOperands, initTypes, initOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ForRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (!init().empty()) {
  _odsPrinter << "(";
  _odsPrinter << init();
  _odsPrinter << ")";
  }
  if (!ctls().empty()) {
  _odsPrinter << ' ' << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter << ' ' << "from";
  _odsPrinter << ' ';
  _odsPrinter << start();
  _odsPrinter << ' ' << "to";
  _odsPrinter << ' ';
  _odsPrinter << limit();
  _odsPrinter << ' ' << "by";
  _odsPrinter << ' ';
  _odsPrinter << delta();
  _odsPrinter << ' ';
  _odsPrinter.printRegion(body_region());
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{"operand_segment_sizes", });
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ' << "(";
  {
    auto type = start().getType();
    if (auto validType = type.dyn_cast<::mlir::TensorType>())
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = limit().getType();
    if (auto validType = type.dyn_cast<::mlir::TensorType>())
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = delta().getType();
    if (auto validType = type.dyn_cast<::mlir::TensorType>())
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  if (!init().empty()) {
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << init().getTypes();
  }
  _odsPrinter << ")";
  if (!outs().empty()) {
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ' << "(";
  _odsPrinter << outs().getTypes();
  _odsPrinter << ")";
  }
}

StringRef ForRegionOp::getDefaultDialect() { return "tfg"; }
void ForRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp ForRegionOp::body_yield() {
  return cast<YieldOp>(body_block().getTerminator());
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::ForRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::GetResultOp definitions
//===----------------------------------------------------------------------===//

GetResultOpAdaptor::GetResultOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.get_result", odsAttrs.getContext());
}

GetResultOpAdaptor::GetResultOpAdaptor(GetResultOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange GetResultOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> GetResultOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::ValueRange GetResultOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value GetResultOpAdaptor::value() {
  return *getODSOperands(0).begin();
}

::mlir::DictionaryAttr GetResultOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::StringAttr GetResultOpAdaptor::nameAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, GetResultOp::nameAttrName(*odsOpName)).cast<::mlir::StringAttr>();
  return attr;
}

::llvm::StringRef GetResultOpAdaptor::name() {
  auto attr = nameAttr();
  return attr.getValue();
}

::mlir::IntegerAttr GetResultOpAdaptor::numberAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, GetResultOp::numberAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint32_t GetResultOpAdaptor::number() {
  auto attr = numberAttr();
  return attr.getValue().getZExtValue();
}

::mlir::LogicalResult GetResultOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_name;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.get_result' op ""requires attribute 'name'");
    if (namedAttrIt->getName() == GetResultOp::nameAttrName(*odsOpName)) {
      tblgen_name = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_number;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.get_result' op ""requires attribute 'number'");
    if (namedAttrIt->getName() == GetResultOp::numberAttrName(*odsOpName)) {
      tblgen_number = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (tblgen_name && !((tblgen_name.isa<::mlir::StringAttr>())))
    return emitError(loc, "'tfg.get_result' op ""attribute 'name' failed to satisfy constraint: string attribute");

  if (tblgen_number && !(((tblgen_number.isa<::mlir::IntegerAttr>())) && ((tblgen_number.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(32)))))
    return emitError(loc, "'tfg.get_result' op ""attribute 'number' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> GetResultOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range GetResultOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value GetResultOp::value() {
  return *getODSOperands(0).begin();
}

::mlir::MutableOperandRange GetResultOp::valueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> GetResultOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range GetResultOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value GetResultOp::result() {
  return *getODSResults(0).begin();
}

::mlir::StringAttr GetResultOp::nameAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, nameAttrName()).cast<::mlir::StringAttr>();
}

::llvm::StringRef GetResultOp::name() {
  auto attr = nameAttr();
  return attr.getValue();
}

::mlir::IntegerAttr GetResultOp::numberAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, numberAttrName()).cast<::mlir::IntegerAttr>();
}

uint32_t GetResultOp::number() {
  auto attr = numberAttr();
  return attr.getValue().getZExtValue();
}

void GetResultOp::nameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(nameAttrName(), attr);
}

void GetResultOp::numberAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(numberAttrName(), attr);
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value value, ::mlir::StringAttr name, ::mlir::IntegerAttr number) {
  odsState.addOperands(value);
  odsState.addAttribute(nameAttrName(odsState.name), name);
  odsState.addAttribute(numberAttrName(odsState.name), number);
  odsState.addTypes(result);
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::StringAttr name, ::mlir::IntegerAttr number) {
  odsState.addOperands(value);
  odsState.addAttribute(nameAttrName(odsState.name), name);
  odsState.addAttribute(numberAttrName(odsState.name), number);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(GetResultOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      /*regions=*/{}, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::StringAttr name, ::mlir::IntegerAttr number) {
  odsState.addOperands(value);
  odsState.addAttribute(nameAttrName(odsState.name), name);
  odsState.addAttribute(numberAttrName(odsState.name), number);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value value, ::llvm::StringRef name, uint32_t number) {
  odsState.addOperands(value);
  odsState.addAttribute(nameAttrName(odsState.name), odsBuilder.getStringAttr(name));
  odsState.addAttribute(numberAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), number));
  odsState.addTypes(result);
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::llvm::StringRef name, uint32_t number) {
  odsState.addOperands(value);
  odsState.addAttribute(nameAttrName(odsState.name), odsBuilder.getStringAttr(name));
  odsState.addAttribute(numberAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), number));

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(GetResultOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      /*regions=*/{}, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::llvm::StringRef name, uint32_t number) {
  odsState.addOperands(value);
  odsState.addAttribute(nameAttrName(odsState.name), odsBuilder.getStringAttr(name));
  odsState.addAttribute(numberAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), number));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GetResultOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(GetResultOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult GetResultOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_name;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'name'");
    if (namedAttrIt->getName() == nameAttrName()) {
      tblgen_name = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_number;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'number'");
    if (namedAttrIt->getName() == numberAttrName()) {
      tblgen_number = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops8(*this, tblgen_name, "name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops9(*this, tblgen_number, "number")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops6(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult GetResultOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult GetResultOp::inferReturnTypes(::mlir::MLIRContext *context, ::llvm::Optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = odsBuilder.getType<::mlir::tf_type::OpaqueTensorType>();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult GetResultOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand valueRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> valueOperands(valueRawOperands);  ::llvm::SMLoc valueOperandsLoc;
  (void)valueOperandsLoc;
  ::mlir::StringAttr nameAttr;
  ::mlir::IntegerAttr numberAttr;
  if (parser.parseLParen())
    return ::mlir::failure();

  valueOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(valueRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(nameAttr, parser.getBuilder().getType<::mlir::NoneType>(), "name",
          result.attributes)) {
    return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(numberAttr, parser.getBuilder().getIntegerType(32), "number",
          result.attributes)) {
    return ::mlir::failure();
  }
  if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
    return ::mlir::failure();
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::OpaqueTensorType>();
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(valueOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void GetResultOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << value();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(nameAttr());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(numberAttr());
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), /*elidedAttrs=*/{"name", "number"});
}

void GetResultOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::GetResultOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::GraphFuncOp definitions
//===----------------------------------------------------------------------===//

GraphFuncOpAdaptor::GraphFuncOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.func", odsAttrs.getContext());
}

GraphFuncOpAdaptor::GraphFuncOpAdaptor(GraphFuncOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange GraphFuncOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> GraphFuncOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::ValueRange GraphFuncOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::DictionaryAttr GraphFuncOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::UnitAttr GraphFuncOpAdaptor::genericAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::genericAttrName(*odsOpName)).dyn_cast_or_null<::mlir::UnitAttr>();
  return attr;
}

bool GraphFuncOpAdaptor::generic() {
  auto attr = genericAttr();
  return attr != nullptr;
}

::mlir::StringAttr GraphFuncOpAdaptor::sym_nameAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, GraphFuncOp::sym_nameAttrName(*odsOpName)).cast<::mlir::StringAttr>();
  return attr;
}

::llvm::StringRef GraphFuncOpAdaptor::sym_name() {
  auto attr = sym_nameAttr();
  return attr.getValue();
}

::mlir::TypeAttr GraphFuncOpAdaptor::function_typeAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, GraphFuncOp::function_typeAttrName(*odsOpName)).cast<::mlir::TypeAttr>();
  return attr;
}

::mlir::FunctionType GraphFuncOpAdaptor::function_type() {
  auto attr = function_typeAttr();
  return attr.getValue().cast<::mlir::FunctionType>();
}

::mlir::ArrayAttr GraphFuncOpAdaptor::arg_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, GraphFuncOp::arg_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > GraphFuncOpAdaptor::arg_attrs() {
  auto attr = arg_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr GraphFuncOpAdaptor::res_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::res_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > GraphFuncOpAdaptor::res_attrs() {
  auto attr = res_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::StringAttr GraphFuncOpAdaptor::descriptionAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, GraphFuncOp::descriptionAttrName(*odsOpName)).dyn_cast_or_null<::mlir::StringAttr>();
  return attr;
}

::llvm::Optional< ::llvm::StringRef > GraphFuncOpAdaptor::description() {
  auto attr = descriptionAttr();
  return attr ? ::llvm::Optional< ::llvm::StringRef >(attr.getValue()) : (::llvm::None);
}

::mlir::UnitAttr GraphFuncOpAdaptor::is_statefulAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::is_statefulAttrName(*odsOpName)).dyn_cast_or_null<::mlir::UnitAttr>();
  return attr;
}

bool GraphFuncOpAdaptor::is_stateful() {
  auto attr = is_statefulAttr();
  return attr != nullptr;
}

::mlir::FlatSymbolRefAttr GraphFuncOpAdaptor::gradientAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::gradientAttrName(*odsOpName)).dyn_cast_or_null<::mlir::FlatSymbolRefAttr>();
  return attr;
}

::llvm::Optional< ::llvm::StringRef > GraphFuncOpAdaptor::gradient() {
  auto attr = gradientAttr();
  return attr ? ::llvm::Optional< ::llvm::StringRef >(attr.getValue()) : (::llvm::None);
}

::mlir::DenseIntElementsAttr GraphFuncOpAdaptor::resource_arg_unique_ids_keysAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::resource_arg_unique_ids_keysAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DenseIntElementsAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DenseIntElementsAttr > GraphFuncOpAdaptor::resource_arg_unique_ids_keys() {
  auto attr = resource_arg_unique_ids_keysAttr();
  return attr ? ::llvm::Optional< ::mlir::DenseIntElementsAttr >(attr) : (::llvm::None);
}

::mlir::DenseIntElementsAttr GraphFuncOpAdaptor::resource_arg_unique_ids_valuesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::resource_arg_unique_ids_valuesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DenseIntElementsAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DenseIntElementsAttr > GraphFuncOpAdaptor::resource_arg_unique_ids_values() {
  auto attr = resource_arg_unique_ids_valuesAttr();
  return attr ? ::llvm::Optional< ::mlir::DenseIntElementsAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr GraphFuncOpAdaptor::control_outputAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, GraphFuncOp::control_outputAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > GraphFuncOpAdaptor::control_output() {
  auto attr = control_outputAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::RegionRange GraphFuncOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::Region &GraphFuncOpAdaptor::body() {
  return *odsRegions[0];
}

::mlir::LogicalResult GraphFuncOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_function_type;
  ::mlir::Attribute tblgen_arg_attrs;
  ::mlir::Attribute tblgen_control_output;
  ::mlir::Attribute tblgen_description;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.func' op ""requires attribute 'function_type'");
    if (namedAttrIt->getName() == GraphFuncOp::function_typeAttrName(*odsOpName)) {
      tblgen_function_type = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == GraphFuncOp::arg_attrsAttrName(*odsOpName)) {
      tblgen_arg_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::control_outputAttrName(*odsOpName)) {
      tblgen_control_output = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::descriptionAttrName(*odsOpName)) {
      tblgen_description = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_sym_name;
  ::mlir::Attribute tblgen_generic;
  ::mlir::Attribute tblgen_gradient;
  ::mlir::Attribute tblgen_is_stateful;
  ::mlir::Attribute tblgen_res_attrs;
  ::mlir::Attribute tblgen_resource_arg_unique_ids_keys;
  ::mlir::Attribute tblgen_resource_arg_unique_ids_values;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.func' op ""requires attribute 'sym_name'");
    if (namedAttrIt->getName() == GraphFuncOp::sym_nameAttrName(*odsOpName)) {
      tblgen_sym_name = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == GraphFuncOp::genericAttrName(*odsOpName)) {
      tblgen_generic = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::gradientAttrName(*odsOpName)) {
      tblgen_gradient = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::is_statefulAttrName(*odsOpName)) {
      tblgen_is_stateful = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::res_attrsAttrName(*odsOpName)) {
      tblgen_res_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::resource_arg_unique_ids_keysAttrName(*odsOpName)) {
      tblgen_resource_arg_unique_ids_keys = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::resource_arg_unique_ids_valuesAttrName(*odsOpName)) {
      tblgen_resource_arg_unique_ids_values = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_generic && !((tblgen_generic.isa<::mlir::UnitAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'generic' failed to satisfy constraint: unit attribute");

  if (tblgen_sym_name && !((tblgen_sym_name.isa<::mlir::StringAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'sym_name' failed to satisfy constraint: string attribute");

  if (tblgen_function_type && !(((tblgen_function_type.isa<::mlir::TypeAttr>())) && ((tblgen_function_type.cast<::mlir::TypeAttr>().getValue().isa<::mlir::FunctionType>()))))
    return emitError(loc, "'tfg.func' op ""attribute 'function_type' failed to satisfy constraint: type attribute of function type");

  if (tblgen_arg_attrs && !((tblgen_arg_attrs.isa<::mlir::ArrayAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'arg_attrs' failed to satisfy constraint: array attribute");

  if (tblgen_res_attrs && !((tblgen_res_attrs.isa<::mlir::ArrayAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'res_attrs' failed to satisfy constraint: array attribute");

  if (tblgen_description && !((tblgen_description.isa<::mlir::StringAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'description' failed to satisfy constraint: string attribute");

  if (tblgen_is_stateful && !((tblgen_is_stateful.isa<::mlir::UnitAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'is_stateful' failed to satisfy constraint: unit attribute");

  if (tblgen_gradient && !((tblgen_gradient.isa<::mlir::FlatSymbolRefAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'gradient' failed to satisfy constraint: flat symbol reference attribute");

  if (tblgen_resource_arg_unique_ids_keys && !(((tblgen_resource_arg_unique_ids_keys.isa<::mlir::DenseIntElementsAttr>())) && ((tblgen_resource_arg_unique_ids_keys.cast<::mlir::DenseIntElementsAttr>().getType().getElementType().isSignlessInteger(32)))))
    return emitError(loc, "'tfg.func' op ""attribute 'resource_arg_unique_ids_keys' failed to satisfy constraint: 32-bit signless integer elements attribute");

  if (tblgen_resource_arg_unique_ids_values && !(((tblgen_resource_arg_unique_ids_values.isa<::mlir::DenseIntElementsAttr>())) && ((tblgen_resource_arg_unique_ids_values.cast<::mlir::DenseIntElementsAttr>().getType().getElementType().isSignlessInteger(32)))))
    return emitError(loc, "'tfg.func' op ""attribute 'resource_arg_unique_ids_values' failed to satisfy constraint: 32-bit signless integer elements attribute");

  if (tblgen_control_output && !(((tblgen_control_output.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_control_output.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::StringAttr>())); }))))
    return emitError(loc, "'tfg.func' op ""attribute 'control_output' failed to satisfy constraint: string array attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> GraphFuncOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range GraphFuncOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> GraphFuncOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range GraphFuncOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &GraphFuncOp::body() {
  return (*this)->getRegion(0);
}

::mlir::UnitAttr GraphFuncOp::genericAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, genericAttrName()).dyn_cast_or_null<::mlir::UnitAttr>();
}

bool GraphFuncOp::generic() {
  auto attr = genericAttr();
  return attr != nullptr;
}

::mlir::StringAttr GraphFuncOp::sym_nameAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, sym_nameAttrName()).cast<::mlir::StringAttr>();
}

::llvm::StringRef GraphFuncOp::sym_name() {
  auto attr = sym_nameAttr();
  return attr.getValue();
}

::mlir::TypeAttr GraphFuncOp::function_typeAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, function_typeAttrName()).cast<::mlir::TypeAttr>();
}

::mlir::FunctionType GraphFuncOp::function_type() {
  auto attr = function_typeAttr();
  return attr.getValue().cast<::mlir::FunctionType>();
}

::mlir::ArrayAttr GraphFuncOp::arg_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, arg_attrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > GraphFuncOp::arg_attrs() {
  auto attr = arg_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr GraphFuncOp::res_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, res_attrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > GraphFuncOp::res_attrs() {
  auto attr = res_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::StringAttr GraphFuncOp::descriptionAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, descriptionAttrName()).dyn_cast_or_null<::mlir::StringAttr>();
}

::llvm::Optional< ::llvm::StringRef > GraphFuncOp::description() {
  auto attr = descriptionAttr();
  return attr ? ::llvm::Optional< ::llvm::StringRef >(attr.getValue()) : (::llvm::None);
}

::mlir::UnitAttr GraphFuncOp::is_statefulAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, is_statefulAttrName()).dyn_cast_or_null<::mlir::UnitAttr>();
}

bool GraphFuncOp::is_stateful() {
  auto attr = is_statefulAttr();
  return attr != nullptr;
}

::mlir::FlatSymbolRefAttr GraphFuncOp::gradientAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, gradientAttrName()).dyn_cast_or_null<::mlir::FlatSymbolRefAttr>();
}

::llvm::Optional< ::llvm::StringRef > GraphFuncOp::gradient() {
  auto attr = gradientAttr();
  return attr ? ::llvm::Optional< ::llvm::StringRef >(attr.getValue()) : (::llvm::None);
}

::mlir::DenseIntElementsAttr GraphFuncOp::resource_arg_unique_ids_keysAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, resource_arg_unique_ids_keysAttrName()).dyn_cast_or_null<::mlir::DenseIntElementsAttr>();
}

::llvm::Optional< ::mlir::DenseIntElementsAttr > GraphFuncOp::resource_arg_unique_ids_keys() {
  auto attr = resource_arg_unique_ids_keysAttr();
  return attr ? ::llvm::Optional< ::mlir::DenseIntElementsAttr >(attr) : (::llvm::None);
}

::mlir::DenseIntElementsAttr GraphFuncOp::resource_arg_unique_ids_valuesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, resource_arg_unique_ids_valuesAttrName()).dyn_cast_or_null<::mlir::DenseIntElementsAttr>();
}

::llvm::Optional< ::mlir::DenseIntElementsAttr > GraphFuncOp::resource_arg_unique_ids_values() {
  auto attr = resource_arg_unique_ids_valuesAttr();
  return attr ? ::llvm::Optional< ::mlir::DenseIntElementsAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr GraphFuncOp::control_outputAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, control_outputAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > GraphFuncOp::control_output() {
  auto attr = control_outputAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void GraphFuncOp::genericAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(genericAttrName(), attr);
}

void GraphFuncOp::sym_nameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(sym_nameAttrName(), attr);
}

void GraphFuncOp::function_typeAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(function_typeAttrName(), attr);
}

void GraphFuncOp::arg_attrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(arg_attrsAttrName(), attr);
}

void GraphFuncOp::res_attrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(res_attrsAttrName(), attr);
}

void GraphFuncOp::descriptionAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(descriptionAttrName(), attr);
}

void GraphFuncOp::is_statefulAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(is_statefulAttrName(), attr);
}

void GraphFuncOp::gradientAttr(::mlir::FlatSymbolRefAttr attr) {
  (*this)->setAttr(gradientAttrName(), attr);
}

void GraphFuncOp::resource_arg_unique_ids_keysAttr(::mlir::DenseIntElementsAttr attr) {
  (*this)->setAttr(resource_arg_unique_ids_keysAttrName(), attr);
}

void GraphFuncOp::resource_arg_unique_ids_valuesAttr(::mlir::DenseIntElementsAttr attr) {
  (*this)->setAttr(resource_arg_unique_ids_valuesAttrName(), attr);
}

void GraphFuncOp::control_outputAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(control_outputAttrName(), attr);
}

::mlir::Attribute GraphFuncOp::removeGenericAttr() {
  return (*this)->removeAttr(genericAttrName());
}

::mlir::Attribute GraphFuncOp::removeArg_attrsAttr() {
  return (*this)->removeAttr(arg_attrsAttrName());
}

::mlir::Attribute GraphFuncOp::removeRes_attrsAttr() {
  return (*this)->removeAttr(res_attrsAttrName());
}

::mlir::Attribute GraphFuncOp::removeDescriptionAttr() {
  return (*this)->removeAttr(descriptionAttrName());
}

::mlir::Attribute GraphFuncOp::removeIs_statefulAttr() {
  return (*this)->removeAttr(is_statefulAttrName());
}

::mlir::Attribute GraphFuncOp::removeGradientAttr() {
  return (*this)->removeAttr(gradientAttrName());
}

::mlir::Attribute GraphFuncOp::removeResource_arg_unique_ids_keysAttr() {
  return (*this)->removeAttr(resource_arg_unique_ids_keysAttrName());
}

::mlir::Attribute GraphFuncOp::removeResource_arg_unique_ids_valuesAttr() {
  return (*this)->removeAttr(resource_arg_unique_ids_valuesAttrName());
}

::mlir::Attribute GraphFuncOp::removeControl_outputAttr() {
  return (*this)->removeAttr(control_outputAttrName());
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState) {
 (void)odsState.addRegion(); 
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, const Twine &sym_name, FunctionType type, bool generic) {
      build(odsBuilder, odsState);
      odsState.addAttribute(GraphFuncOp::sym_nameAttrName(odsState.name),
                           odsBuilder.getStringAttr(sym_name));
      odsState.addAttribute(GraphFuncOp::function_typeAttrName(odsState.name),
                           TypeAttr::get(type));
      if (generic) {
        odsState.addAttribute(GraphFuncOp::genericAttrName(odsState.name),
                             odsBuilder.getUnitAttr());
      }
    
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::UnitAttr generic, ::mlir::StringAttr sym_name, ::mlir::TypeAttr function_type, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::StringAttr description, /*optional*/::mlir::UnitAttr is_stateful, /*optional*/::mlir::FlatSymbolRefAttr gradient, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_keys, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_values, /*optional*/::mlir::ArrayAttr control_output) {
  if (generic) {
  odsState.addAttribute(genericAttrName(odsState.name), generic);
  }
  odsState.addAttribute(sym_nameAttrName(odsState.name), sym_name);
  odsState.addAttribute(function_typeAttrName(odsState.name), function_type);
  if (arg_attrs) {
  odsState.addAttribute(arg_attrsAttrName(odsState.name), arg_attrs);
  }
  if (res_attrs) {
  odsState.addAttribute(res_attrsAttrName(odsState.name), res_attrs);
  }
  if (description) {
  odsState.addAttribute(descriptionAttrName(odsState.name), description);
  }
  if (is_stateful) {
  odsState.addAttribute(is_statefulAttrName(odsState.name), is_stateful);
  }
  if (gradient) {
  odsState.addAttribute(gradientAttrName(odsState.name), gradient);
  }
  if (resource_arg_unique_ids_keys) {
  odsState.addAttribute(resource_arg_unique_ids_keysAttrName(odsState.name), resource_arg_unique_ids_keys);
  }
  if (resource_arg_unique_ids_values) {
  odsState.addAttribute(resource_arg_unique_ids_valuesAttrName(odsState.name), resource_arg_unique_ids_values);
  }
  if (control_output) {
  odsState.addAttribute(control_outputAttrName(odsState.name), control_output);
  }
  (void)odsState.addRegion();
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr generic, ::mlir::StringAttr sym_name, ::mlir::TypeAttr function_type, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::StringAttr description, /*optional*/::mlir::UnitAttr is_stateful, /*optional*/::mlir::FlatSymbolRefAttr gradient, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_keys, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_values, /*optional*/::mlir::ArrayAttr control_output) {
  if (generic) {
  odsState.addAttribute(genericAttrName(odsState.name), generic);
  }
  odsState.addAttribute(sym_nameAttrName(odsState.name), sym_name);
  odsState.addAttribute(function_typeAttrName(odsState.name), function_type);
  if (arg_attrs) {
  odsState.addAttribute(arg_attrsAttrName(odsState.name), arg_attrs);
  }
  if (res_attrs) {
  odsState.addAttribute(res_attrsAttrName(odsState.name), res_attrs);
  }
  if (description) {
  odsState.addAttribute(descriptionAttrName(odsState.name), description);
  }
  if (is_stateful) {
  odsState.addAttribute(is_statefulAttrName(odsState.name), is_stateful);
  }
  if (gradient) {
  odsState.addAttribute(gradientAttrName(odsState.name), gradient);
  }
  if (resource_arg_unique_ids_keys) {
  odsState.addAttribute(resource_arg_unique_ids_keysAttrName(odsState.name), resource_arg_unique_ids_keys);
  }
  if (resource_arg_unique_ids_values) {
  odsState.addAttribute(resource_arg_unique_ids_valuesAttrName(odsState.name), resource_arg_unique_ids_values);
  }
  if (control_output) {
  odsState.addAttribute(control_outputAttrName(odsState.name), control_output);
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/bool generic, ::llvm::StringRef sym_name, ::mlir::FunctionType function_type, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::StringAttr description, /*optional*/bool is_stateful, /*optional*/::mlir::FlatSymbolRefAttr gradient, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_keys, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_values, /*optional*/::mlir::ArrayAttr control_output) {
  if (generic) {
  odsState.addAttribute(genericAttrName(odsState.name), odsBuilder.getUnitAttr());
  }
  odsState.addAttribute(sym_nameAttrName(odsState.name), odsBuilder.getStringAttr(sym_name));
  odsState.addAttribute(function_typeAttrName(odsState.name), ::mlir::TypeAttr::get(function_type));
  if (arg_attrs) {
  odsState.addAttribute(arg_attrsAttrName(odsState.name), arg_attrs);
  }
  if (res_attrs) {
  odsState.addAttribute(res_attrsAttrName(odsState.name), res_attrs);
  }
  if (description) {
  odsState.addAttribute(descriptionAttrName(odsState.name), description);
  }
  if (is_stateful) {
  odsState.addAttribute(is_statefulAttrName(odsState.name), odsBuilder.getUnitAttr());
  }
  if (gradient) {
  odsState.addAttribute(gradientAttrName(odsState.name), gradient);
  }
  if (resource_arg_unique_ids_keys) {
  odsState.addAttribute(resource_arg_unique_ids_keysAttrName(odsState.name), resource_arg_unique_ids_keys);
  }
  if (resource_arg_unique_ids_values) {
  odsState.addAttribute(resource_arg_unique_ids_valuesAttrName(odsState.name), resource_arg_unique_ids_values);
  }
  if (control_output) {
  odsState.addAttribute(control_outputAttrName(odsState.name), control_output);
  }
  (void)odsState.addRegion();
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/bool generic, ::llvm::StringRef sym_name, ::mlir::FunctionType function_type, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::StringAttr description, /*optional*/bool is_stateful, /*optional*/::mlir::FlatSymbolRefAttr gradient, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_keys, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_values, /*optional*/::mlir::ArrayAttr control_output) {
  if (generic) {
  odsState.addAttribute(genericAttrName(odsState.name), odsBuilder.getUnitAttr());
  }
  odsState.addAttribute(sym_nameAttrName(odsState.name), odsBuilder.getStringAttr(sym_name));
  odsState.addAttribute(function_typeAttrName(odsState.name), ::mlir::TypeAttr::get(function_type));
  if (arg_attrs) {
  odsState.addAttribute(arg_attrsAttrName(odsState.name), arg_attrs);
  }
  if (res_attrs) {
  odsState.addAttribute(res_attrsAttrName(odsState.name), res_attrs);
  }
  if (description) {
  odsState.addAttribute(descriptionAttrName(odsState.name), description);
  }
  if (is_stateful) {
  odsState.addAttribute(is_statefulAttrName(odsState.name), odsBuilder.getUnitAttr());
  }
  if (gradient) {
  odsState.addAttribute(gradientAttrName(odsState.name), gradient);
  }
  if (resource_arg_unique_ids_keys) {
  odsState.addAttribute(resource_arg_unique_ids_keysAttrName(odsState.name), resource_arg_unique_ids_keys);
  }
  if (resource_arg_unique_ids_values) {
  odsState.addAttribute(resource_arg_unique_ids_valuesAttrName(odsState.name), resource_arg_unique_ids_values);
  }
  if (control_output) {
  odsState.addAttribute(control_outputAttrName(odsState.name), control_output);
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GraphFuncOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult GraphFuncOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_function_type;
  ::mlir::Attribute tblgen_arg_attrs;
  ::mlir::Attribute tblgen_control_output;
  ::mlir::Attribute tblgen_description;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'function_type'");
    if (namedAttrIt->getName() == function_typeAttrName()) {
      tblgen_function_type = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == arg_attrsAttrName()) {
      tblgen_arg_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == control_outputAttrName()) {
      tblgen_control_output = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == descriptionAttrName()) {
      tblgen_description = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_sym_name;
  ::mlir::Attribute tblgen_generic;
  ::mlir::Attribute tblgen_gradient;
  ::mlir::Attribute tblgen_is_stateful;
  ::mlir::Attribute tblgen_res_attrs;
  ::mlir::Attribute tblgen_resource_arg_unique_ids_keys;
  ::mlir::Attribute tblgen_resource_arg_unique_ids_values;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'sym_name'");
    if (namedAttrIt->getName() == sym_nameAttrName()) {
      tblgen_sym_name = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == genericAttrName()) {
      tblgen_generic = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == gradientAttrName()) {
      tblgen_gradient = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == is_statefulAttrName()) {
      tblgen_is_stateful = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == res_attrsAttrName()) {
      tblgen_res_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == resource_arg_unique_ids_keysAttrName()) {
      tblgen_resource_arg_unique_ids_keys = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == resource_arg_unique_ids_valuesAttrName()) {
      tblgen_resource_arg_unique_ids_values = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops10(*this, tblgen_generic, "generic")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops8(*this, tblgen_sym_name, "sym_name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops11(*this, tblgen_function_type, "function_type")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops12(*this, tblgen_arg_attrs, "arg_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops12(*this, tblgen_res_attrs, "res_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops8(*this, tblgen_description, "description")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops10(*this, tblgen_is_stateful, "is_stateful")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops13(*this, tblgen_gradient, "gradient")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops14(*this, tblgen_resource_arg_unique_ids_keys, "resource_arg_unique_ids_keys")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops14(*this, tblgen_resource_arg_unique_ids_values, "resource_arg_unique_ids_values")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops15(*this, tblgen_control_output, "control_output")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops1(*this, region, "body", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult GraphFuncOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

void GraphFuncOp::getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context) {
  results.add(canonicalize);
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::GraphFuncOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::GraphOp definitions
//===----------------------------------------------------------------------===//

GraphOpAdaptor::GraphOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.graph", odsAttrs.getContext());
}

GraphOpAdaptor::GraphOpAdaptor(GraphOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange GraphOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> GraphOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::ValueRange GraphOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::DictionaryAttr GraphOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::VersionAttr GraphOpAdaptor::versionAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, GraphOp::versionAttrName(*odsOpName)).cast<::mlir::tf_type::VersionAttr>();
  return attr;
}

::mlir::tf_type::VersionAttr GraphOpAdaptor::version() {
  auto attr = versionAttr();
  return attr.cast<::mlir::tf_type::VersionAttr>();
}

::mlir::RegionRange GraphOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::Region &GraphOpAdaptor::nodes() {
  return *odsRegions[0];
}

::mlir::LogicalResult GraphOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_version;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.graph' op ""requires attribute 'version'");
    if (namedAttrIt->getName() == GraphOp::versionAttrName(*odsOpName)) {
      tblgen_version = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (tblgen_version && !((tblgen_version.isa<::mlir::tf_type::VersionAttr>())))
    return emitError(loc, "'tfg.graph' op ""attribute 'version' failed to satisfy constraint: An Attribute describing the version for a TensorFlow Graph");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> GraphOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range GraphOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> GraphOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range GraphOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &GraphOp::nodes() {
  return (*this)->getRegion(0);
}

::mlir::tf_type::VersionAttr GraphOp::versionAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, versionAttrName()).cast<::mlir::tf_type::VersionAttr>();
}

::mlir::tf_type::VersionAttr GraphOp::version() {
  auto attr = versionAttr();
  return attr.cast<::mlir::tf_type::VersionAttr>();
}

void GraphOp::versionAttr(::mlir::tf_type::VersionAttr attr) {
  (*this)->setAttr(versionAttrName(), attr);
}

void GraphOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::tf_type::VersionAttr version) {
  odsState.addAttribute(versionAttrName(odsState.name), version);
  (void)odsState.addRegion();
}

void GraphOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::tf_type::VersionAttr version) {
  odsState.addAttribute(versionAttrName(odsState.name), version);
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GraphOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult GraphOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_version;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'version'");
    if (namedAttrIt->getName() == versionAttrName()) {
      tblgen_version = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops16(*this, tblgen_version, "version")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "nodes", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult GraphOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult GraphOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::tf_type::VersionAttr versionAttr;
  std::unique_ptr<::mlir::Region> nodesRegion = std::make_unique<::mlir::Region>();

  if (parser.parseAttribute(versionAttr, ::mlir::Type{}, "version", result.attributes))
    return ::mlir::failure();
  if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
    return ::mlir::failure();

  if (parser.parseRegion(*nodesRegion))
    return ::mlir::failure();

  if (nodesRegion->empty()) nodesRegion->emplaceBlock();
  result.addRegion(std::move(nodesRegion));
  return ::mlir::success();
}

void GraphOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttribute(versionAttr());
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), /*elidedAttrs=*/{"version"});
  _odsPrinter << ' ';
  _odsPrinter.printRegion(nodes());
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::GraphOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::IfOp definitions
//===----------------------------------------------------------------------===//

IfOpAdaptor::IfOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.If", odsAttrs.getContext());
}

IfOpAdaptor::IfOpAdaptor(IfOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange IfOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> IfOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange IfOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value IfOpAdaptor::cond() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange IfOpAdaptor::args() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr IfOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr IfOpAdaptor::then_branchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, IfOp::then_branchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr IfOpAdaptor::then_branch() {
  auto attr = then_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr IfOpAdaptor::else_branchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, IfOp::else_branchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr IfOpAdaptor::else_branch() {
  auto attr = else_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr IfOpAdaptor::TcondAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, IfOp::TcondAttrName(*odsOpName)).dyn_cast_or_null<::mlir::TypeAttr>();
  return attr;
}

::llvm::Optional<::mlir::Type> IfOpAdaptor::Tcond() {
  auto attr = TcondAttr();
  return attr ? ::llvm::Optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::llvm::None);
}

::mlir::ArrayAttr IfOpAdaptor::TinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, IfOp::TinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > IfOpAdaptor::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr IfOpAdaptor::ToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, IfOp::ToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > IfOpAdaptor::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr IfOpAdaptor::output_shapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, IfOp::output_shapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > IfOpAdaptor::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::LogicalResult IfOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.If' op ""requires attribute 'else_branch'");
    if (namedAttrIt->getName() == IfOp::else_branchAttrName(*odsOpName)) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == IfOp::TcondAttrName(*odsOpName)) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == IfOp::TinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == IfOp::ToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.If' op ""requires attribute 'then_branch'");
    if (namedAttrIt->getName() == IfOp::then_branchAttrName(*odsOpName)) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == IfOp::output_shapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_branch && !((tblgen_then_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.If' op ""attribute 'then_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_else_branch && !((tblgen_else_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.If' op ""attribute 'else_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_Tcond && !(((tblgen_Tcond.isa<::mlir::TypeAttr>())) && ((tblgen_Tcond.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))))
    return emitError(loc, "'tfg.If' op ""attribute 'Tcond' failed to satisfy constraint: any type attribute");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.If' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.If' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.If' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void IfOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!llvm::empty(resultGroup0))
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!llvm::empty(resultGroup1))
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> IfOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range IfOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value IfOp::cond() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range IfOp::args() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange IfOp::condMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange IfOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> IfOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range IfOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range IfOp::outs() {
  return getODSResults(0);
}

::mlir::Value IfOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::tf_type::FuncAttr IfOp::then_branchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, then_branchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr IfOp::then_branch() {
  auto attr = then_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr IfOp::else_branchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, else_branchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr IfOp::else_branch() {
  auto attr = else_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr IfOp::TcondAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, TcondAttrName()).dyn_cast_or_null<::mlir::TypeAttr>();
}

::llvm::Optional<::mlir::Type> IfOp::Tcond() {
  auto attr = TcondAttr();
  return attr ? ::llvm::Optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::llvm::None);
}

::mlir::ArrayAttr IfOp::TinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, TinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > IfOp::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr IfOp::ToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, ToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > IfOp::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr IfOp::output_shapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, output_shapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > IfOp::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void IfOp::then_branchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(then_branchAttrName(), attr);
}

void IfOp::else_branchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(else_branchAttrName(), attr);
}

void IfOp::TcondAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(TcondAttrName(), attr);
}

void IfOp::TinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(TinAttrName(), attr);
}

void IfOp::ToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(ToutAttrName(), attr);
}

void IfOp::output_shapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(output_shapesAttrName(), attr);
}

::mlir::Attribute IfOp::removeTcondAttr() {
  return (*this)->removeAttr(TcondAttrName());
}

::mlir::Attribute IfOp::removeTinAttr() {
  return (*this)->removeAttr(TinAttrName());
}

::mlir::Attribute IfOp::removeToutAttr() {
  return (*this)->removeAttr(ToutAttrName());
}

::mlir::Attribute IfOp::removeOutput_shapesAttr() {
  return (*this)->removeAttr(output_shapesAttrName());
}

void IfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value cond, ValueRange args, FuncAttr then_branch, FuncAttr else_branch) {
      build(odsBuilder, odsState, results, cond, args, then_branch, else_branch,
            /*Tcond=*/{}, /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void IfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(then_branchAttrName(odsState.name), then_branch);
  odsState.addAttribute(else_branchAttrName(odsState.name), else_branch);
  if (Tcond) {
  odsState.addAttribute(TcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void IfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(then_branchAttrName(odsState.name), then_branch);
  odsState.addAttribute(else_branchAttrName(odsState.name), else_branch);
  if (Tcond) {
  odsState.addAttribute(TcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void IfOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult IfOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'else_branch'");
    if (namedAttrIt->getName() == else_branchAttrName()) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == TcondAttrName()) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == TinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == ToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'then_branch'");
    if (namedAttrIt->getName() == then_branchAttrName()) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == output_shapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_then_branch, "then_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_else_branch, "else_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops17(*this, tblgen_Tcond, "Tcond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult IfOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult IfOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyIfLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::IfOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::IfRegionOp definitions
//===----------------------------------------------------------------------===//

IfRegionOpAdaptor::IfRegionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.IfRegion", odsAttrs.getContext());
}

IfRegionOpAdaptor::IfRegionOpAdaptor(IfRegionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange IfRegionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> IfRegionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange IfRegionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value IfRegionOpAdaptor::cond() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange IfRegionOpAdaptor::ctls() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr IfRegionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::DictionaryAttr IfRegionOpAdaptor::then_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, IfRegionOp::then_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > IfRegionOpAdaptor::then_attrs() {
  auto attr = then_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr IfRegionOpAdaptor::else_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, IfRegionOp::else_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > IfRegionOpAdaptor::else_attrs() {
  auto attr = else_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr IfRegionOpAdaptor::then_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, IfRegionOp::then_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> IfRegionOpAdaptor::then_region_attrs() {
  auto attr = then_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr IfRegionOpAdaptor::else_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, IfRegionOp::else_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> IfRegionOpAdaptor::else_region_attrs() {
  auto attr = else_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::RegionRange IfRegionOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::Region &IfRegionOpAdaptor::then_region() {
  return *odsRegions[0];
}

::mlir::Region &IfRegionOpAdaptor::else_region() {
  return *odsRegions[1];
}

::mlir::LogicalResult IfRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == IfRegionOp::else_attrsAttrName(*odsOpName)) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == IfRegionOp::else_region_attrsAttrName(*odsOpName)) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == IfRegionOp::then_attrsAttrName(*odsOpName)) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == IfRegionOp::then_region_attrsAttrName(*odsOpName)) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_attrs && !((tblgen_then_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.IfRegion' op ""attribute 'then_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_else_attrs && !((tblgen_else_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.IfRegion' op ""attribute 'else_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_then_region_attrs && !((tblgen_then_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.IfRegion' op ""attribute 'then_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_else_region_attrs && !((tblgen_else_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.IfRegion' op ""attribute 'else_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> IfRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range IfRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value IfRegionOp::cond() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range IfRegionOp::ctls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange IfRegionOp::condMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange IfRegionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> IfRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range IfRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range IfRegionOp::outs() {
  return getODSResults(0);
}

::mlir::Value IfRegionOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::Region &IfRegionOp::then_region() {
  return (*this)->getRegion(0);
}

::mlir::Region &IfRegionOp::else_region() {
  return (*this)->getRegion(1);
}

::mlir::DictionaryAttr IfRegionOp::then_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, then_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > IfRegionOp::then_attrs() {
  auto attr = then_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr IfRegionOp::else_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, else_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > IfRegionOp::else_attrs() {
  auto attr = else_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr IfRegionOp::then_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, then_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> IfRegionOp::then_region_attrs() {
  auto attr = then_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr IfRegionOp::else_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, else_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> IfRegionOp::else_region_attrs() {
  auto attr = else_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

void IfRegionOp::then_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(then_attrsAttrName(), attr);
}

void IfRegionOp::else_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(else_attrsAttrName(), attr);
}

void IfRegionOp::then_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(then_region_attrsAttrName(), attr);
}

void IfRegionOp::else_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(else_region_attrsAttrName(), attr);
}

::mlir::Attribute IfRegionOp::removeThen_attrsAttr() {
  return (*this)->removeAttr(then_attrsAttrName());
}

::mlir::Attribute IfRegionOp::removeElse_attrsAttr() {
  return (*this)->removeAttr(else_attrsAttrName());
}

::mlir::Attribute IfRegionOp::removeThen_region_attrsAttr() {
  return (*this)->removeAttr(then_region_attrsAttrName());
}

::mlir::Attribute IfRegionOp::removeElse_region_attrsAttr() {
  return (*this)->removeAttr(else_region_attrsAttrName());
}

void IfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
  odsState.addAttribute(then_attrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
  odsState.addAttribute(else_attrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
  odsState.addAttribute(then_region_attrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
  odsState.addAttribute(else_region_attrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void IfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
  odsState.addAttribute(then_attrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
  odsState.addAttribute(else_attrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
  odsState.addAttribute(then_region_attrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
  odsState.addAttribute(else_region_attrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void IfRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult IfRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == else_attrsAttrName()) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == else_region_attrsAttrName()) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == then_attrsAttrName()) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == then_region_attrsAttrName()) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_then_attrs, "then_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_else_attrs, "else_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_then_region_attrs, "then_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_else_region_attrs, "else_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "then_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "else_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult IfRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult IfRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand condRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> condOperands(condRawOperands);  ::llvm::SMLoc condOperandsLoc;
  (void)condOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> then_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> else_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> condTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  condOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(condRawOperands[0]))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseKeyword("then"))
    return ::mlir::failure();

  if (parser.parseRegion(*then_regionRegion))
    return ::mlir::failure();

  if (then_regionRegion->empty()) then_regionRegion->emplaceBlock();
  if (parser.parseKeyword("else"))
    return ::mlir::failure();

  if (parser.parseRegion(*else_regionRegion))
    return ::mlir::failure();

  if (else_regionRegion->empty()) else_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType cond__outs_functionType;
  if (parser.parseType(cond__outs_functionType))
    return ::mlir::failure();
  condTypes = cond__outs_functionType.getInputs();
  outsTypes = cond__outs_functionType.getResults();
  result.addRegion(std::move(then_regionRegion));
  result.addRegion(std::move(else_regionRegion));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(condOperands, condTypes, condOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void IfRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << cond();
  if (!ctls().empty()) {
  _odsPrinter << ' ';
  _odsPrinter << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter << ' ' << "then";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(then_region());
  _odsPrinter << ' ' << "else";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(else_region());
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{});
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(cond().getType()), outs().getTypes());
}

StringRef IfRegionOp::getDefaultDialect() { return "tfg"; }
void IfRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp IfRegionOp::then_yield() {
  return cast<YieldOp>(then_block().getTerminator());
}
YieldOp IfRegionOp::else_yield() {
  return cast<YieldOp>(else_block().getTerminator());
}

void IfRegionOp::getSuccessorRegions(
    Optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetIfLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void IfRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(/*NumInputs=*/2, /*Elt=*/{0, 1});
}

LogicalResult IfRegionOp::verify() { return VerifyIfLikeRegionOp(*this); }

BlockArgument IfRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument IfRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument IfRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument IfRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::IfRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::ReturnOp definitions
//===----------------------------------------------------------------------===//

ReturnOpAdaptor::ReturnOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.return", odsAttrs.getContext());
}

ReturnOpAdaptor::ReturnOpAdaptor(ReturnOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange ReturnOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> ReturnOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange ReturnOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::ValueRange ReturnOpAdaptor::operands() {
  return getODSOperands(0);
}

::mlir::DictionaryAttr ReturnOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr ReturnOpAdaptor::control_ret_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, ReturnOp::control_ret_attrsAttrName(*odsOpName)).cast<::mlir::ArrayAttr>();
  return attr;
}

::mlir::ArrayAttr ReturnOpAdaptor::control_ret_attrs() {
  auto attr = control_ret_attrsAttr();
  return attr;
}

::mlir::LogicalResult ReturnOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_control_ret_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.return' op ""requires attribute 'control_ret_attrs'");
    if (namedAttrIt->getName() == ReturnOp::control_ret_attrsAttrName(*odsOpName)) {
      tblgen_control_ret_attrs = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (tblgen_control_ret_attrs && !(((tblgen_control_ret_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_control_ret_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::DictionaryAttr>())); }))))
    return emitError(loc, "'tfg.return' op ""attribute 'control_ret_attrs' failed to satisfy constraint: an array of dictionaries");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ReturnOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range ReturnOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range ReturnOp::operands() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange ReturnOp::operandsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> ReturnOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ReturnOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::ArrayAttr ReturnOp::control_ret_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, control_ret_attrsAttrName()).cast<::mlir::ArrayAttr>();
}

::mlir::ArrayAttr ReturnOp::control_ret_attrs() {
  auto attr = control_ret_attrsAttr();
  return attr;
}

void ReturnOp::control_ret_attrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(control_ret_attrsAttrName(), attr);
}

void ReturnOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::mlir::ArrayAttr control_ret_attrs) {
  odsState.addOperands(operands);
  odsState.addAttribute(control_ret_attrsAttrName(odsState.name), control_ret_attrs);
}

void ReturnOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::mlir::ArrayAttr control_ret_attrs) {
  odsState.addOperands(operands);
  odsState.addAttribute(control_ret_attrsAttrName(odsState.name), control_ret_attrs);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ReturnOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ReturnOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_control_ret_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'control_ret_attrs'");
    if (namedAttrIt->getName() == control_ret_attrsAttrName()) {
      tblgen_control_ret_attrs = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops3(*this, tblgen_control_ret_attrs, "control_ret_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ReturnOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

void ReturnOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::ReturnOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulCaseOp definitions
//===----------------------------------------------------------------------===//

StatefulCaseOpAdaptor::StatefulCaseOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulCase", odsAttrs.getContext());
}

StatefulCaseOpAdaptor::StatefulCaseOpAdaptor(StatefulCaseOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatefulCaseOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatefulCaseOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange StatefulCaseOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatefulCaseOpAdaptor::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange StatefulCaseOpAdaptor::args() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr StatefulCaseOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr StatefulCaseOpAdaptor::branchesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulCaseOp::branchesAttrName(*odsOpName)).cast<::mlir::ArrayAttr>();
  return attr;
}

::mlir::ArrayAttr StatefulCaseOpAdaptor::branches() {
  auto attr = branchesAttr();
  return attr;
}

::mlir::ArrayAttr StatefulCaseOpAdaptor::TinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatefulCaseOp::TinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulCaseOpAdaptor::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulCaseOpAdaptor::ToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatefulCaseOp::ToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulCaseOpAdaptor::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulCaseOpAdaptor::output_shapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatefulCaseOp::output_shapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulCaseOpAdaptor::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::LogicalResult StatefulCaseOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulCase' op ""requires attribute 'branches'");
    if (namedAttrIt->getName() == StatefulCaseOp::branchesAttrName(*odsOpName)) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulCaseOp::TinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulCaseOp::ToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatefulCaseOp::output_shapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branches && !(((tblgen_branches.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branches.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::FuncAttr>())); }))))
    return emitError(loc, "'tfg.StatefulCase' op ""attribute 'branches' failed to satisfy constraint: an array of functions");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.StatefulCase' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.StatefulCase' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatefulCase' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatefulCaseOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!llvm::empty(resultGroup0))
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!llvm::empty(resultGroup1))
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatefulCaseOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatefulCaseOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatefulCaseOp::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range StatefulCaseOp::args() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatefulCaseOp::branch_indexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatefulCaseOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulCaseOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulCaseOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulCaseOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatefulCaseOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::ArrayAttr StatefulCaseOp::branchesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, branchesAttrName()).cast<::mlir::ArrayAttr>();
}

::mlir::ArrayAttr StatefulCaseOp::branches() {
  auto attr = branchesAttr();
  return attr;
}

::mlir::ArrayAttr StatefulCaseOp::TinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, TinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulCaseOp::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulCaseOp::ToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, ToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulCaseOp::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulCaseOp::output_shapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, output_shapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulCaseOp::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void StatefulCaseOp::branchesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(branchesAttrName(), attr);
}

void StatefulCaseOp::TinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(TinAttrName(), attr);
}

void StatefulCaseOp::ToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(ToutAttrName(), attr);
}

void StatefulCaseOp::output_shapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(output_shapesAttrName(), attr);
}

::mlir::Attribute StatefulCaseOp::removeTinAttr() {
  return (*this)->removeAttr(TinAttrName());
}

::mlir::Attribute StatefulCaseOp::removeToutAttr() {
  return (*this)->removeAttr(ToutAttrName());
}

::mlir::Attribute StatefulCaseOp::removeOutput_shapesAttr() {
  return (*this)->removeAttr(output_shapesAttrName());
}

void StatefulCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value branch_index, ValueRange args, ArrayAttr branches) {
      build(odsBuilder, odsState, results, branch_index, args, branches,
            /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void StatefulCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(branchesAttrName(odsState.name), branches);
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(branchesAttrName(odsState.name), branches);
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulCaseOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulCaseOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'branches'");
    if (namedAttrIt->getName() == branchesAttrName()) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == TinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == ToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == output_shapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops0(*this, tblgen_branches, "branches")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulCaseOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatefulCaseOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyCaseLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulCaseOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulCaseRegionOp definitions
//===----------------------------------------------------------------------===//

StatefulCaseRegionOpAdaptor::StatefulCaseRegionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulCaseRegion", odsAttrs.getContext());
}

StatefulCaseRegionOpAdaptor::StatefulCaseRegionOpAdaptor(StatefulCaseRegionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatefulCaseRegionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatefulCaseRegionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange StatefulCaseRegionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatefulCaseRegionOpAdaptor::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange StatefulCaseRegionOpAdaptor::ctls() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr StatefulCaseRegionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr StatefulCaseRegionOpAdaptor::branch_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulCaseRegionOp::branch_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulCaseRegionOpAdaptor::branch_attrs() {
  auto attr = branch_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulCaseRegionOpAdaptor::region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulCaseRegionOp::region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulCaseRegionOpAdaptor::region_attrs() {
  auto attr = region_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::RegionRange StatefulCaseRegionOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::RegionRange StatefulCaseRegionOpAdaptor::branches() {
  return odsRegions.drop_front(0);
}

::mlir::LogicalResult StatefulCaseRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatefulCaseRegionOp::branch_attrsAttrName(*odsOpName)) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulCaseRegionOp::region_attrsAttrName(*odsOpName)) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branch_attrs && !(((tblgen_branch_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branch_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::DictionaryAttr>())); }))))
    return emitError(loc, "'tfg.StatefulCaseRegion' op ""attribute 'branch_attrs' failed to satisfy constraint: an array of dictionaries");

  if (tblgen_region_attrs && !(((tblgen_region_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_region_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tfg::RegionAttr>())); }))))
    return emitError(loc, "'tfg.StatefulCaseRegion' op ""attribute 'region_attrs' failed to satisfy constraint: case region preserved attributes");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatefulCaseRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatefulCaseRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatefulCaseRegionOp::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range StatefulCaseRegionOp::ctls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatefulCaseRegionOp::branch_indexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatefulCaseRegionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulCaseRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulCaseRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulCaseRegionOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatefulCaseRegionOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::MutableArrayRef<::mlir::Region> StatefulCaseRegionOp::branches() {
  return (*this)->getRegions().drop_front(0);
}

::mlir::ArrayAttr StatefulCaseRegionOp::branch_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, branch_attrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulCaseRegionOp::branch_attrs() {
  auto attr = branch_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulCaseRegionOp::region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, region_attrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulCaseRegionOp::region_attrs() {
  auto attr = region_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void StatefulCaseRegionOp::branch_attrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(branch_attrsAttrName(), attr);
}

void StatefulCaseRegionOp::region_attrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(region_attrsAttrName(), attr);
}

::mlir::Attribute StatefulCaseRegionOp::removeBranch_attrsAttr() {
  return (*this)->removeAttr(branch_attrsAttrName());
}

::mlir::Attribute StatefulCaseRegionOp::removeRegion_attrsAttr() {
  return (*this)->removeAttr(region_attrsAttrName());
}

void StatefulCaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
  odsState.addAttribute(branch_attrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
  odsState.addAttribute(region_attrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulCaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
  odsState.addAttribute(branch_attrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
  odsState.addAttribute(region_attrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulCaseRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != numRegions; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulCaseRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == branch_attrsAttrName()) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == region_attrsAttrName()) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops3(*this, tblgen_branch_attrs, "branch_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops4(*this, tblgen_region_attrs, "region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : branches())
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "branches", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulCaseRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatefulCaseRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand branch_indexRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> branch_indexOperands(branch_indexRawOperands);  ::llvm::SMLoc branch_indexOperandsLoc;
  (void)branch_indexOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::llvm::SmallVector<std::unique_ptr<::mlir::Region>, 2> branchesRegions;
  ::llvm::ArrayRef<::mlir::Type> branch_indexTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  branch_indexOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(branch_indexRawOperands[0]))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  {
    std::unique_ptr<::mlir::Region> region;
    auto firstRegionResult = parser.parseOptionalRegion(region);
    if (firstRegionResult.hasValue()) {
      if (failed(*firstRegionResult))
        return ::mlir::failure();
      branchesRegions.emplace_back(std::move(region));

      // Parse any trailing regions.
      while (succeeded(parser.parseOptionalComma())) {
        region = std::make_unique<::mlir::Region>();
        if (parser.parseRegion(*region))
          return ::mlir::failure();
        branchesRegions.emplace_back(std::move(region));
      }
    }
  }

  for (auto &region : branchesRegions)
    if (region->empty()) region->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType branch_index__outs_functionType;
  if (parser.parseType(branch_index__outs_functionType))
    return ::mlir::failure();
  branch_indexTypes = branch_index__outs_functionType.getInputs();
  outsTypes = branch_index__outs_functionType.getResults();
  result.addRegions(branchesRegions);
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(branch_indexOperands, branch_indexTypes, branch_indexOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatefulCaseRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << branch_index();
  if (!ctls().empty()) {
  _odsPrinter << ' ';
  _odsPrinter << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter << ' ';
    llvm::interleaveComma(branches(), _odsPrinter, [&](::mlir::Region &region) {
        _odsPrinter.printRegion(region);
    });
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{});
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(branch_index().getType()), outs().getTypes());
}

StringRef StatefulCaseRegionOp::getDefaultDialect() { return "tfg"; }
void StatefulCaseRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp StatefulCaseRegionOp::branch_yield(unsigned idx) {
  return cast<YieldOp>(branch_block(idx).getTerminator());
}

void StatefulCaseRegionOp::getSuccessorRegions(
    Optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetCaseLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void StatefulCaseRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(getNumRegions(), /*Elt=*/{0, 1});
}

LogicalResult StatefulCaseRegionOp::verify() { return VerifyCaseLikeRegionOp(*this); }

BlockArgument StatefulCaseRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatefulCaseRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatefulCaseRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatefulCaseRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulCaseRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulIfOp definitions
//===----------------------------------------------------------------------===//

StatefulIfOpAdaptor::StatefulIfOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulIf", odsAttrs.getContext());
}

StatefulIfOpAdaptor::StatefulIfOpAdaptor(StatefulIfOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatefulIfOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatefulIfOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange StatefulIfOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatefulIfOpAdaptor::cond() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange StatefulIfOpAdaptor::args() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr StatefulIfOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr StatefulIfOpAdaptor::then_branchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatefulIfOp::then_branchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatefulIfOpAdaptor::then_branch() {
  auto attr = then_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulIfOpAdaptor::else_branchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatefulIfOp::else_branchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatefulIfOpAdaptor::else_branch() {
  auto attr = else_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr StatefulIfOpAdaptor::TcondAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulIfOp::TcondAttrName(*odsOpName)).dyn_cast_or_null<::mlir::TypeAttr>();
  return attr;
}

::llvm::Optional<::mlir::Type> StatefulIfOpAdaptor::Tcond() {
  auto attr = TcondAttr();
  return attr ? ::llvm::Optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::llvm::None);
}

::mlir::ArrayAttr StatefulIfOpAdaptor::TinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulIfOp::TinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulIfOpAdaptor::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulIfOpAdaptor::ToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulIfOp::ToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulIfOpAdaptor::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulIfOpAdaptor::output_shapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, StatefulIfOp::output_shapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulIfOpAdaptor::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::LogicalResult StatefulIfOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulIf' op ""requires attribute 'else_branch'");
    if (namedAttrIt->getName() == StatefulIfOp::else_branchAttrName(*odsOpName)) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulIfOp::TcondAttrName(*odsOpName)) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulIfOp::TinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulIfOp::ToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulIf' op ""requires attribute 'then_branch'");
    if (namedAttrIt->getName() == StatefulIfOp::then_branchAttrName(*odsOpName)) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulIfOp::output_shapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_branch && !((tblgen_then_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'then_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_else_branch && !((tblgen_else_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'else_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_Tcond && !(((tblgen_Tcond.isa<::mlir::TypeAttr>())) && ((tblgen_Tcond.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'Tcond' failed to satisfy constraint: any type attribute");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatefulIfOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!llvm::empty(resultGroup0))
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!llvm::empty(resultGroup1))
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatefulIfOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatefulIfOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatefulIfOp::cond() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range StatefulIfOp::args() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatefulIfOp::condMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatefulIfOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulIfOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulIfOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulIfOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatefulIfOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::tf_type::FuncAttr StatefulIfOp::then_branchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, then_branchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulIfOp::then_branch() {
  auto attr = then_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulIfOp::else_branchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, else_branchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulIfOp::else_branch() {
  auto attr = else_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr StatefulIfOp::TcondAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, TcondAttrName()).dyn_cast_or_null<::mlir::TypeAttr>();
}

::llvm::Optional<::mlir::Type> StatefulIfOp::Tcond() {
  auto attr = TcondAttr();
  return attr ? ::llvm::Optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::llvm::None);
}

::mlir::ArrayAttr StatefulIfOp::TinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, TinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulIfOp::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulIfOp::ToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, ToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulIfOp::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulIfOp::output_shapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, output_shapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulIfOp::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void StatefulIfOp::then_branchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(then_branchAttrName(), attr);
}

void StatefulIfOp::else_branchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(else_branchAttrName(), attr);
}

void StatefulIfOp::TcondAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(TcondAttrName(), attr);
}

void StatefulIfOp::TinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(TinAttrName(), attr);
}

void StatefulIfOp::ToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(ToutAttrName(), attr);
}

void StatefulIfOp::output_shapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(output_shapesAttrName(), attr);
}

::mlir::Attribute StatefulIfOp::removeTcondAttr() {
  return (*this)->removeAttr(TcondAttrName());
}

::mlir::Attribute StatefulIfOp::removeTinAttr() {
  return (*this)->removeAttr(TinAttrName());
}

::mlir::Attribute StatefulIfOp::removeToutAttr() {
  return (*this)->removeAttr(ToutAttrName());
}

::mlir::Attribute StatefulIfOp::removeOutput_shapesAttr() {
  return (*this)->removeAttr(output_shapesAttrName());
}

void StatefulIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value cond, ValueRange args, FuncAttr then_branch, FuncAttr else_branch) {
      build(odsBuilder, odsState, results, cond, args, then_branch, else_branch,
            /*Tcond=*/{}, /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void StatefulIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(then_branchAttrName(odsState.name), then_branch);
  odsState.addAttribute(else_branchAttrName(odsState.name), else_branch);
  if (Tcond) {
  odsState.addAttribute(TcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(then_branchAttrName(odsState.name), then_branch);
  odsState.addAttribute(else_branchAttrName(odsState.name), else_branch);
  if (Tcond) {
  odsState.addAttribute(TcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulIfOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulIfOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'else_branch'");
    if (namedAttrIt->getName() == else_branchAttrName()) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == TcondAttrName()) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == TinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == ToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'then_branch'");
    if (namedAttrIt->getName() == then_branchAttrName()) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == output_shapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_then_branch, "then_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_else_branch, "else_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops17(*this, tblgen_Tcond, "Tcond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulIfOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatefulIfOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyIfLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulIfOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulIfRegionOp definitions
//===----------------------------------------------------------------------===//

StatefulIfRegionOpAdaptor::StatefulIfRegionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulIfRegion", odsAttrs.getContext());
}

StatefulIfRegionOpAdaptor::StatefulIfRegionOpAdaptor(StatefulIfRegionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatefulIfRegionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatefulIfRegionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange StatefulIfRegionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatefulIfRegionOpAdaptor::cond() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange StatefulIfRegionOpAdaptor::ctls() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr StatefulIfRegionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::DictionaryAttr StatefulIfRegionOpAdaptor::then_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulIfRegionOp::then_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > StatefulIfRegionOpAdaptor::then_attrs() {
  auto attr = then_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr StatefulIfRegionOpAdaptor::else_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulIfRegionOp::else_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > StatefulIfRegionOpAdaptor::else_attrs() {
  auto attr = else_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatefulIfRegionOpAdaptor::then_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulIfRegionOp::then_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatefulIfRegionOpAdaptor::then_region_attrs() {
  auto attr = then_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatefulIfRegionOpAdaptor::else_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulIfRegionOp::else_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatefulIfRegionOpAdaptor::else_region_attrs() {
  auto attr = else_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::RegionRange StatefulIfRegionOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::Region &StatefulIfRegionOpAdaptor::then_region() {
  return *odsRegions[0];
}

::mlir::Region &StatefulIfRegionOpAdaptor::else_region() {
  return *odsRegions[1];
}

::mlir::LogicalResult StatefulIfRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatefulIfRegionOp::else_attrsAttrName(*odsOpName)) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulIfRegionOp::else_region_attrsAttrName(*odsOpName)) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulIfRegionOp::then_attrsAttrName(*odsOpName)) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulIfRegionOp::then_region_attrsAttrName(*odsOpName)) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_attrs && !((tblgen_then_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatefulIfRegion' op ""attribute 'then_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_else_attrs && !((tblgen_else_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatefulIfRegion' op ""attribute 'else_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_then_region_attrs && !((tblgen_then_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatefulIfRegion' op ""attribute 'then_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_else_region_attrs && !((tblgen_else_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatefulIfRegion' op ""attribute 'else_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatefulIfRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatefulIfRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatefulIfRegionOp::cond() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range StatefulIfRegionOp::ctls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatefulIfRegionOp::condMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatefulIfRegionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulIfRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulIfRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulIfRegionOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatefulIfRegionOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::Region &StatefulIfRegionOp::then_region() {
  return (*this)->getRegion(0);
}

::mlir::Region &StatefulIfRegionOp::else_region() {
  return (*this)->getRegion(1);
}

::mlir::DictionaryAttr StatefulIfRegionOp::then_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, then_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > StatefulIfRegionOp::then_attrs() {
  auto attr = then_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr StatefulIfRegionOp::else_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, else_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > StatefulIfRegionOp::else_attrs() {
  auto attr = else_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatefulIfRegionOp::then_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, then_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatefulIfRegionOp::then_region_attrs() {
  auto attr = then_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatefulIfRegionOp::else_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, else_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatefulIfRegionOp::else_region_attrs() {
  auto attr = else_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

void StatefulIfRegionOp::then_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(then_attrsAttrName(), attr);
}

void StatefulIfRegionOp::else_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(else_attrsAttrName(), attr);
}

void StatefulIfRegionOp::then_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(then_region_attrsAttrName(), attr);
}

void StatefulIfRegionOp::else_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(else_region_attrsAttrName(), attr);
}

::mlir::Attribute StatefulIfRegionOp::removeThen_attrsAttr() {
  return (*this)->removeAttr(then_attrsAttrName());
}

::mlir::Attribute StatefulIfRegionOp::removeElse_attrsAttr() {
  return (*this)->removeAttr(else_attrsAttrName());
}

::mlir::Attribute StatefulIfRegionOp::removeThen_region_attrsAttr() {
  return (*this)->removeAttr(then_region_attrsAttrName());
}

::mlir::Attribute StatefulIfRegionOp::removeElse_region_attrsAttr() {
  return (*this)->removeAttr(else_region_attrsAttrName());
}

void StatefulIfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
  odsState.addAttribute(then_attrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
  odsState.addAttribute(else_attrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
  odsState.addAttribute(then_region_attrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
  odsState.addAttribute(else_region_attrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulIfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
  odsState.addAttribute(then_attrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
  odsState.addAttribute(else_attrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
  odsState.addAttribute(then_region_attrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
  odsState.addAttribute(else_region_attrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulIfRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulIfRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == else_attrsAttrName()) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == else_region_attrsAttrName()) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == then_attrsAttrName()) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == then_region_attrsAttrName()) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_then_attrs, "then_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_else_attrs, "else_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_then_region_attrs, "then_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_else_region_attrs, "else_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "then_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "else_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulIfRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatefulIfRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand condRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> condOperands(condRawOperands);  ::llvm::SMLoc condOperandsLoc;
  (void)condOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> then_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> else_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> condTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  condOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(condRawOperands[0]))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseKeyword("then"))
    return ::mlir::failure();

  if (parser.parseRegion(*then_regionRegion))
    return ::mlir::failure();

  if (then_regionRegion->empty()) then_regionRegion->emplaceBlock();
  if (parser.parseKeyword("else"))
    return ::mlir::failure();

  if (parser.parseRegion(*else_regionRegion))
    return ::mlir::failure();

  if (else_regionRegion->empty()) else_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType cond__outs_functionType;
  if (parser.parseType(cond__outs_functionType))
    return ::mlir::failure();
  condTypes = cond__outs_functionType.getInputs();
  outsTypes = cond__outs_functionType.getResults();
  result.addRegion(std::move(then_regionRegion));
  result.addRegion(std::move(else_regionRegion));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(condOperands, condTypes, condOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatefulIfRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << cond();
  if (!ctls().empty()) {
  _odsPrinter << ' ';
  _odsPrinter << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter << ' ' << "then";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(then_region());
  _odsPrinter << ' ' << "else";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(else_region());
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{});
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(cond().getType()), outs().getTypes());
}

StringRef StatefulIfRegionOp::getDefaultDialect() { return "tfg"; }
void StatefulIfRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp StatefulIfRegionOp::then_yield() {
  return cast<YieldOp>(then_block().getTerminator());
}
YieldOp StatefulIfRegionOp::else_yield() {
  return cast<YieldOp>(else_block().getTerminator());
}

void StatefulIfRegionOp::getSuccessorRegions(
    Optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetIfLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void StatefulIfRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(/*NumInputs=*/2, /*Elt=*/{0, 1});
}

LogicalResult StatefulIfRegionOp::verify() { return VerifyIfLikeRegionOp(*this); }

BlockArgument StatefulIfRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatefulIfRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatefulIfRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatefulIfRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulIfRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulWhileOp definitions
//===----------------------------------------------------------------------===//

StatefulWhileOpAdaptor::StatefulWhileOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulWhile", odsAttrs.getContext());
}

StatefulWhileOpAdaptor::StatefulWhileOpAdaptor(StatefulWhileOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatefulWhileOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatefulWhileOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange StatefulWhileOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::ValueRange StatefulWhileOpAdaptor::args() {
  return getODSOperands(0);
}

::mlir::DictionaryAttr StatefulWhileOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr StatefulWhileOpAdaptor::condAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, StatefulWhileOp::condAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatefulWhileOpAdaptor::cond() {
  auto attr = condAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulWhileOpAdaptor::bodyAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulWhileOp::bodyAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatefulWhileOpAdaptor::body() {
  auto attr = bodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr StatefulWhileOpAdaptor::parallel_iterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 0, StatefulWhileOp::parallel_iterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t StatefulWhileOpAdaptor::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr StatefulWhileOpAdaptor::TAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 3, StatefulWhileOp::TAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulWhileOpAdaptor::T() {
  auto attr = TAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulWhileOpAdaptor::output_shapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 1, StatefulWhileOp::output_shapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulWhileOpAdaptor::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::LogicalResult StatefulWhileOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulWhile' op ""requires attribute 'body'");
    if (namedAttrIt->getName() == StatefulWhileOp::bodyAttrName(*odsOpName)) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulWhileOp::TAttrName(*odsOpName)) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulWhile' op ""requires attribute 'cond'");
    if (namedAttrIt->getName() == StatefulWhileOp::condAttrName(*odsOpName)) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulWhile' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == StatefulWhileOp::parallel_iterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulWhileOp::output_shapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_cond && !((tblgen_cond.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatefulWhile' op ""attribute 'cond' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_body && !((tblgen_body.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatefulWhile' op ""attribute 'body' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.StatefulWhile' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_T && !(((tblgen_T.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_T.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.StatefulWhile' op ""attribute 'T' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatefulWhile' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatefulWhileOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!llvm::empty(resultGroup0))
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!llvm::empty(resultGroup1))
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatefulWhileOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatefulWhileOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range StatefulWhileOp::args() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange StatefulWhileOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulWhileOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulWhileOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulWhileOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatefulWhileOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::tf_type::FuncAttr StatefulWhileOp::condAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, condAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulWhileOp::cond() {
  auto attr = condAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulWhileOp::bodyAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, bodyAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulWhileOp::body() {
  auto attr = bodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr StatefulWhileOp::parallel_iterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 0, parallel_iterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t StatefulWhileOp::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr StatefulWhileOp::TAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 3, TAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulWhileOp::T() {
  auto attr = TAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatefulWhileOp::output_shapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 1, output_shapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatefulWhileOp::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void StatefulWhileOp::condAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(condAttrName(), attr);
}

void StatefulWhileOp::bodyAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(bodyAttrName(), attr);
}

void StatefulWhileOp::parallel_iterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(parallel_iterationsAttrName(), attr);
}

void StatefulWhileOp::TAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(TAttrName(), attr);
}

void StatefulWhileOp::output_shapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(output_shapesAttrName(), attr);
}

::mlir::Attribute StatefulWhileOp::removeTAttr() {
  return (*this)->removeAttr(TAttrName());
}

::mlir::Attribute StatefulWhileOp::removeOutput_shapesAttr() {
  return (*this)->removeAttr(output_shapesAttrName());
}

void StatefulWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, ValueRange args, FuncAttr cond, FuncAttr body, IntegerAttr parallel_iterations) {
      build(odsBuilder, odsState, results, args, cond, body, parallel_iterations,
            /*T=*/{}, /*output_shapes=*/{});
    
}

void StatefulWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulWhileOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulWhileOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'body'");
    if (namedAttrIt->getName() == bodyAttrName()) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == TAttrName()) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'cond'");
    if (namedAttrIt->getName() == condAttrName()) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == parallel_iterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == output_shapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_cond, "cond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_body, "body")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_T, "T")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulWhileOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatefulWhileOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyWhileLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulWhileOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulWhileRegionOp definitions
//===----------------------------------------------------------------------===//

StatefulWhileRegionOpAdaptor::StatefulWhileRegionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulWhileRegion", odsAttrs.getContext());
}

StatefulWhileRegionOpAdaptor::StatefulWhileRegionOpAdaptor(StatefulWhileRegionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatefulWhileRegionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatefulWhileRegionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatefulWhileRegionOp::operand_segment_sizesAttrName(*odsOpName)).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::ValueRange StatefulWhileRegionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::ValueRange StatefulWhileRegionOpAdaptor::init() {
  return getODSOperands(0);
}

::mlir::ValueRange StatefulWhileRegionOpAdaptor::ctls() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr StatefulWhileRegionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr StatefulWhileRegionOpAdaptor::parallel_iterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatefulWhileRegionOp::parallel_iterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t StatefulWhileRegionOpAdaptor::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr StatefulWhileRegionOpAdaptor::cond_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulWhileRegionOp::cond_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > StatefulWhileRegionOpAdaptor::cond_attrs() {
  auto attr = cond_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr StatefulWhileRegionOpAdaptor::body_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulWhileRegionOp::body_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > StatefulWhileRegionOpAdaptor::body_attrs() {
  auto attr = body_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatefulWhileRegionOpAdaptor::cond_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulWhileRegionOp::cond_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatefulWhileRegionOpAdaptor::cond_region_attrs() {
  auto attr = cond_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatefulWhileRegionOpAdaptor::body_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulWhileRegionOp::body_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatefulWhileRegionOpAdaptor::body_region_attrs() {
  auto attr = body_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::RegionRange StatefulWhileRegionOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::Region &StatefulWhileRegionOpAdaptor::cond_region() {
  return *odsRegions[0];
}

::mlir::Region &StatefulWhileRegionOpAdaptor::body_region() {
  return *odsRegions[1];
}

::mlir::LogicalResult StatefulWhileRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulWhileRegion' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == StatefulWhileRegionOp::operand_segment_sizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulWhileRegionOp::body_attrsAttrName(*odsOpName)) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulWhileRegionOp::body_region_attrsAttrName(*odsOpName)) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulWhileRegionOp::cond_attrsAttrName(*odsOpName)) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulWhileRegionOp::cond_region_attrsAttrName(*odsOpName)) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulWhileRegion' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == StatefulWhileRegionOp::parallel_iterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 2)
      return emitError(loc, "'tfg.StatefulWhileRegion' op ""'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.StatefulWhileRegion' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_cond_attrs && !((tblgen_cond_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatefulWhileRegion' op ""attribute 'cond_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_body_attrs && !((tblgen_body_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatefulWhileRegion' op ""attribute 'body_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_cond_region_attrs && !((tblgen_cond_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatefulWhileRegion' op ""attribute 'cond_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_body_region_attrs && !((tblgen_body_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatefulWhileRegion' op ""attribute 'body_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatefulWhileRegionOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, operand_segment_sizesAttrName()).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::Operation::operand_range StatefulWhileRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range StatefulWhileRegionOp::init() {
  return getODSOperands(0);
}

::mlir::Operation::operand_range StatefulWhileRegionOp::ctls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatefulWhileRegionOp::initMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange StatefulWhileRegionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, operand_segment_sizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulWhileRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulWhileRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulWhileRegionOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatefulWhileRegionOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::Region &StatefulWhileRegionOp::cond_region() {
  return (*this)->getRegion(0);
}

::mlir::Region &StatefulWhileRegionOp::body_region() {
  return (*this)->getRegion(1);
}

::mlir::IntegerAttr StatefulWhileRegionOp::parallel_iterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, parallel_iterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t StatefulWhileRegionOp::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr StatefulWhileRegionOp::cond_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, cond_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > StatefulWhileRegionOp::cond_attrs() {
  auto attr = cond_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr StatefulWhileRegionOp::body_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, body_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > StatefulWhileRegionOp::body_attrs() {
  auto attr = body_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatefulWhileRegionOp::cond_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, cond_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatefulWhileRegionOp::cond_region_attrs() {
  auto attr = cond_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatefulWhileRegionOp::body_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, body_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatefulWhileRegionOp::body_region_attrs() {
  auto attr = body_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

void StatefulWhileRegionOp::parallel_iterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(parallel_iterationsAttrName(), attr);
}

void StatefulWhileRegionOp::cond_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(cond_attrsAttrName(), attr);
}

void StatefulWhileRegionOp::body_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(body_attrsAttrName(), attr);
}

void StatefulWhileRegionOp::cond_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(cond_region_attrsAttrName(), attr);
}

void StatefulWhileRegionOp::body_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(body_region_attrsAttrName(), attr);
}

::mlir::Attribute StatefulWhileRegionOp::removeCond_attrsAttr() {
  return (*this)->removeAttr(cond_attrsAttrName());
}

::mlir::Attribute StatefulWhileRegionOp::removeBody_attrsAttr() {
  return (*this)->removeAttr(body_attrsAttrName());
}

::mlir::Attribute StatefulWhileRegionOp::removeCond_region_attrsAttr() {
  return (*this)->removeAttr(cond_region_attrsAttrName());
}

::mlir::Attribute StatefulWhileRegionOp::removeBody_region_attrsAttr() {
  return (*this)->removeAttr(body_region_attrsAttrName());
}

void StatefulWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulWhileRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulWhileRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == operand_segment_sizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == body_attrsAttrName()) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == body_region_attrsAttrName()) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == cond_attrsAttrName()) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == cond_region_attrsAttrName()) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == parallel_iterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 2)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_cond_attrs, "cond_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_body_attrs, "body_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_cond_region_attrs, "cond_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_body_region_attrs, "body_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "cond_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "body_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulWhileRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatefulWhileRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> initOperands;
  ::llvm::SMLoc initOperandsLoc;
  (void)initOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> cond_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> body_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> initTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;
  if (succeeded(parser.parseOptionalLParen())) {

  initOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(initOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  if (parser.parseRegion(*cond_regionRegion))
    return ::mlir::failure();

  if (cond_regionRegion->empty()) cond_regionRegion->emplaceBlock();
  if (parser.parseKeyword("do"))
    return ::mlir::failure();

  if (parser.parseRegion(*body_regionRegion))
    return ::mlir::failure();

  if (body_regionRegion->empty()) body_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalColon())) {

  ::mlir::FunctionType init__outs_functionType;
  if (parser.parseType(init__outs_functionType))
    return ::mlir::failure();
  initTypes = init__outs_functionType.getInputs();
  outsTypes = init__outs_functionType.getResults();
  }
  result.addRegion(std::move(cond_regionRegion));
  result.addRegion(std::move(body_regionRegion));
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getI32VectorAttr({static_cast<int32_t>(initOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(initOperands, initTypes, initOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatefulWhileRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (!init().empty()) {
  _odsPrinter << "(";
  _odsPrinter << init();
  _odsPrinter << ")";
  }
  if (!ctls().empty()) {
  _odsPrinter << ' ' << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(cond_region());
  _odsPrinter << ' ' << "do";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(body_region());
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{"operand_segment_sizes", });
  if (!init().empty()) {
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(init().getTypes(), outs().getTypes());
  }
}

StringRef StatefulWhileRegionOp::getDefaultDialect() { return "tfg"; }
void StatefulWhileRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

ConditionOp StatefulWhileRegionOp::cond_condition() {
  return cast<ConditionOp>(cond_block().getTerminator());
}
YieldOp StatefulWhileRegionOp::body_yield() {
  return cast<YieldOp>(body_block().getTerminator());
}

OperandRange StatefulWhileRegionOp::getSuccessorEntryOperands(
    Optional<unsigned> index) {
  return init();
}
void StatefulWhileRegionOp::getSuccessorRegions(
    Optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  return GetWhileLikeRegionOpSuccessorRegions(*this, index, operands,
                                              regions);
}

LogicalResult StatefulWhileRegionOp::verify() { return VerifyWhileLikeRegionOp(*this); }

BlockArgument StatefulWhileRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatefulWhileRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatefulWhileRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatefulWhileRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulWhileRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessCaseOp definitions
//===----------------------------------------------------------------------===//

StatelessCaseOpAdaptor::StatelessCaseOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessCase", odsAttrs.getContext());
}

StatelessCaseOpAdaptor::StatelessCaseOpAdaptor(StatelessCaseOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatelessCaseOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatelessCaseOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange StatelessCaseOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatelessCaseOpAdaptor::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange StatelessCaseOpAdaptor::args() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr StatelessCaseOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr StatelessCaseOpAdaptor::branchesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessCaseOp::branchesAttrName(*odsOpName)).cast<::mlir::ArrayAttr>();
  return attr;
}

::mlir::ArrayAttr StatelessCaseOpAdaptor::branches() {
  auto attr = branchesAttr();
  return attr;
}

::mlir::ArrayAttr StatelessCaseOpAdaptor::TinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatelessCaseOp::TinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessCaseOpAdaptor::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessCaseOpAdaptor::ToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatelessCaseOp::ToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessCaseOpAdaptor::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessCaseOpAdaptor::output_shapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatelessCaseOp::output_shapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessCaseOpAdaptor::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::LogicalResult StatelessCaseOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessCase' op ""requires attribute 'branches'");
    if (namedAttrIt->getName() == StatelessCaseOp::branchesAttrName(*odsOpName)) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessCaseOp::TinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessCaseOp::ToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatelessCaseOp::output_shapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branches && !(((tblgen_branches.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branches.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::FuncAttr>())); }))))
    return emitError(loc, "'tfg.StatelessCase' op ""attribute 'branches' failed to satisfy constraint: an array of functions");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.StatelessCase' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.StatelessCase' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatelessCase' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatelessCaseOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!llvm::empty(resultGroup0))
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!llvm::empty(resultGroup1))
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatelessCaseOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatelessCaseOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatelessCaseOp::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range StatelessCaseOp::args() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatelessCaseOp::branch_indexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatelessCaseOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessCaseOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessCaseOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessCaseOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatelessCaseOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::ArrayAttr StatelessCaseOp::branchesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, branchesAttrName()).cast<::mlir::ArrayAttr>();
}

::mlir::ArrayAttr StatelessCaseOp::branches() {
  auto attr = branchesAttr();
  return attr;
}

::mlir::ArrayAttr StatelessCaseOp::TinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, TinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessCaseOp::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessCaseOp::ToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, ToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessCaseOp::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessCaseOp::output_shapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, output_shapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessCaseOp::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void StatelessCaseOp::branchesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(branchesAttrName(), attr);
}

void StatelessCaseOp::TinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(TinAttrName(), attr);
}

void StatelessCaseOp::ToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(ToutAttrName(), attr);
}

void StatelessCaseOp::output_shapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(output_shapesAttrName(), attr);
}

::mlir::Attribute StatelessCaseOp::removeTinAttr() {
  return (*this)->removeAttr(TinAttrName());
}

::mlir::Attribute StatelessCaseOp::removeToutAttr() {
  return (*this)->removeAttr(ToutAttrName());
}

::mlir::Attribute StatelessCaseOp::removeOutput_shapesAttr() {
  return (*this)->removeAttr(output_shapesAttrName());
}

void StatelessCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value branch_index, ValueRange args, ArrayAttr branches) {
      build(odsBuilder, odsState, results, branch_index, args, branches,
            /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void StatelessCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(branchesAttrName(odsState.name), branches);
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(branchesAttrName(odsState.name), branches);
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessCaseOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessCaseOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'branches'");
    if (namedAttrIt->getName() == branchesAttrName()) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == TinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == ToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == output_shapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops0(*this, tblgen_branches, "branches")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessCaseOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatelessCaseOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyCaseLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessCaseOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessCaseRegionOp definitions
//===----------------------------------------------------------------------===//

StatelessCaseRegionOpAdaptor::StatelessCaseRegionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessCaseRegion", odsAttrs.getContext());
}

StatelessCaseRegionOpAdaptor::StatelessCaseRegionOpAdaptor(StatelessCaseRegionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatelessCaseRegionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatelessCaseRegionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange StatelessCaseRegionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatelessCaseRegionOpAdaptor::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange StatelessCaseRegionOpAdaptor::ctls() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr StatelessCaseRegionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr StatelessCaseRegionOpAdaptor::branch_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessCaseRegionOp::branch_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessCaseRegionOpAdaptor::branch_attrs() {
  auto attr = branch_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessCaseRegionOpAdaptor::region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessCaseRegionOp::region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessCaseRegionOpAdaptor::region_attrs() {
  auto attr = region_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::RegionRange StatelessCaseRegionOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::RegionRange StatelessCaseRegionOpAdaptor::branches() {
  return odsRegions.drop_front(0);
}

::mlir::LogicalResult StatelessCaseRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatelessCaseRegionOp::branch_attrsAttrName(*odsOpName)) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessCaseRegionOp::region_attrsAttrName(*odsOpName)) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branch_attrs && !(((tblgen_branch_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branch_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::DictionaryAttr>())); }))))
    return emitError(loc, "'tfg.StatelessCaseRegion' op ""attribute 'branch_attrs' failed to satisfy constraint: an array of dictionaries");

  if (tblgen_region_attrs && !(((tblgen_region_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_region_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tfg::RegionAttr>())); }))))
    return emitError(loc, "'tfg.StatelessCaseRegion' op ""attribute 'region_attrs' failed to satisfy constraint: case region preserved attributes");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatelessCaseRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatelessCaseRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatelessCaseRegionOp::branch_index() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range StatelessCaseRegionOp::ctls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatelessCaseRegionOp::branch_indexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatelessCaseRegionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessCaseRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessCaseRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessCaseRegionOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatelessCaseRegionOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::MutableArrayRef<::mlir::Region> StatelessCaseRegionOp::branches() {
  return (*this)->getRegions().drop_front(0);
}

::mlir::ArrayAttr StatelessCaseRegionOp::branch_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, branch_attrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessCaseRegionOp::branch_attrs() {
  auto attr = branch_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessCaseRegionOp::region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, region_attrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessCaseRegionOp::region_attrs() {
  auto attr = region_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void StatelessCaseRegionOp::branch_attrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(branch_attrsAttrName(), attr);
}

void StatelessCaseRegionOp::region_attrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(region_attrsAttrName(), attr);
}

::mlir::Attribute StatelessCaseRegionOp::removeBranch_attrsAttr() {
  return (*this)->removeAttr(branch_attrsAttrName());
}

::mlir::Attribute StatelessCaseRegionOp::removeRegion_attrsAttr() {
  return (*this)->removeAttr(region_attrsAttrName());
}

void StatelessCaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
  odsState.addAttribute(branch_attrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
  odsState.addAttribute(region_attrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessCaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
  odsState.addAttribute(branch_attrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
  odsState.addAttribute(region_attrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessCaseRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != numRegions; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessCaseRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == branch_attrsAttrName()) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == region_attrsAttrName()) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops3(*this, tblgen_branch_attrs, "branch_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops4(*this, tblgen_region_attrs, "region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : branches())
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "branches", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessCaseRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatelessCaseRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand branch_indexRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> branch_indexOperands(branch_indexRawOperands);  ::llvm::SMLoc branch_indexOperandsLoc;
  (void)branch_indexOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::llvm::SmallVector<std::unique_ptr<::mlir::Region>, 2> branchesRegions;
  ::llvm::ArrayRef<::mlir::Type> branch_indexTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  branch_indexOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(branch_indexRawOperands[0]))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  {
    std::unique_ptr<::mlir::Region> region;
    auto firstRegionResult = parser.parseOptionalRegion(region);
    if (firstRegionResult.hasValue()) {
      if (failed(*firstRegionResult))
        return ::mlir::failure();
      branchesRegions.emplace_back(std::move(region));

      // Parse any trailing regions.
      while (succeeded(parser.parseOptionalComma())) {
        region = std::make_unique<::mlir::Region>();
        if (parser.parseRegion(*region))
          return ::mlir::failure();
        branchesRegions.emplace_back(std::move(region));
      }
    }
  }

  for (auto &region : branchesRegions)
    if (region->empty()) region->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType branch_index__outs_functionType;
  if (parser.parseType(branch_index__outs_functionType))
    return ::mlir::failure();
  branch_indexTypes = branch_index__outs_functionType.getInputs();
  outsTypes = branch_index__outs_functionType.getResults();
  result.addRegions(branchesRegions);
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(branch_indexOperands, branch_indexTypes, branch_indexOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatelessCaseRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << branch_index();
  if (!ctls().empty()) {
  _odsPrinter << ' ';
  _odsPrinter << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter << ' ';
    llvm::interleaveComma(branches(), _odsPrinter, [&](::mlir::Region &region) {
        _odsPrinter.printRegion(region);
    });
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{});
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(branch_index().getType()), outs().getTypes());
}

StringRef StatelessCaseRegionOp::getDefaultDialect() { return "tfg"; }
void StatelessCaseRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp StatelessCaseRegionOp::branch_yield(unsigned idx) {
  return cast<YieldOp>(branch_block(idx).getTerminator());
}

void StatelessCaseRegionOp::getSuccessorRegions(
    Optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetCaseLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void StatelessCaseRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(getNumRegions(), /*Elt=*/{0, 1});
}

LogicalResult StatelessCaseRegionOp::verify() { return VerifyCaseLikeRegionOp(*this); }

BlockArgument StatelessCaseRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatelessCaseRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatelessCaseRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatelessCaseRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessCaseRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessIfOp definitions
//===----------------------------------------------------------------------===//

StatelessIfOpAdaptor::StatelessIfOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessIf", odsAttrs.getContext());
}

StatelessIfOpAdaptor::StatelessIfOpAdaptor(StatelessIfOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatelessIfOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatelessIfOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange StatelessIfOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatelessIfOpAdaptor::cond() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange StatelessIfOpAdaptor::args() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr StatelessIfOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr StatelessIfOpAdaptor::then_branchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatelessIfOp::then_branchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatelessIfOpAdaptor::then_branch() {
  auto attr = then_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessIfOpAdaptor::else_branchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatelessIfOp::else_branchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatelessIfOpAdaptor::else_branch() {
  auto attr = else_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr StatelessIfOpAdaptor::TcondAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessIfOp::TcondAttrName(*odsOpName)).dyn_cast_or_null<::mlir::TypeAttr>();
  return attr;
}

::llvm::Optional<::mlir::Type> StatelessIfOpAdaptor::Tcond() {
  auto attr = TcondAttr();
  return attr ? ::llvm::Optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::llvm::None);
}

::mlir::ArrayAttr StatelessIfOpAdaptor::TinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessIfOp::TinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessIfOpAdaptor::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessIfOpAdaptor::ToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessIfOp::ToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessIfOpAdaptor::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessIfOpAdaptor::output_shapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, StatelessIfOp::output_shapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessIfOpAdaptor::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::LogicalResult StatelessIfOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessIf' op ""requires attribute 'else_branch'");
    if (namedAttrIt->getName() == StatelessIfOp::else_branchAttrName(*odsOpName)) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessIfOp::TcondAttrName(*odsOpName)) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessIfOp::TinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessIfOp::ToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessIf' op ""requires attribute 'then_branch'");
    if (namedAttrIt->getName() == StatelessIfOp::then_branchAttrName(*odsOpName)) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessIfOp::output_shapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_branch && !((tblgen_then_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'then_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_else_branch && !((tblgen_else_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'else_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_Tcond && !(((tblgen_Tcond.isa<::mlir::TypeAttr>())) && ((tblgen_Tcond.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'Tcond' failed to satisfy constraint: any type attribute");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatelessIfOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!llvm::empty(resultGroup0))
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!llvm::empty(resultGroup1))
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatelessIfOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatelessIfOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatelessIfOp::cond() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range StatelessIfOp::args() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatelessIfOp::condMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatelessIfOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessIfOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessIfOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessIfOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatelessIfOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::tf_type::FuncAttr StatelessIfOp::then_branchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, then_branchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessIfOp::then_branch() {
  auto attr = then_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessIfOp::else_branchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, else_branchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessIfOp::else_branch() {
  auto attr = else_branchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr StatelessIfOp::TcondAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, TcondAttrName()).dyn_cast_or_null<::mlir::TypeAttr>();
}

::llvm::Optional<::mlir::Type> StatelessIfOp::Tcond() {
  auto attr = TcondAttr();
  return attr ? ::llvm::Optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::llvm::None);
}

::mlir::ArrayAttr StatelessIfOp::TinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, TinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessIfOp::Tin() {
  auto attr = TinAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessIfOp::ToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, ToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessIfOp::Tout() {
  auto attr = ToutAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessIfOp::output_shapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, output_shapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessIfOp::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void StatelessIfOp::then_branchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(then_branchAttrName(), attr);
}

void StatelessIfOp::else_branchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(else_branchAttrName(), attr);
}

void StatelessIfOp::TcondAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(TcondAttrName(), attr);
}

void StatelessIfOp::TinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(TinAttrName(), attr);
}

void StatelessIfOp::ToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(ToutAttrName(), attr);
}

void StatelessIfOp::output_shapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(output_shapesAttrName(), attr);
}

::mlir::Attribute StatelessIfOp::removeTcondAttr() {
  return (*this)->removeAttr(TcondAttrName());
}

::mlir::Attribute StatelessIfOp::removeTinAttr() {
  return (*this)->removeAttr(TinAttrName());
}

::mlir::Attribute StatelessIfOp::removeToutAttr() {
  return (*this)->removeAttr(ToutAttrName());
}

::mlir::Attribute StatelessIfOp::removeOutput_shapesAttr() {
  return (*this)->removeAttr(output_shapesAttrName());
}

void StatelessIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value cond, ValueRange args, FuncAttr then_branch, FuncAttr else_branch) {
      build(odsBuilder, odsState, results, cond, args, then_branch, else_branch,
            /*Tcond=*/{}, /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void StatelessIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(then_branchAttrName(odsState.name), then_branch);
  odsState.addAttribute(else_branchAttrName(odsState.name), else_branch);
  if (Tcond) {
  odsState.addAttribute(TcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(then_branchAttrName(odsState.name), then_branch);
  odsState.addAttribute(else_branchAttrName(odsState.name), else_branch);
  if (Tcond) {
  odsState.addAttribute(TcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
  odsState.addAttribute(TinAttrName(odsState.name), Tin);
  }
  if (Tout) {
  odsState.addAttribute(ToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessIfOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessIfOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'else_branch'");
    if (namedAttrIt->getName() == else_branchAttrName()) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == TcondAttrName()) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == TinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == ToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'then_branch'");
    if (namedAttrIt->getName() == then_branchAttrName()) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == output_shapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_then_branch, "then_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_else_branch, "else_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops17(*this, tblgen_Tcond, "Tcond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessIfOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatelessIfOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyIfLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessIfOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessIfRegionOp definitions
//===----------------------------------------------------------------------===//

StatelessIfRegionOpAdaptor::StatelessIfRegionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessIfRegion", odsAttrs.getContext());
}

StatelessIfRegionOpAdaptor::StatelessIfRegionOpAdaptor(StatelessIfRegionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatelessIfRegionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatelessIfRegionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange StatelessIfRegionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatelessIfRegionOpAdaptor::cond() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange StatelessIfRegionOpAdaptor::ctls() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr StatelessIfRegionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::DictionaryAttr StatelessIfRegionOpAdaptor::then_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessIfRegionOp::then_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > StatelessIfRegionOpAdaptor::then_attrs() {
  auto attr = then_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr StatelessIfRegionOpAdaptor::else_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessIfRegionOp::else_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > StatelessIfRegionOpAdaptor::else_attrs() {
  auto attr = else_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatelessIfRegionOpAdaptor::then_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessIfRegionOp::then_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatelessIfRegionOpAdaptor::then_region_attrs() {
  auto attr = then_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatelessIfRegionOpAdaptor::else_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessIfRegionOp::else_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatelessIfRegionOpAdaptor::else_region_attrs() {
  auto attr = else_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::RegionRange StatelessIfRegionOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::Region &StatelessIfRegionOpAdaptor::then_region() {
  return *odsRegions[0];
}

::mlir::Region &StatelessIfRegionOpAdaptor::else_region() {
  return *odsRegions[1];
}

::mlir::LogicalResult StatelessIfRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatelessIfRegionOp::else_attrsAttrName(*odsOpName)) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessIfRegionOp::else_region_attrsAttrName(*odsOpName)) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessIfRegionOp::then_attrsAttrName(*odsOpName)) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessIfRegionOp::then_region_attrsAttrName(*odsOpName)) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_attrs && !((tblgen_then_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatelessIfRegion' op ""attribute 'then_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_else_attrs && !((tblgen_else_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatelessIfRegion' op ""attribute 'else_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_then_region_attrs && !((tblgen_then_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatelessIfRegion' op ""attribute 'then_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_else_region_attrs && !((tblgen_else_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatelessIfRegion' op ""attribute 'else_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatelessIfRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatelessIfRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatelessIfRegionOp::cond() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range StatelessIfRegionOp::ctls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatelessIfRegionOp::condMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatelessIfRegionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessIfRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessIfRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessIfRegionOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatelessIfRegionOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::Region &StatelessIfRegionOp::then_region() {
  return (*this)->getRegion(0);
}

::mlir::Region &StatelessIfRegionOp::else_region() {
  return (*this)->getRegion(1);
}

::mlir::DictionaryAttr StatelessIfRegionOp::then_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, then_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > StatelessIfRegionOp::then_attrs() {
  auto attr = then_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr StatelessIfRegionOp::else_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, else_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > StatelessIfRegionOp::else_attrs() {
  auto attr = else_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatelessIfRegionOp::then_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, then_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatelessIfRegionOp::then_region_attrs() {
  auto attr = then_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatelessIfRegionOp::else_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, else_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatelessIfRegionOp::else_region_attrs() {
  auto attr = else_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

void StatelessIfRegionOp::then_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(then_attrsAttrName(), attr);
}

void StatelessIfRegionOp::else_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(else_attrsAttrName(), attr);
}

void StatelessIfRegionOp::then_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(then_region_attrsAttrName(), attr);
}

void StatelessIfRegionOp::else_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(else_region_attrsAttrName(), attr);
}

::mlir::Attribute StatelessIfRegionOp::removeThen_attrsAttr() {
  return (*this)->removeAttr(then_attrsAttrName());
}

::mlir::Attribute StatelessIfRegionOp::removeElse_attrsAttr() {
  return (*this)->removeAttr(else_attrsAttrName());
}

::mlir::Attribute StatelessIfRegionOp::removeThen_region_attrsAttr() {
  return (*this)->removeAttr(then_region_attrsAttrName());
}

::mlir::Attribute StatelessIfRegionOp::removeElse_region_attrsAttr() {
  return (*this)->removeAttr(else_region_attrsAttrName());
}

void StatelessIfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
  odsState.addAttribute(then_attrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
  odsState.addAttribute(else_attrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
  odsState.addAttribute(then_region_attrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
  odsState.addAttribute(else_region_attrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessIfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
  odsState.addAttribute(then_attrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
  odsState.addAttribute(else_attrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
  odsState.addAttribute(then_region_attrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
  odsState.addAttribute(else_region_attrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessIfRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessIfRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == else_attrsAttrName()) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == else_region_attrsAttrName()) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == then_attrsAttrName()) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == then_region_attrsAttrName()) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_then_attrs, "then_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_else_attrs, "else_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_then_region_attrs, "then_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_else_region_attrs, "else_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "then_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "else_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessIfRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatelessIfRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand condRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> condOperands(condRawOperands);  ::llvm::SMLoc condOperandsLoc;
  (void)condOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> then_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> else_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> condTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  condOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(condRawOperands[0]))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseKeyword("then"))
    return ::mlir::failure();

  if (parser.parseRegion(*then_regionRegion))
    return ::mlir::failure();

  if (then_regionRegion->empty()) then_regionRegion->emplaceBlock();
  if (parser.parseKeyword("else"))
    return ::mlir::failure();

  if (parser.parseRegion(*else_regionRegion))
    return ::mlir::failure();

  if (else_regionRegion->empty()) else_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType cond__outs_functionType;
  if (parser.parseType(cond__outs_functionType))
    return ::mlir::failure();
  condTypes = cond__outs_functionType.getInputs();
  outsTypes = cond__outs_functionType.getResults();
  result.addRegion(std::move(then_regionRegion));
  result.addRegion(std::move(else_regionRegion));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(condOperands, condTypes, condOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatelessIfRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << cond();
  if (!ctls().empty()) {
  _odsPrinter << ' ';
  _odsPrinter << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter << ' ' << "then";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(then_region());
  _odsPrinter << ' ' << "else";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(else_region());
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{});
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(cond().getType()), outs().getTypes());
}

StringRef StatelessIfRegionOp::getDefaultDialect() { return "tfg"; }
void StatelessIfRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp StatelessIfRegionOp::then_yield() {
  return cast<YieldOp>(then_block().getTerminator());
}
YieldOp StatelessIfRegionOp::else_yield() {
  return cast<YieldOp>(else_block().getTerminator());
}

void StatelessIfRegionOp::getSuccessorRegions(
    Optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetIfLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void StatelessIfRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(/*NumInputs=*/2, /*Elt=*/{0, 1});
}

LogicalResult StatelessIfRegionOp::verify() { return VerifyIfLikeRegionOp(*this); }

BlockArgument StatelessIfRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatelessIfRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatelessIfRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatelessIfRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessIfRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessWhileOp definitions
//===----------------------------------------------------------------------===//

StatelessWhileOpAdaptor::StatelessWhileOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessWhile", odsAttrs.getContext());
}

StatelessWhileOpAdaptor::StatelessWhileOpAdaptor(StatelessWhileOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatelessWhileOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatelessWhileOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange StatelessWhileOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::ValueRange StatelessWhileOpAdaptor::args() {
  return getODSOperands(0);
}

::mlir::DictionaryAttr StatelessWhileOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr StatelessWhileOpAdaptor::condAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, StatelessWhileOp::condAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatelessWhileOpAdaptor::cond() {
  auto attr = condAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessWhileOpAdaptor::bodyAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessWhileOp::bodyAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatelessWhileOpAdaptor::body() {
  auto attr = bodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr StatelessWhileOpAdaptor::parallel_iterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 0, StatelessWhileOp::parallel_iterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t StatelessWhileOpAdaptor::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr StatelessWhileOpAdaptor::TAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 3, StatelessWhileOp::TAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessWhileOpAdaptor::T() {
  auto attr = TAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessWhileOpAdaptor::output_shapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 1, StatelessWhileOp::output_shapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessWhileOpAdaptor::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::LogicalResult StatelessWhileOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessWhile' op ""requires attribute 'body'");
    if (namedAttrIt->getName() == StatelessWhileOp::bodyAttrName(*odsOpName)) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessWhileOp::TAttrName(*odsOpName)) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessWhile' op ""requires attribute 'cond'");
    if (namedAttrIt->getName() == StatelessWhileOp::condAttrName(*odsOpName)) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessWhile' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == StatelessWhileOp::parallel_iterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessWhileOp::output_shapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_cond && !((tblgen_cond.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatelessWhile' op ""attribute 'cond' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_body && !((tblgen_body.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatelessWhile' op ""attribute 'body' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.StatelessWhile' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_T && !(((tblgen_T.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_T.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.StatelessWhile' op ""attribute 'T' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatelessWhile' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatelessWhileOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!llvm::empty(resultGroup0))
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!llvm::empty(resultGroup1))
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatelessWhileOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatelessWhileOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range StatelessWhileOp::args() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange StatelessWhileOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessWhileOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessWhileOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessWhileOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatelessWhileOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::tf_type::FuncAttr StatelessWhileOp::condAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, condAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessWhileOp::cond() {
  auto attr = condAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessWhileOp::bodyAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, bodyAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessWhileOp::body() {
  auto attr = bodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr StatelessWhileOp::parallel_iterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 0, parallel_iterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t StatelessWhileOp::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr StatelessWhileOp::TAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 3, TAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessWhileOp::T() {
  auto attr = TAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr StatelessWhileOp::output_shapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 1, output_shapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > StatelessWhileOp::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void StatelessWhileOp::condAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(condAttrName(), attr);
}

void StatelessWhileOp::bodyAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(bodyAttrName(), attr);
}

void StatelessWhileOp::parallel_iterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(parallel_iterationsAttrName(), attr);
}

void StatelessWhileOp::TAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(TAttrName(), attr);
}

void StatelessWhileOp::output_shapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(output_shapesAttrName(), attr);
}

::mlir::Attribute StatelessWhileOp::removeTAttr() {
  return (*this)->removeAttr(TAttrName());
}

::mlir::Attribute StatelessWhileOp::removeOutput_shapesAttr() {
  return (*this)->removeAttr(output_shapesAttrName());
}

void StatelessWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, ValueRange args, FuncAttr cond, FuncAttr body, IntegerAttr parallel_iterations) {
      build(odsBuilder, odsState, results, args, cond, body, parallel_iterations,
            /*T=*/{}, /*output_shapes=*/{});
    
}

void StatelessWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessWhileOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessWhileOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'body'");
    if (namedAttrIt->getName() == bodyAttrName()) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == TAttrName()) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'cond'");
    if (namedAttrIt->getName() == condAttrName()) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == parallel_iterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == output_shapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_cond, "cond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_body, "body")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_T, "T")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessWhileOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatelessWhileOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyWhileLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessWhileOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessWhileRegionOp definitions
//===----------------------------------------------------------------------===//

StatelessWhileRegionOpAdaptor::StatelessWhileRegionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessWhileRegion", odsAttrs.getContext());
}

StatelessWhileRegionOpAdaptor::StatelessWhileRegionOpAdaptor(StatelessWhileRegionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange StatelessWhileRegionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> StatelessWhileRegionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatelessWhileRegionOp::operand_segment_sizesAttrName(*odsOpName)).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::ValueRange StatelessWhileRegionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::ValueRange StatelessWhileRegionOpAdaptor::init() {
  return getODSOperands(0);
}

::mlir::ValueRange StatelessWhileRegionOpAdaptor::ctls() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr StatelessWhileRegionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr StatelessWhileRegionOpAdaptor::parallel_iterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatelessWhileRegionOp::parallel_iterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t StatelessWhileRegionOpAdaptor::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr StatelessWhileRegionOpAdaptor::cond_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessWhileRegionOp::cond_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > StatelessWhileRegionOpAdaptor::cond_attrs() {
  auto attr = cond_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr StatelessWhileRegionOpAdaptor::body_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessWhileRegionOp::body_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > StatelessWhileRegionOpAdaptor::body_attrs() {
  auto attr = body_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatelessWhileRegionOpAdaptor::cond_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessWhileRegionOp::cond_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatelessWhileRegionOpAdaptor::cond_region_attrs() {
  auto attr = cond_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatelessWhileRegionOpAdaptor::body_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessWhileRegionOp::body_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatelessWhileRegionOpAdaptor::body_region_attrs() {
  auto attr = body_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::RegionRange StatelessWhileRegionOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::Region &StatelessWhileRegionOpAdaptor::cond_region() {
  return *odsRegions[0];
}

::mlir::Region &StatelessWhileRegionOpAdaptor::body_region() {
  return *odsRegions[1];
}

::mlir::LogicalResult StatelessWhileRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessWhileRegion' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == StatelessWhileRegionOp::operand_segment_sizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessWhileRegionOp::body_attrsAttrName(*odsOpName)) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessWhileRegionOp::body_region_attrsAttrName(*odsOpName)) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessWhileRegionOp::cond_attrsAttrName(*odsOpName)) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessWhileRegionOp::cond_region_attrsAttrName(*odsOpName)) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessWhileRegion' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == StatelessWhileRegionOp::parallel_iterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 2)
      return emitError(loc, "'tfg.StatelessWhileRegion' op ""'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.StatelessWhileRegion' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_cond_attrs && !((tblgen_cond_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatelessWhileRegion' op ""attribute 'cond_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_body_attrs && !((tblgen_body_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatelessWhileRegion' op ""attribute 'body_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_cond_region_attrs && !((tblgen_cond_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatelessWhileRegion' op ""attribute 'cond_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_body_region_attrs && !((tblgen_body_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatelessWhileRegion' op ""attribute 'body_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatelessWhileRegionOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, operand_segment_sizesAttrName()).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::Operation::operand_range StatelessWhileRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range StatelessWhileRegionOp::init() {
  return getODSOperands(0);
}

::mlir::Operation::operand_range StatelessWhileRegionOp::ctls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatelessWhileRegionOp::initMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange StatelessWhileRegionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, operand_segment_sizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessWhileRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessWhileRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessWhileRegionOp::outs() {
  return getODSResults(0);
}

::mlir::Value StatelessWhileRegionOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::Region &StatelessWhileRegionOp::cond_region() {
  return (*this)->getRegion(0);
}

::mlir::Region &StatelessWhileRegionOp::body_region() {
  return (*this)->getRegion(1);
}

::mlir::IntegerAttr StatelessWhileRegionOp::parallel_iterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, parallel_iterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t StatelessWhileRegionOp::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr StatelessWhileRegionOp::cond_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, cond_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > StatelessWhileRegionOp::cond_attrs() {
  auto attr = cond_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr StatelessWhileRegionOp::body_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, body_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > StatelessWhileRegionOp::body_attrs() {
  auto attr = body_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatelessWhileRegionOp::cond_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, cond_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatelessWhileRegionOp::cond_region_attrs() {
  auto attr = cond_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr StatelessWhileRegionOp::body_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, body_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> StatelessWhileRegionOp::body_region_attrs() {
  auto attr = body_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

void StatelessWhileRegionOp::parallel_iterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(parallel_iterationsAttrName(), attr);
}

void StatelessWhileRegionOp::cond_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(cond_attrsAttrName(), attr);
}

void StatelessWhileRegionOp::body_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(body_attrsAttrName(), attr);
}

void StatelessWhileRegionOp::cond_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(cond_region_attrsAttrName(), attr);
}

void StatelessWhileRegionOp::body_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(body_region_attrsAttrName(), attr);
}

::mlir::Attribute StatelessWhileRegionOp::removeCond_attrsAttr() {
  return (*this)->removeAttr(cond_attrsAttrName());
}

::mlir::Attribute StatelessWhileRegionOp::removeBody_attrsAttr() {
  return (*this)->removeAttr(body_attrsAttrName());
}

::mlir::Attribute StatelessWhileRegionOp::removeCond_region_attrsAttr() {
  return (*this)->removeAttr(cond_region_attrsAttrName());
}

::mlir::Attribute StatelessWhileRegionOp::removeBody_region_attrsAttr() {
  return (*this)->removeAttr(body_region_attrsAttrName());
}

void StatelessWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessWhileRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessWhileRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == operand_segment_sizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == body_attrsAttrName()) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == body_region_attrsAttrName()) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == cond_attrsAttrName()) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == cond_region_attrsAttrName()) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == parallel_iterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 2)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_cond_attrs, "cond_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_body_attrs, "body_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_cond_region_attrs, "cond_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_body_region_attrs, "body_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "cond_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "body_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessWhileRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatelessWhileRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> initOperands;
  ::llvm::SMLoc initOperandsLoc;
  (void)initOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> cond_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> body_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> initTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;
  if (succeeded(parser.parseOptionalLParen())) {

  initOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(initOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  if (parser.parseRegion(*cond_regionRegion))
    return ::mlir::failure();

  if (cond_regionRegion->empty()) cond_regionRegion->emplaceBlock();
  if (parser.parseKeyword("do"))
    return ::mlir::failure();

  if (parser.parseRegion(*body_regionRegion))
    return ::mlir::failure();

  if (body_regionRegion->empty()) body_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalColon())) {

  ::mlir::FunctionType init__outs_functionType;
  if (parser.parseType(init__outs_functionType))
    return ::mlir::failure();
  initTypes = init__outs_functionType.getInputs();
  outsTypes = init__outs_functionType.getResults();
  }
  result.addRegion(std::move(cond_regionRegion));
  result.addRegion(std::move(body_regionRegion));
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getI32VectorAttr({static_cast<int32_t>(initOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(initOperands, initTypes, initOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatelessWhileRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (!init().empty()) {
  _odsPrinter << "(";
  _odsPrinter << init();
  _odsPrinter << ")";
  }
  if (!ctls().empty()) {
  _odsPrinter << ' ' << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(cond_region());
  _odsPrinter << ' ' << "do";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(body_region());
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{"operand_segment_sizes", });
  if (!init().empty()) {
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(init().getTypes(), outs().getTypes());
  }
}

StringRef StatelessWhileRegionOp::getDefaultDialect() { return "tfg"; }
void StatelessWhileRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

ConditionOp StatelessWhileRegionOp::cond_condition() {
  return cast<ConditionOp>(cond_block().getTerminator());
}
YieldOp StatelessWhileRegionOp::body_yield() {
  return cast<YieldOp>(body_block().getTerminator());
}

OperandRange StatelessWhileRegionOp::getSuccessorEntryOperands(
    Optional<unsigned> index) {
  return init();
}
void StatelessWhileRegionOp::getSuccessorRegions(
    Optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  return GetWhileLikeRegionOpSuccessorRegions(*this, index, operands,
                                              regions);
}

LogicalResult StatelessWhileRegionOp::verify() { return VerifyWhileLikeRegionOp(*this); }

BlockArgument StatelessWhileRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatelessWhileRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatelessWhileRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatelessWhileRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessWhileRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::WhileOp definitions
//===----------------------------------------------------------------------===//

WhileOpAdaptor::WhileOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.While", odsAttrs.getContext());
}

WhileOpAdaptor::WhileOpAdaptor(WhileOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange WhileOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> WhileOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperands.size() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::ValueRange WhileOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::ValueRange WhileOpAdaptor::args() {
  return getODSOperands(0);
}

::mlir::DictionaryAttr WhileOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr WhileOpAdaptor::condAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, WhileOp::condAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr WhileOpAdaptor::cond() {
  auto attr = condAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr WhileOpAdaptor::bodyAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, WhileOp::bodyAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr WhileOpAdaptor::body() {
  auto attr = bodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr WhileOpAdaptor::parallel_iterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 0, WhileOp::parallel_iterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t WhileOpAdaptor::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr WhileOpAdaptor::TAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 3, WhileOp::TAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > WhileOpAdaptor::T() {
  auto attr = TAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr WhileOpAdaptor::output_shapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 1, WhileOp::output_shapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::llvm::Optional< ::mlir::ArrayAttr > WhileOpAdaptor::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::LogicalResult WhileOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.While' op ""requires attribute 'body'");
    if (namedAttrIt->getName() == WhileOp::bodyAttrName(*odsOpName)) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == WhileOp::TAttrName(*odsOpName)) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.While' op ""requires attribute 'cond'");
    if (namedAttrIt->getName() == WhileOp::condAttrName(*odsOpName)) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.While' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == WhileOp::parallel_iterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == WhileOp::output_shapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_cond && !((tblgen_cond.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.While' op ""attribute 'cond' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_body && !((tblgen_body.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.While' op ""attribute 'body' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.While' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_T && !(((tblgen_T.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_T.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>()))); }))))
    return emitError(loc, "'tfg.While' op ""attribute 'T' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.While' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void WhileOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!llvm::empty(resultGroup0))
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!llvm::empty(resultGroup1))
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> WhileOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range WhileOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range WhileOp::args() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange WhileOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> WhileOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range WhileOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range WhileOp::outs() {
  return getODSResults(0);
}

::mlir::Value WhileOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::tf_type::FuncAttr WhileOp::condAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, condAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr WhileOp::cond() {
  auto attr = condAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr WhileOp::bodyAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, bodyAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr WhileOp::body() {
  auto attr = bodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr WhileOp::parallel_iterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 0, parallel_iterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t WhileOp::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr WhileOp::TAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 3, TAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > WhileOp::T() {
  auto attr = TAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

::mlir::ArrayAttr WhileOp::output_shapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 1, output_shapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::llvm::Optional< ::mlir::ArrayAttr > WhileOp::output_shapes() {
  auto attr = output_shapesAttr();
  return attr ? ::llvm::Optional< ::mlir::ArrayAttr >(attr) : (::llvm::None);
}

void WhileOp::condAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(condAttrName(), attr);
}

void WhileOp::bodyAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(bodyAttrName(), attr);
}

void WhileOp::parallel_iterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(parallel_iterationsAttrName(), attr);
}

void WhileOp::TAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(TAttrName(), attr);
}

void WhileOp::output_shapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(output_shapesAttrName(), attr);
}

::mlir::Attribute WhileOp::removeTAttr() {
  return (*this)->removeAttr(TAttrName());
}

::mlir::Attribute WhileOp::removeOutput_shapesAttr() {
  return (*this)->removeAttr(output_shapesAttrName());
}

void WhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, ValueRange args, FuncAttr cond, FuncAttr body, IntegerAttr parallel_iterations) {
      build(odsBuilder, odsState, results, args, cond, body, parallel_iterations,
            /*T=*/{}, /*output_shapes=*/{});
    
}

void WhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void WhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void WhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void WhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(condAttrName(odsState.name), cond);
  odsState.addAttribute(bodyAttrName(odsState.name), body);
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
  odsState.addAttribute(TAttrName(odsState.name), T);
  }
  if (output_shapes) {
  odsState.addAttribute(output_shapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void WhileOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult WhileOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'body'");
    if (namedAttrIt->getName() == bodyAttrName()) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == TAttrName()) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'cond'");
    if (namedAttrIt->getName() == condAttrName()) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == parallel_iterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == output_shapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_cond, "cond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_body, "body")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_T, "T")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult WhileOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult WhileOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyWhileLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::WhileOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::WhileRegionOp definitions
//===----------------------------------------------------------------------===//

WhileRegionOpAdaptor::WhileRegionOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.WhileRegion", odsAttrs.getContext());
}

WhileRegionOpAdaptor::WhileRegionOpAdaptor(WhileRegionOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange WhileRegionOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> WhileRegionOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, WhileRegionOp::operand_segment_sizesAttrName(*odsOpName)).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::ValueRange WhileRegionOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::ValueRange WhileRegionOpAdaptor::init() {
  return getODSOperands(0);
}

::mlir::ValueRange WhileRegionOpAdaptor::ctls() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr WhileRegionOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr WhileRegionOpAdaptor::parallel_iterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, WhileRegionOp::parallel_iterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t WhileRegionOpAdaptor::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr WhileRegionOpAdaptor::cond_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, WhileRegionOp::cond_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > WhileRegionOpAdaptor::cond_attrs() {
  auto attr = cond_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr WhileRegionOpAdaptor::body_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, WhileRegionOp::body_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::llvm::Optional< ::mlir::DictionaryAttr > WhileRegionOpAdaptor::body_attrs() {
  auto attr = body_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr WhileRegionOpAdaptor::cond_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, WhileRegionOp::cond_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> WhileRegionOpAdaptor::cond_region_attrs() {
  auto attr = cond_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr WhileRegionOpAdaptor::body_region_attrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, WhileRegionOp::body_region_attrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::llvm::Optional<::mlir::tfg::RegionAttr> WhileRegionOpAdaptor::body_region_attrs() {
  auto attr = body_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::RegionRange WhileRegionOpAdaptor::getRegions() {
  return odsRegions;
}

::mlir::Region &WhileRegionOpAdaptor::cond_region() {
  return *odsRegions[0];
}

::mlir::Region &WhileRegionOpAdaptor::body_region() {
  return *odsRegions[1];
}

::mlir::LogicalResult WhileRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.WhileRegion' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == WhileRegionOp::operand_segment_sizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == WhileRegionOp::body_attrsAttrName(*odsOpName)) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == WhileRegionOp::body_region_attrsAttrName(*odsOpName)) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == WhileRegionOp::cond_attrsAttrName(*odsOpName)) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == WhileRegionOp::cond_region_attrsAttrName(*odsOpName)) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.WhileRegion' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == WhileRegionOp::parallel_iterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 2)
      return emitError(loc, "'tfg.WhileRegion' op ""'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.WhileRegion' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_cond_attrs && !((tblgen_cond_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.WhileRegion' op ""attribute 'cond_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_body_attrs && !((tblgen_body_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.WhileRegion' op ""attribute 'body_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_cond_region_attrs && !((tblgen_cond_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.WhileRegion' op ""attribute 'cond_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_body_region_attrs && !((tblgen_body_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.WhileRegion' op ""attribute 'body_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> WhileRegionOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, operand_segment_sizesAttrName()).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::Operation::operand_range WhileRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range WhileRegionOp::init() {
  return getODSOperands(0);
}

::mlir::Operation::operand_range WhileRegionOp::ctls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange WhileRegionOp::initMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange WhileRegionOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, operand_segment_sizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> WhileRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range WhileRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range WhileRegionOp::outs() {
  return getODSResults(0);
}

::mlir::Value WhileRegionOp::ctl() {
  return *getODSResults(1).begin();
}

::mlir::Region &WhileRegionOp::cond_region() {
  return (*this)->getRegion(0);
}

::mlir::Region &WhileRegionOp::body_region() {
  return (*this)->getRegion(1);
}

::mlir::IntegerAttr WhileRegionOp::parallel_iterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, parallel_iterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t WhileRegionOp::parallel_iterations() {
  auto attr = parallel_iterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr WhileRegionOp::cond_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, cond_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > WhileRegionOp::cond_attrs() {
  auto attr = cond_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::DictionaryAttr WhileRegionOp::body_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, body_attrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::llvm::Optional< ::mlir::DictionaryAttr > WhileRegionOp::body_attrs() {
  auto attr = body_attrsAttr();
  return attr ? ::llvm::Optional< ::mlir::DictionaryAttr >(attr) : (::llvm::None);
}

::mlir::tfg::RegionAttr WhileRegionOp::cond_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, cond_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> WhileRegionOp::cond_region_attrs() {
  auto attr = cond_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

::mlir::tfg::RegionAttr WhileRegionOp::body_region_attrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, body_region_attrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::llvm::Optional<::mlir::tfg::RegionAttr> WhileRegionOp::body_region_attrs() {
  auto attr = body_region_attrsAttr();
  return attr ? ::llvm::Optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::llvm::None);
}

void WhileRegionOp::parallel_iterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(parallel_iterationsAttrName(), attr);
}

void WhileRegionOp::cond_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(cond_attrsAttrName(), attr);
}

void WhileRegionOp::body_attrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(body_attrsAttrName(), attr);
}

void WhileRegionOp::cond_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(cond_region_attrsAttrName(), attr);
}

void WhileRegionOp::body_region_attrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(body_region_attrsAttrName(), attr);
}

::mlir::Attribute WhileRegionOp::removeCond_attrsAttr() {
  return (*this)->removeAttr(cond_attrsAttrName());
}

::mlir::Attribute WhileRegionOp::removeBody_attrsAttr() {
  return (*this)->removeAttr(body_attrsAttrName());
}

::mlir::Attribute WhileRegionOp::removeCond_region_attrsAttr() {
  return (*this)->removeAttr(cond_region_attrsAttrName());
}

::mlir::Attribute WhileRegionOp::removeBody_region_attrsAttr() {
  return (*this)->removeAttr(body_region_attrsAttrName());
}

void WhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void WhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void WhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void WhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(parallel_iterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
  odsState.addAttribute(cond_attrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
  odsState.addAttribute(body_attrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
  odsState.addAttribute(cond_region_attrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
  odsState.addAttribute(body_region_attrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void WhileRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult WhileRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == operand_segment_sizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == body_attrsAttrName()) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == body_region_attrsAttrName()) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == cond_attrsAttrName()) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == cond_region_attrsAttrName()) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == parallel_iterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 2)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_cond_attrs, "cond_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_body_attrs, "body_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_cond_region_attrs, "cond_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_body_region_attrs, "body_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "cond_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::makeMutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "body_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult WhileRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult WhileRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> initOperands;
  ::llvm::SMLoc initOperandsLoc;
  (void)initOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> cond_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> body_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> initTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;
  if (succeeded(parser.parseOptionalLParen())) {

  initOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(initOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  if (parser.parseRegion(*cond_regionRegion))
    return ::mlir::failure();

  if (cond_regionRegion->empty()) cond_regionRegion->emplaceBlock();
  if (parser.parseKeyword("do"))
    return ::mlir::failure();

  if (parser.parseRegion(*body_regionRegion))
    return ::mlir::failure();

  if (body_regionRegion->empty()) body_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalColon())) {

  ::mlir::FunctionType init__outs_functionType;
  if (parser.parseType(init__outs_functionType))
    return ::mlir::failure();
  initTypes = init__outs_functionType.getInputs();
  outsTypes = init__outs_functionType.getResults();
  }
  result.addRegion(std::move(cond_regionRegion));
  result.addRegion(std::move(body_regionRegion));
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getI32VectorAttr({static_cast<int32_t>(initOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(initOperands, initTypes, initOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void WhileRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (!init().empty()) {
  _odsPrinter << "(";
  _odsPrinter << init();
  _odsPrinter << ")";
  }
  if (!ctls().empty()) {
  _odsPrinter << ' ' << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(cond_region());
  _odsPrinter << ' ' << "do";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(body_region());
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{"operand_segment_sizes", });
  if (!init().empty()) {
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(init().getTypes(), outs().getTypes());
  }
}

StringRef WhileRegionOp::getDefaultDialect() { return "tfg"; }
void WhileRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

ConditionOp WhileRegionOp::cond_condition() {
  return cast<ConditionOp>(cond_block().getTerminator());
}
YieldOp WhileRegionOp::body_yield() {
  return cast<YieldOp>(body_block().getTerminator());
}

OperandRange WhileRegionOp::getSuccessorEntryOperands(
    Optional<unsigned> index) {
  return init();
}
void WhileRegionOp::getSuccessorRegions(
    Optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  return GetWhileLikeRegionOpSuccessorRegions(*this, index, operands,
                                              regions);
}

LogicalResult WhileRegionOp::verify() { return VerifyWhileLikeRegionOp(*this); }

BlockArgument WhileRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument WhileRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument WhileRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument WhileRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::WhileRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::YieldOp definitions
//===----------------------------------------------------------------------===//

YieldOpAdaptor::YieldOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.yield", odsAttrs.getContext());
}

YieldOpAdaptor::YieldOpAdaptor(YieldOp op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()), odsOpName(op->getName()) {}

::mlir::ValueRange YieldOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> YieldOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, YieldOp::operand_segment_sizesAttrName(*odsOpName)).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::ValueRange YieldOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::ValueRange YieldOpAdaptor::args() {
  return getODSOperands(0);
}

::mlir::ValueRange YieldOpAdaptor::ctls() {
  return getODSOperands(1);
}

::mlir::DictionaryAttr YieldOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::LogicalResult YieldOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.yield' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == YieldOp::operand_segment_sizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 2)
      return emitError(loc, "'tfg.yield' op ""'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }
    return ::mlir::success();
}

std::pair<unsigned, unsigned> YieldOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName()).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::Operation::operand_range YieldOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range YieldOp::args() {
  return getODSOperands(0);
}

::mlir::Operation::operand_range YieldOp::ctls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange YieldOp::argsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange YieldOp::ctlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, operand_segment_sizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> YieldOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range YieldOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void YieldOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange args, ::mlir::ValueRange ctls) {
  odsState.addOperands(args);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(args.size()), static_cast<int32_t>(ctls.size())}));
}

void YieldOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::ValueRange ctls) {
  odsState.addOperands(args);
  odsState.addOperands(ctls);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({static_cast<int32_t>(args.size()), static_cast<int32_t>(ctls.size())}));
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void YieldOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult YieldOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == operand_segment_sizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseIntElementsAttr>();
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 2)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }
    {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult YieldOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult YieldOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> argsOperands;
  ::llvm::SMLoc argsOperandsLoc;
  (void)argsOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> argsTypes;
  if (succeeded(parser.parseOptionalLParen())) {

  argsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(argsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalColon())) {

  if (parser.parseTypeList(argsTypes))
    return ::mlir::failure();
  }
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getI32VectorAttr({static_cast<int32_t>(argsOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  if (parser.resolveOperands(argsOperands, argsTypes, argsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void YieldOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (!args().empty()) {
  _odsPrinter << "(";
  _odsPrinter << args();
  _odsPrinter << ")";
  }
  if (!ctls().empty()) {
  _odsPrinter << ' ' << "[";
  _odsPrinter << ctls();
  _odsPrinter << "]";
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{"operand_segment_sizes", });
  if (!args().empty()) {
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << args().getTypes();
  }
}

void YieldOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::YieldOp)


#endif  // GET_OP_CLASSES

