/**
 * Copyright 2013-2022 Software Radio Systems Limited
 *
 * This file is part of srsRAN.
 *
 * srsRAN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * srsRAN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * A copy of the GNU Affero General Public License can be found in
 * the LICENSE file in the top-level directory of this distribution
 * and at http://www.gnu.org/licenses/.
 *
 */

#ifndef SRSRAN_RA_SL_H
#define SRSRAN_RA_SL_H

SRSRAN_API int srsran_sl_get_available_pool_prb(uint32_t prb_num, uint32_t prb_start, uint32_t prb_end);

SRSRAN_API int srsran_pscch_resources(uint32_t  prb_num,
                                      uint32_t  prb_start,
                                      uint32_t  prb_end,
                                      uint8_t*  pscch_sf_bitmap,
                                      uint32_t  period_length,
                                      uint32_t  n_pscch,
                                      uint32_t* m_a,
                                      uint32_t* l_b);

SRSRAN_API uint32_t srsran_ra_sl_type0_to_riv(uint32_t nof_prb, uint32_t prb_start, uint32_t L_crb);
SRSRAN_API void     srsran_ra_sl_type0_from_riv(uint32_t riv, uint32_t nof_prb, uint32_t* L_crb, uint32_t* prb_start);
SRSRAN_API int
               srsran_ra_sl_pssch_allowed_sf(uint32_t pssch_sf_idx, uint32_t trp_idx, uint32_t duplex_mode, uint32_t tdd_config);
SRSRAN_API int srsran_sci_generate_trp_idx(uint32_t duplex_mode, uint32_t tdd_config, uint32_t k_TRP);

// TS 36.213 table 14.1.1.1.1-3: Time Resource pattern Index mapping for N_TRP = 6
static const uint8_t srsran_sl_N_TRP_6_k_1[] = {1, 2, 4, 8, 16, 32};
static const uint8_t srsran_sl_N_TRP_6_k_2[] = {3, 5, 6, 9, 10, 12, 17, 18, 20, 24, 33, 34, 36, 40, 48};
static const uint8_t srsran_sl_N_TRP_6_k_3[] = {7,  11, 13, 14, 19, 21, 22, 25, 26, 28,
                                                35, 37, 38, 41, 42, 44, 49, 50, 52, 56};
static const uint8_t srsran_sl_N_TRP_6_k_4[] = {15, 23, 27, 29, 30, 39, 43, 45, 46, 51, 53, 54, 57, 58, 60};
static const uint8_t srsran_sl_N_TRP_6_k_5[] = {31, 47, 55, 59, 61, 62};
static const uint8_t srsran_sl_N_TRP_6_k_6[] = {63};
static const uint8_t srsran_sl_N_TRP_6[][6]  = {
    {0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0},
    {1, 0, 1, 0, 0, 0}, {0, 1, 1, 0, 0, 0}, {1, 1, 1, 0, 0, 0}, {0, 0, 0, 1, 0, 0}, {1, 0, 0, 1, 0, 0},
    {0, 1, 0, 1, 0, 0}, {1, 1, 0, 1, 0, 0}, {0, 0, 1, 1, 0, 0}, {1, 0, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 0},
    {1, 1, 1, 1, 0, 0}, {0, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 1, 0}, {1, 1, 0, 0, 1, 0},
    {0, 0, 1, 0, 1, 0}, {1, 0, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0}, {1, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 1, 0},
    {1, 0, 0, 1, 1, 0}, {0, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 0}, {1, 0, 1, 1, 1, 0},
    {0, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 0, 1},
    {1, 1, 0, 0, 0, 1}, {0, 0, 1, 0, 0, 1}, {1, 0, 1, 0, 0, 1}, {0, 1, 1, 0, 0, 1}, {1, 1, 1, 0, 0, 1},
    {0, 0, 0, 1, 0, 1}, {1, 0, 0, 1, 0, 1}, {0, 1, 0, 1, 0, 1}, {1, 1, 0, 1, 0, 1}, {0, 0, 1, 1, 0, 1},
    {1, 0, 1, 1, 0, 1}, {0, 1, 1, 1, 0, 1}, {1, 1, 1, 1, 0, 1}, {0, 0, 0, 0, 1, 1}, {1, 0, 0, 0, 1, 1},
    {0, 1, 0, 0, 1, 1}, {1, 1, 0, 0, 1, 1}, {0, 0, 1, 0, 1, 1}, {1, 0, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 1},
    {1, 1, 1, 0, 1, 1}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 1, 1, 1}, {0, 1, 0, 1, 1, 1}, {1, 1, 0, 1, 1, 1},
    {0, 0, 1, 1, 1, 1}, {1, 0, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1}};

// TS 36.213 table 14.1.1.1.1-2: Time Resource pattern Index mapping for N_TRP = 7
static const uint8_t srsran_sl_N_TRP_7_k_1[] = {1, 2, 4, 8, 16, 32, 64};
static const uint8_t srsran_sl_N_TRP_7_k_2[] = {3,  5,  6,  9,  10, 12, 17, 18, 20, 24, 33,
                                                34, 36, 40, 48, 65, 66, 68, 72, 80, 96};
static const uint8_t srsran_sl_N_TRP_7_k_3[] = {7,  11, 13, 14, 19, 21, 22, 25, 26,  28,  35, 37,
                                                38, 41, 42, 44, 49, 50, 52, 56, 67,  69,  70, 73,
                                                74, 76, 81, 82, 84, 88, 97, 98, 100, 104, 112};
static const uint8_t srsran_sl_N_TRP_7_k_4[] = {15, 23, 27,  29,  30,  39,  43,  45,  46,  51,  53, 54,
                                                57, 58, 60,  71,  75,  77,  78,  83,  85,  86,  89, 90,
                                                92, 99, 101, 102, 105, 106, 108, 113, 114, 116, 120};
static const uint8_t srsran_sl_N_TRP_7_k_5[] = {31,  47,  55,  59,  61,  62,  79,  87,  91,  93, 94,
                                                103, 107, 109, 110, 115, 117, 118, 121, 122, 124};
static const uint8_t srsran_sl_N_TRP_7_k_6[] = {63, 95, 111, 119, 123, 125, 126};
static const uint8_t srsran_sl_N_TRP_7_k_7[] = {127};
static const uint8_t srsran_sl_N_TRP_7[][7]  = {
    {0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0},
    {1, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 0, 0, 0, 0}, {1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0},
    {0, 1, 0, 1, 0, 0, 0}, {1, 1, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 0}, {1, 0, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0, 0},
    {1, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0}, {1, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 0, 1, 0, 0}, {1, 1, 0, 0, 1, 0, 0},
    {0, 0, 1, 0, 1, 0, 0}, {1, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 0, 1, 0, 0}, {1, 1, 1, 0, 1, 0, 0}, {0, 0, 0, 1, 1, 0, 0},
    {1, 0, 0, 1, 1, 0, 0}, {0, 1, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 0, 0}, {1, 0, 1, 1, 1, 0, 0},
    {0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 1, 1, 0, 0}, {0, 0, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 1, 0},
    {1, 1, 0, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 1, 0, 0, 1, 0}, {0, 1, 1, 0, 0, 1, 0}, {1, 1, 1, 0, 0, 1, 0},
    {0, 0, 0, 1, 0, 1, 0}, {1, 0, 0, 1, 0, 1, 0}, {0, 1, 0, 1, 0, 1, 0}, {1, 1, 0, 1, 0, 1, 0}, {0, 0, 1, 1, 0, 1, 0},
    {1, 0, 1, 1, 0, 1, 0}, {0, 1, 1, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 1, 0}, {0, 0, 0, 0, 1, 1, 0}, {1, 0, 0, 0, 1, 1, 0},
    {0, 1, 0, 0, 1, 1, 0}, {1, 1, 0, 0, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 0}, {1, 0, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1, 0},
    {1, 1, 1, 0, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 0}, {1, 0, 0, 1, 1, 1, 0}, {0, 1, 0, 1, 1, 1, 0}, {1, 1, 0, 1, 1, 1, 0},
    {0, 0, 1, 1, 1, 1, 0}, {1, 0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 1},
    {1, 0, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 0, 0, 1}, {1, 1, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 0, 0, 0, 1},
    {0, 1, 1, 0, 0, 0, 1}, {1, 1, 1, 0, 0, 0, 1}, {0, 0, 0, 1, 0, 0, 1}, {1, 0, 0, 1, 0, 0, 1}, {0, 1, 0, 1, 0, 0, 1},
    {1, 1, 0, 1, 0, 0, 1}, {0, 0, 1, 1, 0, 0, 1}, {1, 0, 1, 1, 0, 0, 1}, {0, 1, 1, 1, 0, 0, 1}, {1, 1, 1, 1, 0, 0, 1},
    {0, 0, 0, 0, 1, 0, 1}, {1, 0, 0, 0, 1, 0, 1}, {0, 1, 0, 0, 1, 0, 1}, {1, 1, 0, 0, 1, 0, 1}, {0, 0, 1, 0, 1, 0, 1},
    {1, 0, 1, 0, 1, 0, 1}, {0, 1, 1, 0, 1, 0, 1}, {1, 1, 1, 0, 1, 0, 1}, {0, 0, 0, 1, 1, 0, 1}, {1, 0, 0, 1, 1, 0, 1},
    {0, 1, 0, 1, 1, 0, 1}, {1, 1, 0, 1, 1, 0, 1}, {0, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1}, {0, 1, 1, 1, 1, 0, 1},
    {1, 1, 1, 1, 1, 0, 1}, {0, 0, 0, 0, 0, 1, 1}, {1, 0, 0, 0, 0, 1, 1}, {0, 1, 0, 0, 0, 1, 1}, {1, 1, 0, 0, 0, 1, 1},
    {0, 0, 1, 0, 0, 1, 1}, {1, 0, 1, 0, 0, 1, 1}, {0, 1, 1, 0, 0, 1, 1}, {1, 1, 1, 0, 0, 1, 1}, {0, 0, 0, 1, 0, 1, 1},
    {1, 0, 0, 1, 0, 1, 1}, {0, 1, 0, 1, 0, 1, 1}, {1, 1, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 0, 1, 1}, {1, 0, 1, 1, 0, 1, 1},
    {0, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 1, 0, 1, 1}, {0, 0, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 1, 1},
    {1, 1, 0, 0, 1, 1, 1}, {0, 0, 1, 0, 1, 1, 1}, {1, 0, 1, 0, 1, 1, 1}, {0, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 0, 1, 1, 1},
    {0, 0, 0, 1, 1, 1, 1}, {1, 0, 0, 1, 1, 1, 1}, {0, 1, 0, 1, 1, 1, 1}, {1, 1, 0, 1, 1, 1, 1}, {0, 0, 1, 1, 1, 1, 1},
    {1, 0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}};

// TS 36.213 table 14.1.1.1.1-1: Time Resource pattern Index mapping for N_TRP = 8
static const uint8_t srsran_sl_N_TRP_8_k_1[] = {0, 1, 2, 3, 4, 5, 6, 7};
static const uint8_t srsran_sl_N_TRP_8_k_2[] = {8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
                                                22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
static const uint8_t srsran_sl_N_TRP_8_k_4[] = {
    36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,  53,  54,  55,  56,  57, 58, 59,
    60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,  77,  78,  79,  80,  81, 82, 83,
    84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105};
static const uint8_t srsran_sl_N_TRP_8_k_8[] = {106};
static const uint8_t srsran_sl_N_TRP_8[][8]  = {
    {1, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 1},
    {1, 1, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 0, 0, 0}, {0, 1, 1, 0, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 0},
    {0, 1, 0, 1, 0, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 0},
    {0, 0, 1, 0, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 0, 0, 1, 0, 0},
    {0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 0, 1, 0, 0}, {0, 0, 0, 0, 1, 1, 0, 0}, {1, 0, 0, 0, 0, 0, 1, 0},
    {0, 1, 0, 0, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 1, 0}, {0, 0, 0, 1, 0, 0, 1, 0}, {0, 0, 0, 0, 1, 0, 1, 0},
    {0, 0, 0, 0, 0, 1, 1, 0}, {1, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 0, 0, 0, 1},
    {0, 0, 0, 1, 0, 0, 0, 1}, {0, 0, 0, 0, 1, 0, 0, 1}, {0, 0, 0, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 0, 1, 1},
    {1, 1, 1, 1, 0, 0, 0, 0}, {1, 1, 1, 0, 1, 0, 0, 0}, {1, 1, 0, 1, 1, 0, 0, 0}, {1, 0, 1, 1, 1, 0, 0, 0},
    {0, 1, 1, 1, 1, 0, 0, 0}, {1, 1, 1, 0, 0, 1, 0, 0}, {1, 1, 0, 1, 0, 1, 0, 0}, {1, 0, 1, 1, 0, 1, 0, 0},
    {0, 1, 1, 1, 0, 1, 0, 0}, {1, 1, 0, 0, 1, 1, 0, 0}, {1, 0, 1, 0, 1, 1, 0, 0}, {0, 1, 1, 0, 1, 1, 0, 0},
    {1, 0, 0, 1, 1, 1, 0, 0}, {0, 1, 0, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 0, 0}, {1, 1, 1, 0, 0, 0, 1, 0},
    {1, 1, 0, 1, 0, 0, 1, 0}, {1, 0, 1, 1, 0, 0, 1, 0}, {0, 1, 1, 1, 0, 0, 1, 0}, {1, 1, 0, 0, 1, 0, 1, 0},
    {1, 0, 1, 0, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 0, 1, 0}, {1, 0, 0, 1, 1, 0, 1, 0}, {0, 1, 0, 1, 1, 0, 1, 0},
    {0, 0, 1, 1, 1, 0, 1, 0}, {1, 1, 0, 0, 0, 1, 1, 0}, {1, 0, 1, 0, 0, 1, 1, 0}, {0, 1, 1, 0, 0, 1, 1, 0},
    {1, 0, 0, 1, 0, 1, 1, 0}, {0, 1, 0, 1, 0, 1, 1, 0}, {0, 0, 1, 1, 0, 1, 1, 0}, {1, 0, 0, 0, 1, 1, 1, 0},
    {0, 1, 0, 0, 1, 1, 1, 0}, {0, 0, 1, 0, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 0, 0, 0, 1},
    {1, 1, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0, 0, 1}, {0, 1, 1, 1, 0, 0, 0, 1}, {1, 1, 0, 0, 1, 0, 0, 1},
    {1, 0, 1, 0, 1, 0, 0, 1}, {0, 1, 1, 0, 1, 0, 0, 1}, {1, 0, 0, 1, 1, 0, 0, 1}, {0, 1, 0, 1, 1, 0, 0, 1},
    {0, 0, 1, 1, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 1, 0, 1}, {1, 0, 1, 0, 0, 1, 0, 1}, {0, 1, 1, 0, 0, 1, 0, 1},
    {1, 0, 0, 1, 0, 1, 0, 1}, {0, 1, 0, 1, 0, 1, 0, 1}, {0, 0, 1, 1, 0, 1, 0, 1}, {1, 0, 0, 0, 1, 1, 0, 1},
    {0, 1, 0, 0, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1, 0, 1}, {0, 0, 0, 1, 1, 1, 0, 1}, {1, 1, 0, 0, 0, 0, 1, 1},
    {1, 0, 1, 0, 0, 0, 1, 1}, {0, 1, 1, 0, 0, 0, 1, 1}, {1, 0, 0, 1, 0, 0, 1, 1}, {0, 1, 0, 1, 0, 0, 1, 1},
    {0, 0, 1, 1, 0, 0, 1, 1}, {1, 0, 0, 0, 1, 0, 1, 1}, {0, 1, 0, 0, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 0, 1, 1},
    {0, 0, 0, 1, 1, 0, 1, 1}, {1, 0, 0, 0, 0, 1, 1, 1}, {0, 1, 0, 0, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 1, 1},
    {0, 0, 0, 1, 0, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}};

#endif // SRSRAN_RA_SL_H
