/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class BitTypeCompiler
extends BaseTypeCompiler {
    public boolean convertible(TypeId typeId, boolean bl) {
        if (typeId.getBaseTypeId().isAnsiUDT()) {
            return false;
        }
        return typeId.isBitTypeId() || typeId.isBlobTypeId() || typeId.userType();
    }

    public boolean compatible(TypeId typeId) {
        if (typeId.isBlobTypeId()) {
            return false;
        }
        return typeId.isBitTypeId();
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        if (typeId.isBlobTypeId()) {
            return false;
        }
        if (typeId.isBitTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), typeId, classFactory);
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.BitDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        return "byte[]";
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.getMaximumWidth();
    }

    String nullMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 27: {
                return "getNullBit";
            }
            case 232: {
                return "getNullLongVarbit";
            }
            case 29: {
                return "getNullVarbit";
            }
        }
        return null;
    }

    String dataValueMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 27: {
                return "getBitDataValue";
            }
            case 232: {
                return "getLongVarbitDataValue";
            }
            case 29: {
                return "getVarbitDataValue";
            }
        }
        return null;
    }
}

