/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.carrotsearch.hppc.IntLongHashMap;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.util.Arrays;
import java.util.function.LongConsumer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.solr.util.DynamicMap;

public class IntLongDynamicMap
implements DynamicMap {
    private int maxSize;
    private IntLongHashMap hashMap;
    private long[] keyValues;
    private long emptyValue;
    private int threshold;

    public IntLongDynamicMap(int expectedKeyMax, long emptyValue) {
        this.threshold = this.threshold(expectedKeyMax);
        this.maxSize = expectedKeyMax;
        this.emptyValue = emptyValue;
        if (this.useArrayBased(expectedKeyMax)) {
            this.upgradeToArray();
        } else {
            this.hashMap = new IntLongHashMap(this.mapExpectedElements(expectedKeyMax));
        }
    }

    private void upgradeToArray() {
        this.keyValues = new long[this.maxSize];
        if (this.emptyValue != 0L) {
            Arrays.fill(this.keyValues, this.emptyValue);
        }
        if (this.hashMap != null) {
            this.hashMap.forEach((key, value) -> {
                this.keyValues[key] = value;
            });
            this.hashMap = null;
        }
    }

    private void growBuffer(int minSize) {
        assert (this.keyValues != null);
        int size = this.keyValues.length;
        this.keyValues = ArrayUtil.grow((long[])this.keyValues, (int)minSize);
        if (this.emptyValue != 0L) {
            for (int i = size; i < this.keyValues.length; ++i) {
                this.keyValues[i] = this.emptyValue;
            }
        }
    }

    public void put(int key, long value) {
        if (this.keyValues != null) {
            if (key >= this.keyValues.length) {
                this.growBuffer(key + 1);
            }
            this.keyValues[key] = value;
        } else {
            this.maxSize = Math.max(key + 1, this.maxSize);
            this.hashMap.put(key, value);
            if (this.hashMap.size() >= this.threshold) {
                this.upgradeToArray();
            }
        }
    }

    public long get(int key) {
        if (this.keyValues != null) {
            if (key >= this.keyValues.length) {
                return this.emptyValue;
            }
            return this.keyValues[key];
        }
        return this.hashMap.getOrDefault(key, this.emptyValue);
    }

    public void forEachValue(LongConsumer consumer) {
        if (this.keyValues != null) {
            for (long val : this.keyValues) {
                if (val == this.emptyValue) continue;
                consumer.accept(val);
            }
        } else {
            for (LongCursor ord : this.hashMap.values()) {
                consumer.accept(ord.value);
            }
        }
    }

    public void remove(int key) {
        if (this.keyValues != null) {
            if (key < this.keyValues.length) {
                this.keyValues[key] = this.emptyValue;
            }
        } else {
            this.hashMap.remove(key);
        }
    }
}

