PK
     
YU      NetlinkTest.stUT	 WcWcux     "======================================================================
|
|   Netlink module declarations
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2014 Free Software Foundation, Inc.
| Written by Holger Hans Peter Freyther
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
|
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
|
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LIB.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.
|
 ======================================================================"


TestCase subclass: NetlinkTest [
    <category: 'Netlink-Test'>

    testIPv4Resolving [
        | addr |
        addr := (SocketAddress byName: '127.0.0.1') determineSourceAddress.
        self assert: addr equals: (IPAddress fromBytes: #[127 0 0 1]).
    ]
]
PK
     
YUnr58  8  
  Netlink.stUT	 WcWcux     "======================================================================
|
|   Netlink module declarations
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2014 Free Software Foundation, Inc.
| Written by Holger Hans Peter Freyther
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
|
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
|
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LIB.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.
|
 ======================================================================"



Object subclass: Netlink [
    <category: 'Netlink'>
    <comment: 'I help speaking netlink with the kernel. Currently this
    only includes the routing sub-system but might be extended.'>

    Netlink class >> fromDestIPv4: destAddress toLocal: localAddress [
        <category: '*Netlink'>
        "Given a destination IPv4 Address this function will
        determine the local source address that would be used.
        The addresses need to be a ByteArray with four entries."
        <cCall: 'nl_route_source_ipv4' returning: #int args: #(#byteArray #cObject)>
    ]
]
PK
     
YUUEt    
  Extensions.stUT	 WcWcux     "======================================================================
|
|   Netlink module declarations
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2014 Free Software Foundation, Inc.
| Written by Holger Hans Peter Freyther
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
|
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
|
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LIB.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.
|
 ======================================================================"



Sockets.IPAddress extend [
    determineSourceAddress  [
        | sourceAddr res |
        <category: '*Netlink'>
        "Assuming that self is the destination address determine the
        source address that will be used."
        sourceAddr := ByteArray new: 4.
        res := Netlink fromDestIPv4: address toLocal: sourceAddr.
        res = 0
            ifFalse: [^self error: 'Failed to determine source address'].
        ^self class fromBytes: sourceAddr.
    ]
]
PK
     
YU{  {    package.xmlUT	 IWcIWcux     <package>
  <name>Netlink</name>
  <namespace>Sockets</namespace>
  <test>
    <namespace>Sockets</namespace>
    <prereq>Netlink</prereq>
    <prereq>SUnit</prereq>
    <sunit>Sockets.NetlinkTest</sunit>
    <filein>NetlinkTest.st</filein>
  </test>
  <prereq>Sockets</prereq>
  <module>netlink</module>

  <filein>Extensions.st</filein>
  <filein>Netlink.st</filein>
</package>PK
     
YU                  NetlinkTest.stUT Wcux     PK
     
YUnr58  8  
          E  Netlink.stUT Wcux     PK
     
YUUEt    
          
  Extensions.stUT Wcux     PK
     
YU{  {              package.xmlUT IWcux     PK      H      