/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Arrays;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.management.BackupManager;
import org.firebirdsql.management.FBBackupManagerBase;

public class FBStreamingBackupManager
extends FBBackupManagerBase
implements BackupManager {
    private OutputStream backupOutputStream = null;
    private BufferedInputStream restoreInputStream = null;
    private int backupBufferSize = 30720;
    private static final int MAX_RESTORE_CHUNK = 65532;
    private static final int DATA_NOT_READY = 0;
    private static final int END_OF_STREAM = -1;

    public void setBackupBufferSize(int bufferSize) {
        if (bufferSize < 0) {
            throw new IllegalArgumentException("Buffer size must be positive");
        }
        this.backupBufferSize = bufferSize;
    }

    public FBStreamingBackupManager() {
    }

    public FBStreamingBackupManager(String gdsType) {
        super(gdsType);
    }

    public FBStreamingBackupManager(GDSType gdsType) {
        super(gdsType);
    }

    @Override
    public void setBackupPath(String backupPath) {
        throw new IllegalArgumentException("You cannot use setBackupPath(String) for Streaming backups.");
    }

    @Override
    public void addBackupPath(String path, int size) {
        throw new IllegalArgumentException("You cannot use setBackupPath(String) for Streaming backups.");
    }

    public void setBackupOutputStream(OutputStream backupStream) {
        this.backupOutputStream = backupStream;
    }

    public void setRestoreInputStream(InputStream restoreStream) {
        this.restoreInputStream = restoreStream instanceof BufferedInputStream ? (BufferedInputStream)restoreStream : new BufferedInputStream(restoreStream, 8388096);
    }

    @Override
    public void clearBackupPaths() {
        this.backupOutputStream = null;
    }

    @Override
    public void backupDatabase(int options) throws SQLException {
        if (this.backupOutputStream == null) {
            throw new SQLException("No output stream specified for the backup.");
        }
        try (FbService service = this.attachServiceManager();){
            this.executeServiceBackupOperation(service, this.getBackupSRB(service, options));
        }
    }

    @Override
    public void restoreDatabase(int options) throws SQLException {
        if (this.restoreInputStream == null) {
            throw new SQLException("No input stream specified for the restore.");
        }
        try (FbService service = this.attachServiceManager();){
            this.executeServiceRestoreOperation(service, this.getRestoreSRB(service, options));
        }
    }

    @Override
    protected boolean verboseBackup() {
        return false;
    }

    @Override
    public void setRestorePageSize(int pageSize) {
        if (pageSize < 4096) {
            throw new IllegalArgumentException("FirebirdSQL versions with streaming restore support don't support pages below 4096");
        }
        super.setRestorePageSize(pageSize);
    }

    @Override
    protected void addBackupsToBackupRequestBuffer(FbService service, ServiceRequestBuffer backupSPB) {
        backupSPB.addArgument(5, "stdout");
    }

    @Override
    protected void addBackupsToRestoreRequestBuffer(FbService service, ServiceRequestBuffer restoreSPB) {
        restoreSPB.addArgument(5, "stdin");
    }

    private void executeServiceBackupOperation(FbService service, ServiceRequestBuffer srb) throws SQLException {
        try {
            service.startServiceAction(srb);
            ServiceRequestBuffer infoSRB = service.createServiceRequestBuffer();
            infoSRB.addArgument(63);
            int bufferSize = this.backupBufferSize;
            boolean processing = true;
            block7: while (processing) {
                byte[] buffer = service.getServiceInfo(null, infoSRB, bufferSize);
                switch (buffer[0]) {
                    case 63: {
                        if (this.readOutput(buffer, 0, this.backupOutputStream) != -1) continue block7;
                        processing = false;
                        continue block7;
                    }
                    case 2: {
                        bufferSize *= 2;
                        continue block7;
                    }
                    case 1: {
                        processing = false;
                        continue block7;
                    }
                }
                throw new SQLException("Unexpected response from service.");
            }
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    private void executeServiceRestoreOperation(FbService service, ServiceRequestBuffer srb) throws SQLException {
        try {
            service.startServiceAction(srb);
            OutputStream currentLogger = this.getLogger();
            ServiceRequestBuffer infoSRB = service.createServiceRequestBuffer();
            ServiceParameterBuffer infoSPB = null;
            infoSRB.addArgument(78);
            infoSRB.addArgument(62);
            if (this.verbose && currentLogger == null) {
                throw new SQLException("Verbose mode was requested but there is no logger provided.");
            }
            int bufferSize = 1024;
            byte[] stdinBuffer = new byte[65532];
            byte[] newLine = System.lineSeparator().getBytes();
            boolean processing = true;
            boolean sending = true;
            while (processing || infoSPB != null) {
                byte[] buffer = service.getServiceInfo(infoSPB, infoSRB, bufferSize);
                if (infoSPB != null && !sending) {
                    infoSRB = service.createServiceRequestBuffer();
                    infoSRB.addArgument(62);
                }
                infoSPB = null;
                int codePos = 0;
                block13: while (codePos < buffer.length && buffer[codePos] != 1) {
                    switch (buffer[codePos]) {
                        case 78: {
                            int requestedBytes = Math.min(VaxEncoding.iscVaxInteger(buffer, ++codePos, 4), stdinBuffer.length);
                            codePos += 4;
                            if (requestedBytes <= 0) continue block13;
                            int actuallyReadBytes = this.restoreInputStream.read(stdinBuffer, 0, requestedBytes);
                            if (actuallyReadBytes > 0) {
                                infoSPB = service.createServiceParameterBuffer();
                                if (stdinBuffer.length == actuallyReadBytes) {
                                    infoSPB.addArgument(62, stdinBuffer);
                                } else {
                                    infoSPB.addArgument(62, Arrays.copyOfRange(stdinBuffer, 0, actuallyReadBytes));
                                }
                            }
                            this.restoreInputStream.mark(2);
                            if (this.restoreInputStream.read() < 0) {
                                sending = false;
                                continue block13;
                            }
                            this.restoreInputStream.reset();
                            continue block13;
                        }
                        case 2: {
                            bufferSize *= 2;
                            ++codePos;
                            continue block13;
                        }
                        case 62: {
                            int bytesToLog = this.readOutput(buffer, codePos, currentLogger);
                            codePos += 3;
                            switch (bytesToLog) {
                                case 0: {
                                    ++codePos;
                                    continue block13;
                                }
                                case -1: {
                                    processing = false;
                                    continue block13;
                                }
                            }
                            codePos += bytesToLog;
                            if (currentLogger == null) continue block13;
                            currentLogger.write(newLine);
                            continue block13;
                        }
                        case 1: {
                            continue block13;
                        }
                    }
                    throw new SQLException("Unexpected response from service.");
                }
            }
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    private int readOutput(byte[] buffer, int offset, OutputStream out) throws SQLException, IOException {
        int dataLength = VaxEncoding.iscVaxInteger2(buffer, offset + 1);
        if (dataLength == 0) {
            switch (buffer[offset + 3]) {
                case 4: {
                    return 0;
                }
                case 1: {
                    return -1;
                }
            }
            throw new SQLException("Unexpected end of stream reached.");
        }
        if (out != null) {
            out.write(buffer, offset + 3, dataLength);
        }
        return dataLength;
    }
}

