/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import schemacrawler.inclusionrule.ExcludeAll;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.InclusionRuleWithRegularExpression;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.Options;
import us.fatehi.utility.ObjectToString;

public final class LimitOptions
implements Options {
    private final Map<DatabaseObjectRuleForInclusion, InclusionRule> inclusionRules;
    private final EnumSet<RoutineType> routineTypes;
    private final String tableNamePattern;
    private final TableTypes tableTypes;

    LimitOptions(Map<DatabaseObjectRuleForInclusion, InclusionRule> inclusionRules, TableTypes tableTypes, String tableNamePattern, EnumSet<RoutineType> routineTypes) {
        this.inclusionRules = Objects.requireNonNull(inclusionRules, "No inclusion rules provided");
        this.tableTypes = Objects.requireNonNull(tableTypes, "No table types provided");
        this.tableNamePattern = tableNamePattern;
        Objects.requireNonNull(routineTypes, "No routine types provided");
        this.routineTypes = EnumSet.copyOf(routineTypes);
    }

    public InclusionRule get(DatabaseObjectRuleForInclusion inclusionRuleKey) {
        InclusionRuleWithRegularExpression defaultInclusionRule = inclusionRuleKey.isExcludeByDefault() ? new ExcludeAll() : new IncludeAll();
        return this.inclusionRules.getOrDefault((Object)inclusionRuleKey, defaultInclusionRule);
    }

    public Collection<RoutineType> getRoutineTypes() {
        return EnumSet.copyOf(this.routineTypes);
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public TableTypes getTableTypes() {
        return this.tableTypes;
    }

    public boolean isExcludeAll(DatabaseObjectRuleForInclusion inclusionRuleKey) {
        return this.get(inclusionRuleKey).equals(new ExcludeAll());
    }

    public boolean isIncludeAll(DatabaseObjectRuleForInclusion inclusionRuleKey) {
        return this.get(inclusionRuleKey).equals(new IncludeAll());
    }

    public String toString() {
        return ObjectToString.toString((Object)this);
    }
}

