/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler;

import java.util.Objects;
import picocli.CommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerShell;
import schemacrawler.tools.commandline.command.CommandLineHelpCommand;
import schemacrawler.tools.commandline.command.LogCommand;
import schemacrawler.tools.commandline.shell.InteractiveShellOptions;
import schemacrawler.tools.commandline.shell.SystemCommand;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.utility.CommandLineLoggingUtility;

public final class Main {
    public static void main(String ... args) throws Exception {
        Objects.requireNonNull(args, "No command-line arguments provided");
        CommandLine commandLine = new CommandLine((Object)new LogCommand());
        commandLine.setUnmatchedArgumentsAllowed(true);
        commandLine.execute(args);
        CommandLineLoggingUtility.logSafeArguments(args, null);
        CommandLineLoggingUtility.logSystemClasspath();
        CommandLineLoggingUtility.logSystemProperties();
        InteractiveShellOptions interactiveShellOptions = new InteractiveShellOptions();
        CommandLine.populateCommand((Object)interactiveShellOptions, (String[])args);
        boolean isInteractive = interactiveShellOptions.isInteractive();
        if (isInteractive) {
            SchemaCrawlerShell.execute(args);
        } else {
            if (Main.showHelpIfRequested(args)) {
                return;
            }
            if (Main.showVersionIfRequested(args)) {
                return;
            }
            SchemaCrawlerCommandLine.execute(args);
        }
    }

    private static boolean showHelpIfRequested(String[] args) {
        CommandLineHelpCommand commandLineHelpCommand = new CommandLineHelpCommand();
        CommandLine commandLine = new CommandLine((Object)commandLineHelpCommand);
        commandLine.setUnmatchedArgumentsAllowed(true);
        commandLine.parseArgs(args);
        if (commandLineHelpCommand.isHelpRequested()) {
            commandLineHelpCommand.run();
            return true;
        }
        return false;
    }

    private static boolean showVersionIfRequested(String[] args) {
        ShellState state = new ShellState();
        SystemCommand systemCommand = new SystemCommand(state);
        CommandLine commandLine = new CommandLine((Object)systemCommand);
        commandLine.setUnmatchedArgumentsAllowed(true);
        commandLine.parseArgs(args);
        if (systemCommand.isVersionRequested() || systemCommand.isShowEnvironment()) {
            systemCommand.run();
            return true;
        }
        return false;
    }

    private Main() {
    }
}

