/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.tools.lint.BaseLinter;

public class LinterTableWithQuotedNames
extends BaseLinter {
    @Override
    public String getSummary() {
        return "spaces in name, or reserved word";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Identifiers identifiers;
        Objects.requireNonNull(table, "No table provided");
        try {
            identifiers = Identifiers.identifiers().withConnection(connection).build();
        }
        catch (SQLException e) {
            throw new DatabaseAccessException((Throwable)e);
        }
        String tableName = table.getName();
        if (identifiers.isToBeQuoted(tableName)) {
            this.addTableLint(table, this.getSummary());
        }
        List<String> spacesInNamesList = this.findColumnsWithQuotedNames(this.getColumns(table), identifiers);
        for (String spacesInName : spacesInNamesList) {
            this.addTableLint(table, this.getSummary(), spacesInName);
        }
    }

    private List<String> findColumnsWithQuotedNames(List<Column> columns, Identifiers identifiers) {
        ArrayList<String> columnsWithQuotedNames = new ArrayList<String>();
        for (Column column : columns) {
            String columnName = column.getName();
            if (!identifiers.isToBeQuoted(columnName)) continue;
            columnsWithQuotedNames.add(columnName);
        }
        return columnsWithQuotedNames;
    }
}

