/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import schemacrawler.crawl.ImmutableDatabaseProperty;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.Property;

final class MutableDatabaseInfo
implements DatabaseInfo {
    private static final long serialVersionUID = 4051323422934251828L;
    private final String databaseProductName;
    private final String databaseProductVersion;
    private final String userName;
    private final Set<Property> serverInfo;
    private final Set<DatabaseProperty> databaseProperties;

    public MutableDatabaseInfo(ConnectionInfo connectionInfo) {
        Objects.requireNonNull(connectionInfo, "No connection information provided");
        this.databaseProductName = connectionInfo.getDatabaseProductName();
        this.databaseProductVersion = connectionInfo.getDatabaseProductVersion();
        this.userName = connectionInfo.getUserName();
        this.serverInfo = new HashSet<Property>();
        this.databaseProperties = new HashSet<DatabaseProperty>();
    }

    @Override
    public String getProductName() {
        return this.databaseProductName;
    }

    @Override
    public String getProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public Collection<DatabaseProperty> getProperties() {
        ArrayList<DatabaseProperty> properties = new ArrayList<DatabaseProperty>(this.databaseProperties);
        properties.sort(Comparator.naturalOrder());
        return properties;
    }

    @Override
    public Collection<Property> getServerInfo() {
        return new TreeSet<Property>(this.serverInfo);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- database: ").append(this.getProductName()).append(' ').append(this.getProductVersion()).append(System.lineSeparator());
        return info.toString();
    }

    void addAll(Collection<ImmutableDatabaseProperty> dbProperties) {
        if (dbProperties != null) {
            this.databaseProperties.addAll(dbProperties);
        }
    }

    void addServerInfo(Property property) {
        if (property != null) {
            this.serverInfo.add(property);
        }
    }
}

